/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.PropertyFilter;
import org.alfresco.repo.cmis.ws.Aspects;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisPropertiesType;
import org.alfresco.repo.cmis.ws.CmisProperty;
import org.alfresco.repo.cmis.ws.CmisPropertyBoolean;
import org.alfresco.repo.cmis.ws.CmisPropertyDateTime;
import org.alfresco.repo.cmis.ws.CmisPropertyDecimal;
import org.alfresco.repo.cmis.ws.CmisPropertyHtml;
import org.alfresco.repo.cmis.ws.CmisPropertyId;
import org.alfresco.repo.cmis.ws.CmisPropertyInteger;
import org.alfresco.repo.cmis.ws.CmisPropertyString;
import org.alfresco.repo.cmis.ws.CmisPropertyUri;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.SetAspects;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    private static final DatatypeFactory DATATYPE_FACTORY;
    private static final String NAMESPACE_BEGIN = "{";
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private CMISServices cmisService;
    private CMISDictionaryService cmisDictionaryService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCmisService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public <ResultType> ResultType getProperty(NodeRef objectNodeRef, String propertyName, ResultType defaultValue) throws CMISInvalidArgumentException {
        if (null == objectNodeRef || null == propertyName) {
            return defaultValue;
        }
        Serializable value = this.cmisService.getProperty(objectNodeRef, propertyName);
        try {
            return this.convertPropertyValue(value, defaultValue);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public <ResultType> ResultType getCmisPropertyValue(CmisPropertiesType cmisProperties, String property, ResultType defaultValue) throws CmisException {
        if (null == property || null == cmisProperties) {
            return defaultValue;
        }
        for (CmisProperty cmisProperty : cmisProperties.getProperty()) {
            if (null == cmisProperty || !property.equals(this.getPropertyName(cmisProperty))) continue;
            return this.convertPropertyValue(this.getValue(cmisProperty), defaultValue);
        }
        return defaultValue;
    }

    private <ResultType> ResultType convertPropertyValue(Object propertyValue, ResultType defaultValue) {
        if (null == propertyValue) {
            return defaultValue;
        }
        try {
            return (ResultType)propertyValue;
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    private Serializable getValue(CmisProperty cmisProperty) throws CmisException {
        Serializable value = null;
        String propertyName = this.getPropertyName(cmisProperty);
        if (null == cmisProperty || null == propertyName) {
            return value;
        }
        PropertyMultiValueStateEnum multivaluedState = this.getPropertyMultiValuedState(null, propertyName);
        List<Object> convertedValue = null;
        if (cmisProperty instanceof CmisPropertyBoolean) {
            convertedValue = ((CmisPropertyBoolean)cmisProperty).getValue();
        } else if (cmisProperty instanceof CmisPropertyDateTime) {
            convertedValue = ((CmisPropertyDateTime)cmisProperty).getValue();
            ArrayList<GregorianCalendar> dates = new ArrayList<GregorianCalendar>(convertedValue.size());
            for (Object e : convertedValue) {
                dates.add(((XMLGregorianCalendar)e).toGregorianCalendar());
            }
            convertedValue = dates;
        } else if (cmisProperty instanceof CmisPropertyDecimal) {
            convertedValue = ((CmisPropertyDecimal)cmisProperty).getValue();
        } else if (cmisProperty instanceof CmisPropertyHtml) {
            convertedValue = ((CmisPropertyHtml)cmisProperty).getValue();
        } else if (cmisProperty instanceof CmisPropertyId) {
            convertedValue = ((CmisPropertyId)cmisProperty).getValue();
        } else if (cmisProperty instanceof CmisPropertyInteger) {
            convertedValue = ((CmisPropertyInteger)cmisProperty).getValue();
        } else if (cmisProperty instanceof CmisPropertyString) {
            convertedValue = ((CmisPropertyString)cmisProperty).getValue();
        } else if (cmisProperty instanceof CmisPropertyUri) {
            convertedValue = ((CmisPropertyUri)cmisProperty).getValue();
        }
        if (null != convertedValue) {
            value = this.isMultiValued(propertyName, multivaluedState, convertedValue) ? (convertedValue.size() > 0 ? new ArrayList<Object>(convertedValue) : null) : (Serializable)convertedValue.iterator().next();
        }
        return value;
    }

    private boolean isMultiValued(String propertyName, PropertyMultiValueStateEnum state, Collection<?> values) throws CmisException {
        if (PropertyMultiValueStateEnum.PROPERTY_NOT_FOUND == state) {
            return values.size() > 0 ? values.size() > 1 : true;
        }
        if (PropertyMultiValueStateEnum.PROPERTY_NOT_MULTIVALUED == state && values.size() > 1) {
            throw ExceptionUtil.createCmisException("\"" + propertyName + "\" property is not Multi Valued", EnumServiceException.INVALID_ARGUMENT);
        }
        return PropertyMultiValueStateEnum.PROPERTY_MULTIVALUED == state;
    }

    private PropertyMultiValueStateEnum getPropertyMultiValuedState(String typeId, String cmisPropertyName) {
        if (null == cmisPropertyName || cmisPropertyName.equals("")) {
            return PropertyMultiValueStateEnum.PROPERTY_NOT_FOUND;
        }
        CMISTypeDefinition typeDefinition = null != typeId && !typeId.equals("") ? this.cmisDictionaryService.findType(typeId) : null;
        CMISPropertyDefinition propertyDefinition = null;
        propertyDefinition = null != typeDefinition && null != typeDefinition.getOwnedPropertyDefinitions() ? (CMISPropertyDefinition)typeDefinition.getOwnedPropertyDefinitions().get(cmisPropertyName) : this.cmisDictionaryService.findProperty(cmisPropertyName, null);
        if (null == propertyDefinition || null == propertyDefinition.getPropertyAccessor()) {
            return PropertyMultiValueStateEnum.PROPERTY_NOT_FOUND;
        }
        PropertyDefinition nativePropertyDefinition = null;
        nativePropertyDefinition = null != propertyDefinition.getPropertyAccessor().getMappedProperty() ? this.dictionaryService.getProperty(propertyDefinition.getPropertyAccessor().getMappedProperty()) : this.dictionaryService.getProperty(this.createQName(cmisPropertyName));
        if (null == nativePropertyDefinition) {
            return PropertyMultiValueStateEnum.PROPERTY_NOT_FOUND;
        }
        return nativePropertyDefinition.isMultiValued() ? PropertyMultiValueStateEnum.PROPERTY_MULTIVALUED : PropertyMultiValueStateEnum.PROPERTY_NOT_MULTIVALUED;
    }

    public Map<String, Serializable> getPropertiesMap(CmisPropertiesType cmisProperties) throws CmisException {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        if (null == cmisProperties) {
            return properties;
        }
        for (CmisProperty cmisProperty : cmisProperties.getProperty()) {
            if (null == cmisProperty) continue;
            String pdid = this.getPropertyName(cmisProperty);
            properties.put(pdid, this.getValue(cmisProperty));
        }
        return properties;
    }

    public void setProperties(NodeRef nodeRef, CmisPropertiesType properties, PropertyFilter ignoringPropertiesFilter) throws CmisException {
        if (nodeRef == null || properties == null) {
            return;
        }
        try {
            for (CmisProperty property : properties.getProperty()) {
                String propertyName = this.getPropertyName(property);
                if (null == propertyName || null != ignoringPropertiesFilter && ignoringPropertiesFilter.allow(propertyName)) continue;
                Serializable value = this.getValue(property);
                this.cmisService.setProperty(nodeRef, propertyName, value);
            }
            for (Object extensionObj : properties.getAny()) {
                if (!(extensionObj instanceof SetAspects)) continue;
                SetAspects setAspects = (SetAspects)extensionObj;
                this.cmisService.setAspects(nodeRef, setAspects.getAspectsToRemove(), setAspects.getAspectsToAdd());
                CmisPropertiesType extensionProperties = setAspects.getProperties();
                if (extensionProperties == null) continue;
                for (CmisProperty property : extensionProperties.getProperty()) {
                    String propertyName = this.getPropertyName(property);
                    if (null == propertyName || null != ignoringPropertiesFilter && ignoringPropertiesFilter.allow(propertyName)) continue;
                    Serializable value = this.getValue(property);
                    this.cmisService.setProperty(nodeRef, null, propertyName, value);
                }
            }
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    public String getPropertyName(CmisProperty property) {
        String propertyName;
        String string = propertyName = null != property ? property.getPropertyDefinitionId() : null;
        if (null == propertyName && null == (propertyName = property.getLocalName())) {
            propertyName = property.getDisplayName();
        }
        return propertyName;
    }

    private QName createQName(String s) {
        QName qname = s.indexOf(NAMESPACE_BEGIN) != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.namespaceService);
        return qname;
    }

    public CmisPropertiesType getProperties(Object object, PropertyFilter filter) throws CmisException {
        if (object instanceof Version) {
            object = ((Version)object).getFrozenStateNodeRef();
        }
        try {
            Map properties;
            CmisPropertiesType result = new CmisPropertiesType();
            if (object instanceof NodeRef) {
                properties = this.cmisService.getProperties((NodeRef)object);
                Aspects extension = new Aspects();
                result.getAny().add(extension);
                List<String> aspects = extension.getAppliedAspects();
                HashMap<String, Serializable> aspectProperties = new HashMap<String, Serializable>(97);
                for (CMISTypeDefinition typeDef : this.cmisService.getAspects((NodeRef)object)) {
                    aspects.add(typeDef.getTypeId().getId());
                    aspectProperties.putAll(this.cmisService.getProperties((NodeRef)object, typeDef));
                }
                CmisPropertiesType aspectResult = new CmisPropertiesType();
                this.convertToCmisProperties(aspectProperties, filter, aspectResult);
                extension.setProperties(aspectResult);
            } else {
                properties = this.cmisService.getProperties((AssociationRef)object);
            }
            this.convertToCmisProperties(properties, filter, result);
            return result;
        }
        catch (CMISInvalidArgumentException e) {
            throw ExceptionUtil.createCmisException(e.getMessage(), EnumServiceException.INVALID_ARGUMENT, e);
        }
    }

    private void convertToCmisProperties(Map<String, Serializable> properties, PropertyFilter filter, CmisPropertiesType cmisProperties) throws CmisException {
        for (String propertyName : properties.keySet()) {
            CmisProperty property;
            CMISPropertyDefinition propertyTypeDef = this.cmisDictionaryService.findProperty(propertyName, null);
            if (null == propertyTypeDef || !filter.allow(propertyName) || null == (property = this.createProperty(propertyName, propertyTypeDef.getDataType(), properties.get(propertyName)))) continue;
            cmisProperties.getProperty().add(property);
        }
    }

    public CmisProperty createProperty(String pdid, CMISDataTypeEnum dataType, Serializable value) {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                CmisPropertyBoolean property = new CmisPropertyBoolean();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (Boolean propertyValue : (Collection)((Object)value)) {
                        property.getValue().add(propertyValue);
                    }
                } else {
                    property.getValue().add((Boolean)value);
                }
                return property;
            }
            case STRING: {
                CmisPropertyString property = new CmisPropertyString();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (String propertyValue : (Collection)((Object)value)) {
                        property.getValue().add(propertyValue);
                    }
                } else {
                    property.getValue().add((String)((Object)value));
                }
                return property;
            }
            case INTEGER: {
                CmisPropertyInteger property = new CmisPropertyInteger();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (Object propertyValue : (Collection)((Object)value)) {
                        if (propertyValue instanceof Long) {
                            property.getValue().add(BigInteger.valueOf((Long)propertyValue));
                            continue;
                        }
                        property.getValue().add(BigInteger.valueOf(((Integer)propertyValue).intValue()));
                    }
                } else if (value instanceof Long) {
                    property.getValue().add(BigInteger.valueOf((Long)value));
                } else {
                    property.getValue().add(BigInteger.valueOf(((Integer)value).intValue()));
                }
                return property;
            }
            case DATETIME: {
                CmisPropertyDateTime property = new CmisPropertyDateTime();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (Date propertyValue : (Collection)((Object)value)) {
                        XMLGregorianCalendar convertedValue = this.convert(propertyValue);
                        if (null == convertedValue) continue;
                        property.getValue().add(convertedValue);
                    }
                } else {
                    XMLGregorianCalendar convertedValue = this.convert((Date)value);
                    if (null != convertedValue) {
                        property.getValue().add(this.convert((Date)value));
                    }
                }
                return property;
            }
            case ID: {
                CmisPropertyId property = new CmisPropertyId();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (Serializable propertyValue : (Collection)((Object)value)) {
                        if (propertyValue == null) continue;
                        property.getValue().add(propertyValue.toString());
                    }
                } else {
                    property.getValue().add(value != null ? value.toString() : null);
                }
                return property;
            }
            case URI: {
                CmisPropertyUri property = new CmisPropertyUri();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (String propertyValue : (Collection)((Object)value)) {
                        property.getValue().add(propertyValue);
                    }
                } else {
                    property.getValue().add((String)((Object)value));
                }
                return property;
            }
            case DECIMAL: {
                CmisPropertyDecimal property = new CmisPropertyDecimal();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (BigDecimal propertyValue : (Collection)((Object)value)) {
                        property.getValue().add(propertyValue);
                    }
                } else {
                    property.getValue().add(BigDecimal.valueOf((Double)value));
                }
                return property;
            }
            case HTML: {
                CmisPropertyHtml property = new CmisPropertyHtml();
                property.setPropertyDefinitionId(pdid);
                if (value instanceof Collection) {
                    for (String propertyValue : (Collection)((Object)value)) {
                        property.getValue().add(propertyValue);
                    }
                } else {
                    property.getValue().add((String)((Object)value));
                }
                return property;
            }
        }
        return null;
    }

    public XMLGregorianCalendar convert(Date date) {
        if (null != date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            return DATATYPE_FACTORY.newXMLGregorianCalendar(calendar);
        }
        return null;
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Data type instance creation failed! Failed message: " + e.toString(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyMultiValueStateEnum {
        PROPERTY_MULTIVALUED,
        PROPERTY_NOT_MULTIVALUED,
        PROPERTY_NOT_FOUND;

    }
}

