/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities.feed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.util.JSONtoFmModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteFeedRetrieverWebScript
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(SiteFeedRetrieverWebScript.class);
    private ActivityService activityService;

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        HashMap<String, Object> model;
        block9: {
            String extensionPath;
            String format = req.getFormat();
            if (format == null || format.length() == 0) {
                format = this.getDescription().getDefaultFormat();
            }
            String[] extParts = (extensionPath = req.getExtensionPath()) == null ? new String[1] : extensionPath.split("/");
            String siteId = null;
            if (extParts.length != 1) {
                throw new AlfrescoRuntimeException("Unexpected extension: " + extensionPath);
            }
            siteId = extParts[0];
            if (format.equals("atomfeed") || format.equals("atom")) {
                format = "atomentry";
            }
            model = new HashMap<String, Object>();
            try {
                List feedEntries = this.activityService.getSiteFeedEntries(siteId, format);
                if (format.equals("json")) {
                    model.put("feedEntries", feedEntries);
                    model.put("siteId", siteId);
                    break block9;
                }
                ArrayList<Map> activityFeedModels = new ArrayList<Map>();
                try {
                    for (String feedEntry : feedEntries) {
                        activityFeedModels.add(JSONtoFmModel.convertJSONObjectToMap((String)feedEntry));
                    }
                }
                catch (JSONException je) {
                    throw new AlfrescoRuntimeException("Unable to get user feed entries: " + je.getMessage());
                }
                model.put("feedEntries", activityFeedModels);
                model.put("siteId", siteId);
            }
            catch (AccessDeniedException ade) {
                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                status.setCode(401);
                logger.warn((Object)("Unable to get site feed entries for '" + siteId + "' (site does not exist or is private) - currently logged in as '" + currentUser + "'"));
                model.put("feedEntries", null);
                model.put("siteId", "");
            }
        }
        return model;
    }
}

