/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class BlogServiceTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(BlogServiceTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private SiteService siteService;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String SITE_SHORT_NAME_BLOG = "BlogSiteShortNameTest";
    private static final String COMPONENT_BLOG = "blog";
    private static final String URL_BLOG_POST = "/api/blog/post/site/BlogSiteShortNameTest/blog/";
    private static final String URL_BLOG_POSTS = "/api/blog/site/BlogSiteShortNameTest/blog/posts";
    private List<String> posts = new ArrayList<String>(5);
    private List<String> drafts = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_BLOG);
        if (siteInfo == null) {
            this.siteService.createSite("BlogSitePreset", SITE_SHORT_NAME_BLOG, "BlogSiteTitle", "BlogSiteDescription", SiteVisibility.PUBLIC);
        }
        this.createUser(USER_ONE, "SiteCollaborator");
        this.createUser(USER_TWO, "SiteCollaborator");
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(SITE_SHORT_NAME_BLOG);
    }

    private void createUser(String userName, String role) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(SITE_SHORT_NAME_BLOG, userName, role);
    }

    private JSONObject getRequestObject(String title, String content, String[] tags, boolean isDraft) throws Exception {
        JSONObject post = new JSONObject();
        if (title != null) {
            post.put("title", (Object)title);
        }
        if (content != null) {
            post.put("content", (Object)content);
        }
        if (tags != null) {
            JSONArray arr = new JSONArray();
            for (String s : tags) {
                arr.put((Object)s);
            }
            post.put("tags", (Object)arr);
        }
        post.put("draft", isDraft);
        return post;
    }

    private JSONObject createPost(String title, String content, String[] tags, boolean isDraft, int expectedStatus) throws Exception {
        JSONObject post = this.getRequestObject(title, content, tags, isDraft);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_BLOG_POSTS, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject item = result.getJSONObject("item");
        if (isDraft) {
            this.drafts.add(item.getString("name"));
        } else {
            this.posts.add(item.getString("name"));
        }
        return item;
    }

    private JSONObject updatePost(String name, String title, String content, String[] tags, boolean isDraft, int expectedStatus) throws Exception {
        JSONObject post = this.getRequestObject(title, content, tags, isDraft);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_BLOG_POST + name, post.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject getPost(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_BLOG_POST + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = new JSONObject(response.getContentAsString());
            return result.getJSONObject("item");
        }
        return null;
    }

    private String getCommentsUrl(String nodeRef) {
        return "/api/node/" + nodeRef.replace("://", "/") + "/comments";
    }

    private String getCommentUrl(String nodeRef) {
        return "/api/comment/node/" + nodeRef.replace("://", "/");
    }

    private JSONObject createComment(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.getCommentsUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    private JSONObject updateComment(String nodeRef, String title, String content, int expectedStatus) throws Exception {
        JSONObject comment = new JSONObject();
        comment.put("title", (Object)title);
        comment.put("content", (Object)content);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.getCommentUrl(nodeRef), comment.toString(), "application/json"), expectedStatus);
        if (expectedStatus != 200) {
            return null;
        }
        JSONObject result = new JSONObject(response.getContentAsString());
        return result.getJSONObject("item");
    }

    public void testCreateDraftPost() throws Exception {
        String title = "test";
        String content = "test";
        JSONObject item = this.createPost(title, content, null, true, 200);
        BlogServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)true, (Object)item.get("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 404);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testCreatePublishedPost() throws Exception {
        String title = "published";
        String content = "content";
        JSONObject item = this.createPost(title, content, null, false, 200);
        BlogServiceTest.assertEquals((Object)title, (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)content, (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)false, (Object)item.get("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testCreateEmptyPost() throws Exception {
        JSONObject item = this.createPost(null, null, null, false, 200);
        BlogServiceTest.assertEquals((Object)"", (Object)item.get("title"));
        BlogServiceTest.assertEquals((Object)"", (Object)item.get("content"));
        BlogServiceTest.assertEquals((Object)false, (Object)item.get("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(item.getString("name"), 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testUpdated() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        item = this.updatePost(name, "new title", "new content", null, false, 200);
        BlogServiceTest.assertEquals((boolean)true, (boolean)item.getBoolean("isUpdated"));
        BlogServiceTest.assertEquals((String)"new title", (String)item.getString("title"));
        BlogServiceTest.assertEquals((String)"new content", (String)item.getString("content"));
    }

    public void testUpdateWithEmptyValues() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isUpdated"));
        item = this.updatePost(item.getString("name"), null, null, null, false, 200);
        BlogServiceTest.assertEquals((String)"", (String)item.getString("title"));
        BlogServiceTest.assertEquals((String)"", (String)item.getString("content"));
    }

    public void testPublishThroughUpdate() throws Exception {
        JSONObject item = this.createPost("test", "test", null, true, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)true, (boolean)item.getBoolean("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(name, 404);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        item = this.updatePost(name, "new title", "new content", null, false, 200);
        BlogServiceTest.assertEquals((String)"new title", (String)item.getString("title"));
        BlogServiceTest.assertEquals((String)"new content", (String)item.getString("content"));
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isDraft"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        this.getPost(name, 200);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testCannotDoUnpublish() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        BlogServiceTest.assertEquals((boolean)false, (boolean)item.getBoolean("isDraft"));
        item = this.updatePost(name, "new title", "new content", null, true, 400);
    }

    public void testGetAll() throws Exception {
        String url = URL_BLOG_POSTS;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)(this.posts.size() + this.drafts.size()), (int)result.getInt("total"));
    }

    public void testGetNew() throws Exception {
        String url = "/api/blog/site/BlogSiteShortNameTest/blog/posts/new";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)this.posts.size(), (int)result.getInt("total"));
    }

    public void _testGetDrafts() throws Exception {
        String url = "/api/blog/site/BlogSiteShortNameTest/blog/posts/mydrafts";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_BLOG_POSTS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)this.drafts.size(), (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void _testMyPublished() throws Exception {
        String url = "/api/blog/site/BlogSiteShortNameTest/blog/posts/mypublished";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)this.drafts.size(), (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)0, (int)result.getInt("total"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testComments() throws Exception {
        JSONObject item = this.createPost("test", "test", null, false, 200);
        String name = item.getString("name");
        String nodeRef = item.getString("nodeRef");
        JSONObject commentOne = this.createComment(nodeRef, "comment", "content", 200);
        JSONObject commentTwo = this.createComment(nodeRef, "comment", "content", 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getCommentsUrl(nodeRef)), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("total"));
        JSONObject commentThree = this.createComment(nodeRef, "comment", "content", 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getCommentsUrl(nodeRef)), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)3, (int)result.getInt("total"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.getCommentUrl(commentThree.getString("nodeRef"))), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getCommentsUrl(nodeRef)), 200);
        result = new JSONObject(response.getContentAsString());
        BlogServiceTest.assertEquals((int)2, (int)result.getInt("total"));
        JSONObject commentTwoUpdated = this.updateComment(commentTwo.getString("nodeRef"), "new title", "new content", 200);
        BlogServiceTest.assertEquals((String)"new title", (String)commentTwoUpdated.getString("title"));
        BlogServiceTest.assertEquals((String)"new content", (String)commentTwoUpdated.getString("content"));
    }

    public void _testTagsStressTest() throws Exception {
        final List<Exception> exceptions = Collections.synchronizedList(new ArrayList());
        ArrayList<Thread> threads = new ArrayList<Thread>();
        System.err.println("Creating and starting threads...");
        for (int x = 0; x < 3; ++x) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    BlogServiceTest.this.authenticationComponent.setCurrentUser(BlogServiceTest.USER_ONE);
                    try {
                        for (int y = 0; y < 3; ++y) {
                            BlogServiceTest.this._testPostTags();
                            BlogServiceTest.this._testClearTags();
                        }
                        System.err.println("------------- SUCCEEDED ---------------");
                    }
                    catch (Exception e) {
                        System.err.println("------------- ERROR ---------------");
                        exceptions.add(e);
                        e.printStackTrace();
                        return;
                    }
                }
            });
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        System.err.println("------------- STACK TRACES ---------------");
        for (Exception e : exceptions) {
            e.printStackTrace();
        }
        System.err.println("------------- STACK TRACES END ---------------");
        if (exceptions.size() > 0) {
            throw exceptions.get(0);
        }
    }

    public void _testPostTags() throws Exception {
        String[] tags = new String[]{"first", "test"};
        JSONObject item = this.createPost("tagtest", "tagtest", tags, false, 200);
        BlogServiceTest.assertEquals((int)2, (int)item.getJSONArray("tags").length());
        BlogServiceTest.assertEquals((Object)"first", (Object)item.getJSONArray("tags").get(0));
        BlogServiceTest.assertEquals((Object)"test", (Object)item.getJSONArray("tags").get(1));
        item = this.updatePost(item.getString("name"), null, null, new String[]{"First", "Test", "Second"}, false, 200);
        BlogServiceTest.assertEquals((int)3, (int)item.getJSONArray("tags").length());
        BlogServiceTest.assertEquals((Object)"first", (Object)item.getJSONArray("tags").get(0));
        BlogServiceTest.assertEquals((Object)"test", (Object)item.getJSONArray("tags").get(1));
        BlogServiceTest.assertEquals((Object)"second", (Object)item.getJSONArray("tags").get(2));
    }

    public void _testClearTags() throws Exception {
        String[] tags = new String[]{"abc", "def"};
        JSONObject item = this.createPost("tagtest", "tagtest", tags, false, 200);
        BlogServiceTest.assertEquals((int)2, (int)item.getJSONArray("tags").length());
        item = this.updatePost(item.getString("name"), null, null, new String[0], false, 200);
        BlogServiceTest.assertEquals((int)0, (int)item.getJSONArray("tags").length());
    }
}

