/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facebook;

import com.facebook.api.FacebookException;
import com.facebook.api.FacebookRestClient;
import java.io.IOException;
import org.alfresco.repo.web.scripts.facebook.FacebookError;
import org.alfresco.repo.web.scripts.facebook.FacebookServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class FacebookModel {
    private static final Log logger = LogFactory.getLog(FacebookModel.class);
    private FacebookServletRequest req;
    private FacebookRestClient client;
    private String[] friends;
    private String[] appFriends;

    public FacebookModel(FacebookServletRequest req) {
        this.req = req;
    }

    private FacebookRestClient getClient() {
        if (this.client == null) {
            String apiKey = this.req.getApiKey();
            String secretKey = this.req.getSecretKey();
            String sessionKey = this.req.getSessionKey();
            this.client = sessionKey == null ? new FacebookRestClient(apiKey, secretKey) : new FacebookRestClient(apiKey, secretKey, sessionKey);
            if (logger.isDebugEnabled()) {
                this.client.setDebug(true);
            }
        }
        return this.client;
    }

    public String[] getFriends() {
        if (this.friends == null) {
            this.friends = this.req.getFriends();
            if (this.friends == null) {
                try {
                    Document response = this.getClient().friends_get();
                    NodeList uids = response.getElementsByTagName("uid");
                    String[] uidsArray = new String[uids.getLength()];
                    for (int i = 0; i < uids.getLength(); ++i) {
                        uidsArray[i] = uids.item(i).getTextContent();
                    }
                    this.friends = uidsArray;
                }
                catch (FacebookException e) {
                    throw new FacebookError(e.getCode(), e.getMessage());
                }
                catch (IOException e) {
                    throw new FacebookError(e.getMessage());
                }
            }
        }
        return this.friends;
    }

    public String[] getAppFriends() {
        if (this.appFriends == null) {
            try {
                Document response = this.getClient().friends_getAppUsers();
                NodeList uids = response.getElementsByTagName("uid");
                String[] uidsArray = new String[uids.getLength()];
                for (int i = 0; i < uids.getLength(); ++i) {
                    uidsArray[i] = uids.item(i).getTextContent();
                }
                this.appFriends = uidsArray;
            }
            catch (FacebookException e) {
                throw new FacebookError(e.getCode(), e.getMessage());
            }
            catch (IOException e) {
                throw new FacebookError(e.getMessage());
            }
        }
        return this.appFriends;
    }

    public int postUserAction(String title, String body) {
        try {
            Document response = this.getClient().feed_publishActionOfUser((CharSequence)title, (CharSequence)body);
            int status = Integer.parseInt(response.getDocumentElement().getTextContent());
            return status;
        }
        catch (FacebookException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Failed to post user action [title=" + title + ", body=" + body + "] due to " + e.toString()));
            }
            throw new FacebookError(e.getCode(), e.getMessage());
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Failed to post user action [title=" + title + ", body=" + body + "] due to " + e.toString()));
            }
            throw new FacebookError(e.getMessage());
        }
    }

    public String getUser() {
        return this.req.getUserId();
    }

    public String getAppId() {
        return this.req.getAppId();
    }

    public String getSessionKey() {
        return this.req.getSessionKey();
    }

    public String getApiKey() {
        return this.req.getApiKey();
    }

    public String getSecret() {
        return this.req.getSecretKey();
    }

    public String getCanvasPath() {
        return this.req.getCanvasPath();
    }

    public String getCanvasURL() {
        return "http://apps.facebook.com/" + this.getCanvasPath();
    }

    public String getPageURL() {
        return "http://apps.facebook.com" + this.req.getPagePath();
    }
}

