/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.forms;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.forms.AbstractTestFormRestApi;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class FormRestApiJsonPost_Test
extends AbstractTestFormRestApi {
    private static final String PROP_CM_DESCRIPTION = "prop_cm_description";
    private static final String PROP_MIMETYPE = "prop_mimetype";
    private static final String ASSOC_CM_REFERENCES = "assoc_cm_references";
    private static final String ASSOC_CM_REFERENCES_ADDED = "assoc_cm_references_added";
    private static final String ASSOC_CM_REFERENCES_REMOVED = "assoc_cm_references_removed";
    private static final String ASSOC_SYS_CHILDREN = "assoc_sys_children";
    private static final String ASSOC_SYS_CHILDREN_ADDED = "assoc_sys_children_added";
    private static final String ASSOC_SYS_CHILDREN_REMOVED = "assoc_sys_children_removed";

    public void testSimpleJsonPostRequest() throws IOException, JSONException {
        Serializable originalDescription = this.nodeService.getProperty(this.referencingDocNodeRef, ContentModel.PROP_DESCRIPTION);
        FormRestApiJsonPost_Test.assertEquals((Object)"Test form description", (Object)originalDescription);
        String originalMimetype = null;
        ContentData content = (ContentData)this.nodeService.getProperty(this.referencingDocNodeRef, ContentModel.PROP_CONTENT);
        if (content != null) {
            originalMimetype = content.getMimetype();
        }
        JSONObject jsonPostData = new JSONObject();
        String proposedNewDescription = "Modified Description";
        jsonPostData.put(PROP_CM_DESCRIPTION, (Object)"Modified Description");
        jsonPostData.put(PROP_MIMETYPE, (Object)"text/html");
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
        Serializable modifiedDescription = this.nodeService.getProperty(this.referencingDocNodeRef, ContentModel.PROP_DESCRIPTION);
        FormRestApiJsonPost_Test.assertEquals((Object)"Modified Description", (Object)modifiedDescription);
        String modifiedMimetype = null;
        content = (ContentData)this.nodeService.getProperty(this.referencingDocNodeRef, ContentModel.PROP_CONTENT);
        if (content != null) {
            modifiedMimetype = content.getMimetype();
        }
        FormRestApiJsonPost_Test.assertEquals((String)"text/html", (String)modifiedMimetype);
    }

    public void testAddNewAssociationsToNode() throws Exception {
        this.checkOriginalAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToAdd = this.associatedDoc_C + "," + this.associatedDoc_D + "," + this.associatedDoc_E;
        jsonPostData.put(ASSOC_CM_REFERENCES_ADDED, (Object)assocsToAdd);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
        List modifiedAssocs = this.nodeService.getTargetAssocs(this.referencingDocNodeRef, RegexQNamePattern.MATCH_ALL);
        FormRestApiJsonPost_Test.assertEquals((int)5, (int)modifiedAssocs.size());
        ArrayList<NodeRef> associatedNodes = new ArrayList<NodeRef>(5);
        for (AssociationRef assocRef : modifiedAssocs) {
            associatedNodes.add(assocRef.getTargetRef());
        }
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_A));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_B));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_C));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_D));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_E));
    }

    public void testRemoveAssociationsFromNode() throws Exception {
        this.checkOriginalAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToRemove = this.associatedDoc_B.toString();
        jsonPostData.put(ASSOC_CM_REFERENCES_REMOVED, (Object)assocsToRemove);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
        List modifiedAssocs = this.nodeService.getTargetAssocs(this.referencingDocNodeRef, RegexQNamePattern.MATCH_ALL);
        FormRestApiJsonPost_Test.assertEquals((int)1, (int)modifiedAssocs.size());
        ArrayList<NodeRef> associatedNodes = new ArrayList<NodeRef>(5);
        for (AssociationRef assocRef : modifiedAssocs) {
            associatedNodes.add(assocRef.getTargetRef());
        }
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_A));
    }

    public void testAddAssocThatAlreadyExists() throws Exception {
        this.checkOriginalAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToAdd = this.associatedDoc_C.toString();
        jsonPostData.put(ASSOC_CM_REFERENCES_ADDED, (Object)assocsToAdd);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
    }

    public void testRemoveAssocThatDoesNotExist() throws Exception {
        this.checkOriginalAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToRemove = this.associatedDoc_E.toString();
        jsonPostData.put(ASSOC_CM_REFERENCES_REMOVED, (Object)assocsToRemove);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
    }

    public void testAddNewChildAssociationsToNode() throws Exception {
        this.checkOriginalChildAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToAdd = this.childDoc_C + "," + this.childDoc_D + "," + this.childDoc_E;
        jsonPostData.put(ASSOC_SYS_CHILDREN_ADDED, (Object)assocsToAdd);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.containingNodeUpdateUrl.toString(), jsonPostString, "application/json"), 200);
        List modifiedAssocs = this.nodeService.getChildAssocs(this.containerNodeRef);
        FormRestApiJsonPost_Test.assertEquals((int)5, (int)modifiedAssocs.size());
        ArrayList<NodeRef> associatedNodes = new ArrayList<NodeRef>(5);
        for (ChildAssociationRef assocRef : modifiedAssocs) {
            associatedNodes.add(assocRef.getChildRef());
        }
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_A));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_B));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_C));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_D));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_E));
    }

    public void testRemoveChildAssociationsFromNode() throws Exception {
        this.checkOriginalChildAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToRemove = this.childDoc_B.toString();
        jsonPostData.put(ASSOC_SYS_CHILDREN_REMOVED, (Object)assocsToRemove);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.containingNodeUpdateUrl, jsonPostString, "application/json"), 200);
        List modifiedAssocs = this.nodeService.getChildAssocs(this.containerNodeRef);
        FormRestApiJsonPost_Test.assertEquals((int)1, (int)modifiedAssocs.size());
        ArrayList<NodeRef> associatedNodes = new ArrayList<NodeRef>(5);
        for (ChildAssociationRef assocRef : modifiedAssocs) {
            associatedNodes.add(assocRef.getChildRef());
        }
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_A));
    }

    public void testAddChildAssocThatAlreadyExists() throws Exception {
        this.checkOriginalChildAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToAdd = this.childDoc_C.toString();
        jsonPostData.put(ASSOC_SYS_CHILDREN_ADDED, (Object)assocsToAdd);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
    }

    public void testRemoveChildAssocThatDoesNotExist() throws Exception {
        this.checkOriginalChildAssocsBeforeChanges();
        JSONObject jsonPostData = new JSONObject();
        String assocsToRemove = this.childDoc_E.toString();
        jsonPostData.put(ASSOC_SYS_CHILDREN_REMOVED, (Object)assocsToRemove);
        String jsonPostString = jsonPostData.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.referencingNodeUpdateUrl, jsonPostString, "application/json"), 200);
    }

    private void checkOriginalAssocsBeforeChanges() {
        List originalAssocs = this.nodeService.getTargetAssocs(this.referencingDocNodeRef, RegexQNamePattern.MATCH_ALL);
        FormRestApiJsonPost_Test.assertEquals((int)2, (int)originalAssocs.size());
        ArrayList<NodeRef> associatedNodes = new ArrayList<NodeRef>(2);
        associatedNodes.add(((AssociationRef)originalAssocs.get(0)).getTargetRef());
        associatedNodes.add(((AssociationRef)originalAssocs.get(1)).getTargetRef());
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_A));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.associatedDoc_B));
    }

    private void checkOriginalChildAssocsBeforeChanges() {
        List originalChildAssocs = this.nodeService.getChildAssocs(this.containerNodeRef);
        FormRestApiJsonPost_Test.assertEquals((int)2, (int)originalChildAssocs.size());
        ArrayList<NodeRef> associatedNodes = new ArrayList<NodeRef>(2);
        associatedNodes.add(((ChildAssociationRef)originalChildAssocs.get(0)).getChildRef());
        associatedNodes.add(((ChildAssociationRef)originalChildAssocs.get(1)).getChildRef());
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_A));
        FormRestApiJsonPost_Test.assertTrue((boolean)associatedNodes.contains(this.childDoc_B));
    }
}

