/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invite;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationExceptionUserError;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InviteResponse
extends DeclarativeWebScript {
    private static final String RESPONSE_ACCEPT = "accept";
    private static final String RESPONSE_REJECT = "reject";
    private static final String MODEL_PROP_KEY_RESPONSE = "response";
    private static final String MODEL_PROP_KEY_SITE_SHORT_NAME = "siteShortName";
    private static final String PARAM_INVITEE_USER_NAME = "inviteeUserName";
    private InvitationService invitationService;
    private TenantService tenantService;

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    protected Map<String, Object> executeImpl(final WebScriptRequest req, final Status status) {
        String inviteeUserName;
        String tenantDomain = "";
        if (this.tenantService.isEnabled() && (inviteeUserName = req.getParameter(PARAM_INVITEE_USER_NAME)) != null) {
            tenantDomain = this.tenantService.getUserDomain(inviteeUserName);
        }
        return (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return InviteResponse.this.execute(req, status);
            }
        }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
    }

    private Map<String, Object> execute(WebScriptRequest req, Status status) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String inviteId = (String)req.getServiceMatch().getTemplateVars().get("inviteId");
        String inviteTicket = (String)req.getServiceMatch().getTemplateVars().get("inviteTicket");
        String action = (String)req.getServiceMatch().getTemplateVars().get("action");
        if (action.equals(RESPONSE_ACCEPT)) {
            try {
                Invitation invitation = this.invitationService.accept(inviteId, inviteTicket);
                model.put(MODEL_PROP_KEY_RESPONSE, RESPONSE_ACCEPT);
                model.put(MODEL_PROP_KEY_SITE_SHORT_NAME, invitation.getResourceName());
            }
            catch (InvitationExceptionForbidden fe) {
                throw new WebScriptException(403, fe.toString());
            }
            catch (InvitationExceptionUserError fe) {
                throw new WebScriptException(409, fe.toString());
            }
        } else if (action.equals(RESPONSE_REJECT)) {
            try {
                Invitation invitation = this.invitationService.reject(inviteId, "Rejected");
                model.put(MODEL_PROP_KEY_RESPONSE, RESPONSE_REJECT);
                model.put(MODEL_PROP_KEY_SITE_SHORT_NAME, invitation.getResourceName());
            }
            catch (InvitationExceptionForbidden fe) {
                throw new WebScriptException(403, fe.toString());
            }
            catch (InvitationExceptionUserError fe) {
                throw new WebScriptException(409, fe.toString());
            }
        } else {
            throw new WebScriptException(400, "action " + action + " is not supported by this webscript.");
        }
        return model;
    }
}

