/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.site.InviteInfo;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invites
extends DeclarativeWebScript {
    private static final String PARAM_INVITER_USER_NAME = "inviterUserName";
    private static final String PARAM_INVITEE_USER_NAME = "inviteeUserName";
    private static final String PARAM_SITE_SHORT_NAME = "siteShortName";
    private static final String PARAM_INVITE_ID = "inviteId";
    private static final String MODEL_KEY_NAME_INVITES = "invites";
    private WorkflowService workflowService;
    private ServiceRegistry serviceRegistry;
    private SiteService siteService;
    private InvitationService invitationService;

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public InvitationService getInvitationService() {
        return this.invitationService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        boolean inviteIdProvided;
        HashMap<String, Object> model = new HashMap<String, Object>();
        String[] paramNames = req.getParameterNames();
        if (paramNames == null || paramNames.length == 0) {
            throw new WebScriptException(400, "No parameters have been provided on URL");
        }
        String inviterUserName = req.getParameter(PARAM_INVITER_USER_NAME);
        boolean inviterUserNameProvided = inviterUserName != null && inviterUserName.length() != 0;
        String inviteeUserName = req.getParameter(PARAM_INVITEE_USER_NAME);
        boolean inviteeUserNameProvided = inviteeUserName != null && inviteeUserName.length() != 0;
        String siteShortName = req.getParameter(PARAM_SITE_SHORT_NAME);
        boolean siteShortNameProvided = siteShortName != null && siteShortName.length() != 0;
        String inviteId = req.getParameter(PARAM_INVITE_ID);
        boolean bl = inviteIdProvided = inviteId != null && inviteId.length() != 0;
        if (!(inviterUserNameProvided || inviteeUserNameProvided || siteShortNameProvided || inviteIdProvided)) {
            throw new WebScriptException(400, "At least one of the following URL request parameters must be provided in URL 'inviterUserName', 'inviteeUserName', 'siteShortName' or 'inviteId'");
        }
        ArrayList<InviteInfo> inviteInfoList = new ArrayList<InviteInfo>();
        if (inviteIdProvided) {
            NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
            inviteInfoList.add(this.toInviteInfo(invitation));
        } else {
            InvitationSearchCriteriaImpl criteria = new InvitationSearchCriteriaImpl();
            criteria.setInvitationType(InvitationSearchCriteria.InvitationType.NOMINATED);
            criteria.setResourceType(Invitation.ResourceType.WEB_SITE);
            if (inviterUserNameProvided) {
                criteria.setInviter(inviterUserName);
            }
            if (inviteeUserNameProvided) {
                criteria.setInvitee(inviteeUserName);
            }
            if (siteShortNameProvided) {
                criteria.setResourceName(siteShortName);
            }
            List invitations = this.invitationService.searchInvitation((InvitationSearchCriteria)criteria);
            for (Invitation invitation : invitations) {
                inviteInfoList.add(this.toInviteInfo((NominatedInvitation)invitation));
            }
        }
        model.put(MODEL_KEY_NAME_INVITES, inviteInfoList);
        return model;
    }

    private InviteInfo toInviteInfo(NominatedInvitation invitation) {
        PersonService personService = this.serviceRegistry.getPersonService();
        SiteInfo siteInfo = this.siteService.getSite(invitation.getResourceName());
        String invitationStatus = "pending";
        NodeRef inviterRef = personService.getPerson(invitation.getInviterUserName());
        TemplateNode inviterPerson = null;
        if (inviterRef != null) {
            inviterPerson = new TemplateNode(inviterRef, this.serviceRegistry, null);
        }
        NodeRef inviteeRef = personService.getPerson(invitation.getInviteeUserName());
        TemplateNode inviteePerson = null;
        if (inviteeRef != null) {
            inviteePerson = new TemplateNode(inviteeRef, this.serviceRegistry, null);
        }
        InviteInfo ret = new InviteInfo(invitationStatus, invitation.getInviterUserName(), inviterPerson, invitation.getInviteeUserName(), inviteePerson, invitation.getRoleName(), invitation.getResourceName(), siteInfo, invitation.getSentInviteDate(), invitation.getInviteId());
        return ret;
    }
}

