/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class SiteServiceTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private SiteService siteService;
    private NodeService nodeService;
    private AuthorityService authorityService;
    private static final String USER_ONE = "SiteTestOne";
    private static final String USER_TWO = "SiteTestTwo";
    private static final String USER_THREE = "SiteTestThree";
    private static final String URL_SITES = "/api/sites";
    private static final String URL_SITES_QUERY = "/api/sites/query";
    private static final String URL_MEMBERSHIPS = "/memberships";
    private List<String> createdSites = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.authorityService = (AuthorityService)this.getServer().getApplicationContext().getBean("AuthorityService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (String shortName : this.createdSites) {
            this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 0);
        }
        this.createdSites.clear();
    }

    public void testCreateSite() throws Exception {
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        SiteServiceTest.assertEquals((Object)"myPreset", (Object)result.get("sitePreset"));
        SiteServiceTest.assertEquals((Object)shortName, (Object)result.get("shortName"));
        SiteServiceTest.assertEquals((Object)"myTitle", (Object)result.get("title"));
        SiteServiceTest.assertEquals((Object)"myDescription", (Object)result.get("description"));
        SiteServiceTest.assertNotNull((Object)result.get("node"));
        SiteServiceTest.assertNotNull((Object)result.get("tagScope"));
        SiteServiceTest.assertEquals((Object)SiteVisibility.PUBLIC.toString(), (Object)result.get("visibility"));
        SiteServiceTest.assertTrue((boolean)result.getBoolean("isPublic"));
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 500);
    }

    private JSONObject createSite(String sitePreset, String shortName, String title, String description, SiteVisibility visibility, int expectedStatus) throws Exception {
        JSONObject site = new JSONObject();
        site.put("sitePreset", (Object)sitePreset);
        site.put("shortName", (Object)shortName);
        site.put("title", (Object)title);
        site.put("description", (Object)description);
        site.put("visibility", (Object)visibility.toString());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_SITES, site.toString(), "application/json"), expectedStatus);
        this.createdSites.add(shortName);
        return new JSONObject(response.getContentAsString());
    }

    public void testGetSites() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((String)"Sites exist prior to running test", (int)0, (int)result.length());
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", GUID.generate(), "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_SITES), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)5, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites?size=3"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)3, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites?size=13"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)5, (int)result.length());
    }

    public void testQuerySites() throws Exception {
        String[] shortNames = new String[]{GUID.generate(), GUID.generate(), GUID.generate(), GUID.generate(), GUID.generate()};
        this.createSite("myPreset", shortNames[0], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[1], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[2], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[3], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.createSite("myPreset", shortNames[4], "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject shortNameQuery = new JSONObject();
        shortNameQuery.put("match", (Object)"exact");
        JSONArray valuesArray = new JSONArray();
        valuesArray.put(0, (Object)shortNames[0]);
        valuesArray.put(1, (Object)shortNames[2]);
        valuesArray.put(2, (Object)shortNames[4]);
        valuesArray.put(3, (Object)"bobbins");
        shortNameQuery.put("values", (Object)valuesArray);
        JSONObject query = new JSONObject();
        query.put("shortName", (Object)shortNameQuery);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_SITES_QUERY, query.toString(), "application/json"), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertEquals((int)3, (int)result.length());
        HashSet<String> resultSet = new HashSet<String>();
        for (int i = 0; i < result.length(); ++i) {
            resultSet.add((String)result.getJSONObject(i).get("shortName"));
        }
        SiteServiceTest.assertTrue((boolean)resultSet.contains(shortNames[0]));
        SiteServiceTest.assertFalse((boolean)resultSet.contains(shortNames[1]));
        SiteServiceTest.assertTrue((boolean)resultSet.contains(shortNames[2]));
        SiteServiceTest.assertFalse((boolean)resultSet.contains(shortNames[3]));
        SiteServiceTest.assertTrue((boolean)resultSet.contains(shortNames[4]));
        SiteServiceTest.assertFalse((boolean)resultSet.contains("bobbins"));
        JSONObject site = result.getJSONObject(0);
        SiteServiceTest.assertNotNull((Object)site);
        SiteServiceTest.assertEquals((Object)"myPreset", (Object)site.get("sitePreset"));
        SiteServiceTest.assertEquals((Object)"myTitle", (Object)site.get("title"));
        SiteServiceTest.assertEquals((Object)"myDescription", (Object)site.get("description"));
        SiteServiceTest.assertNotNull((Object)site.get("node"));
        SiteServiceTest.assertNotNull((Object)site.get("tagScope"));
        SiteServiceTest.assertTrue((boolean)site.getBoolean("isPublic"));
    }

    public void testGetSite() throws Exception {
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/somerandomshortname"), 404);
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
    }

    public void testUpdateSite() throws Exception {
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        result.put("title", (Object)"abs123abc");
        result.put("description", (Object)"123abc123");
        result.put("visibility", (Object)SiteVisibility.PRIVATE.toString());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName, result.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"abs123abc", (Object)result.get("title"));
        SiteServiceTest.assertEquals((Object)"123abc123", (Object)result.get("description"));
        SiteServiceTest.assertFalse((boolean)result.getBoolean("isPublic"));
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)result.get("visibility"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"abs123abc", (Object)result.get("title"));
        SiteServiceTest.assertEquals((Object)"123abc123", (Object)result.get("description"));
        SiteServiceTest.assertFalse((boolean)result.getBoolean("isPublic"));
        SiteServiceTest.assertEquals((Object)SiteVisibility.PRIVATE.toString(), (Object)result.get("visibility"));
    }

    public void testDeleteSite() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/somerandomshortname"), 404);
        String shortName = GUID.generate();
        JSONObject result = this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName), 404);
    }

    public void testGetMemberships() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)1, (int)result.length());
        JSONObject membership = result.getJSONObject(0);
        SiteServiceTest.assertEquals((Object)"SiteManager", (Object)membership.get("role"));
        SiteServiceTest.assertEquals((Object)USER_ONE, (Object)membership.getJSONObject("authority").get("userName"));
    }

    public void testPostMemberships() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteConsumer", (Object)membership.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)membership.getJSONObject("person").get("userName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        JSONArray result2 = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result2);
        SiteServiceTest.assertEquals((int)2, (int)result2.length());
    }

    public void testGetMembership() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/badsite/memberships/SiteTestOne"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/baduser"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_TWO), 404);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_ONE), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteManager", (Object)result.get("role"));
        SiteServiceTest.assertEquals((Object)USER_ONE, (Object)result.getJSONObject("authority").get("userName"));
    }

    public void testPutMembership() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject newMember = new JSONObject(response.getContentAsString());
        newMember.put("role", (Object)"SiteCollaborator");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_TWO, newMember.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteCollaborator", (Object)result.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)result.getJSONObject("authority").get("userName"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_TWO), 200);
        result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((Object)"SiteCollaborator", (Object)result.get("role"));
        SiteServiceTest.assertEquals((Object)USER_TWO, (Object)result.getJSONObject("authority").get("userName"));
    }

    public void testGroupMembership() throws Exception {
        String testGroup = "SiteServiceTestGroupA";
        String testGroupName = "GROUP_" + testGroup;
        if (!this.authorityService.authorityExists(testGroup)) {
            this.authenticationComponent.setSystemUserAsCurrentUser();
            testGroupName = this.authorityService.createAuthority(AuthorityType.GROUP, testGroup, testGroup, this.authorityService.getDefaultZones());
        }
        this.authenticationComponent.setCurrentUser(USER_ONE);
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject group = new JSONObject();
        group.put("fullName", (Object)testGroupName);
        membership.put("group", (Object)group);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        JSONObject newMember = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((String)"role not correct", (String)"SiteConsumer", (String)newMember.getString("role"));
        JSONObject newGroup = newMember.getJSONObject("authority");
        SiteServiceTest.assertNotNull((Object)"newGroup");
        SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)newGroup.getString("fullName"));
        SiteServiceTest.assertEquals((String)"authorityType not correct", (String)"GROUP", (String)newGroup.getString("authorityType"));
        newMember.put("role", (Object)"SiteCollaborator");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_TWO, newMember.toString(), "application/json"), 200);
        JSONObject updateResult = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertEquals((String)"role not correct", (String)"SiteCollaborator", (String)updateResult.getString("role"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS), 200);
        JSONArray listResult = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertTrue((String)"result too small", (listResult.length() >= 2 ? 1 : 0) != 0);
        for (int i = 0; i < listResult.length(); ++i) {
            JSONObject obj = listResult.getJSONObject(i);
            JSONObject authority = obj.getJSONObject("authority");
            if (authority.getString("authorityType").equals("GROUP")) {
                SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)authority.getString("fullName"));
            }
            if (!authority.getString("authorityType").equals("USER")) continue;
            SiteServiceTest.assertEquals((String)"full name not correct", (String)USER_ONE, (String)authority.getString("fullName"));
        }
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + '/' + testGroupName), 200);
        JSONObject getResult = new JSONObject(response.getContentAsString());
        System.out.println(response.getContentAsString());
        JSONObject grp = getResult.getJSONObject("authority");
        SiteServiceTest.assertEquals((String)"full name not correct", (String)testGroupName, (String)grp.getString("fullName"));
    }

    public void testDeleteMembership() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_TWO), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + URL_MEMBERSHIPS + "/" + USER_TWO), 404);
    }

    public void testGetPersonSites() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String shortName2 = GUID.generate();
        this.createSite("myPreset", shortName2, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestTwo/sites"), 200);
        JSONArray result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)0, (int)result.length());
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        membership = new JSONObject();
        membership.put("role", (Object)"SiteConsumer");
        person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName2 + URL_MEMBERSHIPS, membership.toString(), "application/json"), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestTwo/sites"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)2, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestOne/sites"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)2, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestThree/sites"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)0, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestOne/sites?size=1"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)1, (int)result.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/SiteTestOne/sites?size=5"), 200);
        result = new JSONArray(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        SiteServiceTest.assertEquals((int)2, (int)result.length());
    }

    public void testSiteCustomProperties() throws Exception {
        SiteInfo siteInfo = this.siteService.createSite("testPreset", "mySiteWithCustomProperty2", "testTitle", "testDescription", SiteVisibility.PUBLIC);
        NodeRef siteNodeRef = siteInfo.getNodeRef();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(QName.createQName((String)"http://www.alfresco.org/model/sitecustomproperty/1.0", (String)"additionalInformation"), "information");
        this.nodeService.addAspect(siteNodeRef, QName.createQName((String)"http://www.alfresco.org/model/site/1.0", (String)"customSiteProperties"), properties);
        this.createdSites.add("mySiteWithCustomProperty2");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/mySiteWithCustomProperty2"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        SiteServiceTest.assertNotNull((Object)result);
        JSONObject customProperties = result.getJSONObject("customProperties");
        SiteServiceTest.assertNotNull((Object)customProperties);
        JSONObject addInfo = customProperties.getJSONObject("{http://www.alfresco.org/model/sitecustomproperty/1.0}additionalInformation");
        SiteServiceTest.assertNotNull((Object)addInfo);
        SiteServiceTest.assertEquals((Object)"{http://www.alfresco.org/model/sitecustomproperty/1.0}additionalInformation", (Object)addInfo.get("name"));
        SiteServiceTest.assertEquals((Object)"information", (Object)addInfo.get("value"));
        SiteServiceTest.assertEquals((Object)"{http://www.alfresco.org/model/dictionary/1.0}text", (Object)addInfo.get("type"));
        SiteServiceTest.assertEquals((Object)"Additional Site Information", (Object)addInfo.get("title"));
    }

    public void testInvitationSanityCheck() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteComments = "Please sir, let me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "buffy@sunnydale";
        String inviteeUserName = userName;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String nominatedId = this.createNominatedInvitation(shortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + nominatedId), 200);
        String moderatedId = this.createModeratedInvitation(shortName, inviteComments, userName, roleName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + moderatedId), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=" + userName), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations"), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/invitations/" + nominatedId), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/invitations/" + moderatedId), 200);
    }

    public void testGetInvitation() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteeComments = "Please sir, let $* me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteId = this.createModeratedInvitation(shortName, inviteeComments, userName, roleName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/rubbish/invitations/" + inviteId), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/jbpm$8787487"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/trash$123"), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/trash123"), 404);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        SiteServiceTest.assertNotNull((String)"data is null", (Object)data);
        SiteServiceTest.assertEquals((String)"inviteId is not set", (String)data.getString("inviteId"), (String)inviteId);
        SiteServiceTest.assertEquals((String)"invitationType", (String)"MODERATED", (String)data.getString("invitationType"));
        SiteServiceTest.assertEquals((String)"inviteeUserName is not set", (String)userName, (String)data.getString("inviteeUserName"));
        SiteServiceTest.assertEquals((String)"resourceName is not correct", (String)shortName, (String)data.getString("resourceName"));
        SiteServiceTest.assertEquals((String)"resourceType is not correct", (String)"WEB_SITE", (String)data.getString("resourceType"));
        SiteServiceTest.assertEquals((String)"inviteeComments", (String)inviteeComments, (String)data.getString("inviteeComments"));
        SiteServiceTest.assertEquals((String)"roleName is not set", (String)roleName, (String)data.getString("roleName"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 404);
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "FirstName123.LastName123@email.com";
        String inviteeUserName = null;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        inviteId = this.createNominatedInvitation(shortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
        JSONObject top2 = new JSONObject(response2.getContentAsString());
        JSONObject data2 = top2.getJSONObject("data");
        SiteServiceTest.assertNotNull((String)"data is null", (Object)data2);
        SiteServiceTest.assertEquals((String)"inviteId is not set", (String)data2.getString("inviteId"), (String)inviteId);
        SiteServiceTest.assertEquals((String)"invitationType", (String)"NOMINATED", (String)data2.getString("invitationType"));
        SiteServiceTest.assertEquals((String)"resourceName is not correct", (String)shortName, (String)data2.getString("resourceName"));
        SiteServiceTest.assertEquals((String)"resourceType is not correct", (String)"WEB_SITE", (String)data2.getString("resourceType"));
        SiteServiceTest.assertEquals((String)"roleName is not set", (String)roleName, (String)data2.getString("roleName"));
        SiteServiceTest.assertNotNull((String)"inviteeUserName is not set", (Object)data2.getString("inviteeUserName"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/sites/" + shortName + "/invitations/" + inviteId), 200);
    }

    public void testListInvitation() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteeComments = "Please sir, let $* me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String moderatedIdA = this.createModeratedInvitation(shortName, inviteeComments, userName, roleName);
        String inviteeCommentsB = "Please sir, let $* me in";
        String userNameB = USER_THREE;
        String roleNameB = "SiteConsumer";
        String moderatedIdB = this.createModeratedInvitation(shortName, inviteeCommentsB, userNameB, roleNameB);
        String inviteeFirstName = "Buffy";
        String inviteeLastName = "Summers";
        String inviteeEmail = "buffy@sunnydale";
        String inviteeUserName = userName;
        String serverPath = "http://localhost:8081/share/";
        String acceptURL = "page/accept-invite";
        String rejectURL = "page/reject-invite";
        String nominatedId = this.createNominatedInvitation(shortName, inviteeFirstName, inviteeLastName, inviteeEmail, inviteeUserName, roleName, serverPath, acceptURL, rejectURL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=wombat"), 200);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONArray data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"user wombat", (int)data.length(), (int)0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=" + USER_TWO), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"user two invitation not found", (int)data.length(), (int)2);
        JSONObject first = data.getJSONObject(0);
        SiteServiceTest.assertEquals((String)"first userid is wrong", (String)first.getString("inviteeUserName"), (String)USER_TWO);
        JSONObject second = data.getJSONObject(0);
        SiteServiceTest.assertEquals((String)"second userid is wrong", (String)second.getString("inviteeUserName"), (String)USER_TWO);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?invitationType=MODERATED"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"two moderated invitations not found", (int)data.length(), (int)2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?invitationType=NOMINATED"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"one nominated invitation not found", (int)data.length(), (int)1);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?invitationType=Crap"), 500);
        top = new JSONObject(response.getContentAsString());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/sites/" + shortName + "/invitations?inviteeUserName=" + USER_TWO + "&invitationType=MODERATED"), 200);
        top = new JSONObject(response.getContentAsString());
        data = top.getJSONArray("data");
        SiteServiceTest.assertEquals((String)"user two invitation not found", (int)data.length(), (int)1);
        first = data.getJSONObject(0);
        SiteServiceTest.assertEquals((String)"first userid is wrong", (String)first.getString("inviteeUserName"), (String)USER_TWO);
        SiteServiceTest.assertEquals((String)"type is wrong", (String)first.getString("invitationType"), (String)"MODERATED");
    }

    public void testCreateInvitation() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        String inviteComments = "Please sir, let me in";
        String userName = USER_TWO;
        String roleName = "SiteConsumer";
        String inviteId = null;
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"Grundge");
        newInvitation.put("inviteeRoleName", (Object)roleName);
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 400);
        newInvitation = new JSONObject();
        newInvitation.put("inviteeRoleName", (Object)roleName);
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 400);
        newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)"");
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 400);
        newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)roleName);
        newInvitation.put("inviteeComments", (Object)inviteComments);
        newInvitation.put("inviteeUserName", (Object)userName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + shortName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        inviteId = data.getString("inviteId");
        SiteServiceTest.assertEquals((String)"invitationType", (String)"MODERATED", (String)data.getString("invitationType"));
        SiteServiceTest.assertEquals((String)"inviteeUserName is not set", (String)userName, (String)data.getString("inviteeUserName"));
        SiteServiceTest.assertEquals((String)"resourceName is not correct", (String)shortName, (String)data.getString("resourceName"));
        SiteServiceTest.assertEquals((String)"resourceType is not correct", (String)"WEB_SITE", (String)data.getString("resourceType"));
        SiteServiceTest.assertNotNull((String)"inviteId is null", (Object)inviteId);
        SiteServiceTest.assertTrue((String)"inviteId is too small", (inviteId.length() > 0 ? 1 : 0) != 0);
    }

    private String createNominatedInvitation(String siteName, String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeUserName, String inviteeRoleName, String serverPath, String acceptURL, String rejectURL) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"NOMINATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        if (inviteeUserName != null) {
            newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        } else {
            newInvitation.put("inviteeFirstName", (Object)inviteeFirstName);
            newInvitation.put("inviteeLastName", (Object)inviteeLastName);
            newInvitation.put("inviteeEmail", (Object)inviteeEmail);
        }
        newInvitation.put("serverPath", (Object)serverPath);
        newInvitation.put("acceptURL", (Object)acceptURL);
        newInvitation.put("rejectURL", (Object)rejectURL);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        return inviteId;
    }

    private String createModeratedInvitation(String siteName, String inviteeComments, String inviteeUserName, String inviteeRoleName) throws Exception {
        JSONObject newInvitation = new JSONObject();
        newInvitation.put("invitationType", (Object)"MODERATED");
        newInvitation.put("inviteeRoleName", (Object)inviteeRoleName);
        newInvitation.put("inviteeComments", (Object)inviteeComments);
        newInvitation.put("inviteeUserName", (Object)inviteeUserName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/sites/" + siteName + "/invitations", newInvitation.toString(), "application/json"), 201);
        JSONObject top = new JSONObject(response.getContentAsString());
        JSONObject data = top.getJSONObject("data");
        String inviteId = data.getString("inviteId");
        return inviteId;
    }
}

