/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wcm.membership;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class WebProjectMembershipTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "WebProjectTestOne";
    private static final String USER_TWO = "WebProjectTestTwo";
    private static final String USER_THREE = "WebProjectTestThree";
    public static final String ROLE_CONTENT_MANAGER = "ContentManager";
    public static final String ROLE_CONTENT_PUBLISHER = "ContentPublisher";
    public static final String ROLE_CONTENT_REVIEWER = "ContentReviewer";
    public static final String ROLE_CONTENT_CONTRIBUTOR = "ContentContributor";
    private static final String URL_WEB_PROJECTS = "/api/wcm/webprojects";
    private static final String URL_MEMBERSHIPS = "/memberships";
    private static final String BASIC_NAME = "testProj";
    private static final String BASIC_DESCRIPTION = "testDescription";
    private static final String BASIC_TITLE = "testTitle";
    private static final String BASIC_DNSNAME = "testDNSName";
    private List<String> createdWebProjects = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (String webProjectRef : this.createdWebProjects) {
            try {
                this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/" + webProjectRef), 0);
            }
            catch (Exception exception) {}
        }
        this.createdWebProjects.clear();
    }

    private String createWebProject() throws Exception {
        JSONObject webProj = new JSONObject();
        webProj.put("name", (Object)BASIC_NAME);
        webProj.put("description", (Object)BASIC_DESCRIPTION);
        webProj.put("title", (Object)BASIC_TITLE);
        webProj.put("dnsName", (Object)BASIC_DNSNAME);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_WEB_PROJECTS, webProj.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String webProjectRef = data.getString("webprojectref");
        WebProjectMembershipTest.assertNotNull((String)"webproject ref is null", (Object)webProjectRef);
        this.createdWebProjects.add(webProjectRef);
        return webProjectRef;
    }

    public void testListMemberships() throws Exception {
        JSONObject obj;
        int i;
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webProjectRef = this.createWebProject();
        String validURL = "/api/wcm/webprojects/" + webProjectRef + URL_MEMBERSHIPS;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validURL), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONArray data = result.getJSONArray("data");
        WebProjectMembershipTest.assertNotNull((Object)data);
        WebProjectMembershipTest.assertEquals((int)1, (int)data.length());
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_ONE);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validURL), 200);
        JSONObject result2 = new JSONObject(response2.getContentAsString());
        JSONArray data2 = result2.getJSONArray("data");
        WebProjectMembershipTest.assertNotNull((Object)data2);
        WebProjectMembershipTest.assertEquals((int)2, (int)data2.length());
        boolean foundUser = false;
        for (i = 0; i < data2.length(); ++i) {
            obj = data2.getJSONObject(i);
            if (!USER_ONE.equals(obj.getJSONObject("person").get("userName"))) continue;
            WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_MANAGER, (Object)obj.get("role"));
            foundUser = true;
        }
        WebProjectMembershipTest.assertTrue((String)"user one not found", (boolean)foundUser);
        membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_REVIEWER);
        person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
        response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validURL), 200);
        result2 = new JSONObject(response2.getContentAsString());
        data2 = result2.getJSONArray("data");
        WebProjectMembershipTest.assertNotNull((Object)data2);
        WebProjectMembershipTest.assertEquals((int)3, (int)data2.length());
        foundUser = false;
        for (i = 0; i < data2.length(); ++i) {
            obj = data2.getJSONObject(i);
            if (!USER_TWO.equals(obj.getJSONObject("person").get("userName"))) continue;
            WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_REVIEWER, (Object)obj.get("role"));
            foundUser = true;
        }
        WebProjectMembershipTest.assertTrue((String)"user one not found", (boolean)foundUser);
        String stepURL = "/api/wcm/webprojects?userName=WebProjectTestTwo";
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(stepURL), 200);
        response2 = new JSONObject(list.getContentAsString());
        JSONArray data3 = response2.getJSONArray("data");
        WebProjectMembershipTest.assertTrue((data3.length() == 1 ? 1 : 0) != 0);
        String invalidURL = "/api/wcm/webprojects/NotExist/memberships";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(invalidURL), 404);
    }

    public void testCreateMemberships() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webProjectRef = this.createWebProject();
        String validURL = "/api/wcm/webprojects/" + webProjectRef + URL_MEMBERSHIPS;
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_MANAGER, (Object)data.get("role"));
        WebProjectMembershipTest.assertEquals((Object)USER_TWO, (Object)data.getJSONObject("person").get("userName"));
        String validGetURL = "/api/wcm/webprojects/" + webProjectRef + "/memberships/" + USER_TWO;
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validGetURL), 200);
        JSONObject result2 = new JSONObject(response2.getContentAsString());
        JSONObject data2 = result2.getJSONObject("data");
        WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_MANAGER, (Object)data2.get("role"));
        WebProjectMembershipTest.assertEquals((Object)USER_TWO, (Object)data2.getJSONObject("person").get("userName"));
        membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
        result = new JSONObject(response.getContentAsString());
        data = result.getJSONObject("data");
        WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_MANAGER, (Object)data.get("role"));
        WebProjectMembershipTest.assertEquals((Object)USER_TWO, (Object)data.getJSONObject("person").get("userName"));
        membership = new JSONObject();
        person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 400);
        membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 400);
    }

    public void testGetMembership() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webProjectRef = this.createWebProject();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/wcm/webprojects/badsite/memberships/WebProjectTestOne"), 404);
        String validURL = "/api/wcm/webprojects/" + webProjectRef + URL_MEMBERSHIPS;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validURL + "baduser"), 404);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validURL + "/" + AuthenticationUtil.getAdminUserName()), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_MANAGER, (Object)data.get("role"));
        WebProjectMembershipTest.assertEquals((Object)AuthenticationUtil.getAdminUserName(), (Object)data.getJSONObject("person").get("userName"));
    }

    public void testDeleteMembership() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webProjectRef = this.createWebProject();
        String validURL = "/api/wcm/webprojects/" + webProjectRef + URL_MEMBERSHIPS;
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        WebProjectMembershipTest.assertEquals((Object)ROLE_CONTENT_MANAGER, (Object)data.get("role"));
        WebProjectMembershipTest.assertEquals((Object)USER_TWO, (Object)data.getJSONObject("person").get("userName"));
        String validGetURL = "/api/wcm/webprojects/" + webProjectRef + URL_MEMBERSHIPS + "/" + USER_TWO;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validGetURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(validGetURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(validGetURL), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(validGetURL), 404);
    }
}

