/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.wcm.sandbox;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class SandboxTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "WebProjectTestOne";
    private static final String USER_TWO = "WebProjectTestTwo";
    private static final String USER_THREE = "WebProjectTestThree";
    private static final String USER_FOUR = "WebProjectTestFour";
    public static final String ROLE_CONTENT_MANAGER = "ContentManager";
    public static final String ROLE_CONTENT_PUBLISHER = "ContentPublisher";
    public static final String ROLE_CONTENT_REVIEWER = "ContentReviewer";
    public static final String ROLE_CONTENT_CONTRIBUTOR = "ContentContributor";
    private static final String URL_WEB_PROJECT = "/api/wcm/webprojects";
    private static final String URI_MEMBERSHIPS = "/memberships";
    private static final String URI_SANDBOXES = "/sandboxes";
    private static final String BASIC_NAME = "testProj";
    private static final String BASIC_DESCRIPTION = "testDescription";
    private static final String BASIC_TITLE = "testTitle";
    private static final String BASIC_DNSNAME = "testDNSName";
    private List<String> createdWebProjects = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.createUser(USER_FOUR);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private void createMembership(String webProjectRef, String userName, String role) throws Exception {
        String validURL = "/api/wcm/webprojects/" + webProjectRef + URI_MEMBERSHIPS;
        JSONObject membership = new JSONObject();
        membership.put("role", (Object)ROLE_CONTENT_MANAGER);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)USER_TWO);
        membership.put("person", (Object)person);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, membership.toString(), "application/json"), 200);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        for (String webProjectRef : this.createdWebProjects) {
            try {
                this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/wcm/webprojects/" + webProjectRef), 0);
            }
            catch (Exception exception) {}
        }
        this.createdWebProjects.clear();
    }

    private String createWebProject() throws Exception {
        JSONObject webProj = new JSONObject();
        webProj.put("name", (Object)BASIC_NAME);
        webProj.put("description", (Object)BASIC_DESCRIPTION);
        webProj.put("title", (Object)BASIC_TITLE);
        webProj.put("dnsName", (Object)BASIC_DNSNAME);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_WEB_PROJECT, webProj.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String webProjectRef = data.getString("webprojectref");
        SandboxTest.assertNotNull((String)"webproject ref is null", (Object)webProjectRef);
        this.createdWebProjects.add(webProjectRef);
        return webProjectRef;
    }

    public void testCreateSandbox() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        JSONObject box = new JSONObject();
        box.put("userName", (Object)USER_ONE);
        String validURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String sandboxref = data.getString("sandboxref");
        String url = data.getString("url");
        String name = data.getString("name");
        JSONObject createdDate = data.getJSONObject("createdDate");
        String createdOn = createdDate.getString("iso8601");
        String createdBy = data.getString("creator");
        boolean isAuthorSandbox = data.getBoolean("isAuthorSandbox");
        boolean isStagingSandbox = data.getBoolean("isStagingSandbox");
        SandboxTest.assertNotNull((String)"created date is null", (Object)createdOn);
        SandboxTest.assertNotNull((String)"created by is null", (Object)createdBy);
        SandboxTest.assertNotNull((String)"sandboxref is null", (Object)sandboxref);
        SandboxTest.assertNotNull((String)"url is null", (Object)url);
        SandboxTest.assertNotNull((String)"name is null", (Object)name);
        SandboxTest.assertTrue((String)"not author sandbox", (boolean)isAuthorSandbox);
        SandboxTest.assertFalse((String)"is staging sandbox", (boolean)isStagingSandbox);
        Date d = ISO8601DateFormat.parse((String)createdOn);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String sandboxURL = "/api/wcm/webprojects/" + webprojref + "/sandboxes/" + sandboxref;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(sandboxURL), 200);
        JSONObject box2 = new JSONObject();
        String validURL2 = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL2, box2.toString(), "application/json"), 400);
    }

    public void testListSandbox() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        String sandboxesURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        TestWebScriptServer.Response list = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL), 200);
        JSONObject result = new JSONObject(list.getContentAsString());
        JSONArray lookupResult = result.getJSONArray("data");
        SandboxTest.assertTrue((String)"list of sandboxes is empty", (lookupResult.length() > 0 ? 1 : 0) != 0);
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        this.createMembership(webprojref, USER_TWO, ROLE_CONTENT_REVIEWER);
        this.createMembership(webprojref, USER_THREE, ROLE_CONTENT_CONTRIBUTOR);
        String validURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        JSONObject box = new JSONObject();
        box.put("userName", (Object)USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        box.put("userName", (Object)USER_TWO);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        box.put("userName", (Object)USER_THREE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        String sandboxesURL2 = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "?userName=" + USER_ONE;
        TestWebScriptServer.Response list2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 200);
        JSONObject result2 = new JSONObject(list2.getContentAsString());
        JSONArray lookupResult2 = result2.getJSONArray("data");
        SandboxTest.assertTrue((String)"testListUserSandbox", (lookupResult2.length() == 1 ? 1 : 0) != 0);
        JSONObject obj1 = lookupResult2.getJSONObject(0);
        String url = obj1.getString("url");
        String name = obj1.getString("name");
        SandboxTest.assertNotNull((String)"url is null", (Object)url);
        SandboxTest.assertNotNull((String)"name is null", (Object)name);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        sandboxesURL2 = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "?userName=" + USER_TWO;
        list2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 200);
        result2 = new JSONObject(list2.getContentAsString());
        lookupResult2 = result2.getJSONArray("data");
        SandboxTest.assertTrue((String)"testListUserSandbox", (lookupResult2.length() == 1 ? 1 : 0) != 0);
        sandboxesURL2 = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        list2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 200);
        result2 = new JSONObject(list2.getContentAsString());
        lookupResult2 = result2.getJSONArray("data");
        SandboxTest.assertTrue((String)"list of sandboxes is empty", (lookupResult2.length() > 3 ? 1 : 0) != 0);
        sandboxesURL2 = "/api/wcm/webprojects/twaddle/sandboxes";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 404);
        sandboxesURL2 = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES + "?userName=" + USER_FOUR;
        list2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxesURL2), 200);
        result2 = new JSONObject(list2.getContentAsString());
        lookupResult2 = result2.getJSONArray("data");
        SandboxTest.assertTrue((String)"lookup user 4 (not existing) found a sandbox", (lookupResult2.length() == 0 ? 1 : 0) != 0);
    }

    public void testGetSandbox() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        JSONObject box = new JSONObject();
        box.put("userName", (Object)USER_ONE);
        String validURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String sandboxref = data.getString("sandboxref");
        SandboxTest.assertNotNull((String)"sandboxref is null", (Object)sandboxref);
        String sandboxURL = "/api/wcm/webprojects/" + webprojref + "/sandboxes/" + sandboxref;
        TestWebScriptServer.Response response2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(sandboxURL), 200);
        JSONObject result2 = new JSONObject(response2.getContentAsString());
        JSONObject data2 = result2.getJSONObject("data");
        sandboxref = data2.getString("sandboxref");
        String url = data2.getString("url");
        String name = data2.getString("name");
        SandboxTest.assertNotNull((String)"sandboxref is null", (Object)sandboxref);
        SandboxTest.assertNotNull((String)"url is null", (Object)url);
        SandboxTest.assertNotNull((String)"name is null", (Object)name);
        JSONObject createdDate = data2.getJSONObject("createdDate");
        String createdOn = createdDate.getString("iso8601");
        String createdBy = data2.getString("creator");
        SandboxTest.assertNotNull((String)"created date is null", (Object)createdOn);
        SandboxTest.assertNotNull((String)"created by is null", (Object)createdBy);
        String invalidWebprojURL = "/api/wcm/webprojects/twaddle/sandboxes/" + sandboxref;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(invalidWebprojURL), 404);
        String invalidboxURL = "/api/wcm/webprojects/" + webprojref + "/sandboxes/" + "twaddle";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(invalidboxURL), 404);
    }

    public void testDeleteSandbox() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        String webprojref = this.createWebProject();
        this.createMembership(webprojref, USER_ONE, ROLE_CONTENT_MANAGER);
        JSONObject box = new JSONObject();
        box.put("userName", (Object)USER_ONE);
        String validURL = "/api/wcm/webprojects/" + webprojref + URI_SANDBOXES;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(validURL, box.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String sandboxref = data.getString("sandboxref");
        SandboxTest.assertNotNull((String)"sandboxref is null", (Object)sandboxref);
        String sandboxURL = "/api/wcm/webprojects/" + webprojref + "/sandboxes/" + sandboxref;
        String invalidProject = "/api/wcm/webprojects/silly/sandboxes/" + sandboxref;
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(invalidProject), 404);
        String invalidSandbox = "/api/wcm/webprojects/" + webprojref + "/sandboxes/" + "silly";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(invalidSandbox), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(sandboxURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(sandboxURL), 404);
    }
}

