/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.workflow.AbstractWorkflowWebscript;
import org.alfresco.repo.web.scripts.workflow.WorkflowModelBuilder;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowInstanceDelete
extends AbstractWorkflowWebscript {
    public static final String PARAM_FORCED = "forced";

    @Override
    protected Map<String, Object> buildModel(WorkflowModelBuilder modelBuilder, WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        String workflowInstanceId = (String)params.get("workflow_instance_id");
        boolean forced = this.getForced(req);
        if (this.canUserEndWorkflow(workflowInstanceId)) {
            if (forced) {
                this.workflowService.deleteWorkflow(workflowInstanceId);
            } else {
                this.workflowService.cancelWorkflow(workflowInstanceId);
            }
            return null;
        }
        throw new WebScriptException(403, "Failed to " + (forced ? "delete" : "cancel") + " workflow instance with id: " + workflowInstanceId);
    }

    private boolean getForced(WebScriptRequest req) {
        String forced = req.getParameter(PARAM_FORCED);
        if (forced != null) {
            try {
                return Boolean.valueOf(forced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean canUserEndWorkflow(String instanceId) {
        String userName;
        String currentUserName;
        boolean canEnd = false;
        WorkflowInstance wi = this.workflowService.getWorkflowById(instanceId);
        NodeRef initiator = wi.getInitiator();
        if (initiator != null && (currentUserName = this.authenticationService.getCurrentUserName()).equals(userName = (String)((Object)this.nodeService.getProperty(initiator, ContentModel.PROP_USERNAME)))) {
            canEnd = true;
        }
        return canEnd;
    }
}

