/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;

public class DeleteMethod
extends WebDAVMethod {
    protected void parseRequestHeaders() throws WebDAVServerException {
        this.parseIfHeader();
    }

    protected void parseRequestBody() throws WebDAVServerException {
    }

    protected void executeImpl() throws WebDAVServerException, Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WebDAV DELETE: " + this.getPath()));
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        NodeRef rootNodeRef = this.getRootNodeRef();
        String path = this.getPath();
        List<String> pathElements = this.getDAVHelper().splitAllPaths(path);
        FileInfo fileInfo = null;
        try {
            fileInfo = fileFolderService.resolveNamePath(rootNodeRef, pathElements);
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Node not found: " + this.getPath()));
            }
            throw new WebDAVServerException(404);
        }
        this.checkNode(fileInfo);
        fileFolderService.delete(fileInfo.getNodeRef());
    }
}

