/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockInfo {
    private String token = null;
    private String scope = null;
    private String depth = null;
    private boolean shared = false;
    private LinkedList<String> sharedLockTokens = null;
    private static final String SHARED_LOCK_TOKEN_SEPARATOR = ",";

    public LockInfo() {
    }

    public LockInfo(String token, String scope, String depth) {
        this.token = token;
        this.scope = scope;
        this.depth = depth;
    }

    public boolean isLocked() {
        return this.token != null || this.sharedLockTokens != null && !this.sharedLockTokens.isEmpty();
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope == null ? "exclusive" : this.scope;
    }

    public void setDepth(String depth) {
        this.depth = depth;
    }

    public String getDepth() {
        return this.depth;
    }

    public static LinkedList<String> parseSharedLockTokens(String sharedLockTokens) {
        if (sharedLockTokens == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        String[] sl = sharedLockTokens.split(SHARED_LOCK_TOKEN_SEPARATOR);
        for (int i = 0; i < sl.length; ++i) {
            result.add(sl[i]);
        }
        return result;
    }

    public LinkedList<String> getSharedLockTokens() {
        return this.sharedLockTokens;
    }

    public void setSharedLockTokens(LinkedList<String> sharedLockTokens) {
        this.sharedLockTokens = sharedLockTokens;
    }

    public void addSharedLockToken(String token) {
        if (this.sharedLockTokens == null) {
            this.sharedLockTokens = new LinkedList();
        }
        this.sharedLockTokens.add(token);
    }

    public static String makeSharedLockTokensString(LinkedList<String> lockTokens) {
        StringBuilder str = new StringBuilder();
        boolean first = true;
        for (String token : lockTokens) {
            if (!first) {
                str.append(SHARED_LOCK_TOKEN_SEPARATOR);
            } else {
                first = false;
            }
            str.append(token);
        }
        return str.toString();
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append("token=");
        str.append(this.getToken());
        str.append(",scope=");
        str.append(this.getScope());
        str.append(",depth=");
        str.append(this.getDepth());
        str.append(",shared locks=");
        str.append(this.getSharedLockTokens());
        str.append("]");
        return str.toString();
    }
}

