/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WebDAVModel;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockMethod
extends WebDAVMethod {
    public static final String EMPTY_NS = "";
    protected int m_timeoutDuration = -1;
    protected LockInfo lockInfo = new LockInfo();
    protected boolean createExclusive;
    protected String lockToken = null;

    protected final boolean hasLockToken() {
        if (this.m_conditions != null) {
            for (WebDAVMethod.Condition condition : this.m_conditions) {
                if (condition.getLockTokensMatch().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected final int getLockTimeout() {
        return this.m_timeoutDuration;
    }

    @Override
    protected void parseRequestHeaders() throws WebDAVServerException {
        this.m_userAgent = this.m_request.getHeader("User-Agent");
        this.parseDepthHeader();
        if (this.m_depth != 0 && this.m_depth != -1) {
            throw new WebDAVServerException(500);
        }
        this.parseIfHeader();
        String strTimeout = this.m_request.getHeader("Timeout");
        if (strTimeout != null && strTimeout.startsWith("Second-")) {
            try {
                int idx = strTimeout.indexOf(" ");
                strTimeout = idx != -1 ? strTimeout.substring("Second-".length(), idx) : strTimeout.substring("Second-".length());
                this.m_timeoutDuration = Integer.parseInt(strTimeout);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to parse Timeout header: " + strTimeout));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Timeout=" + this.getLockTimeout() + ", depth=" + this.getDepth()));
        }
    }

    @Override
    protected void parseRequestBody() throws WebDAVServerException {
        if (this.m_request.getContentLength() == -1) {
            return;
        }
        Document body = this.getRequestBodyAsDocument();
        if (body != null) {
            block0: for (Node currentNode = body.getDocumentElement().getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                if (!(currentNode instanceof Element) || !"DAV:".equals(((Element)currentNode).getNamespaceURI()) || !"lockscope".equals(((Element)currentNode).getLocalName())) continue;
                for (Node propertiesNode = currentNode.getFirstChild(); propertiesNode != null; propertiesNode = propertiesNode.getNextSibling()) {
                    if (!(propertiesNode instanceof Element) || !"DAV:".equals(((Element)propertiesNode).getNamespaceURI())) continue;
                    this.createExclusive = "exclusive".equals(propertiesNode.getLocalName());
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    protected void executeImpl() throws WebDAVServerException, Exception {
        FileFolderService fileFolderService = this.getFileFolderService();
        String path = this.getPath();
        NodeRef rootNodeRef = this.getRootNodeRef();
        String userName = this.getDAVHelper().getAuthenticationService().getCurrentUserName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locking node: \n   user: " + userName + "\n" + "   path: " + path));
        }
        FileInfo lockNodeInfo = null;
        try {
            lockNodeInfo = this.getNodeForPath(this.getRootNodeRef(), this.getPath(), this.m_request.getServletPath());
        }
        catch (FileNotFoundException e) {
            String[] splitPath = this.getDAVHelper().splitPath(path);
            if (splitPath[1].length() == 0) {
                throw new WebDAVServerException(500);
            }
            FileInfo dirInfo = null;
            List<String> dirPathElements = this.getDAVHelper().splitAllPaths(splitPath[0]);
            dirInfo = dirPathElements.size() == 0 ? fileFolderService.getFileInfo(this.getRootNodeRef()) : FileFolderUtil.makeFolders((FileFolderService)fileFolderService, (NodeRef)rootNodeRef, dirPathElements, (QName)ContentModel.TYPE_FOLDER);
            if (dirInfo == null) {
                throw new WebDAVServerException(500);
            }
            lockNodeInfo = this.createNode(dirInfo.getNodeRef(), splitPath[1], ContentModel.TYPE_CONTENT);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created new node for lock: \n   path: " + path + "\n" + "   node: " + lockNodeInfo));
            }
            this.m_response.setStatus(201);
        }
        if (this.hasLockToken()) {
            this.lockInfo = this.checkNode(lockNodeInfo);
            this.createExclusive = "exclusive".equals(this.lockInfo.getScope());
            this.refreshLock(lockNodeInfo, userName);
        } else {
            this.lockInfo = this.checkNode(lockNodeInfo, true, this.createExclusive);
            this.createLock(lockNodeInfo, userName);
        }
        this.m_response.setHeader("Lock-Token", "<" + WebDAV.makeLockToken(lockNodeInfo.getNodeRef(), userName) + ">");
        this.m_response.setHeader("Content-Type", "text/xml; charset=UTF-8");
        this.generateResponse(lockNodeInfo.getNodeRef(), userName);
    }

    protected FileInfo createNode(NodeRef parentNodeRef, String name, QName typeQName) {
        return this.getFileFolderService().create(parentNodeRef, name, ContentModel.TYPE_CONTENT);
    }

    protected final void createLock(FileInfo lockNode, String userName) throws WebDAVServerException {
        LockService lockService = this.getLockService();
        this.lockToken = WebDAV.makeLockToken(lockNode.getNodeRef(), userName);
        if (this.createExclusive) {
            lockService.lock(lockNode.getNodeRef(), LockType.WRITE_LOCK, this.getLockTimeout());
            this.getNodeService().setProperty(lockNode.getNodeRef(), WebDAVModel.PROP_OPAQUE_LOCK_TOKEN, (Serializable)((Object)this.lockToken));
        } else {
            this.lockInfo.addSharedLockToken(this.lockToken);
            String sharedLockTokens = LockInfo.makeSharedLockTokensString(this.lockInfo.getSharedLockTokens());
            this.getNodeService().setProperty(lockNode.getNodeRef(), WebDAVModel.PROP_SHARED_LOCK_TOKENS, (Serializable)((Object)sharedLockTokens));
        }
        this.getNodeService().setProperty(lockNode.getNodeRef(), WebDAVModel.PROP_LOCK_DEPTH, (Serializable)((Object)WebDAV.getDepthName(this.m_depth)));
        this.getNodeService().setProperty(lockNode.getNodeRef(), WebDAVModel.PROP_LOCK_SCOPE, (Serializable)((Object)(this.createExclusive ? "exclusive" : "shared")));
    }

    protected final void refreshLock(FileInfo lockNode, String userName) throws WebDAVServerException {
        if (this.createExclusive) {
            this.getLockService().lock(lockNode.getNodeRef(), LockType.WRITE_LOCK, this.getLockTimeout());
        }
    }

    protected void generateResponse(NodeRef lockNode, String userName) throws Exception {
        String lt;
        String scope;
        if (this.lockToken != null) {
            scope = this.createExclusive ? "exclusive" : "shared";
            lt = this.lockToken;
        } else {
            scope = this.lockInfo.getScope();
            lt = this.lockInfo.getToken();
        }
        String owner = (String)((Object)this.getNodeService().getProperty(lockNode, ContentModel.PROP_LOCK_OWNER));
        XMLWriter xml = this.createXMLWriter();
        xml.startDocument();
        String nsdec = this.generateNamespaceDeclarations(null);
        xml.startElement("D", "prop" + nsdec, "D:prop" + nsdec, (Attributes)this.getDAVHelper().getNullAttributes());
        this.generateLockDiscoveryXML(xml, lockNode, false, scope, WebDAV.getDepthName(this.m_depth), lt, owner);
        xml.endElement("D", "prop", "D:prop");
    }

    @Override
    protected String generateNamespaceDeclarations(HashMap<String, String> nameSpaces) {
        StringBuilder ns = new StringBuilder();
        ns.append(" ");
        ns.append("xmlns");
        ns.append(":");
        ns.append("D");
        ns.append("=\"");
        ns.append("DAV:");
        ns.append("\"");
        if (nameSpaces != null) {
            for (String strNamespaceUri : nameSpaces.keySet()) {
                String strNamespaceName = nameSpaces.get(strNamespaceUri);
                ns.append(" ").append("xmlns").append(":").append(strNamespaceName).append("=\"");
                ns.append(strNamespaceUri).append("\" ");
            }
        }
        return ns.toString();
    }
}

