/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.webdav.PropFindMethod;
import org.alfresco.repo.webdav.WebDAVProperty;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PropPatchMethod
extends PropFindMethod {
    protected ArrayList<PropertyAction> m_propertyActions = null;

    protected void executeImpl() throws WebDAVServerException, Exception {
        this.m_response.setStatus(207);
        FileInfo pathNodeInfo = null;
        try {
            pathNodeInfo = this.getNodeForPath(this.getRootNodeRef(), this.m_strPath, this.m_request.getServletPath());
        }
        catch (FileNotFoundException e) {
            throw new WebDAVServerException(404);
        }
        this.checkNode(pathNodeInfo);
        this.m_response.setContentType("text/xml; charset=UTF-8");
        XMLWriter xml = this.createXMLWriter();
        xml.startDocument();
        String nsdec = this.generateNamespaceDeclarations(this.m_namespaces);
        xml.startElement("D", "multistatus" + nsdec, "D:multistatus" + nsdec, (Attributes)this.getDAVHelper().getNullAttributes());
        StringBuilder baseBuild = new StringBuilder(256);
        baseBuild.append(this.getPath());
        if (baseBuild.length() == 0 || baseBuild.charAt(baseBuild.length() - 1) != '/') {
            baseBuild.append('/');
        }
        String basePath = baseBuild.toString();
        this.generateResponse(xml, pathNodeInfo, basePath);
        xml.endElement("D", "multistatus", "D:multistatus");
        this.flushXML(xml);
    }

    protected void parseRequestBody() throws WebDAVServerException {
        Document body = this.getRequestBodyAsDocument();
        if (body != null) {
            Element rootElement = body.getDocumentElement();
            NodeList childList = rootElement.getChildNodes();
            this.m_propertyActions = new ArrayList();
            block12: for (int i = 0; i < childList.getLength(); ++i) {
                Node currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block12;
                    }
                    case 1: {
                        if (!currentNode.getNodeName().endsWith("set") && !currentNode.getNodeName().endsWith("remove")) continue block12;
                        NodeList propertiesList = currentNode.getChildNodes();
                        block13: for (int j = 0; j < propertiesList.getLength(); ++j) {
                            Node propertiesNode = propertiesList.item(j);
                            switch (propertiesNode.getNodeType()) {
                                case 3: {
                                    continue block13;
                                }
                                case 1: {
                                    if (!propertiesNode.getNodeName().endsWith("prop")) continue block13;
                                    NodeList propList = propertiesNode.getChildNodes();
                                    block14: for (int k = 0; k < propList.getLength(); ++k) {
                                        Node propNode = propList.item(k);
                                        switch (propNode.getNodeType()) {
                                            case 3: {
                                                continue block14;
                                            }
                                            case 1: {
                                                int action = currentNode.getNodeName().endsWith("set") ? 0 : 1;
                                                this.m_propertyActions.add(new PropertyAction(action, this.createProperty(propNode)));
                                            }
                                        }
                                    }
                                    continue block13;
                                }
                            }
                        }
                        continue block12;
                    }
                }
            }
        }
    }

    protected void parseRequestHeaders() throws WebDAVServerException {
        this.parseIfHeader();
    }

    protected WebDAVProperty createProperty(Node node) {
        WebDAVProperty property = super.createProperty(node);
        String strValue = null;
        Node value = node.getFirstChild();
        if (value != null) {
            strValue = value.getNodeValue();
        }
        property.setValue(strValue);
        return property;
    }

    protected void generateResponse(XMLWriter xml, FileInfo nodeInfo, String path) throws Exception {
        boolean isFolder = nodeInfo.isFolder();
        xml.startElement("D", "response", "D:response", (Attributes)this.getDAVHelper().getNullAttributes());
        String strHRef = this.getURLForPath(this.m_request, path, isFolder);
        xml.startElement("D", "href", "D:href", (Attributes)this.getDAVHelper().getNullAttributes());
        xml.write(strHRef);
        xml.endElement("D", "href", "D:href");
        boolean failed = false;
        WebDAVProperty failedProperty = null;
        for (PropertyAction action : this.m_propertyActions) {
            if (!action.getProperty().isProtected()) continue;
            this.generateError(xml);
            failed = true;
            failedProperty = action.getProperty();
            break;
        }
        for (PropertyAction propertyAction : this.m_propertyActions) {
            String statusCodeDescription;
            int statusCode;
            WebDAVProperty property = propertyAction.getProperty();
            if (!failed) {
                if (0 == propertyAction.getAction()) {
                    this.getNodeService().setProperty(nodeInfo.getNodeRef(), property.createQName(), (Serializable)((Object)property.getValue()));
                } else if (1 == propertyAction.getAction()) {
                    this.getNodeService().removeProperty(nodeInfo.getNodeRef(), property.createQName());
                } else {
                    throw new WebDAVServerException(400);
                }
                statusCode = 200;
                statusCodeDescription = "OK";
            } else if (failedProperty == property) {
                statusCode = 403;
                statusCodeDescription = "Forbidden";
            } else {
                statusCode = 424;
                statusCodeDescription = "Failed Dependency";
            }
            this.generatePropertyResponse(xml, property, statusCode, statusCodeDescription);
        }
        xml.endElement("D", "response", "D:response");
    }

    protected void generatePropertyResponse(XMLWriter xml, WebDAVProperty property, int status, String description) {
        try {
            AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
            xml.startElement("D", "propstat", "D:propstat", (Attributes)nullAttr);
            xml.startElement("D", "prop", "D:prop", (Attributes)nullAttr);
            if (property.hasNamespaceName()) {
                xml.write(DocumentHelper.createElement((String)(property.getNamespaceName() + ":" + property.getName())));
            } else {
                xml.write(DocumentHelper.createElement((String)property.getName()));
            }
            xml.endElement("D", "prop", "D:prop");
            xml.startElement("D", "status", "D:status", (Attributes)nullAttr);
            xml.write("HTTP/1.1 " + status + " " + description);
            xml.endElement("D", "status", "D:status");
            xml.endElement("D", "propstat", "D:propstat");
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("XML processing error", (Throwable)ex);
        }
    }

    protected void generateError(XMLWriter xml) {
        try {
            AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
            xml.startElement("D", "error", "D:error", (Attributes)nullAttr);
            xml.write(DocumentHelper.createElement((String)"D:cannot-modify-protected-property"));
            xml.endElement("D", "error", "D:error");
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("XML processing error", (Throwable)ex);
        }
    }

    protected class PropertyAction {
        public static final int SET = 0;
        public static final int REMOVE = 1;
        private WebDAVProperty property;
        private int action;

        public PropertyAction(int action, WebDAVProperty property) {
            this.action = action;
            this.property = property;
        }

        public int getAction() {
            return this.action;
        }

        public WebDAVProperty getProperty() {
            return this.property;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("[");
            str.append("action=");
            str.append(this.getAction() == 0 ? "SET" : "REMOVE");
            str.append(",property=");
            str.append(this.getProperty());
            str.append("]");
            return str.toString();
        }
    }
}

