/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDAVHelper {
    public static final String PathSeperator = "/";
    public static final char PathSeperatorChar = '/';
    private static Log logger = LogFactory.getLog((String)"org.alfresco.protocol.webdav");
    private ServiceRegistry m_serviceRegistry;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private SearchService m_searchService;
    private NamespaceService m_namespaceService;
    private DictionaryService m_dictionaryService;
    private MimetypeService m_mimetypeService;
    private LockService m_lockService;
    private AuthenticationService m_authService;
    private AttributesImpl m_nullAttribs = new AttributesImpl();

    protected WebDAVHelper(ServiceRegistry serviceRegistry, AuthenticationService authService) {
        this.m_serviceRegistry = serviceRegistry;
        this.m_nodeService = this.m_serviceRegistry.getNodeService();
        this.m_fileFolderService = this.m_serviceRegistry.getFileFolderService();
        this.m_searchService = this.m_serviceRegistry.getSearchService();
        this.m_namespaceService = this.m_serviceRegistry.getNamespaceService();
        this.m_dictionaryService = this.m_serviceRegistry.getDictionaryService();
        this.m_mimetypeService = this.m_serviceRegistry.getMimetypeService();
        this.m_lockService = this.m_serviceRegistry.getLockService();
        this.m_authService = authService;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.m_authService;
    }

    public final ServiceRegistry getServiceRegistry() {
        return this.m_serviceRegistry;
    }

    public final NodeService getNodeService() {
        return this.m_nodeService;
    }

    public FileFolderService getFileFolderService() {
        return this.m_fileFolderService;
    }

    public final SearchService getSearchService() {
        return this.m_searchService;
    }

    public final NamespaceService getNamespaceService() {
        return this.m_namespaceService;
    }

    public final DictionaryService getDictionaryService() {
        return this.m_dictionaryService;
    }

    public final MimetypeService getMimetypeService() {
        return this.m_mimetypeService;
    }

    public final LockService getLockService() {
        return this.m_lockService;
    }

    public final CopyService getCopyService() {
        return this.getServiceRegistry().getCopyService();
    }

    public final String[] splitPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path may not be null");
        }
        String[] pathStr = new String[]{"", ""};
        int pos = path.lastIndexOf(47);
        if (pos == -1 || pos == path.length() - 1) {
            pathStr[1] = path;
        } else {
            pathStr[0] = path.substring(0, pos);
            pathStr[1] = path.substring(pos + 1);
        }
        return pathStr;
    }

    public final List<String> splitAllPaths(String path) {
        if (path == null || path.length() == 0) {
            return Collections.emptyList();
        }
        StringTokenizer token = new StringTokenizer(path, PathSeperator);
        ArrayList<String> results = new ArrayList<String>(10);
        while (token.hasMoreTokens()) {
            results.add(token.nextToken());
        }
        return results;
    }

    public final FileInfo getNodeForPath(NodeRef rootNodeRef, String path, String servletPath) throws FileNotFoundException {
        if (rootNodeRef == null) {
            throw new IllegalArgumentException("Root node may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        if (path.length() == 0 || path.equals(PathSeperator) || EqualsHelper.nullSafeEquals((Object)path, (Object)servletPath)) {
            return fileFolderService.getFileInfo(rootNodeRef);
        }
        if (servletPath != null && servletPath.length() > 0 && path.startsWith(servletPath)) {
            path = path.substring(servletPath.length());
        }
        List<String> splitPath = this.splitAllPaths(path);
        FileInfo fileInfo = this.m_fileFolderService.resolveNamePath(rootNodeRef, splitPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched node for path: \n   root: " + rootNodeRef + "\n" + "   path: " + path + "\n" + "   servlet path: " + servletPath + "\n" + "   result: " + fileInfo));
        }
        return fileInfo;
    }

    public final FileInfo getParentNodeForPath(NodeRef rootNodeRef, String path, String servletPath) throws FileNotFoundException {
        if (rootNodeRef == null) {
            throw new IllegalArgumentException("Root node may not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path may not be null");
        }
        String[] paths = this.splitPath(path);
        return this.getNodeForPath(rootNodeRef, paths[0], servletPath);
    }

    public final String getPathFromNode(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null || nodeRef == null) {
            throw new IllegalArgumentException("Invalid node(s) in getPathFromNode call");
        }
        if (rootNodeRef.equals((Object)nodeRef)) {
            return "";
        }
        FileFolderService fileFolderService = this.getFileFolderService();
        List pathInfos = fileFolderService.getNamePath(rootNodeRef, nodeRef);
        StringBuilder sb = new StringBuilder(pathInfos.size() * 20);
        for (FileInfo fileInfo : pathInfos) {
            sb.append('/');
            sb.append(fileInfo.getName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Build name path for node: \n   root: " + rootNodeRef + "\n" + "   target: " + nodeRef + "\n" + "   path: " + sb));
        }
        return sb.toString();
    }

    public final String makeETag(NodeRef node) {
        StringBuilder etag = new StringBuilder();
        this.makeETagString(node, etag);
        return etag.toString();
    }

    public final String makeQuotedETag(NodeRef node) {
        StringBuilder etag = new StringBuilder();
        etag.append("\"");
        this.makeETagString(node, etag);
        etag.append("\"");
        return etag.toString();
    }

    protected final void makeETagString(NodeRef node, StringBuilder etag) {
        Serializable modVal = this.getNodeService().getProperty(node, ContentModel.PROP_MODIFIED);
        etag.append(node.getId());
        if (modVal != null) {
            etag.append("_");
            etag.append(DefaultTypeConverter.INSTANCE.longValue((Object)modVal));
        }
    }

    public final AttributesImpl getNullAttributes() {
        return this.m_nullAttribs;
    }

    public static final String encodeURL(String s) {
        try {
            return WebDAVHelper.replace(URLEncoder.encode(s, "UTF-8"), "+", "%20");
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
    }

    public static String replace(String str, String repl, String with) {
        int lastindex = 0;
        int pos = str.indexOf(repl);
        if (pos < 0) {
            return str;
        }
        int len = repl.length();
        int lendiff = with.length() - repl.length();
        StringBuilder out = new StringBuilder(lendiff <= 0 ? str.length() : str.length() + (lendiff << 3));
        while (pos >= 0) {
            out.append(str.substring(lastindex, pos)).append(with);
            lastindex = pos + len;
            pos = str.indexOf(repl, lastindex);
        }
        return out.append(str.substring(lastindex, str.length())).toString();
    }

    public static final String encodeHTML(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }
}

