/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WebDAVModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.util.FileCopyUtils;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDAVMethod {
    protected static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    private static final boolean XMLPrettyPrint = true;
    protected HttpServletRequest m_request;
    protected HttpServletResponse m_response;
    private File m_requestBody;
    private ServletInputStream m_inputStream;
    private BufferedReader m_reader;
    protected WebDAVHelper m_davHelper;
    protected NodeRef m_rootNodeRef;
    protected String m_strPath = null;
    protected String m_userAgent = null;
    protected LinkedList<Condition> m_conditions = null;
    protected String m_resourceTag = null;
    protected int m_depth = -1;

    public void setDetails(final HttpServletRequest req, HttpServletResponse resp, WebDAVHelper davHelper, NodeRef rootNode) {
        this.m_request = new HttpServletRequestWrapper(req){

            public ServletInputStream getInputStream() throws IOException {
                if (WebDAVMethod.this.m_reader != null) {
                    throw new IllegalStateException("Reader in use");
                }
                if (WebDAVMethod.this.m_inputStream == null) {
                    final FileInputStream in = new FileInputStream(WebDAVMethod.this.getRequestBodyAsFile(req));
                    WebDAVMethod.this.m_inputStream = new ServletInputStream(){

                        public int read() throws IOException {
                            return in.read();
                        }

                        public int read(byte[] b) throws IOException {
                            return in.read(b);
                        }

                        public int read(byte[] b, int off, int len) throws IOException {
                            return in.read(b, off, len);
                        }

                        public long skip(long n) throws IOException {
                            return in.skip(n);
                        }

                        public int available() throws IOException {
                            return in.available();
                        }

                        public void close() throws IOException {
                            in.close();
                        }

                        public void mark(int readlimit) {
                            in.mark(readlimit);
                        }

                        public void reset() throws IOException {
                            in.reset();
                        }

                        public boolean markSupported() {
                            return in.markSupported();
                        }
                    };
                }
                return WebDAVMethod.this.m_inputStream;
            }

            public BufferedReader getReader() throws IOException {
                if (WebDAVMethod.this.m_inputStream != null) {
                    throw new IllegalStateException("Input Stream in use");
                }
                if (WebDAVMethod.this.m_reader == null) {
                    String encoding = req.getCharacterEncoding();
                    WebDAVMethod.this.m_reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(WebDAVMethod.this.getRequestBodyAsFile(req)), encoding == null ? "ISO-8859-1" : encoding));
                }
                return WebDAVMethod.this.m_reader;
            }
        };
        this.m_response = resp;
        this.m_davHelper = davHelper;
        this.m_rootNodeRef = rootNode;
        this.m_strPath = WebDAV.getRepositoryPath(req);
    }

    private File getRequestBodyAsFile(HttpServletRequest req) throws IOException {
        if (this.m_requestBody == null) {
            this.m_requestBody = TempFileProvider.createTempFile((String)("webdav_" + req.getMethod() + "_"), (String)".bin");
            FileOutputStream out = new FileOutputStream(this.m_requestBody);
            FileCopyUtils.copy((InputStream)req.getInputStream(), (OutputStream)out);
        }
        return this.m_requestBody;
    }

    protected boolean isReadOnly() {
        return false;
    }

    public final int getDepth() {
        return this.m_depth;
    }

    public void execute() throws WebDAVServerException {
        this.parseRequestHeaders();
        this.parseRequestBody();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> executeImplCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                WebDAVMethod.this.m_inputStream = null;
                WebDAVMethod.this.m_reader = null;
                WebDAVMethod.this.executeImpl();
                return null;
            }
        };
        try {
            boolean isReadOnly = this.isReadOnly();
            this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)executeImplCallback, isReadOnly);
        }
        catch (AccessDeniedException e) {
            throw new WebDAVServerException(401, (Throwable)e);
        }
        catch (Throwable e) {
            if (e instanceof WebDAVServerException) {
                throw (WebDAVServerException)e;
            }
            if (e.getCause() instanceof WebDAVServerException) {
                throw (WebDAVServerException)e.getCause();
            }
            throw new WebDAVServerException(500, e);
        }
        finally {
            if (this.m_requestBody != null) {
                try {
                    this.m_requestBody.delete();
                    this.m_requestBody = null;
                }
                catch (Throwable t) {
                    logger.error((Object)"Failed to delete temp file", t);
                }
            }
        }
    }

    protected abstract void executeImpl() throws WebDAVServerException, Exception;

    protected abstract void parseRequestBody() throws WebDAVServerException;

    protected abstract void parseRequestHeaders() throws WebDAVServerException;

    protected Document getRequestBodyAsDocument() throws WebDAVServerException {
        Document body = null;
        if (this.m_request.getContentLength() > 0) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                body = this.m_request.getCharacterEncoding() == null ? builder.parse(new InputSource((InputStream)this.m_request.getInputStream())) : builder.parse(new InputSource(this.m_request.getReader()));
            }
            catch (ParserConfigurationException e) {
                throw new WebDAVServerException(400, (Throwable)e);
            }
            catch (SAXException e) {
                throw new WebDAVServerException(400, (Throwable)e);
            }
            catch (IOException e) {
                throw new WebDAVServerException(400, (Throwable)e);
            }
        }
        return body;
    }

    protected void parseDepthHeader() throws WebDAVServerException {
        String strDepth = this.m_request.getHeader("Depth");
        if (strDepth != null && strDepth.length() > 0) {
            this.m_depth = strDepth.equals("0") ? 0 : (strDepth.equals("1") ? 1 : -1);
        }
    }

    protected void parseIfHeader() throws WebDAVServerException {
        String strIf = this.m_request.getHeader("If");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Parsing If header: " + strIf));
        }
        if (strIf != null && strIf.length() > 0) {
            if (strIf.startsWith("<")) {
                this.m_resourceTag = strIf.substring(1, strIf.indexOf(">"));
                strIf = strIf.substring(this.m_resourceTag.length() + 3);
            }
            this.m_conditions = new LinkedList();
            String[] parts = strIf.split("\\) \\(");
            for (int i = 0; i < parts.length; ++i) {
                String partString = parts[i].replaceAll("\\(", "").replaceAll("\\)", "");
                Condition c = new Condition();
                String[] conditions = partString.split(" ");
                for (int j = 0; j < conditions.length; ++j) {
                    int index;
                    boolean fNot = false;
                    String eTag = null;
                    String lockToken = null;
                    if ("Not".equals(conditions[j])) {
                        if (j == conditions.length - 1) {
                            throw new WebDAVServerException(412);
                        }
                        fNot = true;
                        ++j;
                    }
                    if ((index = conditions[j].indexOf(60)) != -1) {
                        try {
                            String s = conditions[j].substring(index + 1, conditions[j].indexOf(">"));
                            if (!s.startsWith("opaquelocktoken:")) {
                                if (!fNot) {
                                    throw new WebDAVServerException(412);
                                }
                            } else {
                                lockToken = s;
                                c.addLockTocken(lockToken, fNot);
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new WebDAVServerException(412);
                        }
                    }
                    if ((index = conditions[j].indexOf("[\"")) == -1) continue;
                    eTag = conditions[j].substring(index + 1, conditions[j].indexOf("]"));
                    c.addETag(eTag, fNot);
                }
                this.m_conditions.add(c);
            }
        }
    }

    protected final WebDAVHelper getDAVHelper() {
        return this.m_davHelper;
    }

    protected final ServiceRegistry getServiceRegistry() {
        return this.m_davHelper.getServiceRegistry();
    }

    protected final TransactionService getTransactionService() {
        return this.m_davHelper.getServiceRegistry().getTransactionService();
    }

    protected final NodeService getNodeService() {
        return this.m_davHelper.getNodeService();
    }

    protected final SearchService getSearchService() {
        return this.m_davHelper.getSearchService();
    }

    protected final NamespaceService getNamespaceService() {
        return this.m_davHelper.getNamespaceService();
    }

    protected final FileFolderService getFileFolderService() {
        return this.m_davHelper.getFileFolderService();
    }

    protected final ContentService getContentService() {
        return this.m_davHelper.getServiceRegistry().getContentService();
    }

    protected final MimetypeService getMimetypeService() {
        return this.m_davHelper.getMimetypeService();
    }

    protected final LockService getLockService() {
        return this.m_davHelper.getLockService();
    }

    protected final AuthenticationService getAuthenticationService() {
        return this.m_davHelper.getAuthenticationService();
    }

    protected final String getServletPath() {
        return this.m_request.getServletPath();
    }

    protected final NodeRef getRootNodeRef() {
        return this.m_rootNodeRef;
    }

    protected String getPath() {
        return this.m_strPath;
    }

    protected XMLWriter createXMLWriter() throws IOException {
        XMLWriter writer = null;
        writer = new XMLWriter((Writer)this.m_response.getWriter(), OutputFormat.createPrettyPrint());
        return writer;
    }

    protected void generateLockDiscoveryXML(XMLWriter xml, NodeRef lockNode, LockInfo lockInfo) throws Exception {
        String owner = (String)((Object)this.getNodeService().getProperty(lockNode, ContentModel.PROP_LOCK_OWNER));
        this.generateLockDiscoveryXML(xml, lockNode, false, lockInfo.getScope(), lockInfo.getDepth(), WebDAV.makeLockToken(lockNode, owner), owner);
    }

    protected void generateLockDiscoveryXML(XMLWriter xml, NodeRef lockNode, boolean emptyNamespace, String scope, String depth, String lToken, String owner) throws Exception {
        String ns;
        AttributesImpl nullAttr = this.getDAVHelper().getNullAttributes();
        String string = ns = emptyNamespace ? "" : "D";
        if (lockNode != null) {
            NodeService nodeService = this.getNodeService();
            Date expiryDate = (Date)nodeService.getProperty(lockNode, ContentModel.PROP_EXPIRY_DATE);
            xml.startElement(ns, "lockdiscovery", emptyNamespace ? "lockdiscovery" : "D:lockdiscovery", (Attributes)nullAttr);
            xml.startElement(ns, "activelock", emptyNamespace ? "activelock" : "D:activelock", (Attributes)nullAttr);
            xml.startElement(ns, "locktype", emptyNamespace ? "locktype" : "D:locktype", (Attributes)nullAttr);
            xml.write(DocumentHelper.createElement((String)(emptyNamespace ? "write" : "D:write")));
            xml.endElement(ns, "locktype", emptyNamespace ? "locktype" : "D:locktype");
            xml.startElement(ns, "lockscope", emptyNamespace ? "lockscope" : "D:lockscope", (Attributes)nullAttr);
            xml.write(DocumentHelper.createElement((String)(emptyNamespace ? scope : "D:" + scope)));
            xml.endElement(ns, "lockscope", emptyNamespace ? "lockscope" : "D:lockscope");
            xml.startElement(ns, "depth", emptyNamespace ? "depth" : "D:depth", (Attributes)nullAttr);
            xml.write(depth);
            xml.endElement(ns, "depth", emptyNamespace ? "depth" : "D:depth");
            xml.startElement(ns, "owner", emptyNamespace ? "owner" : "D:owner", (Attributes)nullAttr);
            xml.write(owner);
            xml.endElement(ns, "owner", emptyNamespace ? "owner" : "D:owner");
            xml.startElement(ns, "timeout", emptyNamespace ? "timeout" : "D:timeout", (Attributes)nullAttr);
            String strTimeout = "Infinite";
            if (expiryDate != null) {
                long timeoutRemaining = (expiryDate.getTime() - System.currentTimeMillis()) / 1000L;
                strTimeout = "Second-" + timeoutRemaining;
            }
            xml.write(strTimeout);
            xml.endElement(ns, "timeout", emptyNamespace ? "timeout" : "D:timeout");
            xml.startElement(ns, "locktoken", emptyNamespace ? "locktoken" : "D:locktoken", (Attributes)nullAttr);
            xml.startElement(ns, "href", emptyNamespace ? "href" : "D:href", (Attributes)nullAttr);
            xml.write(lToken);
            xml.endElement(ns, "href", emptyNamespace ? "href" : "D:href");
            xml.endElement(ns, "locktoken", emptyNamespace ? "locktoken" : "D:locktoken");
            xml.endElement(ns, "activelock", emptyNamespace ? "activelock" : "D:activelock");
            xml.endElement(ns, "lockdiscovery", emptyNamespace ? "lockdiscovery" : "D:lockdiscovery");
        }
    }

    protected String generateNamespaceDeclarations(HashMap<String, String> nameSpaces) {
        StringBuilder ns = new StringBuilder();
        ns.append(" ");
        ns.append("xmlns");
        ns.append(":");
        ns.append("D");
        ns.append("=\"");
        ns.append("DAV:");
        ns.append("\"");
        if (nameSpaces != null) {
            for (String strNamespaceUri : nameSpaces.keySet()) {
                String strNamespaceName = nameSpaces.get(strNamespaceUri);
                ns.append(" ").append("xmlns").append(":").append(strNamespaceName).append("=\"");
                ns.append(strNamespaceUri == null ? "" : strNamespaceUri).append("\" ");
            }
        }
        return ns.toString();
    }

    protected LockInfo checkNode(FileInfo fileInfo, boolean ignoreShared, boolean lockMethod) throws WebDAVServerException {
        LockInfo nodeLockInfo = this.getNodeLockInfo(fileInfo.getNodeRef());
        String nodeETag = this.getDAVHelper().makeQuotedETag(fileInfo.getNodeRef());
        if (this.m_conditions == null) {
            if (nodeLockInfo.getToken() == null) {
                if (nodeLockInfo.getSharedLockTokens() == null) {
                    return nodeLockInfo;
                }
                if (!ignoreShared) {
                    throw new WebDAVServerException(423);
                }
            } else {
                throw new WebDAVServerException(423);
            }
        }
        this.checkLockToken(nodeLockInfo, ignoreShared, lockMethod);
        this.checkConditions(nodeLockInfo.getToken(), nodeETag);
        return nodeLockInfo;
    }

    protected LockInfo checkNode(FileInfo fileInfo) throws WebDAVServerException {
        return this.checkNode(fileInfo, false, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLockToken(LockInfo lockInfo, boolean ignoreShared, boolean lockMethod) throws WebDAVServerException {
        String nodeLockToken = lockInfo.getToken();
        LinkedList<String> sharedLockTokens = lockInfo.getSharedLockTokens();
        if (this.m_conditions != null) {
            if (lockInfo.isShared()) {
                if (sharedLockTokens == null) throw new WebDAVServerException(423);
                if (ignoreShared) return;
                for (Condition condition : this.m_conditions) {
                    for (String sharedLockToken : sharedLockTokens) {
                        if (!condition.getLockTokensMatch().contains(sharedLockToken)) continue;
                        return;
                    }
                }
                throw new WebDAVServerException(423);
            }
            for (Condition condition : this.m_conditions) {
                if (nodeLockToken == null || !condition.getLockTokensMatch().contains(nodeLockToken)) continue;
                return;
            }
            throw new WebDAVServerException(423);
        }
        if (!lockInfo.isShared()) throw new WebDAVServerException(423);
        if (lockMethod) throw new WebDAVServerException(423);
    }

    private void checkConditions(String nodeLockToken, String nodeETag) throws WebDAVServerException {
        if (this.m_conditions == null) {
            return;
        }
        for (Condition condition : this.m_conditions) {
            boolean fMatchETag = true;
            boolean fMatchLockToken = true;
            if (condition.getETagsMatch() != null) {
                boolean bl = fMatchETag = condition.getETagsMatch().contains(nodeETag);
            }
            if (condition.getETagsNotMatch() != null) {
                boolean bl = fMatchETag = !condition.getETagsNotMatch().contains(nodeETag);
            }
            if (condition.getLockTokensMatch() != null) {
                boolean bl = fMatchLockToken = condition.getLockTokensMatch().contains(nodeLockToken);
            }
            if (condition.getLockTokensNotMatch() != null) {
                boolean bl = fMatchLockToken = !condition.getLockTokensNotMatch().contains(nodeLockToken);
            }
            if (!fMatchETag || !fMatchLockToken) continue;
            return;
        }
        throw new WebDAVServerException(412);
    }

    protected LockInfo getNodeLockInfo(NodeRef nodeRef) {
        LockInfo lockInfo = new LockInfo();
        NodeService nodeService = this.getNodeService();
        LockService lockService = this.getLockService();
        LockStatus lockSts = lockService.getLockStatus(nodeRef);
        if (lockSts == LockStatus.LOCKED || lockSts == LockStatus.LOCK_OWNER) {
            String propOpaqueLockToken = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_OPAQUE_LOCK_TOKEN));
            if (propOpaqueLockToken != null) {
                String depth = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_DEPTH));
                String scope = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_SCOPE));
                String sharedLocks = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_SHARED_LOCK_TOKENS));
                lockInfo.setToken(propOpaqueLockToken);
                lockInfo.setDepth(depth);
                lockInfo.setScope(scope);
                lockInfo.setSharedLockTokens(LockInfo.parseSharedLockTokens(sharedLocks));
                return lockInfo;
            }
        } else {
            String sharedLocks = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_SHARED_LOCK_TOKENS));
            if (sharedLocks != null) {
                String depth = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_DEPTH));
                String scope = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_SCOPE));
                lockInfo.setDepth(depth);
                lockInfo.setScope(scope);
                lockInfo.setSharedLockTokens(LockInfo.parseSharedLockTokens(sharedLocks));
                lockInfo.setShared(true);
                return lockInfo;
            }
        }
        NodeRef node = nodeRef;
        List assocs;
        while (!(assocs = nodeService.getParentAssocs(node, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)).isEmpty()) {
            NodeRef parent = ((ChildAssociationRef)assocs.get(0)).getParentRef();
            lockSts = lockService.getLockStatus(parent);
            if (lockSts == LockStatus.LOCKED || lockSts == LockStatus.LOCK_OWNER) {
                String depth = (String)((Object)nodeService.getProperty(parent, WebDAVModel.PROP_LOCK_DEPTH));
                if ("infinity".equals(depth)) {
                    String scope = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_SCOPE));
                    String sharedLocks = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_SHARED_LOCK_TOKENS));
                    String propOpaqueLockToken = (String)((Object)nodeService.getProperty(parent, WebDAVModel.PROP_OPAQUE_LOCK_TOKEN));
                    lockInfo.setToken(propOpaqueLockToken);
                    lockInfo.setDepth(depth);
                    lockInfo.setScope(scope);
                    lockInfo.setSharedLockTokens(LockInfo.parseSharedLockTokens(sharedLocks));
                    return lockInfo;
                }
            } else {
                String depth;
                String sharedLocks = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_SHARED_LOCK_TOKENS));
                if (sharedLocks != null && "infinity".equals(depth = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_DEPTH)))) {
                    String scope = (String)((Object)nodeService.getProperty(nodeRef, WebDAVModel.PROP_LOCK_SCOPE));
                    lockInfo.setDepth(depth);
                    lockInfo.setScope(scope);
                    lockInfo.setSharedLockTokens(LockInfo.parseSharedLockTokens(sharedLocks));
                    lockInfo.setShared(true);
                    return lockInfo;
                }
            }
            node = parent;
        }
        return new LockInfo();
    }

    protected FileInfo getNodeForPath(NodeRef rootNodeRef, String path, String servletPath) throws FileNotFoundException {
        return this.getDAVHelper().getNodeForPath(rootNodeRef, path, servletPath);
    }

    protected String getURLForPath(HttpServletRequest request, String path, boolean isFolder) {
        return WebDAV.getURLForPath(request, path, isFolder);
    }

    protected void flushXML(XMLWriter xml) throws IOException {
        xml.flush();
    }

    protected FileInfo getWorkingCopy(NodeRef nodeRef) {
        String workingCopyOwner;
        FileInfo result = null;
        NodeRef workingCopy = this.getServiceRegistry().getCheckOutCheckInService().getWorkingCopy(nodeRef);
        if (workingCopy != null && (workingCopyOwner = this.getNodeService().getProperty(workingCopy, ContentModel.PROP_WORKING_COPY_OWNER).toString()).equals(this.getAuthenticationService().getCurrentUserName())) {
            result = this.getFileFolderService().getFileInfo(workingCopy);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Condition {
        private LinkedList<String> lockTokensMatch = new LinkedList();
        private LinkedList<String> lockTokensNotMatch = new LinkedList();
        private LinkedList<String> eTagsMatch;
        private LinkedList<String> eTagsNotMatch;

        public LinkedList<String> getLockTokensMatch() {
            return this.lockTokensMatch;
        }

        public LinkedList<String> getLockTokensNotMatch() {
            return this.lockTokensNotMatch;
        }

        public LinkedList<String> getETagsMatch() {
            return this.eTagsMatch;
        }

        public LinkedList<String> getETagsNotMatch() {
            return this.eTagsNotMatch;
        }

        public void addLockTocken(String lockToken, boolean notMatch) {
            if (notMatch) {
                this.lockTokensNotMatch.add(lockToken);
            } else {
                this.lockTokensMatch.add(lockToken);
            }
        }

        public void addETag(String eTag, boolean notMatch) {
            if (notMatch) {
                if (this.eTagsNotMatch == null) {
                    this.eTagsNotMatch = new LinkedList();
                }
                this.eTagsNotMatch.add(eTag);
            } else {
                if (this.eTagsMatch == null) {
                    this.eTagsMatch = new LinkedList();
                }
                this.eTagsMatch.add(eTag);
            }
        }
    }
}

