/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.webdav.CopyMethod;
import org.alfresco.repo.webdav.DeleteMethod;
import org.alfresco.repo.webdav.GetMethod;
import org.alfresco.repo.webdav.HeadMethod;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.MkcolMethod;
import org.alfresco.repo.webdav.MoveMethod;
import org.alfresco.repo.webdav.OptionsMethod;
import org.alfresco.repo.webdav.PostMethod;
import org.alfresco.repo.webdav.PropFindMethod;
import org.alfresco.repo.webdav.PropPatchMethod;
import org.alfresco.repo.webdav.PutMethod;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebDAVServlet
extends HttpServlet {
    private static final long serialVersionUID = 6900069445027527165L;
    private static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol");
    public static final String WEBDAV_PREFIX = "webdav";
    private static final String INTERNAL_SERVER_ERROR = "Internal Server Error: ";
    public static final String KEY_STORE = "store";
    public static final String KEY_ROOT_PATH = "rootPath";
    private ServiceRegistry m_serviceRegistry;
    private TransactionService m_transactionService;
    private TenantService m_tenantService;
    protected Hashtable<String, Class> m_davMethods;
    private NodeRef m_rootNodeRef;
    private WebDAVHelper m_davHelper;
    private String m_rootPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            WebDAVMethod method = this.createMethod(request, response);
            if (method == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("WebDAV method not implemented - " + request.getMethod()));
                }
                response.sendError(501);
                return;
            }
            if (method.getRootNodeRef() == null) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"No root node for request");
                }
                response.sendError(500);
                return;
            }
            method.execute();
        }
        catch (Throwable e) {
            if (!(e instanceof WebDAVServerException) && e.getCause() != null && e.getCause() instanceof WebDAVServerException) {
                e = e.getCause();
            }
            if (e instanceof WebDAVServerException) {
                WebDAVServerException error = (WebDAVServerException)e;
                if (error.getCause() != null) {
                    logger.error((Object)INTERNAL_SERVER_ERROR, error.getCause());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(request.getMethod() + " is returning status code: " + error.getHttpStatusCode()));
                }
                if (response.isCommitted()) {
                    logger.warn((Object)"Could not return the status code to the client as the response has already been committed!");
                } else {
                    response.sendError(error.getHttpStatusCode());
                }
            } else {
                logger.error((Object)INTERNAL_SERVER_ERROR, e);
                if (response.isCommitted()) {
                    logger.warn((Object)"Could not return the internal server error code to the client as the response has already been committed!");
                } else {
                    response.sendError(500);
                }
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                logger.debug((Object)(request.getMethod() + " took " + duration + "ms to execute"));
            }
        }
    }

    private WebDAVMethod createMethod(HttpServletRequest request, HttpServletResponse response) {
        WebDAVMethod method;
        block5: {
            String strHttpMethod = request.getMethod();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("WebDAV request " + strHttpMethod + " on path " + request.getRequestURI()));
            }
            Class methodClass = this.m_davMethods.get(strHttpMethod);
            method = null;
            if (methodClass != null) {
                try {
                    method = (WebDAVMethod)methodClass.newInstance();
                    NodeRef rootNodeRef = this.m_rootNodeRef;
                    if (this.m_tenantService.isEnabled()) {
                        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
                        NodeService nodeService = (NodeService)context.getBean("NodeService");
                        SearchService searchService = (SearchService)context.getBean("SearchService");
                        NamespaceService namespaceService = (NamespaceService)context.getBean("NamespaceService");
                        rootNodeRef = this.m_tenantService.getRootNode(nodeService, searchService, namespaceService, this.m_rootPath, rootNodeRef);
                    }
                    method.setDetails(request, response, this.m_davHelper, rootNodeRef);
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)ex);
                }
            }
        }
        return method;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (context == null) {
            return;
        }
        this.m_serviceRegistry = (ServiceRegistry)context.getBean("ServiceRegistry");
        this.m_transactionService = this.m_serviceRegistry.getTransactionService();
        this.m_tenantService = (TenantService)context.getBean("tenantService");
        AuthenticationService authService = (AuthenticationService)context.getBean("authenticationService");
        NodeService nodeService = (NodeService)context.getBean("NodeService");
        SearchService searchService = (SearchService)context.getBean("SearchService");
        NamespaceService namespaceService = (NamespaceService)context.getBean("NamespaceService");
        this.m_davHelper = new WebDAVHelper(this.m_serviceRegistry, authService);
        String storeValue = context.getServletContext().getInitParameter(KEY_STORE);
        if (storeValue == null) {
            throw new ServletException("Device missing init value: store");
        }
        this.m_rootPath = context.getServletContext().getInitParameter(KEY_ROOT_PATH);
        if (this.m_rootPath == null) {
            throw new ServletException("Device missing init value: rootPath");
        }
        this.m_rootNodeRef = WebDAVServlet.getRootNode(storeValue, this.m_rootPath, context, nodeService, searchService, namespaceService, this.m_transactionService);
        this.m_davMethods = new Hashtable();
        this.m_davMethods.put("PROPFIND", PropFindMethod.class);
        this.m_davMethods.put("PROPPATCH", PropPatchMethod.class);
        this.m_davMethods.put("COPY", CopyMethod.class);
        this.m_davMethods.put("DELETE", DeleteMethod.class);
        this.m_davMethods.put("GET", GetMethod.class);
        this.m_davMethods.put("HEAD", HeadMethod.class);
        this.m_davMethods.put("LOCK", LockMethod.class);
        this.m_davMethods.put("MKCOL", MkcolMethod.class);
        this.m_davMethods.put("MOVE", MoveMethod.class);
        this.m_davMethods.put("OPTIONS", OptionsMethod.class);
        this.m_davMethods.put("POST", PostMethod.class);
        this.m_davMethods.put("PUT", PutMethod.class);
        this.m_davMethods.put("UNLOCK", UnlockMethod.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeRef getRootNode(String storeValue, String m_rootPath, WebApplicationContext context, NodeService nodeService, SearchService searchService, NamespaceService namespaceService, TransactionService m_transactionService) throws ServletException {
        NodeRef m_rootNodeRef = null;
        ServerConfigurationAccessor fileSrvConfig = (ServerConfigurationAccessor)context.getBean("fileServerConfiguration");
        if (fileSrvConfig == null) {
            throw new ServletException("File server configuration not available");
        }
        AuthenticationContext authComponent = (AuthenticationContext)context.getBean("authenticationContext");
        authComponent.setSystemUserAsCurrentUser();
        UserTransaction tx = m_transactionService.getUserTransaction(true);
        try {
            if (tx != null) {
                tx.begin();
            }
            if (storeValue == null) {
                throw new ServletException("Device missing init value: store");
            }
            StoreRef storeRef = new StoreRef(storeValue);
            if (!nodeService.exists(storeRef)) {
                throw new ServletException("Store not created prior to application startup: " + storeRef);
            }
            NodeRef storeRootNodeRef = nodeService.getRootNode(storeRef);
            if (m_rootPath == null) {
                throw new ServletException("Device missing init value: rootPath");
            }
            List nodeRefs = searchService.selectNodes(storeRootNodeRef, m_rootPath, null, (NamespacePrefixResolver)namespaceService, false);
            if (nodeRefs.size() > 1) {
                throw new ServletException("Multiple possible roots for device: \n   root path: " + m_rootPath + "\n" + "   results: " + nodeRefs);
            }
            if (nodeRefs.size() == 0) {
                throw new ServletException("No root found for device: \n   root path: " + m_rootPath);
            }
            m_rootNodeRef = (NodeRef)nodeRefs.get(0);
            tx.commit();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            authComponent.clearCurrentSecurityContext();
        }
        return m_rootNodeRef;
    }
}

