/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter {
    private static Log logger = LogFactory.getLog(AuthenticationFilter.class);
    private static final String PPT_EXTN = ".ppt";

    public void doFilter(ServletContext context, ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)resp;
        SessionUser user = this.getSessionUser(context, httpReq, httpResp, false);
        if (user == null) {
            String authHdr = httpReq.getHeader("Authorization");
            if (authHdr != null && authHdr.length() > 5 && authHdr.substring(0, 5).equalsIgnoreCase("BASIC")) {
                String basicAuth = new String(Base64.decodeBase64((byte[])authHdr.substring(5).getBytes()));
                String username = null;
                String password = null;
                int pos = basicAuth.indexOf(":");
                if (pos != -1) {
                    username = basicAuth.substring(0, pos);
                    password = basicAuth.substring(pos + 1);
                } else {
                    username = basicAuth;
                    password = "";
                }
                try {
                    this.authenticationService.authenticate(username, password.toCharArray());
                    user = this.createUserEnvironment(httpReq.getSession(), this.authenticationService.getCurrentUserName(), this.authenticationService.getCurrentTicket(), false);
                }
                catch (AuthenticationException ex) {
                }
                catch (NoSuchPersonException e) {}
            } else {
                String ticket = req.getParameter("ticket");
                if (ticket != null && ticket.length() > 0) {
                    if (ticket.endsWith(PPT_EXTN)) {
                        ticket = ticket.substring(0, ticket.length() - PPT_EXTN.length());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Logon via ticket from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ")" + " ticket=" + ticket));
                    }
                    this.authenticationService.validate(ticket);
                    String currentUsername = this.authenticationService.getCurrentUserName();
                    user = this.createUserEnvironment(httpReq.getSession(), currentUsername, ticket, false);
                }
            }
            if (user == null) {
                httpResp.setHeader("WWW-Authenticate", "BASIC realm=\"Alfresco DAV Server\"");
                httpResp.setStatus(401);
                httpResp.flushBuffer();
                return;
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }

    protected Log getLogger() {
        return logger;
    }
}

