/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.BadCredentialsException;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.ntlm.NTLMLogonDetails;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.NTLMv2Blob;
import org.alfresco.jlan.server.auth.ntlm.TargetInfo;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.MD4PasswordEncoder;
import org.alfresco.repo.security.authentication.MD4PasswordEncoderImpl;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.security.authentication.ntlm.NTLMPassthruToken;
import org.alfresco.repo.webdav.auth.BaseSSOAuthenticationFilter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;

public abstract class BaseNTLMAuthenticationFilter
extends BaseSSOAuthenticationFilter {
    public static final String NTLM_AUTH_SESSION = "_alfNTLMAuthSess";
    public static final String NTLM_AUTH_DETAILS = "_alfNTLMDetails";
    protected static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String AUTH_NTLM = "NTLM";
    private static final int NTLM_FLAGS_NTLM2 = -1610087807;
    private static final int NTLM_FLAGS_NTLM1 = -2147483005;
    private int m_ntlmFlags;
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private Random m_random = new Random(System.currentTimeMillis());
    private MD4PasswordEncoder m_md4Encoder = new MD4PasswordEncoderImpl();
    private boolean m_allowGuest = false;
    private boolean m_mapUnknownUserToGuest = false;
    private boolean m_disableNTLMv2 = false;
    private NLTMAuthenticator nltmAuthenticator;

    public void setMapUnknownUserToGuest(boolean mapUnknownUserToGuest) {
        this.m_mapUnknownUserToGuest = mapUnknownUserToGuest;
    }

    protected void init() throws ServletException {
        super.init();
        if (!(this.authenticationComponent instanceof NLTMAuthenticator)) {
            throw new ServletException("Authentication component does not support NTLM");
        }
        this.nltmAuthenticator = (NLTMAuthenticator)this.authenticationComponent;
        if (this.nltmAuthenticator.getNTLMMode() != NTLMMode.MD4_PROVIDER && this.nltmAuthenticator.getNTLMMode() != NTLMMode.PASS_THROUGH) {
            throw new ServletException("Required authentication mode not available");
        }
        this.m_allowGuest = this.authenticationComponent.guestUserAuthenticationAllowed();
        if (this.getLogger().isDebugEnabled() && this.m_allowGuest) {
            this.getLogger().debug((Object)"NTLM filter guest access allowed");
        }
        if (this.getLogger().isDebugEnabled() && this.m_mapUnknownUserToGuest) {
            this.getLogger().debug((Object)"NTLM filter map unknown users to guest");
        }
        this.m_ntlmFlags = this.nltmAuthenticator.getNTLMMode() == NTLMMode.MD4_PROVIDER && !this.m_disableNTLMv2 ? -1610087807 : -2147483005;
    }

    public boolean authenticateRequest(ServletContext context, HttpServletRequest sreq, HttpServletResponse sresp) throws IOException, ServletException {
        SessionUser user;
        String authHdr = sreq.getHeader(AUTHORIZATION);
        boolean reqAuth = false;
        if (authHdr != null) {
            if (authHdr.startsWith(AUTH_NTLM)) {
                reqAuth = true;
            } else if (authHdr.startsWith("Negotiate")) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Received 'Negotiate' from client, may be SPNEGO/Kerberos logon");
                }
                this.restartLoginChallenge(context, sreq, sresp);
                return false;
            }
        }
        if ((user = this.getSessionUser(context, sreq, sresp, true)) != null && !reqAuth) {
            this.onValidate(context, sreq, sresp);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Authentication not required (user), chaining ...");
            }
            return true;
        }
        if (this.hasLoginPage() && sreq.getRequestURI().endsWith(this.getLoginPage())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Login page requested, chaining ...");
            }
            return true;
        }
        String userAgent = sreq.getHeader("user-agent");
        if (userAgent != null && userAgent.indexOf("Opera ") != -1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Opera detected, redirecting to login page");
            }
            if (this.hasLoginPage()) {
                this.redirectToLoginPage(sreq, sresp);
            } else {
                this.restartLoginChallenge(context, sreq, sresp);
            }
            return false;
        }
        if (authHdr == null) {
            if (this.allowsTicketLogons() && this.checkForTicketParameter(context, sreq, sresp)) {
                return true;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("New NTLM auth request from " + sreq.getRemoteHost() + " (" + sreq.getRemoteAddr() + ":" + sreq.getRemotePort() + ") SID:" + sreq.getSession().getId()));
            }
            this.restartLoginChallenge(context, sreq, sresp);
            return false;
        }
        byte[] ntlmByts = Base64.decodeBase64((byte[])authHdr.substring(5).getBytes());
        int ntlmTyp = NTLMMessage.isNTLMType((byte[])ntlmByts);
        if (ntlmTyp == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(ntlmByts);
            this.processType1(type1Msg, sreq, sresp);
            return false;
        }
        if (ntlmTyp == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(ntlmByts);
            return this.processType3(type3Msg, context, sreq, sresp);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"NTLM blob not handled, redirecting to login page.");
        }
        if (this.hasLoginPage()) {
            this.redirectToLoginPage(sreq, sresp);
        } else {
            this.restartLoginChallenge(context, sreq, sresp);
        }
        return false;
    }

    protected void processType1(Type1NTLMMessage type1Msg, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Received type1 " + type1Msg));
        }
        NTLMLogonDetails ntlmDetails = null;
        HttpSession session = req.getSession();
        ntlmDetails = (NTLMLogonDetails)session.getAttribute(NTLM_AUTH_DETAILS);
        if (ntlmDetails != null && ntlmDetails.hasType2Message() && ntlmDetails.hasNTLMHashedPassword() && ntlmDetails.hasAuthenticationToken()) {
            Type2NTLMMessage cachedType2 = ntlmDetails.getType2Message();
            byte[] type2Bytes = cachedType2.getBytes();
            String ntlmBlob = "NTLM " + new String(Base64.encodeBase64((byte[])type2Bytes));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Sending cached NTLM type2 to client - " + cachedType2));
            }
            res.setHeader(WWW_AUTHENTICATE, ntlmBlob);
            res.setStatus(401);
            res.flushBuffer();
        } else {
            session.removeAttribute(NTLM_AUTH_DETAILS);
            byte[] challenge = null;
            NTLMPassthruToken authToken = null;
            if (this.nltmAuthenticator.getNTLMMode() == NTLMMode.MD4_PROVIDER) {
                challenge = new byte[8];
                DataPacker.putIntelLong((long)this.m_random.nextLong(), (byte[])challenge, (int)0);
            } else {
                String domain = type1Msg.getDomain();
                if (domain == null || domain.length() == 0) {
                    domain = this.mapClientAddressToDomain(req.getRemoteAddr());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Client domain " + domain));
                }
                authToken = new NTLMPassthruToken(domain);
                this.nltmAuthenticator.authenticate((Authentication)authToken);
                if (authToken.getChallenge() != null) {
                    challenge = authToken.getChallenge().getBytes();
                }
            }
            int ntlmFlags = type1Msg.getFlags() & this.m_ntlmFlags;
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            String srvName = this.getServerName();
            tList.add(new TargetInfo(1, srvName));
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, srvName, challenge, null, tList);
            ntlmDetails = new NTLMLogonDetails();
            ntlmDetails.setType2Message(type2Msg);
            ntlmDetails.setAuthenticationToken((Object)authToken);
            session.setAttribute(NTLM_AUTH_DETAILS, (Object)ntlmDetails);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Sending NTLM type2 to client - " + type2Msg));
            }
            byte[] type2Bytes = type2Msg.getBytes();
            String ntlmBlob = "NTLM " + new String(Base64.encodeBase64((byte[])type2Bytes));
            res.setHeader(WWW_AUTHENTICATE, ntlmBlob);
            res.setStatus(401);
            res.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processType3(Type3NTLMMessage type3Msg, ServletContext context, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Log logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received type3 " + type3Msg));
        }
        NTLMLogonDetails ntlmDetails = null;
        SessionUser user = null;
        user = this.getSessionUser(context, req, res, true);
        HttpSession session = req.getSession();
        ntlmDetails = (NTLMLogonDetails)session.getAttribute(NTLM_AUTH_DETAILS);
        String userName = type3Msg.getUserName();
        String workstation = type3Msg.getWorkstation();
        String domain = type3Msg.getDomain();
        boolean authenticated = false;
        if (user != null && ntlmDetails != null && ntlmDetails.hasNTLMHashedPassword()) {
            byte[] ntlmPwd = type3Msg.getNTLMHash();
            byte[] cachedPwd = ntlmDetails.getNTLMHashedPassword();
            if (ntlmPwd != null) {
                authenticated = Arrays.equals(cachedPwd, ntlmPwd);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using cached NTLM hash, authenticated = " + authenticated));
            }
            this.onValidate(context, req, res);
            return true;
        }
        if (this.nltmAuthenticator.getNTLMMode() == NTLMMode.MD4_PROVIDER) {
            if (this.m_allowGuest && userName.equalsIgnoreCase(this.authenticationComponent.getGuestUserName())) {
                authenticated = true;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Guest logon");
                }
            } else {
                String md4hash = this.getMD4Hash(userName);
                if (md4hash != null) {
                    authenticated = this.validateLocalHashedPassword(type3Msg, ntlmDetails, authenticated, md4hash);
                } else if (this.m_mapUnknownUserToGuest) {
                    userName = this.authenticationComponent.getGuestUserName();
                    authenticated = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("User " + userName + " logged on as guest, no Alfresco account"));
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("User " + userName + " does not have Alfresco account"));
                    }
                    authenticated = false;
                }
            }
        } else if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288) || type3Msg.getNTLMHash() != null && type3Msg.getNTLMHash().length > 24) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Client " + workstation + " using NTLMv2 logon, not valid with passthru authentication"));
            }
        } else {
            NTLMPassthruToken authToken = (NTLMPassthruToken)ntlmDetails.getAuthenticationToken();
            authToken.setUserAndPassword(type3Msg.getUserName(), type3Msg.getNTLMHash(), 1);
            try {
                this.nltmAuthenticator.authenticate((Authentication)authToken);
                authenticated = true;
                if (authToken.isGuestLogon()) {
                    userName = this.authenticationComponent.getGuestUserName();
                }
                this.authenticationComponent.setCurrentUser(userName);
            }
            catch (BadCredentialsException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication failed, " + ex.getMessage()));
                }
            }
            catch (AuthenticationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication failed, " + ex.getMessage()));
                }
            }
            finally {
                ntlmDetails.setAuthenticationToken(null);
            }
        }
        if (authenticated) {
            boolean userInit = false;
            if (user == null) {
                try {
                    user = this.createUserEnvironment(session, userName);
                    userInit = true;
                }
                catch (AuthenticationException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to validate user " + userName), (Throwable)ex);
                    }
                    this.onValidateFailed(context, req, res, session);
                    return false;
                }
            }
            this.onValidate(context, req, res);
            String srvName = this.getServerName();
            if (ntlmDetails == null) {
                ntlmDetails = new NTLMLogonDetails(userName, workstation, domain, false, srvName);
                ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                session.setAttribute(NTLM_AUTH_DETAILS, (Object)ntlmDetails);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No cached NTLM details, created");
                }
            } else {
                ntlmDetails.setDetails(userName, workstation, domain, false, srvName);
                ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Updated cached NTLM details");
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User logged on via NTLM, " + ntlmDetails));
            }
            if (this.onLoginComplete(context, req, res, userInit)) {
                return true;
            }
        } else {
            this.restartLoginChallenge(context, req, res);
        }
        return false;
    }

    protected boolean validateLocalHashedPassword(Type3NTLMMessage type3Msg, NTLMLogonDetails ntlmDetails, boolean authenticated, String md4hash) {
        if (ntlmDetails == null || ntlmDetails.getType2Message() == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("No cached Type2, ntlmDetails=" + ntlmDetails));
            }
            return false;
        }
        if (type3Msg.hasFlag(524288)) {
            if (type3Msg.getNTLMHashLength() > 24) {
                authenticated = this.checkNTLMv2(md4hash, ntlmDetails.getChallengeKey(), type3Msg);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)((authenticated ? "Logged on" : "Logon failed") + " using NTLMSSP/NTLMv2"));
                }
                if (!authenticated && type3Msg.hasFlag(Integer.MIN_VALUE) && type3Msg.getLMHashLength() == 24) {
                    authenticated = this.checkNTLMv1(md4hash, ntlmDetails.getChallengeKey(), type3Msg, true);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)((authenticated ? "Logged on" : "Logon failed") + " using NTLMSSP/NTLMv1 (via fallback)"));
                    }
                }
            } else {
                authenticated = this.checkNTLMv2SessionKey(md4hash, ntlmDetails.getChallengeKey(), type3Msg);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)((authenticated ? "Logged on" : "Logon failed") + " using NTLMSSP/NTLMv2SessKey"));
                }
            }
        } else {
            authenticated = this.checkNTLMv1(md4hash, ntlmDetails.getChallengeKey(), type3Msg, false);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)((authenticated ? "Logged on" : "Logon failed") + " using NTLMSSP/NTLMv1"));
            }
        }
        return authenticated;
    }

    protected final boolean checkNTLMv1(String md4hash, byte[] challenge, Type3NTLMMessage type3Msg, boolean checkLMHash) {
        byte[] clientHash;
        byte[] p21 = new byte[21];
        byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
        System.arraycopy(md4byts, 0, p21, 0, 16);
        byte[] localHash = null;
        try {
            localHash = this.m_encryptor.doNTLM1Encryption(p21, challenge);
        }
        catch (NoSuchAlgorithmException ex) {
            // empty catch block
        }
        byte[] byArray = clientHash = checkLMHash ? type3Msg.getLMHash() : type3Msg.getNTLMHash();
        if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
            int i;
            for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
            }
            if (i == clientHash.length) {
                return true;
            }
        }
        return false;
    }

    protected final boolean checkNTLMv2(String md4hash, byte[] challenge, Type3NTLMMessage type3Msg) {
        boolean lmv2OK;
        boolean ntlmv2OK;
        block11: {
            ntlmv2OK = false;
            lmv2OK = false;
            try {
                byte[] v2hash = this.m_encryptor.doNTLM2Encryption(this.m_md4Encoder.decodeHash(md4hash), type3Msg.getUserName(), type3Msg.getDomain());
                NTLMv2Blob v2blob = new NTLMv2Blob(type3Msg.getNTLMHash());
                byte[] srvHmac = v2blob.calculateHMAC(challenge, v2hash);
                byte[] clientHmac = v2blob.getHMAC();
                if (clientHmac != null && srvHmac != null && clientHmac.length == srvHmac.length) {
                    int i;
                    for (i = 0; i < clientHmac.length && clientHmac[i] == srvHmac[i]; ++i) {
                    }
                    if (i == clientHmac.length) {
                        ntlmv2OK = true;
                    }
                }
                if (!ntlmv2OK) {
                    byte[] lmv2 = type3Msg.getLMHash();
                    byte[] clChallenge = v2blob.getClientChallenge();
                    if (lmv2 != null && lmv2.length == 24 && clChallenge != null && clChallenge.length == 8) {
                        int i;
                        for (i = 0; i < clChallenge.length && lmv2[i + 16] == clChallenge[i]; ++i) {
                        }
                        if (i == clChallenge.length) {
                            byte[] lmv2Hmac = v2blob.calculateLMv2HMAC(v2hash, challenge, clChallenge);
                            for (i = 0; i < lmv2Hmac.length && lmv2[i] == lmv2Hmac[i]; ++i) {
                            }
                            if (i == lmv2Hmac.length) {
                                lmv2OK = true;
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (!this.getLogger().isDebugEnabled()) break block11;
                this.getLogger().debug((Object)ex);
            }
        }
        return ntlmv2OK || lmv2OK;
    }

    protected final boolean checkNTLMv2SessionKey(String md4hash, byte[] challenge, Type3NTLMMessage type3Msg) {
        byte[] nonce = new byte[16];
        System.arraycopy(challenge, 0, nonce, 0, 8);
        System.arraycopy(type3Msg.getLMHash(), 0, nonce, 8, 8);
        MessageDigest md5 = null;
        byte[] v2challenge = new byte[8];
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(nonce);
            byte[] md5nonce = md5.digest();
            System.arraycopy(md5nonce, 0, v2challenge, 0, 8);
        }
        catch (NoSuchAlgorithmException ex) {
            this.getLogger().error((Object)ex);
        }
        byte[] p21 = new byte[21];
        byte[] md4byts = this.m_md4Encoder.decodeHash(md4hash);
        System.arraycopy(md4byts, 0, p21, 0, 16);
        byte[] localHash = null;
        try {
            localHash = this.m_encryptor.doNTLM1Encryption(p21, v2challenge);
        }
        catch (NoSuchAlgorithmException ex) {
            this.getLogger().error((Object)ex);
        }
        byte[] clientHash = type3Msg.getNTLMHash();
        if (clientHash != null && localHash != null && clientHash.length == localHash.length) {
            int i;
            for (i = 0; i < clientHash.length && clientHash[i] == localHash[i]; ++i) {
            }
            if (i == clientHash.length) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMD4Hash(String userName) {
        String md4hash = null;
        UserTransaction tx = this.transactionService.getUserTransaction();
        try {
            tx.begin();
            md4hash = this.nltmAuthenticator.getMD4HashedPassword(userName);
        }
        catch (Throwable ex) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)ex);
            }
        }
        finally {
            block16: {
                if (tx != null) {
                    try {
                        if (tx.getStatus() == 1 || tx.getStatus() == 4 || tx.getStatus() == 9) {
                            tx.rollback();
                        } else {
                            tx.commit();
                        }
                    }
                    catch (Throwable ex) {
                        if (!this.getLogger().isDebugEnabled()) break block16;
                        this.getLogger().debug((Object)ex);
                    }
                }
            }
        }
        return md4hash;
    }

    public void restartLoginChallenge(ServletContext context, HttpServletRequest req, HttpServletResponse res) throws IOException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        res.setHeader(WWW_AUTHENTICATE, AUTH_NTLM);
        res.setStatus(401);
        this.writeLoginPageLink(req, res);
        res.flushBuffer();
    }

    protected final void disableNTLMv2() {
        this.m_disableNTLMv2 = true;
    }
}

