/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.accesscontrol;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.accesscontrol.ACE;
import org.alfresco.repo.webservice.accesscontrol.ACL;
import org.alfresco.repo.webservice.accesscontrol.AccessControlFault;
import org.alfresco.repo.webservice.accesscontrol.AccessControlServiceSoapPort;
import org.alfresco.repo.webservice.accesscontrol.AccessStatus;
import org.alfresco.repo.webservice.accesscontrol.AuthorityFilter;
import org.alfresco.repo.webservice.accesscontrol.GetClassPermissionsResult;
import org.alfresco.repo.webservice.accesscontrol.GetPermissionsResult;
import org.alfresco.repo.webservice.accesscontrol.HasPermissionsResult;
import org.alfresco.repo.webservice.accesscontrol.NewAuthority;
import org.alfresco.repo.webservice.accesscontrol.OwnerResult;
import org.alfresco.repo.webservice.accesscontrol.SiblingAuthorityFilter;
import org.alfresco.repo.webservice.action.ActionFault;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessControlWebService
extends AbstractWebService
implements AccessControlServiceSoapPort {
    private static Log logger = LogFactory.getLog(AccessControlWebService.class);
    private TransactionServiceImpl transactionService = null;
    private PermissionService permissionService = null;
    private OwnableService ownableService = null;
    private AuthorityService authorityService;

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public ACL[] getACLs(final Predicate predicate, final ACE filter) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ACL[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ACL[]>(){

                public ACL[] execute() throws Exception {
                    return AccessControlWebService.this.getACLsImpl(predicate, filter);
                }
            };
            return (ACL[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private ACL[] getACLsImpl(Predicate predicate, ACE filter) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        ACL[] acls = new ACL[nodes.size()];
        int index = 0;
        for (NodeRef node : nodes) {
            ACL acl;
            acls[index] = acl = this.getACLFromNodeRef(node, filter);
            ++index;
        }
        return acls;
    }

    private ACL getACLFromNodeRef(NodeRef node, ACE filter) {
        ACL acl = new ACL();
        acl.setReference(Utils.convertToReference(this.nodeService, this.namespaceService, node));
        boolean inheritPermission = this.permissionService.getInheritParentPermissions(node);
        acl.setInheritPermissions(inheritPermission);
        Set accessPermissions = this.permissionService.getAllSetPermissions(node);
        ACE[] aces = new ACE[accessPermissions.size()];
        int count = 0;
        for (AccessPermission permission : accessPermissions) {
            ACE ace;
            AccessStatus accessStatus = AccessStatus.declined;
            if (org.alfresco.service.cmr.security.AccessStatus.ALLOWED.equals((Object)permission.getAccessStatus())) {
                accessStatus = AccessStatus.acepted;
            }
            aces[count] = ace = new ACE(permission.getAuthority(), permission.getPermission(), accessStatus);
            ++count;
        }
        acl.setAces(aces);
        return acl;
    }

    public ACL[] addACEs(final Predicate predicate, final ACE[] aces) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ACL[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ACL[]>(){

                public ACL[] execute() throws Exception {
                    return AccessControlWebService.this.addACEsImpl(predicate, aces);
                }
            };
            return (ACL[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private ACL[] addACEsImpl(Predicate predicate, ACE[] aces) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        ACL[] acls = new ACL[nodes.size()];
        int count = 0;
        for (NodeRef node : nodes) {
            for (ACE ace : aces) {
                boolean allow = false;
                if (ace.getAccessStatus().equals(AccessStatus.acepted)) {
                    allow = true;
                }
                this.permissionService.setPermission(node, ace.getAuthority(), ace.getPermission(), allow);
            }
            acls[count] = this.getACLFromNodeRef(node, null);
            ++count;
        }
        return acls;
    }

    public ACL[] removeACEs(final Predicate predicate, final ACE[] aces) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ACL[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ACL[]>(){

                public ACL[] execute() throws Exception {
                    return AccessControlWebService.this.removeACEsImpl(predicate, aces);
                }
            };
            return (ACL[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private ACL[] removeACEsImpl(Predicate predicate, ACE[] aces) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        ACL[] acls = new ACL[nodes.size()];
        int count = 0;
        for (NodeRef node : nodes) {
            if (aces == null) {
                this.permissionService.deletePermissions(node);
            } else {
                for (ACE ace : aces) {
                    this.permissionService.deletePermission(node, ace.getAuthority(), ace.getPermission());
                }
            }
            acls[count] = this.getACLFromNodeRef(node, null);
            ++count;
        }
        return acls;
    }

    public GetPermissionsResult[] getPermissions(final Predicate predicate) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<GetPermissionsResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<GetPermissionsResult[]>(){

                public GetPermissionsResult[] execute() throws Exception {
                    return AccessControlWebService.this.getPermissionsImpl(predicate);
                }
            };
            return (GetPermissionsResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private GetPermissionsResult[] getPermissionsImpl(Predicate predicate) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        GetPermissionsResult[] results = new GetPermissionsResult[nodes.size()];
        int count = 0;
        for (NodeRef node : nodes) {
            Set permissions = this.permissionService.getSettablePermissions(node);
            GetPermissionsResult result = new GetPermissionsResult();
            result.setReference(Utils.convertToReference(this.nodeService, this.namespaceService, node));
            result.setPermissions(permissions.toArray(new String[permissions.size()]));
            results[count] = result;
            ++count;
        }
        return results;
    }

    public GetClassPermissionsResult[] getClassPermissions(final String[] classNames) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<GetClassPermissionsResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<GetClassPermissionsResult[]>(){

                public GetClassPermissionsResult[] execute() throws Exception {
                    return AccessControlWebService.this.getClassPermissionsImpl(classNames);
                }
            };
            return (GetClassPermissionsResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private GetClassPermissionsResult[] getClassPermissionsImpl(String[] classNames) {
        GetClassPermissionsResult[] results = new GetClassPermissionsResult[classNames.length];
        int count = 0;
        for (String className : classNames) {
            Set permissions = this.permissionService.getSettablePermissions(QName.createQName((String)className));
            GetClassPermissionsResult result = new GetClassPermissionsResult();
            result.setClassName(className);
            result.setPermissions(permissions.toArray(new String[permissions.size()]));
            results[count] = result;
            ++count;
        }
        return results;
    }

    public HasPermissionsResult[] hasPermissions(final Predicate predicate, final String[] permissions) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<HasPermissionsResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<HasPermissionsResult[]>(){

                public HasPermissionsResult[] execute() throws Exception {
                    return AccessControlWebService.this.hasPermissionsImpl(predicate, permissions);
                }
            };
            return (HasPermissionsResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private HasPermissionsResult[] hasPermissionsImpl(Predicate predicate, String[] permissions) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        ArrayList<HasPermissionsResult> results = new ArrayList<HasPermissionsResult>(20);
        for (NodeRef node : nodes) {
            for (String permission : permissions) {
                org.alfresco.service.cmr.security.AccessStatus accessStatus = this.permissionService.hasPermission(node, permission);
                AccessStatus accessState = AccessStatus.declined;
                if (org.alfresco.service.cmr.security.AccessStatus.ALLOWED.equals((Object)accessStatus)) {
                    accessState = AccessStatus.acepted;
                }
                results.add(new HasPermissionsResult(Utils.convertToReference(this.nodeService, this.namespaceService, node), permission, accessState));
            }
        }
        return results.toArray(new HasPermissionsResult[results.size()]);
    }

    public ACL[] setInheritPermission(final Predicate predicate, final boolean inheritPermission) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ACL[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ACL[]>(){

                public ACL[] execute() throws Exception {
                    return AccessControlWebService.this.setInheritPermissionImpl(predicate, inheritPermission);
                }
            };
            return (ACL[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private ACL[] setInheritPermissionImpl(Predicate predicate, boolean inheritPermission) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        ACL[] acls = new ACL[nodes.size()];
        int count = 0;
        for (NodeRef node : nodes) {
            this.permissionService.setInheritParentPermissions(node, inheritPermission);
            acls[count] = this.getACLFromNodeRef(node, null);
            ++count;
        }
        return acls;
    }

    public OwnerResult[] getOwners(final Predicate predicate) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<OwnerResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<OwnerResult[]>(){

                public OwnerResult[] execute() throws Exception {
                    return AccessControlWebService.this.getOwnersImpl(predicate);
                }
            };
            return (OwnerResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private OwnerResult[] getOwnersImpl(Predicate predicate) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        OwnerResult[] result = new OwnerResult[nodes.size()];
        int count = 0;
        for (NodeRef node : nodes) {
            String owner = this.ownableService.getOwner(node);
            result[count] = new OwnerResult(Utils.convertToReference(this.nodeService, this.namespaceService, node), owner);
            ++count;
        }
        return result;
    }

    public OwnerResult[] setOwners(final Predicate predicate, final String owner) throws RemoteException, AccessControlFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<OwnerResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<OwnerResult[]>(){

                public OwnerResult[] execute() throws Exception {
                    return AccessControlWebService.this.setOwnersImpl(predicate, owner);
                }
            };
            return (OwnerResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private OwnerResult[] setOwnersImpl(Predicate predicate, String owner) {
        List<NodeRef> nodes = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        OwnerResult[] result = new OwnerResult[nodes.size()];
        int count = 0;
        for (NodeRef node : nodes) {
            this.ownableService.setOwner(node, owner);
            result[count] = new OwnerResult(Utils.convertToReference(this.nodeService, this.namespaceService, node), owner);
            ++count;
        }
        return result;
    }

    public String[] addChildAuthorities(String parentAuthority, String[] authorities) throws RemoteException, AccessControlFault {
        String[] result = new String[authorities.length];
        int index = 0;
        for (String authority : authorities) {
            this.authorityService.addAuthority(parentAuthority, authority);
            result[index] = authority;
            ++index;
        }
        return result;
    }

    public String[] createAuthorities(String parentAuthority, NewAuthority[] newAuthorites) throws RemoteException, AccessControlFault {
        String[] result = new String[newAuthorites.length];
        int index = 0;
        for (NewAuthority newAuthority : newAuthorites) {
            AuthorityType authorityType = AuthorityType.valueOf((String)newAuthority.getAuthorityType());
            String authority = this.authorityService.createAuthority(authorityType, newAuthority.getName());
            if (parentAuthority != null) {
                this.authorityService.addAuthority(parentAuthority, authority);
            }
            result[index] = authority;
            ++index;
        }
        return result;
    }

    public void deleteAuthorities(String[] authorities) throws RemoteException, AccessControlFault {
        for (String authority : authorities) {
            this.authorityService.deleteAuthority(authority);
        }
    }

    public String[] getAllAuthorities(AuthorityFilter filter) throws RemoteException, AccessControlFault {
        ArrayList result = new ArrayList(10);
        AuthorityType authorityType = AuthorityType.valueOf((String)filter.getAuthorityType());
        if (filter.isRootOnly()) {
            result.addAll(this.authorityService.getAllRootAuthorities(authorityType));
        } else {
            result.addAll(this.authorityService.getAllAuthorities(authorityType));
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getAuthorities() throws RemoteException, AccessControlFault {
        Set result = this.authorityService.getAuthorities();
        return result.toArray(new String[result.size()]);
    }

    public String[] getChildAuthorities(String authority, SiblingAuthorityFilter filter) throws RemoteException, AccessControlFault {
        AuthorityType authorityType = AuthorityType.valueOf((String)filter.getAuthorityType());
        Set result = this.authorityService.getContainedAuthorities(authorityType, authority, filter.isImmediate());
        return result.toArray(new String[result.size()]);
    }

    public String[] getParentAuthorities(String authority, SiblingAuthorityFilter filter) throws RemoteException, AccessControlFault {
        AuthorityType authorityType = AuthorityType.valueOf((String)filter.getAuthorityType());
        Set result = this.authorityService.getContainingAuthorities(authorityType, authority, filter.isImmediate());
        return result.toArray(new String[result.size()]);
    }

    public void removeChildAuthorities(String parentAuthority, String[] authorities) throws RemoteException, AccessControlFault {
        for (String authority : authorities) {
            this.authorityService.removeAuthority(parentAuthority, authority);
        }
    }
}

