/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.axis;

import org.alfresco.repo.webservice.types.QueryConfiguration;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryConfigHandler
extends BasicHandler {
    public static final String ALF_FETCH_SIZE = "ALF_FETCH_SIZE";
    private static final long serialVersionUID = 6467938074555362971L;
    private static Log logger = LogFactory.getLog(QueryConfigHandler.class);

    public void invoke(MessageContext msgContext) throws AxisFault {
        block11: {
            try {
                SOAPEnvelope env;
                SOAPHeaderElement header;
                String opName = "Unknown method";
                OperationDesc op = msgContext.getOperation();
                if (op != null) {
                    opName = op.getName();
                }
                if ((header = (env = msgContext.getRequestMessage().getSOAPEnvelope()).getHeaderByName("http://www.alfresco.org/ws/service/repository/1.0", "QueryHeader")) != null) {
                    QueryConfiguration queryCfg;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found QueryHeader for call to " + opName));
                    }
                    if ((queryCfg = (QueryConfiguration)header.getObjectValue(QueryConfiguration.class)) != null) {
                        int fetchSize = queryCfg.getFetchSize();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Fetch size for query = " + fetchSize));
                        }
                        msgContext.setProperty(ALF_FETCH_SIZE, (Object)new Integer(fetchSize));
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to find QueryConfiguration within QueryHeader");
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("QueryHeader was not found for call to " + opName));
                }
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug((Object)"Failed to determine fetch size", e);
            }
        }
    }
}

