/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.repository;

import org.alfresco.repo.webservice.AbstractQuerySession;
import org.alfresco.repo.webservice.ServerQuery;
import org.alfresco.repo.webservice.types.ResultSet;
import org.alfresco.repo.webservice.types.ResultSetRow;
import org.alfresco.service.ServiceRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryQuerySession
extends AbstractQuerySession<ResultSet, ResultSetRow> {
    private static final long serialVersionUID = -3621997639261137000L;
    private static Log logger = LogFactory.getLog(RepositoryQuerySession.class);

    public RepositoryQuerySession(long maxResults, long batchSize, ServerQuery<ResultSet> query) {
        super(maxResults, batchSize, query);
    }

    protected ResultSetRow[] makeArray(int size) {
        return new ResultSetRow[size];
    }

    @Override
    public ResultSet getNextResults(ServiceRegistry serviceRegistry) {
        ResultSet queryResults = (ResultSet)this.getQueryResults(serviceRegistry);
        ResultSetRow[] allRows = queryResults.getRows();
        ResultSetRow[] batchedRows = this.getNextResults(allRows);
        ResultSet batchedResults = new ResultSet();
        batchedResults.setMetaData(queryResults.getMetaData());
        batchedResults.setRows(batchedRows);
        batchedResults.setTotalRowCount(allRows.length);
        logger.debug((Object)("total row count :" + allRows.length));
        return batchedResults;
    }
}

