/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class HTTPProxy {
    protected URL url;
    protected HttpServletResponse response;

    public HTTPProxy(String requestUrl, HttpServletResponse response) throws MalformedURLException {
        this.url = new URL(requestUrl);
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        this.setRequestHeaders(connection);
        this.initialiseResponse(connection);
        InputStream input = connection.getInputStream();
        ServletOutputStream output = this.response.getOutputStream();
        try {
            this.writeResponse(input, (OutputStream)output);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.flush();
                    output.close();
                }
                connection.disconnect();
            }
            catch (IOException e) {}
        }
    }

    protected void initialiseResponse(URLConnection urlConnection) {
        String type = urlConnection.getContentType();
        if (type != null) {
            String encoding;
            int encodingIdx = type.lastIndexOf("charset=");
            if (encodingIdx == -1 && (encoding = urlConnection.getContentEncoding()) != null && encoding.length() > 0) {
                type = type + ";charset=" + encoding;
            }
            this.response.setContentType(type);
        }
    }

    protected void setRequestHeaders(URLConnection urlConnection) {
    }

    protected void writeResponse(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int read = input.read(buffer);
        while (read != -1) {
            output.write(buffer, 0, read);
            read = input.read(buffer);
        }
    }
}

