/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.DateTime;
import com.google.gdata.util.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeHelper {
    protected final Map<String, String> attrs = new HashMap<String, String>();
    private Set<String> dups = new HashSet<String>();
    private boolean contentConsumed = false;
    private String content = null;

    public AttributeHelper(Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.getURI(i).length() != 0) {
                String attrLocalName = attrs.getLocalName(i);
                if (this.attrs.put(attrLocalName, attrs.getValue(i)) == null) continue;
                this.dups.add(attrLocalName);
                continue;
            }
            this.attrs.put(attrs.getQName(i), attrs.getValue(i));
        }
    }

    public String consumeContent(boolean required) throws ParseException {
        return this.consume(null, required);
    }

    public String consume(String name, boolean required) throws ParseException {
        if (name == null) {
            if (this.content == null && required) {
                throw new ParseException(CoreErrorDomain.ERR.missingRequiredContent);
            }
            this.contentConsumed = true;
            return this.content;
        }
        String value = this.attrs.get(name);
        if (value == null) {
            if (required) {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.missingAttribute);
                pe.setInternalReason("Missing attribute: '" + name + "'");
                throw pe;
            }
            return null;
        }
        this.attrs.remove(name);
        return value;
    }

    public int consumeInteger(String name, boolean required, int defaultValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidIntegerAttribute);
            pe.setInternalReason("Invalid integer value for attribute: '" + name + "'");
            throw pe;
        }
    }

    public int consumeInteger(String name, boolean required) throws ParseException {
        return this.consumeInteger(name, required, 0);
    }

    public long consumeLong(String name, boolean required, long defaultValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidLongAttribute, (Throwable)e);
            pe.setInternalReason("Invalid long value for attribute: '" + name + "'");
            throw pe;
        }
    }

    public long consumeLong(String name, boolean required) throws ParseException {
        return this.consumeLong(name, required, 0L);
    }

    public double consumeDouble(String name, boolean required, double defaultValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        if ("INF".equals(value)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(value)) {
            return Double.NEGATIVE_INFINITY;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidDoubleAttribute, (Throwable)e);
            pe.setInternalReason("Invalid double value for attribute: '" + name + "'");
            throw pe;
        }
    }

    public double consumeDouble(String name, boolean required) throws ParseException {
        return this.consumeDouble(name, required, 0.0);
    }

    public float consumeFloat(String name, boolean required, float defaultValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        if ("INF".equals(value)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-INF".equals(value)) {
            return Float.NEGATIVE_INFINITY;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidFloatAttribute, (Throwable)e);
            pe.setInternalReason("Invalid float value for attribute: '" + name + "'");
            throw pe;
        }
    }

    public float consumeFloat(String name, boolean required) throws ParseException {
        return this.consumeFloat(name, required, 0.0f);
    }

    public boolean consumeBoolean(String name, boolean required, boolean defaultValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        if ("true".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "0".equals(value)) {
            return false;
        }
        ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidBooleanAttribute);
        pe.setInternalReason("Invalid boolean value for attribute: '" + name + "'");
        throw pe;
    }

    public boolean consumeBoolean(String name, boolean required) throws ParseException {
        return this.consumeBoolean(name, required, false);
    }

    public DateTime consumeDateTime(String name, boolean required) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return null;
        }
        try {
            return DateTime.parseDateTimeChoice(value);
        }
        catch (NumberFormatException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidDatetime, (Throwable)e);
            pe.setInternalReason("Badly formatted datetime in attribute: " + name);
            throw pe;
        }
    }

    public <T extends Enum<T>> T consumeEnum(String name, boolean required, Class<T> enumClass, T defaultValue, EnumToAttributeValue<T> enumToAttributeValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            if (!enumToAttributeValue.getAttributeValue(enumValue).equals(value)) continue;
            return (T)enumValue;
        }
        ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidAttributeValue);
        pe.setInternalReason("Invalid value for attribute : '" + name + "'");
        throw pe;
    }

    public <T extends Enum<T>> T consumeEnum(String name, boolean required, Class<T> enumClass, T defaultValue) throws ParseException {
        String value = this.consume(name, required);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidAttributeValue, (Throwable)e);
            pe.setInternalReason("Invalid value for attribute : '" + name + "'");
            throw pe;
        }
    }

    public <T extends Enum<T>> T consumeEnum(String name, boolean required, Class<T> enumClass) throws ParseException {
        return this.consumeEnum(name, required, enumClass, null);
    }

    public void assertAllConsumed() throws ParseException {
        StringBuffer message = new StringBuffer();
        if (!this.attrs.isEmpty()) {
            message.append("Unknown attribute");
            if (this.attrs.size() > 1) {
                message.append('s');
            }
            message.append(':');
            for (String name : this.attrs.keySet()) {
                message.append(" '");
                message.append(name);
                message.append("' ");
            }
        }
        if (!this.dups.isEmpty()) {
            message.append("Duplicate attribute");
            if (this.dups.size() > 1) {
                message.append('s');
            }
            message.append(':');
            for (String dup : this.dups) {
                message.append(" '");
                message.append(dup);
                message.append("' ");
            }
        }
        if (!this.contentConsumed && this.content != null && this.content.length() != 0) {
            message.append("Unexpected text content ");
        }
        if (message.length() != 0) {
            throw new ParseException(message.toString());
        }
    }

    void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LowerCaseEnumToAttributeValue<T extends Enum<T>>
    implements EnumToAttributeValue<T> {
        @Override
        public String getAttributeValue(T enumValue) {
            return ((Enum)enumValue).name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EnumToAttributeValue<T extends Enum<T>> {
        public String getAttributeValue(T var1);
    }
}

