/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import junit.framework.TestCase;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.content.ContentServiceSoapBindingStub;
import org.alfresco.webservice.repository.RepositoryServiceSoapBindingStub;
import org.alfresco.webservice.repository.UpdateResult;
import org.alfresco.webservice.types.CML;
import org.alfresco.webservice.types.CMLAddAspect;
import org.alfresco.webservice.types.CMLCreate;
import org.alfresco.webservice.types.CMLCreateAssociation;
import org.alfresco.webservice.types.ContentFormat;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Node;
import org.alfresco.webservice.types.ParentReference;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.types.Store;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseWebServiceSystemTest
extends TestCase {
    private static Log logger = LogFactory.getLog(BaseWebServiceSystemTest.class);
    protected static final String USERNAME = "admin";
    protected static final String PASSWORD = "admin";
    public static final String FOLDER_NAME = "test folder";
    protected static final String CONTENT_NAME = "test content";
    protected static final String CONTENT_NAME_2 = "test content 2";
    protected static final String TEST_CONTENT = "This is some test content.  This is some test content.";
    protected static Store store;
    protected static Reference rootReference;
    protected static Reference contentReference;
    protected static Reference contentReference2;
    protected static Reference folderReference;
    protected RepositoryServiceSoapBindingStub repositoryService = WebServiceFactory.getRepositoryService();
    protected ContentServiceSoapBindingStub contentService = WebServiceFactory.getContentService();

    protected void setUp() throws Exception {
        super.setUp();
        AuthenticationUtils.startSession("admin", "admin");
        if (store == null) {
            store = WebServiceFactory.getRepositoryService().createStore("workspace", "Test" + System.currentTimeMillis());
            Predicate predicate = new Predicate(null, store, null);
            Node[] nodes = WebServiceFactory.getRepositoryService().get(predicate);
            if (nodes.length != 1) {
                throw new Exception("Unable to get the root not of the created sotre.");
            }
            rootReference = nodes[0].getReference();
            ParentReference contentParentRef = new ParentReference(store, rootReference.getUuid(), null, Constants.ASSOC_CHILDREN, "{http://www.alfresco.org/model/content/1.0}testContent");
            NamedValue[] contentProperties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, CONTENT_NAME, null)};
            CMLCreate createContent = new CMLCreate("testContent", contentParentRef, null, null, null, Constants.TYPE_CONTENT, contentProperties);
            ParentReference contentParentRef2 = new ParentReference(store, rootReference.getUuid(), null, Constants.ASSOC_CHILDREN, "{http://www.alfresco.org/model/content/1.0}testContent2");
            NamedValue[] contentProperties2 = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, CONTENT_NAME_2, null)};
            CMLCreate createContent2 = new CMLCreate("testContent2", contentParentRef2, null, null, null, Constants.TYPE_CONTENT, contentProperties2);
            ParentReference folderParentRef = new ParentReference(store, rootReference.getUuid(), null, Constants.ASSOC_CHILDREN, "{http://www.alfresco.org/model/content/1.0}testFolder");
            NamedValue[] folderProperties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, FOLDER_NAME, null)};
            CMLCreate createFolder = new CMLCreate("testFolder", folderParentRef, null, null, null, Constants.TYPE_FOLDER, folderProperties);
            CMLAddAspect cmlAddAspect = new CMLAddAspect("{http://www.alfresco.org/model/content/1.0}attachable", null, null, "testContent");
            CMLCreateAssociation createAssoc = new CMLCreateAssociation(null, "testContent", null, "testContent2", Constants.createQNameString("http://www.alfresco.org/model/content/1.0", "attachments"));
            CML cml = new CML();
            cml.setCreate(new CMLCreate[]{createContent, createContent2, createFolder});
            cml.setAddAspect(new CMLAddAspect[]{cmlAddAspect});
            cml.setCreateAssociation(new CMLCreateAssociation[]{createAssoc});
            UpdateResult[] updateResult = this.repositoryService.update(cml);
            contentReference = updateResult[0].getDestination();
            contentReference2 = updateResult[1].getDestination();
            folderReference = updateResult[2].getDestination();
            this.contentService.write(contentReference, Constants.PROP_CONTENT, TEST_CONTENT.getBytes(), new ContentFormat("text/plain", "UTF-8"));
        }
    }

    protected void tearDown() throws Exception {
        AuthenticationUtils.endSession();
    }

    protected ParentReference getFolderParentReference(String assocName) {
        ParentReference parentReference = new ParentReference();
        parentReference.setStore(store);
        parentReference.setUuid(folderReference.getUuid());
        parentReference.setAssociationType(Constants.ASSOC_CONTAINS);
        parentReference.setChildName(assocName);
        return parentReference;
    }

    protected Reference createContentAtRoot(String name, String contentValue) throws Exception {
        ParentReference parentRef = new ParentReference();
        parentRef.setStore(store);
        parentRef.setUuid(rootReference.getUuid());
        parentRef.setAssociationType(Constants.ASSOC_CHILDREN);
        parentRef.setChildName("{http://www.alfresco.org/model/content/1.0}test" + System.currentTimeMillis());
        NamedValue[] properties = new NamedValue[]{new NamedValue(Constants.PROP_NAME, false, name, null)};
        CMLCreate create = new CMLCreate("1", parentRef, null, null, null, Constants.TYPE_CONTENT, properties);
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{create});
        UpdateResult[] result = this.repositoryService.update(cml);
        Reference newContentNode = result[0].getDestination();
        Content content = this.contentService.write(newContentNode, Constants.PROP_CONTENT, contentValue.getBytes(), new ContentFormat("text/plain", "UTF-8"));
        BaseWebServiceSystemTest.assertNotNull((Object)content);
        BaseWebServiceSystemTest.assertNotNull((Object)content.getFormat());
        BaseWebServiceSystemTest.assertEquals((String)"text/plain", (String)content.getFormat().getMimetype());
        return content.getNode();
    }

    protected Predicate convertToPredicate(Reference reference) {
        Predicate predicate = new Predicate();
        predicate.setNodes(new Reference[]{reference});
        return predicate;
    }
}

