/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.webservice.action.Action;
import org.alfresco.webservice.action.ActionExecutionResult;
import org.alfresco.webservice.action.ActionServiceSoapBindingStub;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.util.Utils;
import org.alfresco.webservice.util.WebServiceException;
import org.alfresco.webservice.util.WebServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtils {
    public static String executeAction(Reference actionedUpon, String actionName, Map<String, String> parameters) {
        String result = null;
        Predicate predicate = new Predicate(new Reference[]{actionedUpon}, null, null);
        try {
            ActionServiceSoapBindingStub actionService = WebServiceFactory.getActionService();
            Action action = new Action();
            action.setActionName(actionName);
            if (parameters != null && parameters.size() != 0) {
                NamedValue[] namedValues = new NamedValue[parameters.size()];
                int index = 0;
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    namedValues[index] = Utils.createNamedValue(entry.getKey(), entry.getValue());
                    ++index;
                }
                action.setParameters(namedValues);
            } else {
                action.setParameters(new NamedValue[]{Utils.createNamedValue("temp", "temp")});
            }
            ActionExecutionResult[] actionResults = actionService.executeActions(predicate, new Action[]{action});
            Action actionResult = actionResults[0].getActions(0);
            for (NamedValue namedValueResult : actionResult.getParameters()) {
                if (!namedValueResult.getName().equals("result")) continue;
                result = namedValueResult.getValue();
                break;
            }
        }
        catch (RemoteException exception) {
            throw new WebServiceException("Unable to execute action", exception);
        }
        return result;
    }

    public static String executeScript(Reference actionedUpon, Reference script) {
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put("script-ref", Utils.getNodeRef(script));
        return ActionUtils.executeAction(actionedUpon, "script", parameters);
    }
}

