/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import org.apache.abdera.protocol.client.util.ClientAuthSSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.RemoteConfigProperties;
import org.springframework.extensions.config.element.ConfigElementAdapter;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;

public class RemoteConfigElement
extends ConfigElementAdapter
implements RemoteConfigProperties {
    private static final String REMOTE_KEYSTORE = "keystore";
    private static final String REMOTE_ENDPOINT = "endpoint";
    private static final String REMOTE_AUTHENTICATOR = "authenticator";
    private static final String REMOTE_CONNECTOR = "connector";
    private static final String CONFIG_ELEMENT_ID = "remote";
    protected KeyStoreDescriptor keyStoreDescriptor;
    protected HashMap<String, ConnectorDescriptor> connectors = new HashMap(10);
    protected HashMap<String, AuthenticatorDescriptor> authenticators = new HashMap(10);
    protected HashMap<String, EndpointDescriptor> endpoints = new HashMap(10);
    protected String defaultEndpointId;
    protected String defaultCredentialVaultProviderId;

    public RemoteConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ConfigElement combine(ConfigElement element) {
        RemoteConfigElement configElement = (RemoteConfigElement)element;
        RemoteConfigElement combinedElement = new RemoteConfigElement();
        combinedElement.connectors.putAll(this.connectors);
        combinedElement.authenticators.putAll(this.authenticators);
        combinedElement.endpoints.putAll(this.endpoints);
        combinedElement.connectors.putAll(configElement.connectors);
        combinedElement.authenticators.putAll(configElement.authenticators);
        combinedElement.endpoints.putAll(configElement.endpoints);
        combinedElement.keyStoreDescriptor = this.keyStoreDescriptor;
        if (configElement.keyStoreDescriptor != null) {
            combinedElement.keyStoreDescriptor = configElement.keyStoreDescriptor;
        }
        combinedElement.defaultEndpointId = this.defaultEndpointId;
        if (configElement.defaultEndpointId != null) {
            combinedElement.defaultEndpointId = configElement.defaultEndpointId;
        }
        combinedElement.defaultCredentialVaultProviderId = this.defaultCredentialVaultProviderId;
        if (configElement.defaultCredentialVaultProviderId != null) {
            combinedElement.defaultCredentialVaultProviderId = configElement.defaultCredentialVaultProviderId;
        }
        return combinedElement;
    }

    public String[] getConnectorIds() {
        return this.connectors.keySet().toArray(new String[this.connectors.size()]);
    }

    public ConnectorDescriptor getConnectorDescriptor(String id) {
        return this.connectors.get(id);
    }

    public String[] getAuthenticatorIds() {
        return this.authenticators.keySet().toArray(new String[this.authenticators.size()]);
    }

    public AuthenticatorDescriptor getAuthenticatorDescriptor(String id) {
        return this.authenticators.get(id);
    }

    public String[] getEndpointIds() {
        return this.endpoints.keySet().toArray(new String[this.endpoints.size()]);
    }

    public EndpointDescriptor getEndpointDescriptor(String id) {
        return this.endpoints.get(id);
    }

    public String getDefaultEndpointId() {
        if (this.defaultEndpointId == null) {
            return "alfresco";
        }
        return this.defaultEndpointId;
    }

    public String getDefaultCredentialVaultProviderId() {
        if (this.defaultCredentialVaultProviderId == null) {
            return "credential.vault.provider";
        }
        return this.defaultCredentialVaultProviderId;
    }

    protected static RemoteConfigElement newInstance(Element elem) {
        String _defaultCredentialVaultProviderId;
        String _defaultEndpointId;
        RemoteConfigElement configElement = new RemoteConfigElement();
        List connectors = elem.elements(REMOTE_CONNECTOR);
        for (int i = 0; i < connectors.size(); ++i) {
            Element el = (Element)connectors.get(i);
            ConnectorDescriptor descriptor = new ConnectorDescriptor(el);
            configElement.connectors.put(descriptor.getId(), descriptor);
        }
        List authenticators = elem.elements(REMOTE_AUTHENTICATOR);
        for (int i = 0; i < authenticators.size(); ++i) {
            Element el = (Element)authenticators.get(i);
            AuthenticatorDescriptor descriptor = new AuthenticatorDescriptor(el);
            configElement.authenticators.put(descriptor.getId(), descriptor);
        }
        List endpoints = elem.elements(REMOTE_ENDPOINT);
        for (int i = 0; i < endpoints.size(); ++i) {
            Element el = (Element)endpoints.get(i);
            EndpointDescriptor descriptor = new EndpointDescriptor(el);
            configElement.endpoints.put(descriptor.getId(), descriptor);
        }
        Element el = elem.element(REMOTE_KEYSTORE);
        if (el != null) {
            configElement.keyStoreDescriptor = new KeyStoreDescriptor(el);
        }
        if ((_defaultEndpointId = elem.elementTextTrim("default-endpoint-id")) != null && _defaultEndpointId.length() > 0) {
            configElement.defaultEndpointId = _defaultEndpointId;
        }
        if ((_defaultCredentialVaultProviderId = elem.elementTextTrim("default-credential-vault-provider-id")) != null && _defaultCredentialVaultProviderId.length() > 0) {
            configElement.defaultCredentialVaultProviderId = _defaultCredentialVaultProviderId;
        }
        return configElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IdentityType {
        DECLARED,
        USER,
        NONE;

    }

    public static class EndpointDescriptor
    extends Descriptor {
        private static final String PASSWORD = "password";
        private static final String USERNAME = "username";
        private static final String IDENTITY = "identity";
        private static final String ENDPOINT_URL = "endpoint-url";
        private static final String AUTH_ID = "auth-id";
        private static final String CONNECTOR_ID = "connector-id";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";
        private static final String UNSECURE = "unsecure";
        private static final String PERSISTENT = "persistent";
        private static final String BASIC_AUTH = "basic-auth";
        private static final String EXTERNAL_AUTH = "external-auth";

        EndpointDescriptor(Element el) {
            super(el);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public String getConnectorId() {
            return this.getStringProperty(CONNECTOR_ID);
        }

        public String getAuthId() {
            return this.getStringProperty(AUTH_ID);
        }

        public String getEndpointUrl() {
            return this.getStringProperty(ENDPOINT_URL);
        }

        public IdentityType getIdentity() {
            IdentityType identityType = IdentityType.NONE;
            String identity = this.getStringProperty(IDENTITY);
            if (identity != null) {
                identityType = IdentityType.valueOf(identity.toUpperCase());
            }
            return identityType;
        }

        public String getUsername() {
            return this.getStringProperty(USERNAME);
        }

        public String getPassword() {
            return this.getStringProperty(PASSWORD);
        }

        public boolean getUnsecure() {
            return Boolean.parseBoolean(this.getStringProperty(UNSECURE));
        }

        public boolean getPersistent() {
            return Boolean.parseBoolean(this.getStringProperty(PERSISTENT));
        }

        public boolean getBasicAuth() {
            return Boolean.parseBoolean(this.getStringProperty(BASIC_AUTH));
        }

        public boolean getExternalAuth() {
            return Boolean.parseBoolean(this.getStringProperty(EXTERNAL_AUTH));
        }
    }

    public static class AuthenticatorDescriptor
    extends Descriptor {
        private static final String CLAZZ = "class";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";

        AuthenticatorDescriptor(Element el) {
            super(el);
        }

        public String getImplementationClass() {
            return this.getStringProperty(CLAZZ);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }
    }

    public static class ConnectorDescriptor
    extends Descriptor {
        private static final String CLAZZ = "class";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";
        private static final String AUTHENTICATOR_ID = "authenticator-id";
        private static final String UNAUTHENTICATED_MODE = "unauthenticated-mode";

        ConnectorDescriptor(Element el) {
            super(el);
        }

        public String getImplementationClass() {
            return this.getStringProperty(CLAZZ);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public String getAuthenticatorId() {
            return this.getStringProperty(AUTHENTICATOR_ID);
        }

        public String getUnauthenticatedMode() {
            return this.getStringProperty(UNAUTHENTICATED_MODE);
        }
    }

    public static class KeyStoreDescriptor
    extends Descriptor {
        private static final String PATH = "path";
        private static final String TYPE = "type";
        private static final String PASSWORD = "password";

        KeyStoreDescriptor(Element el) {
            super(el);
            InputStream keyStoreIn;
            String keyStorePath = this.getStringProperty(PATH);
            if (keyStorePath != null && (keyStoreIn = this.getClass().getResourceAsStream("/" + keyStorePath)) != null) {
                try {
                    KeyStore keyStore = KeyStore.getInstance(this.getStringProperty(TYPE));
                    String password = this.getStringProperty(PASSWORD);
                    keyStore.load(keyStoreIn, password.toCharArray());
                    Protocol authHttps = new Protocol("https", (ProtocolSocketFactory)new ClientAuthSSLProtocolSocketFactory(keyStore, password, "TLS", KeyManagerFactory.getDefaultAlgorithm(), null), 443);
                    Protocol.registerProtocol((String)"https", (Protocol)authHttps);
                }
                catch (GeneralSecurityException e) {
                    throw new PlatformRuntimeException("Error loading keyStore: " + keyStorePath, (Throwable)e);
                }
                catch (IOException e) {
                    throw new PlatformRuntimeException("Error loading keyStore: " + keyStorePath, (Throwable)e);
                }
            }
        }
    }

    public static class Descriptor
    implements Serializable {
        private static final String ID = "id";
        protected HashMap<String, Object> map = new HashMap();

        Descriptor(Element el) {
            List elements = el.elements();
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                this.put(element);
            }
        }

        public void put(Element el) {
            String key = el.getName();
            String value = el.getTextTrim();
            if (value != null) {
                this.map.put(key, value);
            }
        }

        public Object get(String key) {
            return this.map.get(key);
        }

        public String getId() {
            return (String)this.get(ID);
        }

        public Object getProperty(String key) {
            return this.get(key);
        }

        public String getStringProperty(String key) {
            return (String)this.get(key);
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

