/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.dom4j.Element;
import org.springframework.extensions.webscripts.AbstractBaseDescription;

public class ArgumentTypeDescription
extends AbstractBaseDescription {
    private String defaultValue;
    private boolean required = true;

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void parse(Element elem) {
        super.parse(elem);
        Element defaultElement = elem.element("default");
        if (defaultElement != null) {
            this.setDefaultValue(defaultElement.getText());
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ").append("    ").append("<").append("arg").append(">").append("\n");
        sb.append("    ").append("    ").append("    ").append("<shortname>").append(this.getShortName()).append("</shortname>").append("\n");
        sb.append("    ").append("    ").append("    ").append("<description>").append(this.getDescription()).append("</description>").append("\n");
        if (this.getDefaultValue() != null) {
            sb.append("    ").append("    ").append("    ").append("<").append("default").append(">").append(this.getDefaultValue()).append("</").append("default").append(">").append("\n");
        }
        sb.append("    ").append("    ").append("</").append("arg").append(">");
        return sb.toString();
    }

    public static ArgumentTypeDescription newInstance() {
        ArgumentTypeDescription newArgumentTypeDescription = new ArgumentTypeDescription("shortname", "description", "default");
        return newArgumentTypeDescription;
    }

    public boolean compare(ArgumentTypeDescription newArgumentTypeDescription) {
        return !this.compareField(newArgumentTypeDescription.getShortName(), this.getShortName()) || !this.compareField(newArgumentTypeDescription.getDescription(), this.getDescription()) || !this.compareField(newArgumentTypeDescription.getDefaultValue(), this.getDefaultValue());
    }

    public ArgumentTypeDescription(String shortName, String description, String defaultValue) {
        super("", shortName, description);
        this.defaultValue = defaultValue;
    }

    public ArgumentTypeDescription() {
    }
}

