/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarativeWebScript
extends AbstractWebScript {
    private static final Log logger = LogFactory.getLog(DeclarativeWebScript.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String format = req.getFormat();
        try {
            String mimetype = this.getContainer().getFormatRegistry().getMimeType(req.getAgent(), format);
            if (mimetype == null) {
                throw new WebScriptException("Web Script format '" + format + "' is not registered");
            }
            Status status = new Status();
            Cache cache = new Cache(this.getDescription().getRequiredCache());
            Map<String, Object> model = this.executeImpl(req, status, cache);
            if (model == null) {
                model = new HashMap<String, Object>(8, 1.0f);
            }
            model.put("status", status);
            model.put("cache", cache);
            try {
                AbstractWebScript.ScriptDetails script = this.getExecuteScript(req.getContentType());
                if (script != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Executing script " + script.getContent().getPathDescription()));
                    }
                    Map<String, Object> scriptModel = this.createScriptParameters(req, res, script, model);
                    HashMap<String, Object> returnModel = new HashMap<String, Object>(8, 1.0f);
                    scriptModel.put("model", returnModel);
                    this.executeScript(script.getContent(), scriptModel);
                    this.mergeScriptModelIntoTemplateModel(script.getContent(), returnModel, model);
                }
                Map<String, Object> templateModel = this.createTemplateParameters(req, res, model);
                if (status.getRedirect()) {
                    this.sendStatus(req, res, status, cache, format, templateModel);
                } else {
                    String location;
                    int statusCode = status.getCode();
                    if (statusCode != 200 && !req.forceSuccessStatus()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Force success status header in response: " + req.forceSuccessStatus()));
                            logger.debug((Object)("Setting status " + statusCode));
                        }
                        res.setStatus(statusCode);
                    }
                    if ((location = status.getLocation()) != null && location.length() > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Setting location to " + location));
                        }
                        res.setHeader("Location", location);
                    }
                    res.setCache(cache);
                    String callback = null;
                    if (this.getContainer().allowCallbacks()) {
                        callback = req.getJSONCallback();
                    }
                    if (format.equals("json") && callback != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Rendering JSON callback response: content type=" + Format.JAVASCRIPT.mimetype() + ", status=" + statusCode + ", callback=" + callback));
                        }
                        res.setContentType(Format.JAVASCRIPT.mimetype() + ";charset=UTF-8");
                        res.getWriter().write(callback + "(");
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Rendering response: content type=" + mimetype + ", status=" + statusCode));
                        }
                        res.setContentType(mimetype + ";charset=UTF-8");
                    }
                    this.renderFormatTemplate(format, templateModel, res.getWriter());
                    if (format.equals("json") && callback != null) {
                        res.getWriter().write(")");
                    }
                }
            }
            finally {
                this.executeFinallyImpl(req, status, cache, model);
            }
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                logger.debug((Object)("Caught exception; decorating with appropriate status template : " + stack.toString()));
            }
            throw this.createStatusException(e, req, res);
        }
    }

    private final void mergeScriptModelIntoTemplateModel(ScriptContent scriptContent, Map<String, Object> scriptModel, Map<String, Object> templateModel) {
        ScriptProcessor scriptProcessor = this.getContainer().getScriptProcessorRegistry().getScriptProcessor(scriptContent);
        if (scriptProcessor != null) {
            for (Map.Entry<String, Object> entry : scriptModel.entrySet()) {
                Object value = entry.getValue();
                Object templateValue = scriptProcessor.unwrapValue(value);
                templateModel.put(entry.getKey(), templateValue);
            }
        }
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, WebScriptStatus status) {
        return null;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        return this.executeImpl(req, new WebScriptStatus(status));
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        return this.executeImpl(req, status);
    }

    protected void executeFinallyImpl(WebScriptRequest req, Status status, Cache cache, Map<String, Object> model) {
    }

    protected final void renderFormatTemplate(String format, Map<String, Object> model, Writer writer) {
        format = format == null ? "" : format;
        String templatePath = this.getDescription().getId() + "." + format;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering template '" + templatePath + "'"));
        }
        this.renderTemplate(templatePath, model, writer);
    }

    public Map<String, Object> getTemplateModel(WebScriptRequest req, WebScriptResponse res) throws IOException {
        Status status = new Status();
        Cache cache = new Cache(this.getDescription().getRequiredCache());
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        model.put("status", status);
        model.put("cache", cache);
        AbstractWebScript.ScriptDetails script = this.getExecuteScript(req.getContentType());
        if (script != null) {
            Map<String, Object> scriptModel = this.createScriptParameters(req, res, script, model);
            HashMap<String, Object> returnModel = new HashMap<String, Object>(8, 1.0f);
            scriptModel.put("model", returnModel);
            this.executeScript(script.getContent(), scriptModel);
            this.mergeScriptModelIntoTemplateModel(script.getContent(), returnModel, model);
        }
        return this.createTemplateParameters(req, res, model);
    }
}

