/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.Serializable;
import org.springframework.extensions.webscripts.ScriptableLinkedHashMap;
import org.springframework.extensions.webscripts.ScriptableMap;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptCredentials
implements Serializable {
    private final CredentialVault vault;
    private final Credentials credentials;
    private final boolean hideNonPersistent;
    protected ScriptableMap<String, Serializable> properties;

    public ScriptCredentials(CredentialVault vault, Credentials credentials) {
        this(vault, credentials, false);
    }

    public ScriptCredentials(CredentialVault vault, Credentials credentials, boolean hideNonPersistent) {
        this.vault = vault;
        this.credentials = credentials;
        this.hideNonPersistent = hideNonPersistent;
    }

    public ScriptableMap<String, Serializable> getProperties() {
        if (this.properties == null) {
            this.properties = new ScriptableLinkedHashMap<String, Serializable>();
            if (!this.isHidden()) {
                String[] keys = this.credentials.getPropertyKeys();
                for (int i = 0; i < keys.length; ++i) {
                    Object propertyValue = this.credentials.getProperty(keys[i]);
                    this.properties.put(keys[i], (Serializable)propertyValue);
                }
            }
        }
        return this.properties;
    }

    public boolean isHidden() {
        return !this.isPersistent() && this.hideNonPersistent;
    }

    public boolean isPersistent() {
        return this.credentials.isPersistent();
    }
}

