/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.ScriptRemote;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScriptClass(help="Describes a connector to a remote endpoint.", code="// get a connector to the Alfresco repository endpoint\nvar connector = remote.connect(\"alfresco\"); \n// retrieve the web script index page \nvar indexHtml = connector.get(\"/index\");", types={ScriptClassType.JavaScriptAPI})
public final class ScriptRemoteConnector {
    private static final Log logger = LogFactory.getLog(ScriptRemote.class);
    private final Connector connector;
    private final RemoteConfigElement.EndpointDescriptor descriptor;

    public ScriptRemoteConnector(Connector connector, RemoteConfigElement.EndpointDescriptor descriptor) {
        this.connector = connector;
        this.descriptor = descriptor;
    }

    @ScriptMethod(help="Invokes a URI on the endpoint via a GET request.", output="Response object from the call")
    public Response call(@ScriptParameter(help="Endpoint Url") String uri) {
        ConnectorContext context = new ConnectorContext(null, ScriptRemoteConnector.buildDefaultHeaders());
        return this.connector.call(uri, context);
    }

    @ScriptMethod(help="Invokes a GET request URI on the endpoint.", output="Response object from the call")
    public Response get(@ScriptParameter(help="Endpoint Url") String uri) {
        return this.call(uri);
    }

    @ScriptMethod(help="Invokes a URI on a remote service, passing the supplied body as a POST request.", output="Response object from the call")
    public Response post(@ScriptParameter(help="Endpoint Url") String uri, @ScriptParameter(help="Body of the POST request.") String body) {
        ConnectorContext context = new ConnectorContext(null, ScriptRemoteConnector.buildDefaultHeaders());
        context.setMethod(HttpMethod.POST);
        try {
            return this.connector.call(uri, context, new ByteArrayInputStream(body.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException err) {
            throw new WebScriptsPlatformException("Unsupported encoding.", err);
        }
    }

    @ScriptMethod(help="Invokes a URI on a remote service, passing the supplied body as a POST request.", output="Response object from the call")
    public Response post(@ScriptParameter(help="Endpoint Url") String uri, @ScriptParameter(help="Body of the POST request.") String body, @ScriptParameter(help="Content mimetype of the request body") String contentType) {
        ConnectorContext context = new ConnectorContext(null, ScriptRemoteConnector.buildDefaultHeaders());
        context.setMethod(HttpMethod.POST);
        context.setContentType(contentType);
        try {
            return this.connector.call(uri, context, new ByteArrayInputStream(body.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException err) {
            throw new WebScriptsPlatformException("Unsupported encoding.", err);
        }
    }

    @ScriptMethod(help="Invokes a URI on a remote service, passing the supplied body as a PUT request.", output="Response object from the call")
    public Response put(@ScriptParameter(help="Endpoint Url") String uri, @ScriptParameter(help="Body of the PUT request.") String body) {
        ConnectorContext context = new ConnectorContext(null, ScriptRemoteConnector.buildDefaultHeaders());
        context.setMethod(HttpMethod.PUT);
        try {
            return this.connector.call(uri, context, new ByteArrayInputStream(body.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException err) {
            throw new WebScriptsPlatformException("Unsupported encoding.", err);
        }
    }

    @ScriptMethod(help="Invokes a URI on a remote service, passing the supplied body as a PUT request.", output="Response object from the call")
    public Response put(@ScriptParameter(help="Endpoint Url") String uri, @ScriptParameter(help="Body of the PUT request.") String body, @ScriptParameter(help="Content mimetype of the request.") String contentType) {
        ConnectorContext context = new ConnectorContext(null, ScriptRemoteConnector.buildDefaultHeaders());
        context.setMethod(HttpMethod.PUT);
        context.setContentType(contentType);
        try {
            return this.connector.call(uri, context, new ByteArrayInputStream(body.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException err) {
            throw new WebScriptsPlatformException("Unsupported encoding.", err);
        }
    }

    @ScriptMethod(help="Invokes a URI on a remote service as DELETE request.\nNOTE: the name of the method is 'del' not 'delete' so as to not\ninterfere with JavaScript Object.delete() method.", output="Response object from the call")
    public Response del(@ScriptParameter(help="Endpoint Url") String uri) {
        ConnectorContext context = new ConnectorContext(null, ScriptRemoteConnector.buildDefaultHeaders());
        context.setMethod(HttpMethod.DELETE);
        return this.connector.call(uri, context);
    }

    @ScriptMethod(help="Returns the endpoint string", output="Endpoint")
    public String getEndpoint() {
        return this.connector.getEndpoint();
    }

    @ScriptMethod(help="Returns the endpoint descriptor", output="Endpoint descriptor")
    public RemoteConfigElement.EndpointDescriptor getDescriptor() {
        return this.descriptor;
    }

    private static Map<String, String> buildDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(1, 1.0f);
        headers.put("Accept-Language", I18NUtil.getLocale().toString().replace('_', '-'));
        return headers;
    }
}

