/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.processor.BaseProcessor;

public class TemplateProcessorRegistry {
    private static final Log logger = LogFactory.getLog(TemplateProcessorRegistry.class);
    private String defaultTemplateProcessorName = "freemarker";
    private Map<String, TemplateProcessor> templateProcessors = new HashMap<String, TemplateProcessor>(8);
    private Map<String, String> templateProcessorNamesByExtension = new HashMap<String, String>(8);

    public void setDefaultTemplateProcessor(String defaultTemplateProcessorName) {
        this.defaultTemplateProcessorName = defaultTemplateProcessorName;
    }

    public void registerTemplateProcessor(TemplateProcessor templateProcessor) {
        this.registerTemplateProcessor(templateProcessor, null, null);
    }

    public void registerTemplateProcessor(TemplateProcessor templateProcessor, String extension, String name) {
        if (name == null && extension == null && templateProcessor instanceof BaseProcessor) {
            name = ((BaseProcessor)((Object)templateProcessor)).getName();
            extension = ((BaseProcessor)((Object)templateProcessor)).getExtension();
        }
        if (name != null && extension != null) {
            this.templateProcessors.put(name, templateProcessor);
            this.templateProcessorNamesByExtension.put(extension, name);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Registered template processor " + name + " for extension " + extension));
            }
        }
    }

    protected TemplateProcessor getDefaultTemplateProcessor() {
        return this.templateProcessors.get(this.defaultTemplateProcessorName);
    }

    public TemplateProcessor getTemplateProcessor(String path) {
        String extension;
        String templateProcessorName;
        TemplateProcessor processor = null;
        int i = path.lastIndexOf(46);
        if (i != -1 && (templateProcessorName = this.templateProcessorNamesByExtension.get(extension = path.substring(i + 1))) != null) {
            processor = this.templateProcessors.get(templateProcessorName);
        }
        if (processor == null) {
            processor = this.getDefaultTemplateProcessor();
        }
        return processor;
    }

    public TemplateProcessor getTemplateProcessorByExtension(String extension) {
        TemplateProcessor processor = null;
        String templateProcessorName = this.templateProcessorNamesByExtension.get(extension);
        if (templateProcessorName != null) {
            processor = this.templateProcessors.get(templateProcessorName);
        }
        return processor;
    }

    public String findValidTemplatePath(String path) {
        String extension;
        TemplateProcessor processor;
        String validTemplatePath = null;
        int i = path.lastIndexOf(46);
        if (i != -1 && (processor = this.getTemplateProcessorByExtension(extension = path.substring(i + 1))) != null && processor.hasTemplate(path)) {
            validTemplatePath = path;
        }
        if (validTemplatePath == null) {
            String[] extensions = this.getRegisteredExtensions();
            for (int n = 0; n < extensions.length; ++n) {
                String template;
                String extension2 = extensions[n];
                TemplateProcessor processor2 = this.getTemplateProcessorByExtension(extension2);
                if (!processor2.hasTemplate(template = path + '.' + extension2)) continue;
                validTemplatePath = template;
                break;
            }
        }
        return validTemplatePath;
    }

    public String[] getRegisteredExtensions() {
        return this.templateProcessorNamesByExtension.keySet().toArray(new String[this.templateProcessorNamesByExtension.keySet().size()]);
    }

    public String getExtensionForProcessor(TemplateProcessor templateProcessor) {
        String ext = null;
        String[] extensions = this.getRegisteredExtensions();
        for (int n = 0; n < extensions.length; ++n) {
            String extension = extensions[n];
            TemplateProcessor processor = this.getTemplateProcessorByExtension(extension);
            if (processor != templateProcessor) continue;
            ext = extension;
            break;
        }
        return ext;
    }

    public void reset() {
        for (TemplateProcessor p : this.templateProcessors.values()) {
            p.reset();
        }
    }
}

