/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.atom;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Service;
import org.apache.abdera.parser.Parser;
import org.apache.abdera.writer.Writer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.atom.AbderaService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbderaServiceImpl
implements AbderaService,
InitializingBean {
    private Abdera abdera;
    private Parser parser;
    private Factory factory;
    private List<String> writerNames;
    private Map<String, Writer> writers;
    private Map<String, QName> qNames;

    public void setWriters(List<String> writerNames) {
        this.writerNames = writerNames;
    }

    public void afterPropertiesSet() throws Exception {
        this.abdera = new Abdera();
        this.factory = this.abdera.getFactory();
        this.parser = this.factory.newParser();
        this.writers = new HashMap<String, Writer>(this.writerNames == null ? 1 : this.writerNames.size() + 1);
        this.writers.put("default", this.abdera.getWriter());
        if (this.writerNames != null) {
            for (String writerName : this.writerNames) {
                Writer writer = this.abdera.getWriterFactory().getWriter(writerName);
                if (writer == null) {
                    throw new WebScriptException("Failed to register Atom writer '" + writerName + "'; does not exist.");
                }
                this.writers.put(writerName, writer);
            }
        }
        this.qNames = new HashMap<String, QName>();
    }

    @Override
    public Abdera getAbdera() {
        return this.abdera;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Entry createEntry() {
        return this.factory.newEntry();
    }

    @Override
    public Feed createFeed() {
        return this.factory.newFeed();
    }

    @Override
    public Element parse(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parse(inputReader, base);
    }

    @Override
    public Element parse(Reader doc, String base) {
        Document entryDoc = base != null && base.length() > 0 ? this.parser.parse(doc, base) : this.parser.parse(doc);
        Element root = entryDoc.getRoot();
        return root;
    }

    @Override
    public Service parseService(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parseService(inputReader, base);
    }

    @Override
    public Service parseService(Reader doc, String base) {
        Element root = this.parse(doc, base);
        if (!Service.class.isAssignableFrom(root.getClass())) {
            throw new WebScriptException(400, "Expected APP Service, but recieved " + root.getClass());
        }
        return (Service)root;
    }

    @Override
    public Entry parseEntry(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parseEntry(inputReader, base);
    }

    @Override
    public Entry parseEntry(Reader doc, String base) {
        Element root = this.parse(doc, base);
        if (!Entry.class.isAssignableFrom(root.getClass())) {
            throw new WebScriptException(400, "Expected Atom Entry, but recieved " + root.getClass());
        }
        return (Entry)root;
    }

    @Override
    public Feed parseFeed(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parseFeed(inputReader, base);
    }

    @Override
    public Feed parseFeed(Reader doc, String base) {
        Element root = this.parse(doc, base);
        if (!Feed.class.isAssignableFrom(root.getClass())) {
            throw new WebScriptException(400, "Expected Atom Feed, but recieved " + root.getClass());
        }
        return (Feed)root;
    }

    @Override
    public Writer getWriter(String name) {
        return this.writers.get(name);
    }

    @Override
    public Map<String, QName> getNames() {
        return Collections.unmodifiableMap(this.qNames);
    }

    public void registerQName(String alias, String qname) {
        this.qNames.put(alias, QName.valueOf(qname));
    }

    public void registerExtensionFactory(ExtensionFactory extensionFactory) {
        this.factory.registerExtension(extensionFactory);
    }
}

