/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.atom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.model.Entry;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.FormatReader;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.atom.AbderaService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEntryReader
implements FormatReader<Entry> {
    protected AbderaService abderaService;

    public void setAbderaService(AbderaService abderaService) {
        this.abderaService = abderaService;
    }

    @Override
    public Class<Entry> getDestinationClass() {
        return Entry.class;
    }

    @Override
    public String getSourceMimetype() {
        return Format.ATOMENTRY.mimetype();
    }

    @Override
    public Entry read(WebScriptRequest req) {
        Content content = req.getContent();
        if (content == null) {
            throw new WebScriptException("Failed to convert request to Atom Entry");
        }
        try {
            return this.abderaService.parseEntry(content.getReader(), req.getServerPath() + URLEncoder.encodeUri((String)req.getServicePath()));
        }
        catch (IOException e) {
            throw new WebScriptException("Failed to convert request to Atom Entry", e);
        }
    }

    @Override
    public Map<String, Object> createScriptParameters(WebScriptRequest req, WebScriptResponse res) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entry", this.read(req));
        params.put("slug", req.getHeader("Slug"));
        return params;
    }
}

