/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.ConnectorProviderException;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorProvider;
import org.springframework.extensions.webscripts.connector.ConnectorService;

public class ConnectorProviderImpl
implements ConnectorProvider {
    private static final Log logger = LogFactory.getLog(ConnectorProviderImpl.class);
    private ConnectorService connectorService;

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public Connector provide(String endpoint) throws ConnectorProviderException {
        Connector conn = null;
        try {
            conn = this.connectorService.getConnector(endpoint);
        }
        catch (ConnectorServiceException cse) {
            throw new ConnectorProviderException("Unable to provision connector for endpoint: " + endpoint, cse);
        }
        return conn;
    }
}

