/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.DefaultHttpParamsFactory;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.connector.AbstractClient;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.ResponseStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClient
extends AbstractClient {
    private static Log logger;
    private static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String CHARSETEQUALS = "charset=";
    private static final int BUFFERSIZE = 4096;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 90000;
    private static final String XML_START = "<?xml";
    private static final Pattern XML_ENCODING;
    private static final int XML_ENC_READ_LIMIT = 100;
    private Map<String, String> cookies;
    private String defaultEncoding;
    private String ticket;
    private String ticketName = "alf_ticket";
    private String requestContentType = "application/octet-stream";
    private HttpMethod requestMethod = HttpMethod.GET;
    private String username;
    private String password;
    private Map<String, String> requestProperties;
    public static final int SC_REMOTE_CONN_TIMEOUT = 499;
    public static final int SC_REMOTE_CONN_NOHOST = 498;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    private static final int MAX_REDIRECTS = 10;

    public RemoteClient(String endpoint) {
        this(endpoint, null);
    }

    public RemoteClient(String endpoint, String defaultEncoding) {
        super(endpoint);
        this.defaultEncoding = defaultEncoding;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicketName(String ticketName) {
        this.ticketName = ticketName;
    }

    public String getTicketName() {
        return this.ticketName;
    }

    public void setUsernamePassword(String user, String pass) {
        this.username = user;
        this.password = pass;
    }

    public void setRequestContentType(String contentType) {
        if (this.requestContentType != null && this.requestContentType.length() != 0) {
            this.requestContentType = contentType;
        }
    }

    public void setRequestMethod(HttpMethod method) {
        if (method != null) {
            this.requestMethod = method;
        }
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public Response call(String uri) {
        return this.call(uri, true, null);
    }

    public Response call(String uri, String body) {
        try {
            byte[] bytes = body.getBytes("UTF-8");
            return this.call(uri, true, new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebScriptsPlatformException("Encoding not supported.", e);
        }
    }

    public Response call(String uri, InputStream in) {
        return this.call(uri, true, in);
    }

    public Response call(String uri, boolean buildResponseString, InputStream in) {
        Response result;
        if (in != null && this.requestMethod != HttpMethod.POST && this.requestMethod != HttpMethod.PUT) {
            this.requestMethod = HttpMethod.POST;
        }
        ResponseStatus status = new ResponseStatus();
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(4096);
            String encoding = this.service(this.buildURL(uri), in, bOut, status);
            if (buildResponseString) {
                String data;
                if (encoding != null) {
                    data = bOut.toString(encoding);
                } else {
                    String string = data = this.defaultEncoding != null ? bOut.toString(this.defaultEncoding) : bOut.toString();
                    if (data.startsWith(XML_START)) {
                        Matcher xmlMatcher;
                        String searchXML = data;
                        if (data.length() > 100) {
                            searchXML = data.substring(0, 100);
                        }
                        if ((xmlMatcher = XML_ENCODING.matcher(searchXML)).find()) {
                            data = bOut.toString(xmlMatcher.group(1));
                        }
                    }
                }
                result = new Response(data, status);
            } else {
                result = new Response(new ByteArrayInputStream(bOut.toByteArray()), status);
            }
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error status " + status.getCode() + " " + status.getMessage()));
            }
            result = new Response(status);
        }
        return result;
    }

    public Response call(String uri, OutputStream out) {
        return this.call(uri, null, out);
    }

    public Response call(String uri, InputStream in, OutputStream out) {
        Response result;
        if (in != null && this.requestMethod != HttpMethod.POST && this.requestMethod != HttpMethod.PUT) {
            this.requestMethod = HttpMethod.POST;
        }
        ResponseStatus status = new ResponseStatus();
        try {
            String encoding = this.service(this.buildURL(uri), in, out, status);
            result = new Response(status);
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error status " + status.getCode() + " " + status.getMessage()));
            }
            result = new Response(status);
        }
        return result;
    }

    public Response call(String uri, HttpServletRequest req, HttpServletResponse res) {
        Response result;
        ResponseStatus status = new ResponseStatus();
        try {
            boolean isPush = this.requestMethod == HttpMethod.POST || this.requestMethod == HttpMethod.PUT;
            String encoding = this.service(this.buildURL(uri), (InputStream)(isPush ? req.getInputStream() : null), (OutputStream)(res != null ? res.getOutputStream() : null), req, res, status);
            result = new Response(status);
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error status " + status.getCode() + " " + status.getMessage()));
            }
            result = new Response(status);
        }
        return result;
    }

    protected URL processResponse(URL url, org.apache.commons.httpclient.HttpMethod method) throws MalformedURLException {
        String redirectLocation = null;
        for (Header header : method.getResponseHeaders()) {
            String headerValue;
            int z;
            String headerName = header.getName();
            if (this.cookies != null && headerName.equalsIgnoreCase("set-cookie") && (z = (headerValue = header.getValue()).indexOf(61)) != -1) {
                String cookieName = headerValue.substring(0, z);
                String cookieValue = headerValue.substring(z + 1, headerValue.length());
                int y = cookieValue.indexOf(59);
                if (y != -1) {
                    cookieValue = cookieValue.substring(0, y);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RemoteClient found set-cookie: " + cookieName + " = " + cookieValue));
                }
                this.cookies.put(cookieName, cookieValue);
            }
            if (!headerName.equalsIgnoreCase("Location")) continue;
            switch (method.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    redirectLocation = header.getValue();
                }
            }
        }
        return redirectLocation == null ? null : new URL(url, redirectLocation);
    }

    private URL buildURL(String uri) throws MalformedURLException {
        String resolvedUri;
        String string = resolvedUri = uri.startsWith(this.endpoint) ? uri : this.endpoint + uri;
        URL url = this.getTicket() == null ? new URL(resolvedUri) : new URL(resolvedUri + (uri.lastIndexOf(63) == -1 ? "?" + this.getTicketName() + "=" + this.getTicket() : "&" + this.getTicketName() + "=" + this.getTicket()));
        return url;
    }

    private String service(URL url, InputStream in, OutputStream out, ResponseStatus status) throws IOException {
        return this.service(url, in, out, null, null, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String service(URL url, InputStream in, OutputStream out, HttpServletRequest req, HttpServletResponse res, ResponseStatus status) throws IOException {
        trace = RemoteClient.logger.isTraceEnabled();
        debug = RemoteClient.logger.isDebugEnabled();
        if (debug) {
            RemoteClient.logger.debug((Object)("Executing (" + (Object)this.requestMethod + ") " + url.toString()));
            if (in != null) {
                RemoteClient.logger.debug((Object)" - InputStream supplied - will push...");
            }
            if (out != null) {
                RemoteClient.logger.debug((Object)" - OutputStream supplied - will stream response...");
            }
            if (req != null && res != null) {
                RemoteClient.logger.debug((Object)" - Full Proxy mode between servlet request and response...");
            }
        }
        client = new HttpClient((HttpClientParams)new NonBlockingHttpParams());
        params = client.getParams();
        params.setBooleanParameter("http.connection.stalecheck", false);
        params.setBooleanParameter("http.tcp.nodelay", true);
        if (!debug) {
            params.setIntParameter("http.connection.timeout", 5000);
            params.setIntParameter("http.socket.timeout", 90000);
        }
        if (url.getProtocol().equals("http")) {
            this.setupHttpProxyHost(url, client);
        } else if (url.getProtocol().equals("https")) {
            this.setupHttpsProxyHost(url, client);
        }
        redirectURL = url;
        method = null;
        retries = 0;
        maxRetries = in == null ? 10 : 1;
        try {
            block73: {
                try {
                    block72: {
                        block70: {
                            do {
                                if (method != null) {
                                    method.releaseConnection();
                                    method = null;
                                }
                                switch (1.$SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod[this.requestMethod.ordinal()]) {
                                    default: {
                                        method = new GetMethod(redirectURL.toString());
                                        break;
                                    }
                                    case 2: {
                                        method = new PutMethod(redirectURL.toString());
                                        break;
                                    }
                                    case 3: {
                                        method = new PostMethod(redirectURL.toString());
                                        break;
                                    }
                                    case 4: {
                                        method = new DeleteMethod(redirectURL.toString());
                                        break;
                                    }
                                    case 5: {
                                        method = new HeadMethod(redirectURL.toString());
                                    }
                                }
                                method.setFollowRedirects(false);
                                if (req != null) {
                                    headers = req.getHeaderNames();
                                    while (headers.hasMoreElements()) {
                                        key = (String)headers.nextElement();
                                        if (key == null) continue;
                                        method.setRequestHeader(key, req.getHeader(key));
                                        if (!trace) continue;
                                        RemoteClient.logger.trace((Object)("Proxy request header: " + key + "=" + req.getHeader(key)));
                                    }
                                }
                                if (this.requestProperties != null && this.requestProperties.size() != 0) {
                                    for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                                        headerName = entry.getKey();
                                        headerValue = this.requestProperties.get(headerName);
                                        method.setRequestHeader(headerName, headerValue);
                                        if (!trace) continue;
                                        RemoteClient.logger.trace((Object)("Set request header: " + headerName + "=" + headerValue));
                                    }
                                }
                                if (this.cookies != null && !this.cookies.isEmpty()) {
                                    builder = new StringBuilder(128);
                                    for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                                        if (builder.length() != 0) {
                                            builder.append(';');
                                        }
                                        builder.append(entry.getKey());
                                        builder.append('=');
                                        builder.append(entry.getValue());
                                    }
                                    cookieString = builder.toString();
                                    if (debug) {
                                        RemoteClient.logger.debug((Object)("Setting cookie header: " + cookieString));
                                    }
                                    method.setRequestHeader("Cookie", cookieString);
                                }
                                if (this.username != null && this.password != null) {
                                    auth = this.username + ':' + this.password;
                                    method.addRequestHeader("Authorization", "Basic " + Base64.encodeBytes((byte[])auth.getBytes()));
                                    if (debug) {
                                        RemoteClient.logger.debug((Object)"Applied HTTP Basic Authorization");
                                    }
                                }
                                if (in != null) {
                                    method.setRequestHeader("Content-Type", this.requestContentType);
                                    if (debug) {
                                        RemoteClient.logger.debug((Object)("Set content-type=" + this.requestContentType));
                                    }
                                    if (!(urlencoded = this.requestContentType.equals("application/x-www-form-urlencoded"))) {
                                        contentLength = -2;
                                        if (req != null) {
                                            contentLength = req.getContentLength();
                                        }
                                        if (debug) {
                                            RemoteClient.logger.debug((Object)((Object)this.requestMethod + " entity content-length=" + contentLength));
                                        }
                                        ((EntityEnclosingMethod)method).setRequestEntity((RequestEntity)new InputStreamRequestEntity(in, (long)contentLength));
                                    } else if (req != null && method instanceof PostMethod && (postParams = req.getParameterMap()) != null) {
                                        for (String key : postParams.keySet()) {
                                            values = (String[])postParams.get(key);
                                            for (i = 0; i < values.length; ++i) {
                                                ((PostMethod)method).addParameter(key, values[i]);
                                            }
                                        }
                                    }
                                }
                                responseCode = client.executeMethod((org.apache.commons.httpclient.HttpMethod)method);
                            } while ((redirectURL = this.processResponse(redirectURL, (org.apache.commons.httpclient.HttpMethod)method)) != null && ++retries < maxRetries);
                            if (res != null) {
                                res.reset();
                                if (responseCode != 401) {
                                    res.setStatus(responseCode);
                                }
                            }
                            status.setCode(responseCode);
                            if (debug) {
                                RemoteClient.logger.debug((Object)("Response status code: " + responseCode));
                            }
                            contentType = null;
                            contentLength = null;
                            for (Header header : method.getResponseHeaders()) {
                                key = header.getName();
                                if (key == null) continue;
                                if (!key.equalsIgnoreCase("Server") && !key.equalsIgnoreCase("Transfer-Encoding")) {
                                    if (res != null && responseCode != 401) {
                                        res.setHeader(key, header.getValue());
                                    }
                                    status.setHeader(key, header.getValue());
                                    if (trace) {
                                        RemoteClient.logger.trace((Object)("Response header: " + key + "=" + header.getValue()));
                                    }
                                }
                                if (contentType == null && key.equalsIgnoreCase("Content-Type")) {
                                    contentType = header;
                                    continue;
                                }
                                if (contentLength != null || !key.equalsIgnoreCase("Content-Length")) continue;
                                contentLength = header;
                            }
                            encoding = null;
                            ct = null;
                            if (contentType != null && (csi = (ct = contentType.getValue()).indexOf("charset=")) != -1) {
                                encoding = ct.substring(csi + "charset=".length());
                            }
                            if (debug) {
                                RemoteClient.logger.debug((Object)("Response encoding: " + contentType));
                            }
                            bufferSize = 4096;
                            if (contentLength != null && (length = Long.parseLong(contentLength.getValue())) < (long)bufferSize) {
                                bufferSize = (int)length;
                            }
                            traceBuf = null;
                            if (trace) {
                                traceBuf = new StringBuilder(bufferSize);
                            }
                            responseCommit = false;
                            if (responseCode == 304 || responseCode == 401 || (input = method.getResponseBodyAsStream()) == null) break block72;
                            try {
                                buffer = new byte[bufferSize];
                                read = input.read(buffer);
                                if (read != -1) {
                                    responseCommit = true;
                                }
                                while (read != -1) {
                                    if (out != null) {
                                        out.write(buffer, 0, read);
                                    }
                                    if (trace && ct != null && (ct.startsWith("text/") || ct.startsWith("application/json"))) {
                                        traceBuf.append(new String(buffer, 0, read));
                                    }
                                    read = input.read(buffer);
                                }
                                var27_43 = null;
                                if (!trace || traceBuf.length() == 0) break block70;
                            }
                            catch (Throwable var26_53) {
                                var27_44 = null;
                                if (trace && traceBuf.length() != 0) {
                                    RemoteClient.logger.trace((Object)("Output (" + traceBuf.length() + " bytes) from: " + url.toString()));
                                    RemoteClient.logger.trace((Object)traceBuf.toString());
                                }
                                try {
                                    try {
                                        input.close();
                                        var29_47 = null;
                                        if (responseCommit == false) throw var26_53;
                                        if (out == null) throw var26_53;
                                    }
                                    catch (Throwable var28_51) {
                                        var29_48 = null;
                                        if (responseCommit == false) throw var28_51;
                                        if (out == null) throw var28_51;
                                        out.close();
                                        throw var28_51;
                                    }
                                    out.close();
                                    throw var26_53;
                                }
                                catch (IOException e) {
                                    if (RemoteClient.logger.isWarnEnabled() == false) throw var26_53;
                                    RemoteClient.logger.warn((Object)"Exception during close() of HTTP API connection", (Throwable)e);
                                }
                                throw var26_53;
                            }
                            RemoteClient.logger.trace((Object)("Output (" + traceBuf.length() + " bytes) from: " + url.toString()));
                            RemoteClient.logger.trace((Object)traceBuf.toString());
                        }
                        ** try [egrp 3[TRYBLOCK] [4 : 1837->1876)] { 
lbl-1000:
                        // 1 sources

                        try {}
                        catch (Throwable var28_49) {
                            var29_46 = null;
                            if (responseCommit == false) throw var28_49;
                            if (out == null) throw var28_49;
                            out.close();
                            throw var28_49;
                        }
                        input.close();
                        var29_45 = null;
                        if (!responseCommit || out == null) break block72;
                        out.close();
                        break block72;
lbl210:
                        // 1 sources

                        catch (IOException e) {
                            if (!RemoteClient.logger.isWarnEnabled()) break block72;
                            RemoteClient.logger.warn((Object)"Exception during close() of HTTP API connection", (Throwable)e);
                        }
                    }
                    if (res != null && responseCode != 200 && !responseCommit && responseCode != 401) {
                        res.sendError(responseCode, method.getStatusText());
                    }
                    var23_40 = encoding;
                    var31_54 = null;
                    if (method == null) break block73;
                }
                catch (ConnectTimeoutException timeErr) {
                    status.setCode(499);
                    status.setException(timeErr);
                    status.setMessage(timeErr.getMessage());
                    if (res == null) throw timeErr;
                    res.setStatus(500, timeErr.getMessage());
                    throw timeErr;
                }
                catch (SocketTimeoutException socketErr) {
                    status.setCode(499);
                    status.setException(socketErr);
                    status.setMessage(socketErr.getMessage());
                    if (res == null) throw socketErr;
                    res.setStatus(500, socketErr.getMessage());
                    throw socketErr;
                }
                catch (UnknownHostException hostErr) {
                    status.setCode(498);
                    status.setException(hostErr);
                    status.setMessage(hostErr.getMessage());
                    if (res == null) throw hostErr;
                    res.setStatus(500, hostErr.getMessage());
                    throw hostErr;
                }
                catch (ConnectException connErr) {
                    status.setCode(498);
                    status.setException(connErr);
                    status.setMessage(connErr.getMessage());
                    if (res == null) throw connErr;
                    res.setStatus(500, connErr.getMessage());
                    throw connErr;
                }
                catch (IOException ioErr) {
                    status.setCode(500);
                    status.setException(ioErr);
                    status.setMessage(ioErr.getMessage());
                    if (res == null) throw ioErr;
                    res.setStatus(500, ioErr.getMessage());
                    throw ioErr;
                }
                method.releaseConnection();
            }
            this.requestContentType = "application/octet-stream";
            this.requestMethod = HttpMethod.GET;
            return var23_40;
        }
        catch (Throwable var30_56) {
            var31_55 = null;
            if (method != null) {
                method.releaseConnection();
            }
            this.requestContentType = "application/octet-stream";
            this.requestMethod = HttpMethod.GET;
            throw var30_56;
        }
    }

    private void setupHttpProxyHost(URL url, HttpClient httpClient) {
        ProxyHost proxyHost = this.createProxyHost(url, "http.proxyHost", "http.proxyPort", 80);
        if (proxyHost != null) {
            httpClient.getHostConfiguration().setProxyHost(proxyHost);
        }
    }

    private void setupHttpsProxyHost(URL url, HttpClient httpClient) {
        ProxyHost proxyHost = this.createProxyHost(url, "https.proxyHost", "https.proxyPort", 443);
        if (proxyHost != null) {
            httpClient.getHostConfiguration().setProxyHost(proxyHost);
        }
    }

    private ProxyHost createProxyHost(URL url, String hostProperty, String portProperty, int defaultPort) {
        String proxyHost = System.getProperty(hostProperty);
        ProxyHost proxy = null;
        if (proxyHost != null && proxyHost.length() != 0 && this.requiresProxy(url.getHost())) {
            String strProxyPort = System.getProperty(portProperty);
            proxy = strProxyPort == null || strProxyPort.length() == 0 ? new ProxyHost(proxyHost, defaultPort) : new ProxyHost(proxyHost, Integer.parseInt(strProxyPort));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ProxyHost: " + proxy.toString()));
            }
        }
        return proxy;
    }

    private boolean requiresProxy(String targetHost) {
        boolean requiresProxy = true;
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!targetHost.matches(pattern = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"))) continue;
                requiresProxy = false;
                break;
            }
        }
        return requiresProxy;
    }

    static {
        DefaultHttpParams.setHttpParamsFactory((HttpParamsFactory)new NonBlockingHttpParamsFactory());
        logger = LogFactory.getLog(RemoteClient.class);
        XML_ENCODING = Pattern.compile("<\\?xml.*.encoding=\"([^\"]*)\"");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod;

        static {
            $SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod = new int[HttpMethod.values().length];
            try {
                1.$SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod[HttpMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod[HttpMethod.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod[HttpMethod.POST.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod[HttpMethod.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$springframework$extensions$webscripts$connector$HttpMethod[HttpMethod.HEAD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class NonBlockingHttpParams
    extends HttpClientParams {
        private HashMap<String, Object> parameters = new HashMap(8);
        private ReadWriteLock paramLock = new ReentrantReadWriteLock();

        public NonBlockingHttpParams() {
        }

        public NonBlockingHttpParams(HttpParams defaults) {
            super(defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getParameter(String name) {
            HttpParams defaults;
            Object param = null;
            this.paramLock.readLock().lock();
            try {
                param = this.parameters.get(name);
            }
            finally {
                this.paramLock.readLock().unlock();
            }
            if (param == null && (defaults = this.getDefaults()) != null) {
                param = defaults.getParameter(name);
            }
            return param;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setParameter(String name, Object value) {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.put(name, value);
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isParameterSetLocally(String name) {
            this.paramLock.readLock().lock();
            try {
                boolean bl = this.parameters.get(name) != null;
                return bl;
            }
            finally {
                this.paramLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            this.paramLock.writeLock().lock();
            try {
                this.parameters.clear();
            }
            finally {
                this.paramLock.writeLock().unlock();
            }
        }

        public Object clone() throws CloneNotSupportedException {
            NonBlockingHttpParams clone = (NonBlockingHttpParams)((Object)super.clone());
            clone.parameters = (HashMap)this.parameters.clone();
            clone.setDefaults(this.getDefaults());
            return clone;
        }
    }

    public static class NonBlockingHttpParamsFactory
    extends DefaultHttpParamsFactory {
        private volatile HttpParams httpParams;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpParams getDefaultParams() {
            if (this.httpParams == null) {
                NonBlockingHttpParamsFactory nonBlockingHttpParamsFactory = this;
                synchronized (nonBlockingHttpParamsFactory) {
                    if (this.httpParams == null) {
                        this.httpParams = this.createParams();
                    }
                }
            }
            return this.httpParams;
        }

        protected HttpParams createParams() {
            NonBlockingHttpParams params = new NonBlockingHttpParams(null);
            params.setParameter("http.useragent", "Jakarta Commons-HttpClient/3.1");
            params.setVersion(HttpVersion.HTTP_1_1);
            params.setConnectionManagerClass(SimpleHttpConnectionManager.class);
            params.setCookiePolicy("default");
            params.setHttpElementCharset("US-ASCII");
            params.setContentCharset("ISO-8859-1");
            params.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
            ArrayList<String> datePatterns = new ArrayList<String>();
            datePatterns.addAll(Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z"));
            params.setParameter("http.dateparser.patterns", datePatterns);
            String agent = null;
            try {
                agent = System.getProperty("httpclient.useragent");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (agent != null) {
                params.setParameter("http.useragent", agent);
            }
            String preemptiveDefault = null;
            try {
                preemptiveDefault = System.getProperty("httpclient.authentication.preemptive");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (preemptiveDefault != null) {
                if ((preemptiveDefault = preemptiveDefault.trim().toLowerCase()).equals("true")) {
                    params.setParameter("http.authentication.preemptive", Boolean.TRUE);
                } else if (preemptiveDefault.equals("false")) {
                    params.setParameter("http.authentication.preemptive", Boolean.FALSE);
                }
            }
            String defaultCookiePolicy = null;
            try {
                defaultCookiePolicy = System.getProperty("apache.commons.httpclient.cookiespec");
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (defaultCookiePolicy != null) {
                if ("COMPATIBILITY".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("compatibility");
                } else if ("NETSCAPE_DRAFT".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("netscape");
                } else if ("RFC2109".equalsIgnoreCase(defaultCookiePolicy)) {
                    params.setCookiePolicy("rfc2109");
                }
            }
            return params;
        }
    }
}

