/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.InputStreamContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormData
implements Serializable {
    private static final long serialVersionUID = 1832644544828452385L;
    private static Log logger = LogFactory.getLog(FormData.class);
    private HttpServletRequest req;
    private String encoding = null;
    private ServletFileUpload upload;
    private FormField[] fields = null;
    private Map<String, String[]> parameters = null;

    public FormData(HttpServletRequest req) {
        this.req = req;
    }

    public boolean getIsMultiPart() {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)this.req);
    }

    public boolean hasField(String name) {
        for (FormField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public FormField[] getFields() {
        if (this.fields == null) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            this.upload = new ServletFileUpload((FileItemFactory)factory);
            this.encoding = this.req.getCharacterEncoding();
            this.upload.setHeaderEncoding(this.encoding);
            try {
                List fileItems = this.upload.parseRequest(this.req);
                this.fields = new FormField[fileItems.size()];
                for (int i = 0; i < fileItems.size(); ++i) {
                    FormField formField;
                    this.fields[i] = formField = new FormField((FileItem)fileItems.get(i));
                }
            }
            catch (FileUploadException e) {
                this.fields = new FormField[0];
            }
        }
        return this.fields;
    }

    public Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            FormField[] fields = this.getFields();
            this.parameters = new HashMap<String, String[]>(fields.length);
            for (FormField field : fields) {
                String[] vals = this.parameters.get(field.getName());
                if (vals == null) {
                    this.parameters.put(field.getName(), new String[]{field.getValue()});
                    continue;
                }
                String[] valsNew = new String[vals.length + 1];
                System.arraycopy(vals, 0, valsNew, 0, vals.length);
                valsNew[vals.length] = field.getValue();
                this.parameters.put(field.getName(), valsNew);
            }
        }
        return this.parameters;
    }

    public class FormField
    implements Serializable {
        private static final long serialVersionUID = -6061565518843862346L;
        private FileItem file;

        public FormField(FileItem file) {
            this.file = file;
        }

        public String getName() {
            return this.file.getFieldName();
        }

        public boolean getIsFile() {
            return !this.file.isFormField();
        }

        public String getValue() {
            try {
                String value = this.file.isFormField() ? (FormData.this.encoding != null ? this.file.getString(FormData.this.encoding) : this.file.getString()) : this.file.getName();
                return value;
            }
            catch (UnsupportedEncodingException e) {
                throw new WebScriptsPlatformException("Unable to decode form field", e);
            }
        }

        public Content getContent() {
            try {
                return new InputStreamContent(this.file.getInputStream(), this.getMimetype(), null);
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to get content: " + e.getMessage()));
                }
                return null;
            }
        }

        public InputStream getInputStream() {
            try {
                return this.file.getInputStream();
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to get input stream: " + e.getMessage()));
                }
                return null;
            }
        }

        public String getMimetype() {
            return this.file.getContentType();
        }

        public String getFilename() {
            return FilenameUtils.getName((String)this.file.getName());
        }
    }
}

