/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class RepositoryStartupTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;

    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = this.serviceRegistry.getTransactionService();
        AuthenticationUtil.setRunAsUserSystem();
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testRepoReadWrite() throws Exception {
        RepositoryStartupTest.assertFalse((String)"The transaction is read-only - further unit tests are pointless.", (boolean)this.transactionService.isReadOnly());
    }

    public void testBasicWriteOperations() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> addPropertyCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeService nodeService = RepositoryStartupTest.this.serviceRegistry.getNodeService();
                NodeRef rootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                nodeService.setProperty(rootNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"SanityCheck"));
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(addPropertyCallback, false, true);
    }
}

