/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.alfresco.cmis.CMISFilterNotValidException;

public class PropertyFilter {
    public static final String MATCH_ALL_FILTER = "*";
    public static final String PROPERTY_NAME_TOKENS_DELIMITER = ",";
    private static final Pattern PROPERTY_FILTER_REGEX = Pattern.compile("^([^\\s,\"'\\\\\\.\\(\\)]+)(,[^\\s,\"'\\\\\\.\\(\\)]+)*$");
    private Set<String> properties;

    public PropertyFilter(String filter) throws CMISFilterNotValidException {
        if (filter != null) {
            if (!PROPERTY_FILTER_REGEX.matcher(filter).matches()) {
                throw new CMISFilterNotValidException("Property filter \"" + filter + "\" is invalid");
            }
            if (!filter.equals(MATCH_ALL_FILTER)) {
                String[] tokens = filter.split(PROPERTY_NAME_TOKENS_DELIMITER);
                this.properties = new HashSet<String>(tokens.length * 2);
                for (String token : tokens) {
                    this.properties.add(token);
                }
            }
        }
    }

    public boolean allow(String property) {
        return this.properties == null || this.properties.contains(property);
    }
}

