/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.search;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.alfresco.cmis.CMISCardinalityEnum;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISDictionaryModel;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISQueryException;
import org.alfresco.cmis.CMISQueryOptions;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.cmis.CMISResultSetColumn;
import org.alfresco.cmis.CMISResultSetMetaData;
import org.alfresco.cmis.CMISResultSetRow;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.cmis.mapping.BaseCMISTest;
import org.alfresco.cmis.mapping.BaseTypeIdProperty;
import org.alfresco.cmis.mapping.CheckinCommentProperty;
import org.alfresco.cmis.mapping.ContentStreamIdProperty;
import org.alfresco.cmis.mapping.ContentStreamLengthProperty;
import org.alfresco.cmis.mapping.ContentStreamMimetypeProperty;
import org.alfresco.cmis.mapping.DirectProperty;
import org.alfresco.cmis.mapping.FixedValueProperty;
import org.alfresco.cmis.mapping.IsImmutableProperty;
import org.alfresco.cmis.mapping.IsLatestMajorVersionProperty;
import org.alfresco.cmis.mapping.IsLatestVersionProperty;
import org.alfresco.cmis.mapping.IsMajorVersionProperty;
import org.alfresco.cmis.mapping.IsVersionSeriesCheckedOutProperty;
import org.alfresco.cmis.mapping.ObjectIdProperty;
import org.alfresco.cmis.mapping.ObjectTypeIdProperty;
import org.alfresco.cmis.mapping.ParentProperty;
import org.alfresco.cmis.mapping.PathProperty;
import org.alfresco.cmis.mapping.VersionLabelProperty;
import org.alfresco.cmis.mapping.VersionSeriesCheckedOutByProperty;
import org.alfresco.cmis.mapping.VersionSeriesCheckedOutIdProperty;
import org.alfresco.cmis.mapping.VersionSeriesIdProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.parsers.CMISLexer;
import org.alfresco.repo.search.impl.parsers.CMISParser;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTest
extends BaseCMISTest {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/cmis-query-test";
    QName extendedContent = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"extendedContent");
    QName singleTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleTextBoth");
    QName singleTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleTextUntokenised");
    QName singleTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleTextTokenised");
    QName multipleTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleTextBoth");
    QName multipleTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleTextUntokenised");
    QName multipleTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleTextTokenised");
    QName singleMLTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleMLTextBoth");
    QName singleMLTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleMLTextUntokenised");
    QName singleMLTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleMLTextTokenised");
    QName multipleMLTextBoth = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleMLTextBoth");
    QName multipleMLTextUntokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleMLTextUntokenised");
    QName multipleMLTextTokenised = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleMLTextTokenised");
    QName singleFloat = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleFloat");
    QName multipleFloat = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleFloat");
    QName singleDouble = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleDouble");
    QName multipleDouble = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleDouble");
    QName singleInteger = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleInteger");
    QName multipleInteger = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleInteger");
    QName singleLong = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleLong");
    QName multipleLong = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleLong");
    QName singleBoolean = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleBoolean");
    QName multipleBoolean = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleBoolean");
    QName singleDate = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleDate");
    QName multipleDate = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleDate");
    QName singleDatetime = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"singleDatetime");
    QName multipleDatetime = QName.createQName((String)"http://www.alfresco.org/test/cmis-query-test", (String)"multipleDatetime");
    private int file_count = 0;
    private int folder_count = 0;
    private NodeRef f0;
    private NodeRef f1;
    private NodeRef f2;
    private NodeRef f3;
    private NodeRef f4;
    private NodeRef f5;
    private NodeRef f6;
    private NodeRef f7;
    private NodeRef f8;
    private NodeRef f9;
    private NodeRef c0;
    private NodeRef c1;
    private NodeRef c2;
    private NodeRef c3;
    private NodeRef c4;
    private NodeRef c5;
    private NodeRef c6;
    private NodeRef c7;
    private NodeRef c8;
    private NodeRef c9;
    private Date date1;
    private Date date2;
    private Date date0;
    private long contentLength0;
    private String contentUrl0;
    private static String[] orderable = new String[]{"zero loons", "one banana", "two apples", "three fruit", "four lemurs", "five rats", "six badgers", "seven cards", "eight cabbages", "nine zebras", "ten lemons"};
    private static String[] mlOrderable_en = new String[]{"AAAA BBBB", "EEEE FFFF", "II", "KK", "MM", "OO", "QQ", "SS", "UU", "AA", "CC"};
    private static String[] mlOrderable_fr = new String[]{"CCCC DDDD", "GGGG HHHH", "JJ", "LL", "NN", "PP", "RR", "TT", "VV", "BB", "DD"};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.f0 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 0", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f0, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 0"));
        ++this.folder_count;
        this.permissionService.setPermission(this.f0, "cmis", "Read", true);
        this.f1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 1", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f1, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 1"));
        ++this.folder_count;
        this.f2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 2", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f2, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 2"));
        ++this.folder_count;
        this.f3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 3", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f3, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 3"));
        ++this.folder_count;
        this.f4 = this.nodeService.createNode(this.f0, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 4", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f4, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 4"));
        ++this.folder_count;
        this.f5 = this.nodeService.createNode(this.f0, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 5", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f5, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 5"));
        ++this.folder_count;
        this.f6 = this.nodeService.createNode(this.f5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 6", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f6, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 6"));
        ++this.folder_count;
        this.f7 = this.nodeService.createNode(this.f6, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 7", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f7, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 7"));
        ++this.folder_count;
        this.f8 = this.nodeService.createNode(this.f7, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 8", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f8, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 8"));
        ++this.folder_count;
        this.f9 = this.nodeService.createNode(this.f8, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Folder 9", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.f9, ContentModel.PROP_NAME, (Serializable)((Object)"Folder 9'"));
        ++this.folder_count;
        HashMap<QName, Object> properties0 = new HashMap<QName, Object>();
        MLText desc0 = new MLText();
        desc0.addValue(Locale.ENGLISH, "Alfresco tutorial");
        desc0.addValue(Locale.US, "Alfresco tutorial");
        properties0.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties0.put(ContentModel.PROP_DESCRIPTION, desc0);
        properties0.put(ContentModel.PROP_TITLE, desc0);
        properties0.put(ContentModel.PROP_NAME, "Alfresco Tutorial");
        properties0.put(ContentModel.PROP_CREATED, new Date());
        this.c0 = this.nodeService.createNode(this.f0, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Alfresco Tutorial", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties0).getChildRef();
        ContentWriter writer0 = this.contentService.getWriter(this.c0, ContentModel.PROP_CONTENT, true);
        writer0.setEncoding("UTF-8");
        writer0.putContent("The quick brown fox jumped over the lazy dog and ate the Alfresco Tutorial, in pdf format, along with the following stop words;  a an and are as at be but by for if in into is it no not of on or such that the their then there these they this to was will with:  and random charcters \u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff");
        this.contentLength0 = writer0.getSize();
        this.contentUrl0 = ((ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(this.c0, ContentModel.PROP_CONTENT))).getContentUrl();
        this.nodeService.addAspect(this.c0, ContentModel.ASPECT_TITLED, null);
        this.nodeService.addAspect(this.c0, ContentModel.ASPECT_OWNABLE, null);
        this.nodeService.setProperty(this.c0, ContentModel.PROP_OWNER, (Serializable)((Object)"andy"));
        ++this.file_count;
        HashMap<QName, Object> properties1 = new HashMap<QName, Object>();
        MLText desc1 = new MLText();
        desc1.addValue(Locale.ENGLISH, "One");
        desc1.addValue(Locale.US, "One");
        properties1.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties1.put(ContentModel.PROP_DESCRIPTION, desc1);
        properties1.put(ContentModel.PROP_TITLE, desc1);
        properties1.put(ContentModel.PROP_NAME, "AA%");
        properties1.put(ContentModel.PROP_CREATED, new Date());
        this.c1 = this.nodeService.createNode(this.f1, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"One", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties1).getChildRef();
        ContentWriter writer1 = this.contentService.getWriter(this.c1, ContentModel.PROP_CONTENT, true);
        writer1.setEncoding("UTF-8");
        writer1.putContent("One Zebra Apple");
        this.nodeService.addAspect(this.c1, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties2 = new HashMap<QName, Object>();
        MLText desc2 = new MLText();
        desc2.addValue(Locale.ENGLISH, "Two");
        desc2.addValue(Locale.US, "Two");
        properties2.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties2.put(ContentModel.PROP_DESCRIPTION, desc2);
        properties2.put(ContentModel.PROP_TITLE, desc2);
        properties2.put(ContentModel.PROP_NAME, "BB_");
        properties2.put(ContentModel.PROP_CREATED, new Date());
        this.c2 = this.nodeService.createNode(this.f2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Two", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties2).getChildRef();
        ContentWriter writer2 = this.contentService.getWriter(this.c2, ContentModel.PROP_CONTENT, true);
        writer2.setEncoding("UTF-8");
        writer2.putContent("Two Zebra Banana");
        this.nodeService.addAspect(this.c2, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties3 = new HashMap<QName, Object>();
        MLText desc3 = new MLText();
        desc3.addValue(Locale.ENGLISH, "Three");
        desc3.addValue(Locale.US, "Three");
        properties3.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties3.put(ContentModel.PROP_DESCRIPTION, desc3);
        properties3.put(ContentModel.PROP_TITLE, desc3);
        properties3.put(ContentModel.PROP_NAME, "CC\\");
        properties3.put(ContentModel.PROP_CREATED, new Date());
        this.c3 = this.nodeService.createNode(this.f3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Three", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties3).getChildRef();
        ContentWriter writer3 = this.contentService.getWriter(this.c3, ContentModel.PROP_CONTENT, true);
        writer3.setEncoding("UTF-8");
        writer3.putContent("Three Zebra Clementine");
        this.nodeService.addAspect(this.c3, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties4 = new HashMap<QName, Object>();
        MLText desc4 = new MLText();
        desc4.addValue(Locale.ENGLISH, "Four");
        desc4.addValue(Locale.US, "Four");
        properties4.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties4.put(ContentModel.PROP_DESCRIPTION, desc4);
        properties4.put(ContentModel.PROP_TITLE, desc4);
        properties4.put(ContentModel.PROP_NAME, "DD'");
        properties4.put(ContentModel.PROP_CREATED, new Date());
        this.c4 = this.nodeService.createNode(this.f4, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Four", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties4).getChildRef();
        ContentWriter writer4 = this.contentService.getWriter(this.c4, ContentModel.PROP_CONTENT, true);
        writer4.setEncoding("UTF-8");
        writer4.putContent("Four zebra durian");
        this.nodeService.addAspect(this.c4, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties5 = new HashMap<QName, Object>();
        MLText desc5 = new MLText();
        desc5.addValue(Locale.ENGLISH, "Five");
        desc5.addValue(Locale.US, "Five");
        properties5.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties5.put(ContentModel.PROP_DESCRIPTION, desc5);
        properties5.put(ContentModel.PROP_TITLE, desc5);
        properties5.put(ContentModel.PROP_NAME, "EE.aa");
        properties5.put(ContentModel.PROP_CREATED, new Date());
        this.c5 = this.nodeService.createNode(this.f5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Five", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties5).getChildRef();
        ContentWriter writer5 = this.contentService.getWriter(this.c5, ContentModel.PROP_CONTENT, true);
        writer5.setEncoding("UTF-8");
        writer5.putContent("Five zebra Ebury");
        this.nodeService.addAspect(this.c5, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> lockProperties = new HashMap<QName, Object>();
        lockProperties.put(ContentModel.PROP_EXPIRY_DATE, DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)"2012-12-12T12:12:12.012Z"));
        lockProperties.put(ContentModel.PROP_LOCK_OWNER, "andy");
        lockProperties.put(ContentModel.PROP_LOCK_TYPE, "WRITE_LOCK");
        this.nodeService.addAspect(this.c5, ContentModel.ASPECT_LOCKABLE, lockProperties);
        HashMap<QName, Object> properties6 = new HashMap<QName, Object>();
        MLText desc6 = new MLText();
        desc6.addValue(Locale.ENGLISH, "Six");
        desc6.addValue(Locale.US, "Six");
        properties6.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties6.put(ContentModel.PROP_DESCRIPTION, desc6);
        properties6.put(ContentModel.PROP_TITLE, desc6);
        properties6.put(ContentModel.PROP_NAME, "FF.EE");
        properties6.put(ContentModel.PROP_CREATED, new Date());
        this.c6 = this.nodeService.createNode(this.f6, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Six", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties6).getChildRef();
        ContentWriter writer6 = this.contentService.getWriter(this.c6, ContentModel.PROP_CONTENT, true);
        writer6.setEncoding("UTF-8");
        writer6.putContent("Six zebra fig");
        this.nodeService.addAspect(this.c6, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties7 = new HashMap<QName, Object>();
        MLText desc7 = new MLText();
        desc7.addValue(Locale.ENGLISH, "Seven");
        desc7.addValue(Locale.US, "Seven");
        properties7.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties7.put(ContentModel.PROP_DESCRIPTION, desc7);
        properties7.put(ContentModel.PROP_TITLE, desc7);
        properties7.put(ContentModel.PROP_NAME, "GG*GG");
        properties7.put(ContentModel.PROP_CREATED, new Date());
        this.c7 = this.nodeService.createNode(this.f7, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Seven", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties7).getChildRef();
        ContentWriter writer7 = this.contentService.getWriter(this.c7, ContentModel.PROP_CONTENT, true);
        writer7.setEncoding("UTF-8");
        writer7.putContent("Seven zebra grapefruit");
        this.nodeService.addAspect(this.c7, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties8 = new HashMap<QName, Object>();
        MLText desc8 = new MLText();
        desc8.addValue(Locale.ENGLISH, "Eight");
        desc8.addValue(Locale.US, "Eight");
        properties8.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties8.put(ContentModel.PROP_DESCRIPTION, desc8);
        properties8.put(ContentModel.PROP_TITLE, desc8);
        properties8.put(ContentModel.PROP_NAME, "HH?HH");
        properties8.put(ContentModel.PROP_CREATED, new Date());
        this.c8 = this.nodeService.createNode(this.f8, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Eight", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties8).getChildRef();
        ContentWriter writer8 = this.contentService.getWriter(this.c8, ContentModel.PROP_CONTENT, true);
        writer8.setEncoding("UTF-8");
        writer8.putContent("Eight zebra jackfruit");
        this.nodeService.addAspect(this.c8, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        HashMap<QName, Object> properties9 = new HashMap<QName, Object>();
        MLText desc9 = new MLText();
        desc9.addValue(Locale.ENGLISH, "Nine");
        desc9.addValue(Locale.US, "Nine");
        properties9.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties9.put(ContentModel.PROP_DESCRIPTION, desc9);
        properties9.put(ContentModel.PROP_TITLE, desc9);
        properties9.put(ContentModel.PROP_NAME, "aa");
        properties9.put(ContentModel.PROP_CREATED, new Date());
        this.c9 = this.nodeService.createNode(this.f9, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Nine", (NamespacePrefixResolver)this.namespaceService), ContentModel.TYPE_CONTENT, properties9).getChildRef();
        ContentWriter writer9 = this.contentService.getWriter(this.c9, ContentModel.PROP_CONTENT, true);
        writer9.setEncoding("UTF-8");
        writer9.putContent("Nine zebra kiwi");
        this.nodeService.addAspect(this.c9, ContentModel.ASPECT_TITLED, null);
        ++this.file_count;
        this.nodeService.setProperty(this.c9, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)"label"));
    }

    private <T> T testQuery(String query, int size, boolean dump, String returnPropertyName, T returnType, boolean shouldThrow) throws Exception {
        return this.testQuery(query, size, dump, returnPropertyName, returnType, shouldThrow, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
    }

    private <T> T testExtendedQuery(String query, int size, boolean dump, String returnPropertyName, T returnType, boolean shouldThrow) throws Exception {
        return this.testQuery(query, size, dump, returnPropertyName, returnType, shouldThrow, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T testQuery(String query, int size, boolean dump, String returnPropertyName, T returnType, boolean shouldThrow, CMISQueryOptions.CMISQueryMode mode) throws Exception {
        CMISResultSet rs = null;
        try {
            Object returnValue = null;
            CMISQueryOptions options = new CMISQueryOptions(query, this.rootNodeRef.getStoreRef());
            options.setQueryMode(mode);
            rs = this.cmisQueryService.query(options);
            Iterator i$ = rs.iterator();
            while (i$.hasNext()) {
                CMISResultSetRow row = (CMISResultSetRow)i$.next();
                if (row.getIndex() == 0) {
                    Serializable sValue = row.getValue(returnPropertyName);
                    returnValue = DefaultTypeConverter.INSTANCE.convert(returnType.getClass(), (Object)sValue);
                    if (dump) {
                        System.out.println(this.cmisService.getProperties(row.getNodeRef(rs.getMetaData().getSelectorNames()[0])));
                    }
                }
                if (!dump) continue;
                System.out.println("ID =" + row.getValue("cmis:objectId") + " " + (returnPropertyName != null ? returnPropertyName + "=" + row.getValue(returnPropertyName) : "") + " Score=" + row.getScore() + " " + row.getScores());
            }
            if (size >= 0) {
                QueryTest.assertEquals((int)size, (int)rs.getLength());
            }
            if (shouldThrow) {
                QueryTest.fail();
            }
            Object object = returnValue;
            return (T)object;
        }
        catch (CMISQueryException e) {
            if (shouldThrow) {
                T t = null;
                return t;
            }
            throw e;
        }
        catch (QueryModelException e) {
            if (shouldThrow) {
                T t = null;
                return t;
            }
            throw e;
        }
        catch (FTSQueryException e) {
            if (shouldThrow) {
                T t = null;
                return t;
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            if (shouldThrow) {
                T t = null;
                return t;
            }
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                finally {
                    rs = null;
                }
            }
        }
    }

    public void test_ALLOWED_CHILD_OBJECT_TYPES() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:allowedChildObjectTypeIds");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:allowedChildObjectTypeIds");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds =  'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds <> 'test'", 10, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds <  'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds <= 'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds >  'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds >= 'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds IN     ('test')", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds NOT IN ('test')", 10, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds     LIKE 'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds NOT LIKE 'test'", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds IS NOT NULL", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE cmis:allowedChildObjectTypeIds IS     NULL", 10, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE 'test' =  ANY cmis:allowedChildObjectTypeIds", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE 'test' <> ANY cmis:allowedChildObjectTypeIds", 10, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE 'test' <  ANY cmis:allowedChildObjectTypeIds", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE 'test' <= ANY cmis:allowedChildObjectTypeIds", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE 'test' >  ANY cmis:allowedChildObjectTypeIds", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE 'test' >= ANY cmis:allowedChildObjectTypeIds", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE ANY cmis:allowedChildObjectTypeIds IN     ('test')", 0, false, "cmis:allowedChildObjectTypeIds", new String(), true);
        this.testQuery("SELECT cmis:allowedChildObjectTypeIds FROM cmis:Folder WHERE ANY cmis:allowedChildObjectTypeIds NOT IN ('test')", 10, false, "cmis:allowedChildObjectTypeIds", new String(), true);
    }

    public void test_PARENT() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:parentId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:parentId");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ParentProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:folder where cmis:parentId = '" + this.f8.toString() + "'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:parentId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)this.f8.toString(), (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:parentId");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ParentProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId =  '" + this.rootNodeRef.toString() + "'", 4, false, "cmis:parentId", new String(), false);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId <> '" + this.rootNodeRef.toString() + "'", 6, false, "cmis:parentId", new String(), false);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId <  '" + this.rootNodeRef.toString() + "'", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId <= '" + this.rootNodeRef.toString() + "'", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId >  '" + this.rootNodeRef.toString() + "'", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId >= '" + this.rootNodeRef.toString() + "'", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IN     ('" + this.rootNodeRef.toString() + "')", 4, false, "cmis:parentId", new String(), false);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId NOT IN ('" + this.rootNodeRef.toString() + "')", 6, false, "cmis:parentId", new String(), false);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId     LIKE '" + this.rootNodeRef.toString() + "'", 4, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId NOT LIKE '" + this.rootNodeRef.toString() + "'", 6, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IS NOT NULL", 10, false, "cmis:parentId", new String(), false);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE cmis:parentId IS     NULL", 0, false, "cmis:parentId", new String(), false);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE '" + this.rootNodeRef.toString() + "' =  ANY cmis:parentId", 4, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE '" + this.rootNodeRef.toString() + "' <> ANY cmis:parentId", 6, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE '" + this.rootNodeRef.toString() + "' <  ANY cmis:parentId", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE '" + this.rootNodeRef.toString() + "' <= ANY cmis:parentId", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE '" + this.rootNodeRef.toString() + "' >  ANY cmis:parentId", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE '" + this.rootNodeRef.toString() + "' >= ANY cmis:parentId", 0, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE ANY cmis:parentId IN     ('" + this.rootNodeRef.toString() + "')", 4, false, "cmis:parentId", new String(), true);
        this.testQuery("SELECT cmis:parentId FROM cmis:folder WHERE ANY cmis:parentId NOT IN ('" + this.rootNodeRef.toString() + "')", 6, false, "cmis:parentId", new String(), true);
    }

    public void test_PATH() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:path");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:path");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof PathProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:path FROM cmis:folder", this.folder_count, false, "cmis:path", new String(), false);
        this.testQuery("SELECT cmis:path FROM cmis:folder WHERE cmis:path =  'anything'", this.folder_count, false, "cmis:path", new String(), true);
    }

    public void test_CONTENT_STREAM_ID() throws Exception {
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            ContentData cd = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_CONTENT));
            QueryTest.assertEquals((String)cd.getContentUrl(), (String)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ContentStreamIdProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)this.contentUrl0, (String)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ContentStreamIdProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:contentStreamId FROM cmis:document", this.file_count, false, "cmis:contentStreamId", new String(), false);
        this.testQuery("SELECT cmis:contentStreamId FROM cmis:document WHERE cmis:contentStreamId =  '" + this.contentUrl0 + "'", 1, false, "cmis:contentStreamId", new String(), true);
    }

    public void test_CONTENT_STREAM_FILENAME() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamFileName");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamFileName");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamFileName");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"Alfresco Tutorial", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamFileName");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'AA%'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'BB_'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'CC\\\\'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'DD\\''", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'EE.aa'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'FF.EE'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'GG*GG'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'HH?HH'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'aa'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName =  'Alfresco Tutorial'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <> 'Alfresco Tutorial'", 9, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <  'Alfresco Tutorial'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName <= 'Alfresco Tutorial'", 2, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName >  'Alfresco Tutorial'", 8, true, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName >= 'Alfresco Tutorial'", 9, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IN     ('Alfresco Tutorial')", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName NOT IN ('Alfresco Tutorial')", 9, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName     LIKE 'Alfresco Tutorial'", 1, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName NOT LIKE 'Alfresco Tutorial'", 9, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IS NOT NULL", 10, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE cmis:contentStreamFileName IS     NULL", 0, false, "cmis:contentStreamFileName", new String(), false);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE 'Alfresco Tutorial' =  ANY cmis:contentStreamFileName", 1, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE 'Alfresco Tutorial' <> ANY cmis:contentStreamFileName", 9, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE 'Alfresco Tutorial' <  ANY cmis:contentStreamFileName", 1, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE 'Alfresco Tutorial' <= ANY cmis:contentStreamFileName", 2, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE 'Alfresco Tutorial' >  ANY cmis:contentStreamFileName", 8, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE 'Alfresco Tutorial' >= ANY cmis:contentStreamFileName", 9, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE ANY cmis:contentStreamFileName IN     ('Alfresco Tutorial')", 1, false, "cmis:contentStreamFileName", new String(), true);
        this.testQuery("SELECT cmis:contentStreamFileName FROM cmis:document WHERE ANY cmis:contentStreamFileName NOT IN ('Alfresco Tutorial')", 9, false, "cmis:contentStreamFileName", new String(), true);
    }

    public void test_CONTENT_STREAM_MIME_TYPE() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamMimeType");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamMimeType");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ContentStreamMimetypeProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:contentStreamMimeType =  'text/plain'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertTrue((rs.length() > 0 ? 1 : 0) != 0);
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamMimeType");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"text/plain", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamMimeType");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ContentStreamMimetypeProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType =  'text/plain'", 10, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <> 'text/plain'", 0, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <  'text/plain'", 0, true, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType <= 'text/plain'", 10, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType >  'text/plain'", 0, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType >= 'text/plain'", 10, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IN     ('text/plain')", 10, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType NOT IN ('text/plain')", 0, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType     LIKE 'text/plain'", 10, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType NOT LIKE 'text/plain'", 0, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IS NOT NULL", 10, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE cmis:contentStreamMimeType IS     NULL", 0, false, "cmis:contentStreamMimeType", new String(), false);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE 'text/plain' =  ANY cmis:contentStreamMimeType", 10, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE 'text/plain' <> ANY cmis:contentStreamMimeType", 0, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE 'text/plain' <  ANY cmis:contentStreamMimeType", 0, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE 'text/plain' <= ANY cmis:contentStreamMimeType", 10, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE 'text/plain' >  ANY cmis:contentStreamMimeType", 0, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE 'text/plain' >= ANY cmis:contentStreamMimeType", 10, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE ANY cmis:contentStreamMimeType IN     ('text/plain')", 10, false, "cmis:contentStreamMimeType", new String(), true);
        this.testQuery("SELECT cmis:contentStreamMimeType FROM cmis:document WHERE ANY cmis:contentStreamMimeType NOT IN ('text/plain')", 0, false, "cmis:contentStreamMimeType", new String(), true);
    }

    public void test_CONTENT_STREAM_LENGTH() throws Exception {
        CMISResultSetColumn column;
        Long value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamLength");
            value = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamLength");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.INTEGER, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ContentStreamLengthProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:contentStreamLength = " + this.contentLength0, this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:contentStreamLength");
            value = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)this.contentLength0, (Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:contentStreamLength");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.INTEGER, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ContentStreamLengthProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength =  750", 0, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <> 750", 10, true, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <  750", 10, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength <= 750", 10, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength >  750", 0, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength >= 750", 0, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IN     (750)", 0, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength NOT IN (750)", 10, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength     LIKE '750'", 0, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength NOT LIKE '750'", 10, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IS NOT NULL", 10, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE cmis:contentStreamLength IS     NULL", 0, false, "cmis:contentStreamLength", new String(), false);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE 750 =  ANY cmis:contentStreamLength", 0, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE 750 <> ANY cmis:contentStreamLength", 10, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE 750 <  ANY cmis:contentStreamLength", 10, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE 750 <= ANY cmis:contentStreamLength", 10, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE 750 >  ANY cmis:contentStreamLength", 0, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE 750 >= ANY cmis:contentStreamLength", 0, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE ANY cmis:contentStreamLength IN     (750)", 0, false, "cmis:contentStreamLength", new String(), true);
        this.testQuery("SELECT cmis:contentStreamLength FROM cmis:document WHERE ANY cmis:contentStreamLength NOT IN (750)", 10, false, "cmis:contentStreamLength", new String(), true);
    }

    public void test_CHECKIN_COMMENT() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:checkinComment");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:checkinComment");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof CheckinCommentProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment =  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment <> 'admin'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment <  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment <= 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment >  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment >= 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment IN     ('admin')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment NOT IN ('admin')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment     LIKE 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment NOT LIKE 'admin'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE cmis:checkinComment IS     NULL", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE 'admin' =  ANY cmis:checkinComment", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE 'admin' <> ANY cmis:checkinComment", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE 'admin' <  ANY cmis:checkinComment", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE 'admin' <= ANY cmis:checkinComment", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE 'admin' >  ANY cmis:checkinComment", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE 'admin' >= ANY cmis:checkinComment", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE ANY cmis:checkinComment IN     ('admin')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:checkinComment FROM cmis:document WHERE ANY cmis:checkinComment NOT IN ('admin')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_VERSION_SERIES_CHECKED_OUT_ID() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:versionSeriesCheckedOutId");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:versionSeriesCheckedOutId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof VersionSeriesCheckedOutIdProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId =  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId <> 'admin'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId <  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId <= 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId >  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId >= 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId IN     ('admin')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId NOT IN ('admin')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId     LIKE 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId NOT LIKE 'admin'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE cmis:versionSeriesCheckedOutId IS     NULL", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE 'admin' =  ANY cmis:versionSeriesCheckedOutId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE 'admin' <> ANY cmis:versionSeriesCheckedOutId", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE 'admin' <  ANY cmis:versionSeriesCheckedOutId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE 'admin' <= ANY cmis:versionSeriesCheckedOutId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE 'admin' >  ANY cmis:versionSeriesCheckedOutId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE 'admin' >= ANY cmis:versionSeriesCheckedOutId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE ANY cmis:versionSeriesCheckedOutId IN     ('admin')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutId FROM cmis:document WHERE ANY cmis:versionSeriesCheckedOutId NOT IN ('admin')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_VERSION_SERIES_CHECKED_OUT_BY() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:versionSeriesCheckedOutBy");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:versionSeriesCheckedOutBy");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof VersionSeriesCheckedOutByProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy =  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy <> 'admin'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy <  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy <= 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy >  'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy >= 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy IN     ('admin')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy NOT IN ('admin')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy     LIKE 'admin'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy NOT LIKE 'admin'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE cmis:versionSeriesCheckedOutBy IS     NULL", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE 'admin' =  ANY cmis:versionSeriesCheckedOutBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE 'admin' <> ANY cmis:versionSeriesCheckedOutBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE 'admin' <  ANY cmis:versionSeriesCheckedOutBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE 'admin' <= ANY cmis:versionSeriesCheckedOutBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE 'admin' >  ANY cmis:versionSeriesCheckedOutBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE 'admin' >= ANY cmis:versionSeriesCheckedOutBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE ANY cmis:versionSeriesCheckedOutBy IN     ('admin')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesCheckedOutBy FROM cmis:document WHERE ANY cmis:versionSeriesCheckedOutBy NOT IN ('admin')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_IS_VERSION_SERIES_CHECKED_OUT() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:isVersionSeriesCheckedOut");
            Boolean value = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)Boolean.FALSE, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:isVersionSeriesCheckedOut");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof IsVersionSeriesCheckedOutProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut =  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut <> 'TRUE'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut <  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut <= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut >  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut >= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut NOT IN ('TRUE')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut     LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut NOT LIKE 'TRUE'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE cmis:isVeriesSeriesCheckedOut IS     NULL", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE 'TRUE' =  ANY cmis:isVeriesSeriesCheckedOut", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE 'TRUE' <> ANY cmis:isVeriesSeriesCheckedOut", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE 'TRUE' <  ANY cmis:isVeriesSeriesCheckedOut", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE 'TRUE' <= ANY cmis:isVeriesSeriesCheckedOut", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE 'TRUE' >  ANY cmis:isVeriesSeriesCheckedOut", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE 'TRUE' >= ANY cmis:isVeriesSeriesCheckedOut", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE ANY cmis:isVeriesSeriesCheckedOut IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isVersionSeriesCheckedOut FROM cmis:document WHERE ANY cmis:isVeriesSeriesCheckedOut NOT IN ('TRUE')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_VERSION_SERIES_ID() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:versionSeriesId");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)row.getNodeRef().toString(), (String)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:versionSeriesId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof VersionSeriesIdProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId =  'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId <> 'company'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId <  'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId <= 'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId >  'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId >= 'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId IN     ('company')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId NOT IN ('company')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId     LIKE 'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId NOT LIKE 'company'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE cmis:versionSeriesId IS     NULL", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE 'company' =  ANY cmis:versionSeriesId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE 'company' <> ANY cmis:versionSeriesId", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE 'company' <  ANY cmis:versionSeriesId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE 'company' <= ANY cmis:versionSeriesId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE 'company' >  ANY cmis:versionSeriesId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE 'company' >= ANY cmis:versionSeriesId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE ANY cmis:versionSeriesId IN     ('company')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionSeriesId FROM cmis:document WHERE ANY cmis:versionSeriesId NOT IN ('company')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_VERSION_LABEL() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:versionLabel");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:versionLabel");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof VersionLabelProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel =  'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel <> 'company'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel <  'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel <= 'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel >  'company'", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel >= 'company'", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel IN     ('company')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel NOT IN ('company')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel     LIKE 'company'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel NOT LIKE 'company'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel IS NOT NULL", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE cmis:versionLabel IS     NULL", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE 'company' =  ANY cmis:versionLabel", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE 'company' <> ANY cmis:versionLabel", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE 'company' <  ANY cmis:versionLabel", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE 'company' <= ANY cmis:versionLabel", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE 'company' >  ANY cmis:versionLabel", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE 'company' >= ANY cmis:versionLabel", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE ANY cmis:versionLabel IN     ('company')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:versionLabel FROM cmis:document WHERE ANY cmis:versionLabel NOT IN ('company')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_IS_LATEST_MAJOR_VERSION() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:isLatestMajorVersion");
            Boolean value = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)Boolean.FALSE, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:isLatestMajorVersion");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof IsLatestMajorVersionProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion =  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion <> 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion <  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion <= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion >  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion >= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion     LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion NOT LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE cmis:isLatestMajorVersion IS     NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE 'TRUE' =  ANY cmis:isLatestMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE 'TRUE' <> ANY cmis:isLatestMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE 'TRUE' <  ANY cmis:isLatestMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE 'TRUE' <= ANY cmis:isLatestMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE 'TRUE' >  ANY cmis:isLatestMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE 'TRUE' >= ANY cmis:isLatestMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE ANY cmis:isLatestMajorVersion IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestMajorVersion FROM cmis:document WHERE ANY cmis:isLatestMajorVersion NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
    }

    public void test_IS_MAJOR_VERSION() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:isMajorVersion");
            Boolean value = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)Boolean.FALSE, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:isMajorVersion");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof IsMajorVersionProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion =  TRUE", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion =  true", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion =  FALSE", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion =  false", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion <> 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion <  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion <= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion >  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion >= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion     LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion NOT LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE cmis:isMajorVersion IS     NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE 'TRUE' =  ANY cmis:isMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE 'TRUE' <> ANY cmis:isMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE 'TRUE' <  ANY cmis:isMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE 'TRUE' <= ANY cmis:isMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE 'TRUE' >  ANY cmis:isMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE 'TRUE' >= ANY cmis:isMajorVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE ANY cmis:isMajorVersion IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isMajorVersion FROM cmis:document WHERE ANY cmis:isMajorVersion NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
    }

    public void test_IS_LATEST_VERSION() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:isLatestVersion");
            Boolean value = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)Boolean.TRUE, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:isLatestVersion");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof IsLatestVersionProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion =  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion <> 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion <  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion <= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion >  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion >= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion     LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion NOT LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE cmis:isLatestVersion IS     NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE 'TRUE' =  ANY cmis:isLatestVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE 'TRUE' <> ANY cmis:isLatestVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE 'TRUE' <  ANY cmis:isLatestVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE 'TRUE' <= ANY cmis:isLatestVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE 'TRUE' >  ANY cmis:isLatestVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE 'TRUE' >= ANY cmis:isLatestVersion", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE ANY cmis:isLatestVersion IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isLatestVersion FROM cmis:document WHERE ANY cmis:isLatestVersion NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
    }

    public void test_IS_IMMUTABLE() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:Document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:isImmutable");
            Boolean value = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)Boolean.FALSE, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:isImmutable");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof IsImmutableProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable =  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable <> 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable <  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable <= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable >  'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable >= 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable     LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable NOT LIKE 'TRUE'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE cmis:isImmutable IS     NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE 'TRUE' =  ANY cmis:isImmutable", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE 'TRUE' <> ANY cmis:isImmutable", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE 'TRUE' <  ANY cmis:isImmutable", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE 'TRUE' <= ANY cmis:isImmutable", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE 'TRUE' >  ANY cmis:isImmutable", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE 'TRUE' >= ANY cmis:isImmutable", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE ANY cmis:isImmutable IN     ('TRUE')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:isImmutable FROM cmis:document WHERE ANY cmis:isImmutable NOT IN ('TRUE')", 0, false, "cmis:objectId", new String(), true);
    }

    public void test_folder_NAME() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:name");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:name");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:folder WHERE cmis:name =  'Folder 1'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:name");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"Folder 1", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:name");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name =  'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name <> 'Folder 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name <  'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name <= 'Folder 1'", 2, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name >  'Folder 1'", 8, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name >= 'Folder 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name IN     ('Folder 1')", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name NOT IN ('Folder 1')", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name     LIKE 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name NOT LIKE 'Folder 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE cmis:name IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE 'Folder 1' =  ANY cmis:name", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE 'Folder 1' <> ANY cmis:name", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE 'Folder 1' <  ANY cmis:name", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE 'Folder 1' <= ANY cmis:name", 2, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE 'Folder 1' >  ANY cmis:name", 8, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE 'Folder 1' >= ANY cmis:name", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE ANY cmis:name IN     ('Folder 1')", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:folder WHERE ANY cmis:name NOT IN ('Folder 1')", 9, false, "cmis:objectId", new String(), true);
    }

    public void test_document_Name() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:name");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:name");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:name =  'Alfresco Tutorial'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:name");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"Alfresco Tutorial", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:name");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name =  'Alfresco Tutorial'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name <> 'Alfresco Tutorial'", 9, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name <  'Alfresco Tutorial'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name <= 'Alfresco Tutorial'", 2, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name >  'Alfresco Tutorial'", 8, true, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name >= 'Alfresco Tutorial'", 9, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name IN     ('Alfresco Tutorial')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name NOT IN ('Alfresco Tutorial')", 9, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutorial'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name NOT LIKE 'Alfresco Tutorial'", 9, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name IS NOT NULL", 10, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name IS     NULL", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE 'Alfresco Tutorial' =  ANY cmis:name", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE 'Alfresco Tutorial' <> ANY cmis:name", 9, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE 'Alfresco Tutorial' <  ANY cmis:name", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE 'Alfresco Tutorial' <= ANY cmis:name", 2, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE 'Alfresco Tutorial' >  ANY cmis:name", 8, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE 'Alfresco Tutorial' >= ANY cmis:name", 9, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE ANY cmis:name IN     ('Alfresco Tutorial')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE ANY cmis:name NOT IN ('Alfresco Tutorial')", 9, false, "cmis:name", new String(), true);
    }

    public void test_CHANGE_TOKEN() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:changeToken");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:changeToken");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof FixedValueProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken =  'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken <> 'test'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken <  'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken <= 'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken >  'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken >= 'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken IN     ('test')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken NOT IN ('test')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken     LIKE 'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken NOT LIKE 'test'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken IS NOT NULL", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE cmis:changeToken IS     NULL", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE 'test' =  ANY cmis:changeToken", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE 'test' <> ANY cmis:changeToken", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE 'test' <  ANY cmis:changeToken", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE 'test' <= ANY cmis:changeToken", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE 'test' >  ANY cmis:changeToken", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE 'test' >= ANY cmis:changeToken", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE ANY cmis:changeToken IN     ('test')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:changeToken FROM cmis:folder WHERE ANY cmis:changeToken NOT IN ('test')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_LAST_MODIFICATION_DATE() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:lastModificationDate");
            Date value = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:lastModificationDate");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        Calendar today = Calendar.getInstance();
        if (today.get(11) == 0 || today.get(11) == 23) {
            return;
        }
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (boolean)true);
        Date lmd0 = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(this.c0, ContentModel.PROP_MODIFIED));
        String lmds0 = df.format(lmd0);
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:lastModificationDate = TIMESTAMP '" + lmds0 + "' and cmis:objectId = '" + this.c0.toString() + "'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$2 = rs.iterator();
        while (i$2.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$2.next();
            Serializable sValue = row.getValue("cmis:lastModificationDate");
            Date value = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)lmd0, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:lastModificationDate");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        Date date = this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document", -1, false, "cmis:lastModificationDate", new Date(), false);
        today.setTime(date);
        today.set(14, today.getMinimum(14));
        String sDate = df.format(today.getTime());
        String sDate2 = sDate.substring(0, sDate.length() - 1) + "+00:00";
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate = TIMESTAMP '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate = TIMESTAMP '" + sDate2 + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <> '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IN     ('" + sDate + "')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT IN ('" + sDate + "')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate     LIKE '" + sDate + "'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT LIKE '" + sDate + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' =  ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <> ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <  ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <= ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' >  ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' >= ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate IN     ('" + sDate + "')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate NOT IN ('" + sDate + "')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate NOT IN ('" + sDate + "') order by cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        date = Duration.subtract((Date)date, (Duration)new Duration("P1D"));
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(date);
        yesterday.set(14, today.getMinimum(14));
        sDate = df.format(yesterday.getTime());
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate =  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <> '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <= '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >  '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate     LIKE '" + sDate + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT LIKE '" + sDate + "'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' =  ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <> ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <  ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <= ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' >  ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' >= ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), true);
        date = Duration.add((Date)date, (Duration)new Duration("P2D"));
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(date);
        tomorrow.set(14, today.getMinimum(14));
        sDate = df.format(tomorrow.getTime());
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate =  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <> '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <  '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate <= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate >= '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate     LIKE '" + sDate + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate NOT LIKE '" + sDate + "'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE cmis:lastModificationDate IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' =  ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <> ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <  ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' <= ANY cmis:lastModificationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' >  ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE '" + sDate + "' >= ANY cmis:lastModificationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModificationDate FROM cmis:document WHERE ANY cmis:lastModificationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_LAST_MODIFIED_BY() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:lastModifiedBy");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:lastModifiedBy");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:lastModifiedBy =  'System'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:lastModifiedBy");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"System", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:lastModifiedBy");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy =  'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy <> 'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy <  'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy <= 'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy >  'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy >= 'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy IN     ('System')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy NOT IN ('System')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy     LIKE 'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy NOT LIKE 'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE cmis:lastModifiedBy IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE 'System' =  ANY cmis:lastModifiedBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE 'System' <> ANY cmis:lastModifiedBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE 'System' <  ANY cmis:lastModifiedBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE 'System' <= ANY cmis:lastModifiedBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE 'System' >  ANY cmis:lastModifiedBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE 'System' >= ANY cmis:lastModifiedBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE ANY cmis:lastModifiedBy IN     ('System')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE ANY cmis:lastModifiedBy NOT IN ('System')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:lastModifiedBy FROM cmis:document WHERE ANY cmis:lastModifiedBy NOT IN ('System') order by cmis:lastModifiedBy", 0, true, "cmis:objectId", new String(), true);
    }

    public void test_CREATION_DATE() throws Exception {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:creationDate");
            Date value = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:creationDate");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        Calendar today = Calendar.getInstance();
        if (today.get(11) == 0 || today.get(11) == 23) {
            return;
        }
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (boolean)true);
        Date cd0 = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(this.c0, ContentModel.PROP_CREATED));
        String cds0 = df.format(cd0);
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:creationDate = TIMESTAMP '" + cds0 + "' and cmis:objectId = '" + this.c0.toString() + "'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$2 = rs.iterator();
        while (i$2.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$2.next();
            Serializable sValue = row.getValue("cmis:creationDate");
            Date value = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((Object)cd0, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:creationDate");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        Date date = this.testQuery("SELECT cmis:creationDate FROM cmis:document", -1, false, "cmis:creationDate", new Date(), false);
        today.setTime(date);
        today.set(14, today.getMinimum(14));
        String sDate = df.format(today.getTime());
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate =  '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <> '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IN     ('" + sDate + "')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT IN ('" + sDate + "')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate     LIKE '" + sDate + "'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT LIKE '" + sDate + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' =  ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <> ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <  ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <= ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' >  ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' >= ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate IN     ('" + sDate + "')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate NOT IN ('" + sDate + "')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate NOT IN ('" + sDate + "') order by cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        date = Duration.subtract((Date)date, (Duration)new Duration("P1D"));
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(date);
        yesterday.set(14, today.getMinimum(14));
        sDate = df.format(yesterday.getTime());
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate =  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <> '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <= '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >  '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate     LIKE '" + sDate + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT LIKE '" + sDate + "'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' =  ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <> ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <  ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <= ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' >  ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' >= ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), true);
        date = Duration.add((Date)date, (Duration)new Duration("P2D"));
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(date);
        tomorrow.set(14, today.getMinimum(14));
        sDate = df.format(tomorrow.getTime());
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate =  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <> '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <  '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate <= '" + sDate + "'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >  '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate >= '" + sDate + "'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate     LIKE '" + sDate + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate NOT LIKE '" + sDate + "'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE cmis:creationDate IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' =  ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <> ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <  ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' <= ANY cmis:creationDate", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' >  ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE '" + sDate + "' >= ANY cmis:creationDate", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate IN     ('" + sDate + "')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:creationDate FROM cmis:document WHERE ANY cmis:creationDate NOT IN ('" + sDate + "')", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_CREATED_BY() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:createdBy");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:createdBy");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document WHERE cmis:createdBy =  'System'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:createdBy");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"System", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:createdBy");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof DirectProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy =  'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <> 'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <  'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy <= 'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy >  'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy >= 'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IN     ('System')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy NOT IN ('System')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy     LIKE 'System'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy NOT LIKE 'System'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE cmis:createdBy IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE 'System' =  ANY cmis:createdBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE 'System' <> ANY cmis:createdBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE 'System' <  ANY cmis:createdBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE 'System' <= ANY cmis:createdBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE 'System' >  ANY cmis:createdBy", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE 'System' >= ANY cmis:createdBy", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE ANY cmis:createdBy IN     ('System')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE ANY cmis:createdBy NOT IN ('System')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:createdBy FROM cmis:document WHERE ANY cmis:createdBy IN     ('System') order by cmis:createdBy", 10, false, "cmis:objectId", new String(), true);
    }

    public void test_OBJECT_TYPE_ID() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:objectTypeId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"cmis:document", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:objectTypeId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ObjectTypeIdProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:objectTypeId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"cmis:folder", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:objectTypeId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ObjectTypeIdProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId =  'cmis:document'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId <> 'cmis:document'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId <  'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId <= 'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId >  'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId >= 'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IN     ('cmis:document')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId NOT IN ('cmis:document')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId     LIKE 'cmis:document'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId NOT LIKE 'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE cmis:objectTypeId IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE 'cmis:document' =  ANY cmis:objectTypeId", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE 'cmis:document' <> ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE 'cmis:document' <  ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE 'cmis:document' <= ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE 'cmis:document' >  ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE 'cmis:document' >= ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE ANY cmis:objectTypeId IN     ('cmis:document')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:document WHERE ANY cmis:objectTypeId NOT IN ('cmis:document')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId =  'cmis:folder'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <> 'cmis:folder'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <  'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <= 'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId >  'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId >= 'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IN     ('cmis:folder')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId NOT IN ('cmis:folder')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId     LIKE 'cmis:folder'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId NOT LIKE 'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' =  ANY cmis:objectTypeId", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' <> ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' <  ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' <= ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' >  ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' >= ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE ANY cmis:objectTypeId IN     ('cmis:folder')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE ANY cmis:objectTypeId NOT IN ('cmis:folder')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM Relationship WHERE cmis:objectTypeId =  ''", 1, false, "cmis:objectId", new String(), true);
    }

    public void test_BASE_TYPE_ID() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:baseTypeId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"cmis:document", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:baseTypeId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof BaseTypeIdProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:baseTypeId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            QueryTest.assertEquals((String)"cmis:folder", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:baseTypeId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof BaseTypeIdProperty));
        }
        rs.close();
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document", this.file_count, false, "cmis:baseTypeId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId =  'cmis:document'", this.file_count, false, "cmis:baseTypeId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId <> 'cmis:document'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId <  'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId <= 'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId >  'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId >= 'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId IN     ('cmis:document')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId NOT IN ('cmis:document')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId     LIKE 'cmis:document'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId NOT LIKE 'cmis:document'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE 'cmis:document' =  ANY cmis:baseTypeId", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE 'cmis:document' <> ANY cmis:baseTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE 'cmis:document' <  ANY cmis:baseTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE 'cmis:document' <= ANY cmis:baseTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE 'cmis:document' >  ANY cmis:baseTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE 'cmis:document' >= ANY cmis:baseTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE ANY cmis:baseTypeId IN     ('cmis:document')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE ANY cmis:baseTypeId NOT IN ('cmis:document')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:folder", this.folder_count, false, "cmis:baseTypeId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:folder WHERE cmis:baseTypeId =  'cmis:folder'", this.folder_count, false, "cmis:baseTypeId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <> 'cmis:folder'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <  'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId <= 'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId >  'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId >= 'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IN     ('cmis:folder')", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId NOT IN ('cmis:folder')", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId     LIKE 'cmis:folder'", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId NOT LIKE 'cmis:folder'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE cmis:objectTypeId IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' =  ANY cmis:objectTypeId", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' <> ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' <  ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' <= ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' >  ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE 'cmis:folder' >= ANY cmis:objectTypeId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE ANY cmis:objectTypeId IN     ('cmis:folder')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectTypeId FROM cmis:folder WHERE ANY cmis:objectTypeId NOT IN ('cmis:folder')", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:relationship WHERE cmis:baseTypeId =  'cmis:relationship'", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:policy WHERE cmis:baseTypeId =  'cmis:relationship'", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:folder WHERE cmis:baseTypeId =  'cmis:policy'", 0, false, "cmis:baseTypeId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:folder WHERE cmis:baseTypeId =  'cmis:relationship'", 0, false, "cmis:baseTypeId", new String(), true);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:folder WHERE cmis:baseTypeId =  'cmis:document'", 0, false, "cmis:baseTypeId", new String(), false);
        this.testQuery("SELECT cmis:baseTypeId FROM cmis:document WHERE cmis:baseTypeId =  'cmis:folder'", 0, false, "cmis:baseTypeId", new String(), false);
    }

    public void test_ObjectId() throws Exception {
        CMISResultSetColumn column;
        String value;
        Serializable sValue;
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.file_count, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:objectId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:objectId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ObjectIdProperty));
        }
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)this.folder_count, (int)rs.length());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            sValue = row.getValue("cmis:objectId");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertNotNull((Object)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:objectId");
            QueryTest.assertNotNull((Object)column);
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column.getCMISPropertyDefinition().getPropertyAccessor() instanceof ObjectIdProperty));
        }
        rs.close();
        String companyHomeId = this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:name = 'Folder 0'", 1, false, "cmis:objectId", new String(), false);
        options = new CMISQueryOptions("SELECT * FROM cmis:folder WHERE cmis:objectId =  '" + companyHomeId + "'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$2 = rs.iterator();
        while (i$2.hasNext()) {
            CMISResultSetRow row2 = (CMISResultSetRow)i$2.next();
            Serializable sValue2 = row2.getValue("cmis:objectId");
            String value2 = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue2);
            QueryTest.assertNotNull((Object)value2);
            QueryTest.assertEquals((String)companyHomeId, (String)value2);
            CMISResultSetColumn column2 = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("cmis:objectId");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.ID, (Object)column2.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column2.getCMISPropertyDefinition().getCardinality());
            QueryTest.assertTrue((boolean)(column2.getCMISPropertyDefinition().getPropertyAccessor() instanceof ObjectIdProperty));
        }
        rs.close();
        Serializable ser = this.cmisService.getProperty(this.f0, "cmis:objectId");
        String id = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)ser);
        QueryTest.assertEquals((String)companyHomeId, (String)id);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId =  '" + companyHomeId + "'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <> '" + companyHomeId + "'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <  '" + companyHomeId + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId <= '" + companyHomeId + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId >  '" + companyHomeId + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId >= '" + companyHomeId + "'", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IN     ('" + companyHomeId + "')", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId NOT IN ('" + companyHomeId + "')", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId     LIKE '" + companyHomeId + "'", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId NOT LIKE '" + companyHomeId + "'", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE IN_FOLDER('" + companyHomeId + "')", 2, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE IN_TREE  ('" + companyHomeId + "')", 6, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE cmis:objectId IS     NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE '" + companyHomeId + "' =  ANY cmis:objectId", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE '" + companyHomeId + "' <> ANY cmis:objectId", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE '" + companyHomeId + "' <  ANY cmis:objectId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE '" + companyHomeId + "' <= ANY cmis:objectId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE '" + companyHomeId + "' >  ANY cmis:objectId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE '" + companyHomeId + "' >= ANY cmis:objectId", 0, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE ANY cmis:objectId IN     ('" + companyHomeId + "')", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT cmis:objectId FROM cmis:folder WHERE ANY cmis:objectId NOT IN ('" + companyHomeId + "')", 9, false, "cmis:objectId", new String(), true);
    }

    public void testOrderBy() throws Exception {
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectTypeId", this.folder_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectTypeId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder ORDER BY cmis:objectId DESC", this.folder_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY Meep", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "Meep");
        this.testOrderBy("SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY cmis:objectId", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "Meep");
        this.testOrderBy("SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY Meep ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "Meep");
        this.testOrderBy("SELECT  cmis:objectId Meep FROM cmis:folder ORDER BY Meep DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "Meep");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder F ORDER BY F.cmis:objectId", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder F ORDER BY cmis:objectId", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder F ORDER BY F.cmis:objectId ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "F.cmis:objectId");
        this.testOrderBy("SELECT  cmis:objectId FROM cmis:folder F ORDER BY F.cmis:objectId DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "F.cmis:objectId");
        this.testOrderBy("SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY Meep", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "Meep");
        this.testOrderBy("SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY F.cmis:objectId", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "F.cmis:objectId");
        this.testOrderBy("SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY cmis:objectId", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "F.cmis:objectId");
        this.testOrderBy("SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY Meep ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectId");
        this.testOrderBy("SELECT  F.cmis:objectId Meep FROM cmis:folder F ORDER BY Meep DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "Meep");
        this.testOrderBy("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY MEEP", this.file_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "MEEP");
        this.testOrderBy("SELECT SCORE(), cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY SEARCH_SCORE", this.file_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "SEARCH_SCORE");
        this.testOrderBy("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY MEEP ASC", this.file_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "MEEP");
        this.testOrderBy("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:document where CONTAINS('*') ORDER BY MEEP DESC", this.file_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "MEEP");
        this.testOrderBy("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder where CONTAINS('cmis:name:*') ORDER BY MEEP", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "MEEP");
        this.testOrderBy("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder where CONTAINS('cmis:name:*') ORDER BY MEEP ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "MEEP");
        this.testOrderBy("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder where CONTAINS('cmis:name:*') ORDER BY MEEP DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, "MEEP");
        this.testOrderBy("SELECT cmis:objectTypeId FROM cmis:folder ORDER BY cmis:objectTypeId ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectTypeId");
        this.testOrderBy("SELECT cmis:objectTypeId FROM cmis:folder ORDER BY cmis:objectTypeId DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectTypeId");
        this.testOrderBy("SELECT cmis:objectTypeId FROM cmis:folder ORDER BY cmis:objectTypeId ASC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:objectTypeId");
        this.testOrderBy("SELECT cmis:createdBy FROM cmis:folder ORDER BY cmis:createdBy ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:createdBy");
        this.testOrderBy("SELECT cmis:createdBy FROM cmis:folder ORDER BY cmis:createdBy DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:createdBy");
        this.testOrderBy("SELECT cmis:createdBy FROM cmis:folder ORDER BY cmis:createdBy ASC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:createdBy");
        this.testOrderBy("SELECT cmis:creationDate FROM cmis:folder ORDER BY cmis:creationDate ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:creationDate");
        this.testOrderBy("SELECT cmis:creationDate FROM cmis:folder ORDER BY cmis:creationDate DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:creationDate");
        this.testOrderBy("SELECT cmis:creationDate FROM cmis:folder ORDER BY cmis:creationDate DESC", this.folder_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:creationDate");
        this.testOrderBy("SELECT cmis:lastModifiedBy FROM cmis:folder ORDER BY cmis:lastModifiedBy ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:lastModifiedBy");
        this.testOrderBy("SELECT cmis:lastModifiedBy FROM cmis:folder ORDER BY cmis:lastModifiedBy DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:lastModifiedBy");
        this.testOrderBy("SELECT cmis:lastModifiedBy FROM cmis:folder ORDER BY cmis:lastModifiedBy DESC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:lastModifiedBy");
        this.testOrderBy("SELECT cmis:lastModificationDate FROM cmis:folder ORDER BY cmis:lastModificationDate ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:lastModificationDate");
        this.testOrderBy("SELECT cmis:lastModificationDate FROM cmis:folder ORDER BY cmis:lastModificationDate DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:lastModificationDate");
        this.testOrderBy("SELECT cmis:lastModificationDate FROM cmis:folder ORDER BY cmis:lastModificationDate DESC", this.folder_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:lastModificationDate");
        this.testOrderBy("SELECT cmis:name FROM cmis:folder ORDER BY cmis:name ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:name");
        this.testOrderBy("SELECT cmis:name FROM cmis:folder ORDER BY cmis:name DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:name");
        this.testOrderBy("SELECT cmis:name FROM cmis:folder ORDER BY cmis:name DESC", this.folder_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:name");
        this.testOrderBy("SELECT cmis:name FROM cmis:document ORDER BY cmis:name ASC", this.file_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:name");
        this.testOrderBy("SELECT cmis:name FROM cmis:document ORDER BY cmis:name DESC", this.file_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:name");
        this.testOrderBy("SELECT cmis:name FROM cmis:document ORDER BY cmis:name DESC", this.file_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:name");
        this.testOrderBy("SELECT cmis:versionLabel FROM cmis:document ORDER BY cmis:versionLabel ASC", this.file_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:versionLabel");
        this.testOrderBy("SELECT cmis:versionLabel FROM cmis:document ORDER BY cmis:versionLabel DESC", this.file_count, true, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:versionLabel");
        this.testOrderBy("SELECT cmis:versionLabel FROM cmis:document ORDER BY cmis:versionLabel DESC", this.file_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:versionLabel");
        this.testOrderBy("SELECT cmis:contentStreamFileName FROM cmis:document ORDER BY cmis:contentStreamFileName ASC", this.file_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:contentStreamFileName");
        this.testOrderBy("SELECT cmis:contentStreamFileName FROM cmis:document ORDER BY cmis:contentStreamFileName DESC", this.file_count, true, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:contentStreamFileName");
        this.testOrderBy("SELECT cmis:contentStreamFileName FROM cmis:document ORDER BY cmis:contentStreamFileName DESC", this.file_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:contentStreamFileName");
        this.testOrderBy("SELECT cmis:parentId FROM cmis:folder ORDER BY cmis:parentId ASC", this.folder_count, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:parentId");
        this.testOrderBy("SELECT cmis:parentId FROM cmis:folder ORDER BY cmis:parentId DESC", this.folder_count, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:parentId");
        this.testOrderBy("SELECT cmis:parentId FROM cmis:folder ORDER BY cmis:parentId DESC", this.folder_count, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, "cmis:parentId");
        this.testQuery("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder WHERE CONTAINS('cmis:name:*') AND cmis:name = 'compan home') ORDER BY SCORE() DESC", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder WHERE CONTAINS('cmis:name:*') AND cmis:name IN ('company', 'home') ORDER BY MEEEP DESC", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder WHERE CONTAINS('cmis:name:*') AND cmis:name IN ('company', 'home') ORDER BY cmis:parentId DESC", 1, false, "cmis:objectId", new String(), true);
        this.testExtendedQuery("SELECT SCORE() AS MEEP, cmis:objectId, cmis:parentId FROM cmis:folder WHERE CONTAINS('cmis:name:*') ORDER BY cmis:parentId DESC", this.folder_count, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder WHERE CONTAINS('cmis:name:*') AND cmis:name IN ('company', 'home') ORDER BY cmis:notThere DESC", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder as F WHERE CONTAINS('cmis:name:*') AND cmis:name IN ('company', 'home') ORDER BY F.cmis:parentId DESC", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT SCORE() AS MEEP, cmis:objectId FROM cmis:folder F WHERE CONTAINS('cmis:name:*') AND cmis:name IN ('company', 'home') ORDER BY F.cmis:notThere DESC", 1, false, "cmis:objectId", new String(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void testOrderBy(String query, int size, boolean shouldThrow, Order order, CMISQueryOptions.CMISQueryMode mode, String ... orderByPropertyName) {
        CMISResultSet rs = null;
        try {
            CMISQueryOptions options = new CMISQueryOptions(query, this.rootNodeRef.getStoreRef());
            options.setQueryMode(mode);
            rs = this.cmisQueryService.query(options);
            Comparable[] previous = null;
            boolean[] wasNull = null;
            boolean[] hasValue = null;
            Iterator i$ = rs.iterator();
            while (i$.hasNext()) {
                Comparable comparable;
                Serializable sValue;
                int i;
                CMISResultSetRow row = (CMISResultSetRow)i$.next();
                if (previous == null) {
                    previous = new Comparable[orderByPropertyName.length];
                    wasNull = new boolean[orderByPropertyName.length];
                    hasValue = new boolean[orderByPropertyName.length];
                    for (i = 0; i < orderByPropertyName.length; ++i) {
                        sValue = row.getValue(orderByPropertyName[i]);
                        if (sValue instanceof Comparable) {
                            previous[i] = comparable = (Comparable)((Object)sValue);
                            hasValue[i] = true;
                            continue;
                        }
                        previous[i] = null;
                        wasNull[i] = true;
                    }
                    continue;
                }
                block55: for (i = 0; i < orderByPropertyName.length; ++i) {
                    Serializable current = row.getValue(orderByPropertyName[i]);
                    Comparable last = previous[i];
                    if (last != null) {
                        if (current == null) {
                            switch (order) {
                                case ASCENDING: {
                                    if (shouldThrow) {
                                        throw new IllegalStateException("Incorrect Order");
                                    }
                                    QueryTest.fail((String)"Null found after value ascending");
                                }
                                case DESCENDING: {
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException();
                                }
                            }
                        }
                        Method ct = null;
                        Method[] methods = last.getClass().getMethods();
                        for (int m = 0; m < methods.length; ++m) {
                            if (!methods[m].getName().equals("compareTo") || methods[m].getParameterTypes().length != 1 || !methods[m].getParameterTypes()[0].equals(methods[m].getDeclaringClass())) continue;
                            if (ct != null) {
                                throw new IllegalStateException("Found 2 or more compareTo methods");
                            }
                            ct = methods[m];
                        }
                        int comparison = (Integer)ct.invoke((Object)last, current);
                        switch (order) {
                            case ASCENDING: {
                                if (comparison <= 0) break;
                                if (shouldThrow) {
                                    throw new IllegalStateException("Incorrect Order");
                                }
                                QueryTest.fail((String)"Incorrect Order");
                            }
                            case DESCENDING: {
                                if (comparison >= 0) break;
                                if (shouldThrow) {
                                    throw new IllegalStateException("Incorrect Order");
                                }
                                QueryTest.fail((String)"Incorrect Order");
                            }
                            default: {
                                throw new UnsupportedOperationException("Column data type is not comparable " + orderByPropertyName[i]);
                            }
                        }
                        continue;
                    }
                    if (current == null) continue;
                    switch (order) {
                        case ASCENDING: {
                            continue block55;
                        }
                        case DESCENDING: {
                            if (shouldThrow) {
                                throw new IllegalStateException("Incorrect Order");
                            }
                            QueryTest.fail((String)"Null found descending");
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
                for (i = 0; i < orderByPropertyName.length; ++i) {
                    sValue = row.getValue(orderByPropertyName[i]);
                    if (sValue instanceof Comparable) {
                        previous[i] = comparable = (Comparable)((Object)sValue);
                        hasValue[i] = true;
                        continue;
                    }
                    previous[i] = null;
                    wasNull[i] = true;
                }
            }
            for (int i = 0; i < hasValue.length; ++i) {
                if (hasValue[i] != false) continue;
                throw new UnsupportedOperationException("Only nulls found for " + orderByPropertyName[i]);
            }
            if (size >= 0) {
                QueryTest.assertEquals((int)size, (int)rs.getLength());
            }
            if (shouldThrow) {
                QueryTest.fail((String)"Should have thrown an exception");
            }
        }
        catch (CMISQueryException e) {
            if (shouldThrow) {
                return;
            }
            throw e;
        }
        catch (QueryModelException e) {
            if (shouldThrow) {
                return;
            }
            throw e;
        }
        catch (FTSQueryException e) {
            if (shouldThrow) {
                return;
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            if (shouldThrow) {
                return;
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            if (shouldThrow) {
                return;
            }
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                finally {
                    rs = null;
                }
            }
        }
    }

    public void testUpperAndLower() throws Exception {
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'FOLDER 1'", 0, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'folder 1'", 0, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) = 'FOLDER 1'", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Lower(cmis:name) = 'folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) = 'folder 1'", 0, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Lower(cmis:name) = 'FOLDER 1'", 0, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) = 'Folder 1'", 0, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Lower(cmis:name) = 'Folder 1'", 0, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) <> 'FOLDER 1'", 9, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) <= 'FOLDER 1'", 2, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) < 'FOLDER 1'", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) >= 'FOLDER 1'", 9, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) > 'FOLDER 1'", 8, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE Upper(cmis:name) > 'FOLDER 1'", 8, false, "cmis:objectId", new String(), true);
    }

    public void testAllSimpleTextPredicates() throws Exception {
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 9'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 9\\''", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND NOT cmis:name = 'Folder 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND 'Folder 1' = ANY cmis:name", 1, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND NOT cmis:name <> 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <> 'Folder 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name < 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name <= 'Folder 1'", 2, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name > 'Folder 1'", 8, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name >= 'Folder 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name IN ('Folder 1', '1')", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT IN ('Folder 1', 'Folder 9\\'')", 8, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND ANY cmis:name IN ('Folder 1', 'Folder 9\\'')", 2, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND ANY cmis:name NOT IN ('2', '3')", 10, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'Fol%'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ 1'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ %'", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ %'", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name LIKE 'F_l_e_ _'", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name NOT LIKE 'F_l_e_ _'", 1, false, "cmis:objectId", new String(), false);
    }

    public void testSimpleConjunction() throws Exception {
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL AND cmis:name = 'Folder'", 0, false, "cmis:objectId", new String(), false);
    }

    public void testSimpleDisjunction() throws Exception {
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 2'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1' OR cmis:name = 'Folder 2'", 2, false, "cmis:objectId", new String(), false);
    }

    public void testPropertyToSelectorBinding() throws Exception {
        this.testQuery("SELECT cmis:parentId FROM cmis:document", 10, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        this.testQuery("SELECT * FROM cmis:document where cmis:parentId <> 'woof://woof/woof'", 10, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        this.testQuery("SELECT D.*, O.cmis:name FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId", 1, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cmis:document order by cmis:parentId", 10, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        this.testQuery("SELECT * FROM cmis:document where CONTAINS('cmis:parentId:*')", 10, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
    }

    public void testExists() throws Exception {
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name IS NULL", 0, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE cmis:name IS NOT NULL", 10, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE cmis:name IS NULL", 0, false, "cmis:objectId", new String(), false);
    }

    public void testObjectEquals() {
    }

    public void testDocumentEquals() {
    }

    public void testFolderEquals() throws Exception {
        Serializable ser = this.cmisService.getProperty(this.f0, "cmis:name");
        String Name = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)ser);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name = '" + Name + "'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:name = 'Folder 1'", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:parentId = '" + this.rootNodeRef.toString() + "'", 4, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder WHERE cmis:allowedChildObjectTypeIds = 'meep'", 0, false, "cmis:objectId", new String(), true);
    }

    public void test_IN_TREE() throws Exception {
        Serializable ser = this.cmisService.getProperty(this.f0, "cmis:objectId");
        String id = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)ser);
        this.testQuery("SELECT * FROM cmis:folder WHERE IN_TREE('" + id + "')", 6, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder F WHERE IN_TREE(F, '" + id + "')", 6, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder X WHERE IN_TREE(F, '" + id + "')", 6, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT D.*, O.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_TREE(D, '" + id + "')", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, O.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_TREE('" + id + "')", 1, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cmis:folder WHERE IN_TREE('woof://woof/woof')", 6, false, "cmis:objectId", new String(), true);
    }

    public void test_IN_FOLDER() throws Exception {
        Serializable ser = this.cmisService.getProperty(this.f0, "cmis:objectId");
        String id = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)ser);
        this.testQuery("SELECT * FROM cmis:folder WHERE IN_FOLDER('" + id + "')", 2, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder F WHERE IN_FOLDER(F, '" + id + "')", 2, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:folder X WHERE IN_FOLDER(F, '" + id + "')", 2, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT D.*, O.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_FOLDER(D, '" + id + "')", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, O.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId WHERE IN_FOLDER('" + id + "')", 1, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cmis:folder WHERE IN_FOLDER('woof://woof/woof')", 2, false, "cmis:objectId", new String(), true);
    }

    public void testFTS() throws Exception {
        this.testQuery("SELECT SCORE(), D.* FROM cmis:document D WHERE D.cmis:contentStreamFileName = 'zebra'", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'zebra\\'') AND CONTAINS('\\'quick\\'')", 9, false, "cmis:objectId", new String(), true);
        this.testQuery("SELECT SCORE()as ONE, SCORE()as TWO, D.* FROM cmis:document D WHERE CONTAINS('\\'zebra\\'')", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'zebra\\'')", 9, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick\\'')", 1, false, "cmis:objectId", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick\\'')", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:document D WHERE CONTAINS(D, 'cmis:name:\\'Tutorial\\'')", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT cmis:name as BOO FROM cmis:document D WHERE CONTAINS('BOO:\\'Tutorial\\'')", 1, false, "cmis:objectId", new String(), false);
    }

    public void testScoreValues() {
        CMISResultSetRow row;
        CMISQueryOptions options = new CMISQueryOptions("SELECT SCORE() AS ONE FROM cmis:document WHERE CONTAINS('cmis:name:\\'DD\\' and \\'Four\\'') AND cmis:name = 'DD\\''", this.rootNodeRef.getStoreRef());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.getLength());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            System.out.println(row.getValue("cmis:objectId") + " Score " + row.getScore() + " " + row.getScores());
            QueryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(row.getScore()));
        }
        rs.close();
        rs = null;
        options = new CMISQueryOptions("SELECT SCORE() AS ONE FROM cmis:document WHERE CONTAINS('\\'Four zebra durian\\'')", this.rootNodeRef.getStoreRef());
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.getLength());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            System.out.println(row.getValue("cmis:objectId") + " Score " + row.getScore() + " " + row.getScores());
        }
        rs.close();
        rs = null;
        options = new CMISQueryOptions("SELECT SCORE() AS ONE FROM cmis:document WHERE CONTAINS('\\'Zebra\\'')", this.rootNodeRef.getStoreRef());
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)9, (int)rs.getLength());
        i$ = rs.iterator();
        while (i$.hasNext()) {
            row = (CMISResultSetRow)i$.next();
            System.out.println(row.getValue("cmis:objectId") + " Score " + row.getScore() + " " + row.getScores());
        }
        rs.close();
        rs = null;
    }

    public void testBasicSelectAsGuest() throws Exception {
        this.runAs("guest");
        this.testQuery("SELECT * FROM cmis:document", 0, false, "cmis:objectId", new String(), false);
    }

    public void testBasicSelectAsCmis() throws Exception {
        this.runAs("cmis");
        this.testQuery("SELECT * FROM cmis:document", 7, false, "cmis:objectId", new String(), false);
    }

    public void testBasicSelect() throws Exception {
        this.testQuery("SELECT * FROM cmis:document", 10, false, "cmis:objectId", new String(), false);
    }

    public void testBasicDefaultMetaData() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document", this.rootNodeRef.getStoreRef());
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        QueryTest.assertNotNull((Object)((Object)md.getQueryOptions()));
        CMISTypeDefinition typeDef = this.cmisDictionaryService.findType(CMISDictionaryModel.DOCUMENT_TYPE_ID);
        int count = 0;
        for (CMISPropertyDefinition pdef : typeDef.getPropertyDefinitions().values()) {
            ++count;
        }
        QueryTest.assertEquals((int)count, (int)md.getColumnNames().length);
        QueryTest.assertNotNull((Object)md.getColumn("cmis:objectId"));
        QueryTest.assertEquals((int)1, (int)md.getSelectors().length);
        QueryTest.assertNotNull((Object)md.getSelector(""));
        rs.close();
    }

    public void testBasicMetaData() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT DOC.cmis:objectId, DOC.cmis:objectId AS ID FROM cmis:document AS DOC", this.rootNodeRef.getStoreRef());
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        QueryTest.assertNotNull((Object)((Object)md.getQueryOptions()));
        QueryTest.assertEquals((int)2, (int)md.getColumnNames().length);
        QueryTest.assertNotNull((Object)md.getColumn("DOC.cmis:objectId"));
        QueryTest.assertNotNull((Object)md.getColumn("ID"));
        QueryTest.assertEquals((int)1, (int)md.getSelectors().length);
        QueryTest.assertNotNull((Object)md.getSelector("DOC"));
        rs.close();
    }

    public void testBasicColumns() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT DOC.cmis:objectId, DOC.cmis:objectTypeId AS ID FROM cmis:folder AS DOC", this.rootNodeRef.getStoreRef());
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        QueryTest.assertNotNull((Object)((Object)md.getQueryOptions()));
        QueryTest.assertEquals((int)2, (int)md.getColumnNames().length);
        QueryTest.assertNotNull((Object)md.getColumn("DOC.cmis:objectId"));
        QueryTest.assertNotNull((Object)md.getColumn("ID"));
        QueryTest.assertEquals((int)1, (int)md.getSelectors().length);
        QueryTest.assertNotNull((Object)md.getSelector("DOC"));
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            System.out.println("Id  " + row.getValue("ID"));
        }
        rs.close();
    }

    public void testBasicAllDocumentColumns() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT DOC.*  FROM cmis:document AS DOC", this.rootNodeRef.getStoreRef());
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            for (String column : md.getColumnNames()) {
                System.out.println("Column  " + column + " value =" + row.getValue(column));
            }
            System.out.println("\n\n");
        }
        rs.close();
    }

    public void testBasicAllFolderColumns() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:folder AS DOC", this.cmisService.getDefaultRootStoreRef());
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            for (String column : md.getColumnNames()) {
                System.out.println("Column  " + column + " value =" + row.getValue(column));
            }
            System.out.println("\n\n");
        }
        rs.close();
    }

    public void testBasicAll_ST_SITES_Columns() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT *  FROM ST:SITES AS DOC", this.cmisService.getDefaultRootStoreRef());
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            for (String column : md.getColumnNames()) {
                System.out.println("Column  " + column + " value =" + row.getValue(column));
            }
            System.out.println("\n\n");
            System.out.println(row.getValues());
            System.out.println("\n\n");
        }
        rs.close();
    }

    public void testFunctionColumns() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT DOC.cmis:name AS cmis:name, \nLOWER(\tDOC.cmis:name \n), LOWER ( DOC.cmis:name )  AS Lcmis:name, UPPER ( DOC.cmis:name ) , UPPER(DOC.cmis:name) AS Ucmis:name, Score(), SCORE() AS S1, SCORE() AS SCORED FROM cmis:folder AS DOC", this.rootNodeRef.getStoreRef());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        QueryTest.assertNotNull((Object)((Object)md.getQueryOptions()));
        QueryTest.assertEquals((int)8, (int)md.getColumnNames().length);
        QueryTest.assertNotNull((Object)md.getColumn("cmis:name"));
        QueryTest.assertNotNull((Object)md.getColumn("LOWER(\tDOC.cmis:name \n)"));
        QueryTest.assertNotNull((Object)md.getColumn("Lcmis:name"));
        QueryTest.assertNotNull((Object)md.getColumn("UPPER ( DOC.cmis:name )"));
        QueryTest.assertNotNull((Object)md.getColumn("Ucmis:name"));
        QueryTest.assertNotNull((Object)md.getColumn("SEARCH_SCORE"));
        QueryTest.assertNotNull((Object)md.getColumn("S1"));
        QueryTest.assertNotNull((Object)md.getColumn("SCORED"));
        QueryTest.assertEquals((int)1, (int)md.getSelectors().length);
        QueryTest.assertNotNull((Object)md.getSelector("DOC"));
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            System.out.println("\n\n");
            System.out.println(row.getValues());
            System.out.println("\n\n");
        }
        rs.close();
    }

    public void testParse1() throws RecognitionException {
        String query = "SELECT UPPER(1.0) AS WOOF FROM cmis:document AS DOC LEFT OUTER JOIN cmis:folder AS FOLDER ON DOC.cmis:name = FOLDER.cmis:name WHERE LOWER(DOC.cmis:name) = ' woof' AND CONTAINS('one two three') AND  CONTAINS('DOC.cmis:name:lemur AND woof') AND (DOC.cmis:name in ('one', 'two') AND IN_FOLDER('meep') AND DOC.cmis:name like 'woof' and DOC.cmis:name = 'woof' and DOC.cmis:objectId = 'meep') ORDER BY DOC.cmis:name DESC, WOOF";
        this.parse(query);
    }

    public void testParse2() throws RecognitionException {
        String query = "SELECT TITLE, AUTHORS, DATE FROM WHITE_PAPER WHERE ( IN_TREE( 'ID00093854763') ) AND ( 'SMITH' = ANY AUTHORS )";
        this.parse(query);
    }

    public void testParse3() throws RecognitionException {
        String query = "SELECT cmis:objectId, SCORE() AS X, DESTINATION, DEPARTURE_DATES FROM TRAVEL_BROCHURE WHERE ( CONTAINS('CARIBBEAN CENTRAL AMERICA CRUISE TOUR') ) AND ( '2009-1-1' < ANY DEPARTURE_DATES ) ORDER BY X DESC";
        this.parse(query);
    }

    public void testParse4() throws RecognitionException {
        String query = "SELECT * FROM CAR_REVIEW WHERE ( LOWER(MAKE) = 'buick' ) OR ( ANY FEATURES IN ('NAVIGATION SYSTEM', 'SATELLITE RADIO', 'MP3' ) )";
        this.parse(query);
    }

    public void testParse5() throws RecognitionException {
        String query = "SELECT Y.CLAIM_NUM, X.PROPERTY_ADDRESS, Y.DAMAGE_ESTIMATES FROM POLICY AS X JOIN CLAIMS AS Y ON X.POLICY_NUM = Y.POLICY_NUM WHERE ( 100000 <= ANY Y.DAMAGE_ESTIMATES ) AND ( Y.CAUSE NOT LIKE '%Katrina%' )";
        this.parse(query);
    }

    public void testParse6() throws RecognitionException {
        String query = "SELECT * FROM CM_TITLED";
        this.parse(query);
        query = "SELECT D.*, T.* FROM DOCUMENT AS D JOIN CM_TITLED AS T ON D.OBJECTID = T.OBJECTID";
        this.parse(query);
        query = "SELECT D.*, T.* FROM CM_TITLED T JOIN DOCUMENT D ON D.OBJECTID = T.OBJECTID";
        this.parse(query);
    }

    public void testParse7() throws RecognitionException {
        String query = "SELECT * from DOCUMENT D JOIN DOCUMENT DD ON D.ID = DD.ID ";
        this.parse(query);
    }

    public void testParse8() throws RecognitionException {
        String query = "SELECT * from ((FOLDER F JOIN RELATIONSHIP RL ON F.ID = RL.ID))";
        this.parse(query);
    }

    public void testDateFormattingErrors() throws Exception {
        this.testQuery("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-12-12T12:12:12.012Z'", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-012-12T12:12:12.012Z'", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP '2012-2-12T12:12:12.012Z'", 0, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cm:lockable L WHERE L.cm:expiryDate =  TIMESTAMP 'Mon Dec 12 12:12:12.012 GMT 2012'", 1, false, "cmis:objectId", new String(), true, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
    }

    public void testAspectProperties() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM CM:OWNABLE O", this.rootNodeRef.getStoreRef());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        CMISResultSet rs = this.cmisQueryService.query(options);
        CMISResultSetMetaData md = rs.getMetaData();
        QueryTest.assertNotNull((Object)((Object)md.getQueryOptions()));
        QueryTest.assertEquals((int)1, (int)md.getColumnNames().length);
        QueryTest.assertNotNull((Object)md.getColumn("O.cm:owner"));
        QueryTest.assertEquals((int)1, (int)md.getSelectors().length);
        QueryTest.assertNotNull((Object)md.getSelector("O"));
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            System.out.println("\n\n");
            System.out.println(row.getValues());
            System.out.println("\n\n");
        }
        rs.close();
    }

    public void testAspectJoin() throws Exception {
        this.testQuery("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN CMIS:DOCUMENT AS D ON D.cmis:objectId = o.cmis:objectId  ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, '\\'jumped\\'') and D.cmis:contentStreamLength <> 2", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM CM:OWNABLE", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM CM:OWNABLE where CM:oWNER = 'andy'", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM CM:OWNABLE where CM:OWNER = 'bob'", 0, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, O.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, O.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, O.*, T.* FROM CMIS:DOCUMENT AS D JOIN CM:OWNABLE AS O ON D.cmis:objectId = O.cmis:objectId JOIN CM:TITLED AS T ON T.cmis:objectId = D.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, O.* FROM CM:OWNABLE O JOIN CMIS:DOCUMENT D ON D.cmis:objectId = O.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT D.*, F.* FROM CMIS:FOLDER F JOIN CMIS:DOCUMENT D ON D.cmis:objectId = F.cmis:objectId", 0, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT O.*, T.* FROM CM:OWNABLE O JOIN CM:TITLED T ON O.cmis:objectId = T.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("select o.*, t.* from cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("sElEcT o.*, T.* fRoM cM:oWnAbLe o JoIn Cm:TiTlEd T oN o.cmis:objectId = T.cmis:objectId", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId )", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId  JOIN CMIS:DOCUMENT AS D ON D.cmis:objectId = o.cmis:objectId  )", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN CMIS:DOCUMENT AS D ON D.cmis:objectId = o.cmis:objectId ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, '\\'jumped\\'') and D.cmis:contentStreamLength <> 2", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("select o.*, t.* from ( cm:ownable o join cm:titled t on o.cmis:objectId = t.cmis:objectId JOIN CMIS:DOCUMENT AS D ON D.cmis:objectId = o.cmis:objectId ) where o.cm:owner = 'andy' and t.cm:title = 'Alfresco tutorial' and CONTAINS(D, 'jumped') and D.cmis:contentStreamLength <> 2", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
    }

    public void testPaging() {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        ArrayList<String> expected = new ArrayList<String>(10);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)10, (int)rs.getLength());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:objectId");
            String id = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            expected.add(id);
        }
        rs.close();
        for (int skip = 0; skip < 20; ++skip) {
            for (int max = 0; max < 20; ++max) {
                this.doPage(expected, skip, max);
            }
        }
    }

    public void testFTSConnectives() throws Exception {
        this.testQuery("SELECT * FROM cmis:document where contains('\\'one\\' OR \\'zebra\\'')", 9, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        this.testQuery("SELECT * FROM cmis:document where contains('\\'one\\' or \\'zebra\\'')", 9, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        this.testQuery("SELECT * FROM cmis:document where contains('\\'one\\' \\'zebra\\'')", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_STRICT);
        this.testQuery("SELECT * FROM cmis:document where contains('\\'one\\' and \\'zebra\\'')", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cmis:document where contains('\\'one\\' or \\'zebra\\'')", 9, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        this.testQuery("SELECT * FROM cmis:document where contains('\\'one\\'  \\'zebra\\'')", 1, false, "cmis:objectId", new String(), false, CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:document where contains('\\'one\\'  \\'zebra\\'')", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM cmis:document where contains('\\'one\\'  \\'zebra\\'')", this.rootNodeRef.getStoreRef());
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)9, (int)rs.length());
        rs.close();
    }

    public void testLikeEscaping() throws Exception {
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutorial'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco Tutoria_'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T_______'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T______\\_'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'Alfresco T\\%'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'GG*GG'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '__*__'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '%*%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'HH?HH'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '__?__'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE '%?%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'AA%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'AA\\%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'A%'", 2, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'a%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'A\\%'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'BB_'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'BB\\_'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B__'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B_\\_'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'B\\_\\_'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'CC\\\\'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT cmis:name FROM cmis:document WHERE cmis:name     LIKE 'DD\\''", 1, false, "cmis:name", new String(), false);
    }

    public void testColumnAliasUse() throws Exception {
        this.testQuery("SELECT cmis:name as myname FROM cmis:document WHERE myname LIKE 'Alfresco Tutorial'", 1, false, "myname", new String(), false);
        this.testQuery("SELECT cmis:name as myname FROM cmis:document WHERE myname LIKE 'A%' order by myname", 2, false, "cmis:name", new String(), false);
        this.testExtendedQuery("SELECT SCORE() as myscore, D.cmis:name as myname FROM cmis:document D WHERE CONTAINS(D, 'myname:\\'Tutorial\\'') order by myscore", 1, false, "cmis:objectId", new String(), false);
        this.testExtendedQuery("SELECT SCORE() as myscore, D.cmis:name FROM cmis:document D WHERE CONTAINS(D, 'cmis:name:\\'Tutorial\\'') and myscore > 0.5 order by myscore", 9, false, "cmis:objectId", new String(), true);
    }

    private void doPage(List<String> expected, int skip, int max) {
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM cmis:folder", this.rootNodeRef.getStoreRef());
        options.setSkipCount(skip);
        options.setMaxItems(max);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (int)(skip + max > 10 ? 10 - skip : max), (int)rs.getLength());
        QueryTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (skip + max < 10 ? 1 : 0) != 0, (boolean)rs.hasMore());
        QueryTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (int)skip, (int)rs.getStart());
        int actualPosition = skip;
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("cmis:objectId");
            String id = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)("Skip = " + skip + " max  = " + max + " actual = " + actualPosition), (String)expected.get(actualPosition), (String)id);
            ++actualPosition;
        }
    }

    private CommonTree parse(String query) throws RecognitionException {
        ANTLRStringStream cs = new ANTLRStringStream(query);
        CMISLexer lexer = new CMISLexer((CharStream)cs);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CMISParser parser = new CMISParser((TokenStream)tokens);
        CommonTree queryNode = (CommonTree)parser.query().getTree();
        return queryNode;
    }

    public void test_d_text() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleTextBoth");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)"Un tokenised", (String)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleTextBoth");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:singleTextUntokenised");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)"Un tokenised", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleTextUntokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:singleTextTokenised");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)"Un tokenised", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleTextTokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleTextBoth");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            String[] members = new String[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((String)"Un tokenised", (String)members[0]);
            QueryTest.assertEquals((String)"two parts", (String)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleTextBoth");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleTextUntokenised");
            assert (sValue instanceof Collection);
            collection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            members = new String[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((String)"Un tokenised", (String)members[0]);
            QueryTest.assertEquals((String)"two parts", (String)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleTextUntokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleTextTokenised");
            assert (sValue instanceof Collection);
            collection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            members = new String[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((String)"Un tokenised", (String)members[0]);
            QueryTest.assertEquals((String)"two parts", (String)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleTextTokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextBoth = 'Un tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextBoth <> 'tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextBoth LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextBoth NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextBoth IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextBoth NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'Un tokenised' =  ANY test:singleTextBoth ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleTextBoth IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleTextBoth NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextUntokenised = 'Un tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextUntokenised <> 'tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextUntokenised LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextUntokenised NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextUntokenised IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextUntokenised NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'Un tokenised' =  ANY test:singleTextUntokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleTextUntokenised IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleTextUntokenised NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextTokenised = 'tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextTokenised <> 'tokenized'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextTokenised LIKE 'to%sed'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextTokenised NOT LIKE 'Ut__eniz%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextTokenised IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleTextTokenised NOT IN ('tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'tokenised' =  ANY test:singleTextTokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleTextTokenised IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleTextTokenised NOT IN ('tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE alias = 'Un tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE alias <> 'tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE alias LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE alias NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE 'Un tokenised' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE ANY alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:singleTextBoth as alias FROM test:extendedContent as T WHERE ANY alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE alias = 'Un tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE alias <> 'tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE alias LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE alias NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE 'Un tokenised' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE ANY alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:singleTextUntokenised as alias FROM test:extendedContent as T WHERE ANY alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE alias = 'tokenised'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE alias <> 'tokenized'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE alias LIKE 'to%sed'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE alias NOT LIKE 'Ut__eniz%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE alias IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE alias NOT IN ('tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE 'tokenised' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE ANY alias IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleTextTokenised as alias FROM test:extendedContent WHERE ANY alias NOT IN ('tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextBoth = 'Un tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextBoth <> 'tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextBoth LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextBoth NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextBoth IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextBoth NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'Un tokenised' =  ANY test:multipleTextBoth ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleTextBoth IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleTextBoth NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextUntokenised = 'Un tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextUntokenised <> 'tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextUntokenised LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextUntokenised NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextUntokenised IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextUntokenised NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'Un tokenised' =  ANY test:multipleTextUntokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleTextUntokenised IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleTextUntokenised NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextTokenised = 'tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextTokenised <> 'tokenized'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextTokenised LIKE 'to%sed'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextTokenised NOT LIKE 'Ut__eniz%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextTokenised IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleTextTokenised NOT IN ('tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'tokenised' =  ANY test:multipleTextTokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleTextTokenised IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleTextTokenised NOT IN ('tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE alias = 'Un tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE alias <> 'tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE alias LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE alias NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE 'Un tokenised' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE ANY alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleTextBoth as alias FROM test:extendedContent WHERE ANY alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE alias = 'Un tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE alias <> 'tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE alias LIKE 'U_ to%sed'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE alias NOT LIKE 't__eni%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE 'Un tokenised' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE ANY alias IN ('Un tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleTextUntokenised alias FROM test:extendedContent WHERE ANY alias NOT IN ('Un tokenized')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE alias = 'tokenised'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE alias <> 'tokenized'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE alias LIKE 'to%sed'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE alias NOT LIKE 'Ut__eniz%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE alias IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE alias NOT IN ('tokenized')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE 'tokenised' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE ANY alias IN ('tokenised', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT T.test:multipleTextTokenised alias FROM test:extendedContent T WHERE ANY alias NOT IN ('tokenized')", 1, false, "cmis:name", new String(), false);
    }

    public void test_locale() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA BBBB'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.ENGLISH));
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA BBBB'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.FRENCH));
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA BBBB'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.FRENCH));
        options.setMlAnalaysisMode(MLAnalysisMode.ALL_LANGUAGES);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)0, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.ENGLISH));
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.ENGLISH));
        options.setMlAnalaysisMode(MLAnalysisMode.ALL_LANGUAGES);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)0, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.FRENCH));
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setLocales(Collections.singletonList(Locale.FRENCH));
        options.setIncludeInTransactionData(false);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)0, (int)rs.length());
        rs.close();
        I18NUtil.setLocale((Locale)Locale.UK);
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA BBBB'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setMlAnalaysisMode(MLAnalysisMode.ALL_LANGUAGES);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setMlAnalaysisMode(MLAnalysisMode.ALL_LANGUAGES);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)0, (int)rs.length());
        rs.close();
        I18NUtil.setLocale((Locale)Locale.FRANCE);
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA BBBB'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setMlAnalaysisMode(MLAnalysisMode.ALL_LANGUAGES);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)0, (int)rs.length());
        rs.close();
        options = new CMISQueryOptions("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        options.setMlAnalaysisMode(MLAnalysisMode.ALL_LANGUAGES);
        rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        rs.close();
    }

    public void test_d_mltext() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleMLTextBoth");
            String value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)"AAAA BBBB", (String)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleMLTextBoth");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:singleMLTextUntokenised");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)"AAAA BBBB", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleMLTextUntokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:singleMLTextTokenised");
            value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)sValue);
            QueryTest.assertEquals((String)"AAAA BBBB", (String)value);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleMLTextTokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleMLTextBoth");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)sValue);
            QueryTest.assertEquals((int)1, (int)collection.size());
            String[] members = new String[1];
            members = collection.toArray(members);
            QueryTest.assertEquals((String)"AAAA BBBB", (String)members[0]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleMLTextBoth");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleMLTextUntokenised");
            assert (sValue instanceof Collection);
            collection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)sValue);
            QueryTest.assertEquals((int)1, (int)collection.size());
            members = new String[1];
            members = collection.toArray(members);
            QueryTest.assertEquals((String)"AAAA BBBB", (String)members[0]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleMLTextUntokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleMLTextTokenised");
            assert (sValue instanceof Collection);
            collection = DefaultTypeConverter.INSTANCE.getCollection(String.class, (Object)sValue);
            QueryTest.assertEquals((int)1, (int)collection.size());
            members = new String[1];
            members = collection.toArray(members);
            QueryTest.assertEquals((String)"AAAA BBBB", (String)members[0]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleMLTextTokenised");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.STRING, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA BBBB'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'AAAA'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = '%AAAA'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = '%AAA'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'BBBB'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth = 'CCCC DDDD'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth NOT LIKE 'B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth NOT LIKE 'D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextBoth NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY test:singleMLTextBoth ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY test:singleMLTextBoth ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextBoth IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextBoth IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextBoth NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised = 'AAAA BBBB'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised = 'CCCC DDDD'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised NOT LIKE 'B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised NOT LIKE 'D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextUntokenised NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY test:singleMLTextUntokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY test:singleMLTextUntokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextUntokenised NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised = 'AAAA'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised = 'BBBB'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised = 'CCCC'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised = 'DDDD'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised <> 'EEEE'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised LIKE 'A%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised LIKE '_B__'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised LIKE '%C'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised LIKE 'D%D'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised NOT LIKE 'CCCC_'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleMLTextTokenised NOT IN ('EEEE')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'AAAA' =  ANY test:singleMLTextTokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'BBBB' =  ANY test:singleMLTextTokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'CCCC' =  ANY test:singleMLTextTokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'DDDD' =  ANY test:singleMLTextTokenised ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextTokenised IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextTokenised IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextTokenised IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextTokenised IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleMLTextTokenised NOT IN ('EEEE')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias = 'AAAA BBBB'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias = 'AAAA'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias = 'BBBB'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias = 'CCCC DDDD'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias NOT LIKE 'B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias NOT LIKE 'D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextBoth as alias FROM test:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias = 'AAAA BBBB'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias = 'CCCC DDDD'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias NOT LIKE 'B%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias NOT LIKE 'D%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextUntokenised as alias FROM test:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias = 'AAAA'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias = 'BBBB'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias = 'CCCC'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias = 'DDDD'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias <> 'EEEE'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias LIKE 'A%'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias LIKE '_B__'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias LIKE '%C'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias LIKE 'D%D'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias NOT LIKE 'CCCC_'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE alias NOT IN ('EEEE')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE 'AAAA' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE 'BBBB' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE 'CCCC' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE 'DDDD' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE ANY alias IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE ANY alias IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE ANY alias IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE ANY alias IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleMLTextTokenised as alias FROM test:extendedContent WHERE ANY alias NOT IN ('EEEE')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth = 'AAAA BBBB'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth = 'AAAA'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth = 'BBBB'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth = 'CCCC DDDD'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth NOT LIKE 'B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth NOT LIKE 'D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextBoth NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY test:multipleMLTextBoth ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY test:multipleMLTextBoth ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextBoth IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextBoth IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextBoth NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised = 'AAAA BBBB'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised = 'CCCC DDDD'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised NOT LIKE 'B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised NOT LIKE 'D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextUntokenised NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY test:multipleMLTextUntokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY test:multipleMLTextUntokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextUntokenised IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextUntokenised IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextUntokenised NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised = 'AAAA'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised = 'BBBB'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised = 'CCCC'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised = 'DDDD'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised <> 'EEEE'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised LIKE 'A%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised LIKE '_B__'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised LIKE '%C'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised LIKE 'D%D'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised NOT LIKE 'CCCC_'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleMLTextTokenised NOT IN ('EEEE')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'AAAA' =  ANY test:multipleMLTextTokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'BBBB' =  ANY test:multipleMLTextTokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'CCCC' =  ANY test:multipleMLTextTokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE 'DDDD' =  ANY test:multipleMLTextTokenised ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextTokenised IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextTokenised IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextTokenised IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextTokenised IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleMLTextTokenised NOT IN ('EEEE')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias = 'AAAA BBBB'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias = 'AAAA'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias = 'BBBB'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias = 'CCCC DDDD'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias NOT LIKE 'B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias NOT LIKE 'D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextBoth alias FROM test:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias = 'AAAA BBBB'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias = 'CCCC DDDD'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias <> 'EEEE FFFF'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias LIKE 'AAA_ B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias LIKE 'CCC_ D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias NOT LIKE 'B%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias NOT LIKE 'D%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE 'AAAA BBBB' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE 'CCCC DDDD' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE ANY alias IN ('AAAA BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE ANY alias IN ('CCCC DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextUntokenised alias FROM test:extendedContent WHERE ANY alias NOT IN ('EEEE FFFF')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias = 'AAAA'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias = 'BBBB'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias = 'CCCC'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias = 'DDDD'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias <> 'EEEE'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias LIKE 'A%'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias LIKE '_B__'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias LIKE '%C'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias LIKE 'D%D'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias NOT LIKE 'CCCC_'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE alias NOT IN ('EEEE')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE 'AAAA' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE 'BBBB' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE 'CCCC' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE 'DDDD' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE ANY alias IN ('AAAA', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE ANY alias IN ('BBBB', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE ANY alias IN ('CCCC', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE ANY alias IN ('DDDD', 'Monkey')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleMLTextTokenised alias FROM test:extendedContent WHERE ANY alias NOT IN ('EEEE')", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_float() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleFloat");
            Float value = (Float)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)sValue);
            QueryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleFloat");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DECIMAL, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleFloat");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Float.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Float[] members = new Float[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)Float.valueOf(1.0f), (Object)members[0]);
            QueryTest.assertEquals((Object)Float.valueOf(1.1f), (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleFloat");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DECIMAL, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat = 1.1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat <> 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat < 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat <= 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat > 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat >= 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleFloat NOT IN (1.1)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:singleFloat ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1.1' =  ANY test:singleFloat ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleFloat IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleFloat NOT IN (1.1, 2.2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias = 1.1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias <> 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias < 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias <= 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias > 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias >= 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE alias NOT IN (1.1)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE '1.1' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleFloat as alias FROM test:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat = 1.1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat <> 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat < 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat <= 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat > 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat >= 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleFloat NOT IN (1.1)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:multipleFloat ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1.1' =  ANY test:multipleFloat ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleFloat IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleFloat IN (1.1, 2.2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleFloat NOT IN (1.1, 2.2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleFloat NOT IN (1.3, 2.3)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleFloat as alias  FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias = 1.1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias <> 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias < 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias <= 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias > 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias >= 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE alias NOT IN (1.1)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE '1.1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE ANY alias IN (1.1, 2.2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleFloat as alias FROM test:extendedContent WHERE ANY alias NOT IN (1.3, 2.3)", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_double() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleDouble");
            Double value = (Double)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)sValue);
            QueryTest.assertEquals((Object)1.0, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleDouble");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DECIMAL, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleDouble");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Double.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Double[] members = new Double[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)1.0, (Object)members[0]);
            QueryTest.assertEquals((Object)1.1, (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleDouble");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DECIMAL, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble = 1.1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble <> 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble < 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble <= 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble > 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble >= 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDouble NOT IN (1.1)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:singleDouble ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1.1' =  ANY test:singleDouble ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleDouble IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleDouble NOT IN (1.1, 2.2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias = 1.1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias <> 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias < 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias <= 1.1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias > 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias >= 0.9", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE alias NOT IN (1.1)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE '1.1' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDouble alias FROM test:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble = 1.1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble <> 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble < 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble <= 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble > 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble >= 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDouble NOT IN (1.1)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:multipleDouble ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1.1' =  ANY test:multipleDouble ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDouble IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDouble IN (1.1, 2.2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDouble NOT IN (1.1, 2.2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDouble NOT IN (1.3, 2.3)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias = 1.1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias <> 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias < 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias <= 1.1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias > 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias >= 0.9", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE alias NOT IN (1.1)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE '1.1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE ANY alias IN (1.1, 2.2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE ANY alias NOT IN (1.1, 2.2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDouble alias FROM test:extendedContent WHERE ANY alias NOT IN (1.3, 2.3)", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_int() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleInteger");
            Integer value = (Integer)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)sValue);
            QueryTest.assertEquals((Object)1, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleInteger");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.INTEGER, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleInteger");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Integer.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Integer[] members = new Integer[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)1, (Object)members[0]);
            QueryTest.assertEquals((Object)2, (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleInteger");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.INTEGER, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger = 2", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger <> 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger < 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger <= 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger > 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger >= 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleInteger NOT IN (2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:singleInteger ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '2' =  ANY test:singleInteger ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleInteger IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleInteger NOT IN (2, 3)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias = 2", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias <> 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias < 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias <= 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias > 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias >= 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE alias NOT IN (2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE '2' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleInteger alias FROM test:extendedContent WHERE ANY alias NOT IN (2, 3)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger = 2", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger <> 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger < 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger <= 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger > 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger >= 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleInteger NOT IN (2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:multipleInteger ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '2' =  ANY test:multipleInteger ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleInteger IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleInteger IN (2, 3)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleInteger NOT IN (1, 2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleInteger NOT IN (2, 3)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleInteger NOT IN (3, 4)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias = 2", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias <> 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias < 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias <= 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias > 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias >= 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE alias NOT IN (2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE '2' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE ANY alias IN (2, 3)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE ANY alias NOT IN (1, 2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE ANY alias NOT IN (2, 3)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleInteger as alias FROM test:extendedContent WHERE ANY alias NOT IN (3, 4)", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_long() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleLong");
            Long value = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)sValue);
            QueryTest.assertEquals((Object)1L, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleLong");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.INTEGER, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleLong");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Long.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Long[] members = new Long[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)1L, (Object)members[0]);
            QueryTest.assertEquals((Object)2L, (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleLong");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.INTEGER, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong = 2", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong <> 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong < 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong <= 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong > 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong >= 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleLong NOT IN (2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:singleLong ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '2' =  ANY test:singleLong ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleLong IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleLong NOT IN (2, 3)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias = 2", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias <> 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias < 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias <= 2", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias > 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias >= 0", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE alias NOT IN (2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE '2' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleLong as alias FROM test:extendedContent WHERE ANY alias NOT IN (2, 3)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT alias FROM test:extendedContent WHERE test:multipleLong = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong = 2", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong <> 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong < 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong <= 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong > 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong >= 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleLong NOT IN (2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:multipleLong ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '2' =  ANY test:multipleLong ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleLong IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleLong IN (2, 3)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleLong NOT IN (1, 2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleLong NOT IN (2, 3)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleLong NOT IN (3, 4)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias = 2", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias <> 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias < 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias <= 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias > 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias >= 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE alias NOT IN (2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE '2' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE ANY alias IN (2, 3)", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE ANY alias NOT IN (1, 2)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE ANY alias NOT IN (2, 3)", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleLong alias FROM test:extendedContent WHERE ANY alias NOT IN (3, 4)", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_date() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleDate");
            Date value = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)sValue);
            QueryTest.assertEquals((Object)this.date1, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleDate");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleDate");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Date.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Date[] members = new Date[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)this.date1, (Object)members[0]);
            QueryTest.assertEquals((Object)this.date2, (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleDate");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSSZ");
        String d0 = df1.format(this.date0);
        StringBuilder builder = new StringBuilder();
        builder.append(d0);
        builder.insert(builder.length() - 2, ':');
        d0 = builder.toString();
        String d1 = df1.format(this.date1);
        builder = new StringBuilder();
        builder.append(d1);
        builder.insert(builder.length() - 2, ':');
        d1 = builder.toString();
        String d2 = df1.format(this.date2);
        builder = new StringBuilder();
        builder.append(d2);
        builder.insert(builder.length() - 2, ':');
        d2 = builder.toString();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate LIKE TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDate NOT IN (TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY test:singleDate ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY test:singleDate ", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleDate IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleDate NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias LIKE TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias ", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDate as alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate LIKE TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDate NOT IN (TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY test:multipleDate ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY test:multipleDate ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDate IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDate IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDate NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDate NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDate NOT IN (TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias LIKE TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDate alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_datetime() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleDatetime");
            Date value = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)sValue);
            QueryTest.assertEquals((Object)this.date1, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleDatetime");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleDatetime");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Date.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Date[] members = new Date[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)this.date1, (Object)members[0]);
            QueryTest.assertEquals((Object)this.date2, (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleDatetime");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.DATETIME, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'SSSZ");
        String d0 = df1.format(this.date0);
        StringBuilder builder = new StringBuilder();
        builder.append(d0);
        builder.insert(builder.length() - 2, ':');
        d0 = builder.toString();
        String d1 = df1.format(this.date1);
        builder = new StringBuilder();
        builder.append(d1);
        builder.insert(builder.length() - 2, ':');
        d1 = builder.toString();
        String d2 = df1.format(this.date2);
        builder = new StringBuilder();
        builder.append(d2);
        builder.insert(builder.length() - 2, ':');
        d2 = builder.toString();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime LIKE TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleDatetime NOT IN (TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY test:singleDatetime ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY test:singleDatetime ", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleDatetime IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleDatetime NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias LIKE TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias IN (TIMESTAMP '" + d0 + "' ,TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias ", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleDatetime alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime LIKE TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleDatetime NOT IN (TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY test:multipleDatetime ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY test:multipleDatetime ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDatetime IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDatetime IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDatetime NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDatetime NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleDatetime NOT IN (TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias = TIMESTAMP '" + d2 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias <> TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias < TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias <= TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d1 + "'", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias > TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d1 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias >= TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias LIKE TIMESTAMP '" + d0 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias NOT LIKE TIMESTAMP '" + d2 + "'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE alias NOT IN (TIMESTAMP '" + d1 + "')", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE TIMESTAMP '" + d1 + "' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE TIMESTAMP '" + d2 + "' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE ANY alias IN (TIMESTAMP '" + d2 + "', TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "', TIMESTAMP '" + d1 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d1 + "', TIMESTAMP '" + d2 + "')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleDatetime alias FROM test:extendedContent WHERE ANY alias NOT IN (TIMESTAMP '" + d0 + "')", 1, false, "cmis:name", new String(), false);
    }

    public void test_d_boolean() throws Exception {
        this.addTypeTestData();
        QueryTest.assertNotNull((Object)this.dictionaryService.getType(this.extendedContent));
        QueryTest.assertNotNull((Object)this.cmisDictionaryService.findTypeByQueryName("test:extendedContent"));
        this.testQuery("SELECT * FROM test:extendedContent", 1, false, "cmis:name", new String(), false);
        CMISQueryOptions options = new CMISQueryOptions("SELECT * FROM test:extendedContent", this.rootNodeRef.getStoreRef());
        options.setDefaultFTSConnective(QueryOptions.Connective.OR);
        options.setDefaultFTSFieldConnective(QueryOptions.Connective.OR);
        CMISResultSet rs = this.cmisQueryService.query(options);
        QueryTest.assertEquals((int)1, (int)rs.length());
        Iterator i$ = rs.iterator();
        while (i$.hasNext()) {
            CMISResultSetRow row = (CMISResultSetRow)i$.next();
            Serializable sValue = row.getValue("test:singleBoolean");
            Boolean value = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue);
            QueryTest.assertEquals((Object)Boolean.TRUE, (Object)value);
            CMISResultSetColumn column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:singleBoolean");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.SINGLE_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
            sValue = row.getValue("test:multipleBoolean");
            assert (sValue instanceof Collection);
            Collection collection = DefaultTypeConverter.INSTANCE.getCollection(Boolean.class, (Object)sValue);
            QueryTest.assertEquals((int)2, (int)collection.size());
            Boolean[] members = new Boolean[2];
            members = collection.toArray(members);
            QueryTest.assertEquals((Object)Boolean.TRUE, (Object)members[0]);
            QueryTest.assertEquals((Object)Boolean.FALSE, (Object)members[1]);
            column = ((CMISResultSetMetaData)rs.getResultSetMetaData()).getColumn("test:multipleBoolean");
            QueryTest.assertEquals((Object)CMISDataTypeEnum.BOOLEAN, (Object)column.getCMISDataType());
            QueryTest.assertEquals((Object)CMISCardinalityEnum.MULTI_VALUED, (Object)column.getCMISPropertyDefinition().getCardinality());
        }
        rs.close();
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean = TRUE", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean = true", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean = FALSE", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean = false", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean = TRue", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean <> TRUE", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean <> FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean < TRUE", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean < FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean <= TRUE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean <= FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean > TRUE", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean > FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean >= TRUE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean >= FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean LIKE 'TRUE'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean NOT LIKE 'FALSE'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean IN (TRUE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:singleBoolean NOT IN (FALSE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE TRUE =  ANY test:singleBoolean ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE FALSE =  ANY test:singleBoolean ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleBoolean IN (TRUE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:singleBoolean NOT IN (FALSE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias = TRUE", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias = true", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias = FALSE", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias = false", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias = TRue", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias <> TRUE", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias <> FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias < TRUE", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias < FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias <= TRUE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias <= FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias > TRUE", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias > FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias >= TRUE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias >= FALSE", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias LIKE 'TRUE'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias NOT LIKE 'FALSE'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias IN (TRUE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE alias NOT IN (FALSE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE TRUE =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE FALSE =  ANY alias ", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE ANY alias IN (TRUE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:singleBoolean alias FROM test:extendedContent WHERE ANY alias NOT IN (FALSE)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean = 2", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean <> 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean < 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean <= 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean > 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean >= 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE test:multipleBoolean NOT IN (2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '1' =  ANY test:multipleBoolean ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE '2' =  ANY test:multipleBoolean ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleBoolean IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleBoolean IN (2, 3)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleBoolean NOT IN (1, 2)", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleBoolean NOT IN (2, 3)", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM test:extendedContent WHERE ANY test:multipleBoolean NOT IN (3, 4)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias = 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias = 2", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias <> 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias <> 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias < 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias < 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias <= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias <= 2", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias > 1", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias > 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias >= 1", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias >= 0", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias LIKE '1'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias NOT LIKE '2'", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE alias NOT IN (2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE '1' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE '2' =  ANY alias ", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE ANY alias IN (1, 2)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE ANY alias IN (2, 3)", 1, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE ANY alias NOT IN (1, 2)", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE ANY alias NOT IN (2, 3)", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT test:multipleBoolean as alias FROM test:extendedContent WHERE ANY alias NOT IN (3, 4)", 1, false, "cmis:name", new String(), true);
    }

    public void testBasicContainsSyntax() throws Exception {
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('one')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('-quick')", 9, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick brown fox')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick one')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick -one')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('-quick one')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('-quick -one')", 8, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('fox brown quick')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR one')", 2, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR -one')", 9, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('-quick OR -one')", 10, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\'')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'fox brown quick\\'')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\' one')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('\\'quick brown fox\\' -one')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('-\\'quick brown fox\\' one')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('-\\'quick brown fox\\' -one')", 8, false, "cmis:name", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:folder WHERE CONTAINS('cmis:name:\\'Folder 9\\\\\\'\\'')", 1, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown one')", 1, false, "cmis:name", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown AND one')", 1, false, "cmis:name", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR (brown AND one)')", 1, false, "cmis:name", new String(), false);
        this.testExtendedQuery("SELECT * FROM cmis:document WHERE CONTAINS('(quick OR brown) AND one')", 0, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown OR one')", 2, false, "cmis:name", new String(), false);
        this.testQuery("SELECT * FROM cmis:document WHERE CONTAINS('quick OR brown one')", 1, false, "cmis:name", new String(), false);
    }

    public void testOrderableProperties() {
        this.addTypeSortTestData();
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleTextUntokenised").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleTextTokenised").isOrderable());
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleTextBoth").isOrderable());
        this.testOrderableProperty("test:singleTextUntokenised");
        this.testOrderablePropertyFail("test:singleTextTokenised");
        this.testOrderableProperty("test:singleTextBoth");
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleTextUntokenised").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleTextTokenised").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleTextBoth").isOrderable());
        this.testOrderablePropertyFail("test:multipleTextUntokenised");
        this.testOrderablePropertyFail("test:multipleTextTokenised");
        this.testOrderablePropertyFail("test:multipleTextBoth");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleMLTextUntokenised").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleMLTextTokenised").isOrderable());
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleMLTextBoth").isOrderable());
        this.testOrderableProperty("test:singleMLTextUntokenised");
        this.testOrderablePropertyFail("test:singleMLTextTokenised");
        this.testOrderableProperty("test:singleMLTextBoth");
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleMLTextUntokenised").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleMLTextTokenised").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleMLTextBoth").isOrderable());
        this.testOrderablePropertyFail("test:multipleMLTextUntokenised");
        this.testOrderablePropertyFail("test:multipleMLTextTokenised");
        this.testOrderablePropertyFail("test:multipleMLTextBoth");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleFloat").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleFloat").isOrderable());
        this.testOrderableProperty("test:singleFloat");
        this.testOrderablePropertyFail("test:multipleFloat");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleDouble").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleDouble").isOrderable());
        this.testOrderableProperty("test:singleDouble");
        this.testOrderablePropertyFail("test:multipleDouble");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleInteger").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleInteger").isOrderable());
        this.testOrderableProperty("test:singleInteger");
        this.testOrderablePropertyFail("test:multipleInteger");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleLong").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleLong").isOrderable());
        this.testOrderableProperty("test:singleLong");
        this.testOrderablePropertyFail("test:multipleLong");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleDate").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleDate").isOrderable());
        this.testOrderableProperty("test:singleDate");
        this.testOrderablePropertyFail("test:multipleDate");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleDatetime").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleDatetime").isOrderable());
        this.testOrderableProperty("test:singleDatetime");
        this.testOrderablePropertyFail("test:multipleDatetime");
        QueryTest.assertTrue((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:singleBoolean").isOrderable());
        QueryTest.assertFalse((boolean)this.cmisDictionaryService.findPropertyByQueryName("test:multipleBoolean").isOrderable());
        this.testOrderableProperty("test:singleBoolean");
        this.testOrderablePropertyFail("test:multipleBoolean");
    }

    public void testNonQueryableTypes() throws Exception {
        this.testQuery("SELECT * FROM cmis:policy", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM cmis:relationship ", 0, false, "cmis:name", new String(), true);
        this.testQuery("SELECT * FROM cm:ownable ", 0, false, "cmis:name", new String(), true);
        this.testExtendedQuery("SELECT * FROM cm:ownable ", 1, false, "cmis:name", new String(), false);
    }

    private void testOrderableProperty(String propertyQueryName) {
        this.testOrderBy("SELECT " + propertyQueryName + " FROM test:extendedContent ORDER BY " + propertyQueryName + " ASC", 13, false, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, propertyQueryName);
        this.testOrderBy("SELECT " + propertyQueryName + " FROM test:extendedContent ORDER BY " + propertyQueryName + " DESC", 13, false, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, propertyQueryName);
        this.testOrderBy("SELECT " + propertyQueryName + " FROM test:extendedContent ORDER BY " + propertyQueryName + " DESC", 13, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, propertyQueryName);
    }

    private void testOrderablePropertyFail(String propertyQueryName) {
        this.testOrderBy("SELECT " + propertyQueryName + " FROM test:extendedContent ORDER BY " + propertyQueryName + " ASC", 13, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, propertyQueryName);
        this.testOrderBy("SELECT " + propertyQueryName + " FROM test:extendedContent ORDER BY " + propertyQueryName + " DESC", 13, true, Order.DESCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, propertyQueryName);
        this.testOrderBy("SELECT " + propertyQueryName + " FROM test:extendedContent ORDER BY " + propertyQueryName + " DESC", 13, true, Order.ASCENDING, CMISQueryOptions.CMISQueryMode.CMS_STRICT, propertyQueryName);
    }

    private void addTypeTestDataModel() {
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/cmis/search/CMIS-query-test-model.xml");
        QueryTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        this.dictionaryDAO.putModel(model);
        ((CMISAbstractDictionaryService)this.cmisDictionaryService).afterDictionaryDestroy();
        ((CMISAbstractDictionaryService)this.cmisDictionaryService).afterDictionaryInit();
        this.namespaceDao.addPrefix("test", TEST_NAMESPACE);
    }

    private void addTypeSortTestData() {
        this.addTypeTestDataModel();
        this.addSortableNull();
        for (int i = 0; i < 10; ++i) {
            this.addSortableNode(i);
            if (i != 5) continue;
            this.addSortableNull();
        }
        this.addSortableNull();
    }

    private NodeRef addSortableNull() {
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        MLText ml = new MLText();
        ml.addValue(Locale.ENGLISH, "Test null");
        properties.put(ContentModel.PROP_DESCRIPTION, ml);
        properties.put(ContentModel.PROP_TITLE, ml);
        properties.put(ContentModel.PROP_NAME, "Test null");
        properties.put(ContentModel.PROP_CREATED, new Date());
        NodeRef c0 = this.nodeService.createNode(this.f0, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Test One", (NamespacePrefixResolver)this.namespaceService), this.extendedContent, properties).getChildRef();
        return c0;
    }

    private NodeRef addSortableNode(int position) {
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        MLText ml = new MLText();
        ml.addValue(Locale.ENGLISH, "Test " + position);
        properties.put(ContentModel.PROP_DESCRIPTION, ml);
        properties.put(ContentModel.PROP_TITLE, ml);
        properties.put(ContentModel.PROP_NAME, "Test " + position);
        properties.put(ContentModel.PROP_CREATED, new Date());
        properties.put(this.singleTextUntokenised, orderable[position]);
        properties.put(this.singleTextTokenised, orderable[position]);
        properties.put(this.singleTextBoth, orderable[position]);
        properties.put(this.multipleTextUntokenised, this.asArray(orderable[position], orderable[position + 1]));
        properties.put(this.multipleTextTokenised, this.asArray(orderable[position], orderable[position + 1]));
        properties.put(this.multipleTextBoth, this.asArray(orderable[position], orderable[position + 1]));
        properties.put(this.singleMLTextUntokenised, this.makeMLText(position));
        properties.put(this.singleMLTextTokenised, this.makeMLText(position));
        properties.put(this.singleMLTextBoth, this.makeMLText(position));
        properties.put(this.multipleMLTextUntokenised, this.makeMLTextMVP(position));
        properties.put(this.multipleMLTextTokenised, this.makeMLTextMVP(position));
        properties.put(this.multipleMLTextBoth, this.makeMLTextMVP(position));
        properties.put(this.singleFloat, Float.valueOf(1.1f * (float)position));
        properties.put(this.multipleFloat, this.asArray(Float.valueOf(1.1f * (float)position), Float.valueOf(2.2f * (float)position)));
        properties.put(this.singleDouble, 1.1 * (double)position);
        properties.put(this.multipleDouble, this.asArray(1.1 * (double)position, 2.2 * (double)position));
        properties.put(this.singleInteger, 1 * position);
        properties.put(this.multipleInteger, this.asArray(1 * position, 2 * position));
        properties.put(this.singleLong, 1L * (long)position);
        properties.put(this.multipleLong, this.asArray(1L * (long)position, 2L * (long)position));
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        cal.add(5, position);
        Date d1 = cal.getTime();
        cal.add(5, -1);
        cal.add(5, 2);
        Date d2 = cal.getTime();
        properties.put(this.singleDate, d1);
        properties.put(this.multipleDate, this.asArray(d1, d2));
        properties.put(this.singleDatetime, d1);
        properties.put(this.multipleDatetime, this.asArray(d1, d2));
        properties.put(this.singleBoolean, position % 2 == 0);
        properties.put(this.multipleBoolean, this.asArray(true, false));
        NodeRef c0 = this.nodeService.createNode(this.f0, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Test One", (NamespacePrefixResolver)this.namespaceService), this.extendedContent, properties).getChildRef();
        return c0;
    }

    private NodeRef addTypeTestData() {
        this.addTypeTestDataModel();
        I18NUtil.setLocale((Locale)Locale.UK);
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        MLText ml = new MLText();
        ml.addValue(Locale.ENGLISH, "Test one");
        ml.addValue(Locale.US, "Test 1");
        properties.put(ContentModel.PROP_DESCRIPTION, ml);
        properties.put(ContentModel.PROP_TITLE, ml);
        properties.put(ContentModel.PROP_NAME, "Test one");
        properties.put(ContentModel.PROP_CREATED, new Date());
        properties.put(this.singleTextUntokenised, "Un tokenised");
        properties.put(this.singleTextTokenised, "Un tokenised");
        properties.put(this.singleTextBoth, "Un tokenised");
        properties.put(this.multipleTextUntokenised, this.asArray("Un tokenised", "two parts"));
        properties.put(this.multipleTextTokenised, this.asArray("Un tokenised", "two parts"));
        properties.put(this.multipleTextBoth, this.asArray("Un tokenised", "two parts"));
        properties.put(this.singleMLTextUntokenised, this.makeMLText());
        properties.put(this.singleMLTextTokenised, this.makeMLText());
        properties.put(this.singleMLTextBoth, this.makeMLText());
        properties.put(this.multipleMLTextUntokenised, this.makeMLTextMVP());
        properties.put(this.multipleMLTextTokenised, this.makeMLTextMVP());
        properties.put(this.multipleMLTextBoth, this.makeMLTextMVP());
        properties.put(this.singleFloat, Float.valueOf(1.0f));
        properties.put(this.multipleFloat, this.asArray(Float.valueOf(1.0f), Float.valueOf(1.1f)));
        properties.put(this.singleDouble, 1.0);
        properties.put(this.multipleDouble, this.asArray(1.0, 1.1));
        properties.put(this.singleInteger, 1);
        properties.put(this.multipleInteger, this.asArray(1, 2));
        properties.put(this.singleLong, 1L);
        properties.put(this.multipleLong, this.asArray(1L, 2L));
        this.date1 = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date1);
        cal.add(5, -1);
        this.date0 = cal.getTime();
        cal.add(5, 2);
        this.date2 = cal.getTime();
        properties.put(this.singleDate, this.date1);
        properties.put(this.multipleDate, this.asArray(this.date1, this.date2));
        properties.put(this.singleDatetime, this.date1);
        properties.put(this.multipleDatetime, this.asArray(this.date1, this.date2));
        properties.put(this.singleBoolean, true);
        properties.put(this.multipleBoolean, this.asArray(true, false));
        NodeRef c0 = this.nodeService.createNode(this.f0, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"Test One", (NamespacePrefixResolver)this.namespaceService), this.extendedContent, properties).getChildRef();
        return c0;
    }

    private MLText makeMLText() {
        return this.makeMLText(0);
    }

    private MLText makeMLText(int position) {
        MLText ml = new MLText();
        ml.addValue(Locale.ENGLISH, mlOrderable_en[position]);
        ml.addValue(Locale.FRENCH, mlOrderable_fr[position]);
        return ml;
    }

    private ArrayList<MLText> makeMLTextMVP() {
        return this.makeMLTextMVP(0);
    }

    private ArrayList<MLText> makeMLTextMVP(int position) {
        MLText m1 = new MLText();
        m1.addValue(Locale.ENGLISH, mlOrderable_en[position]);
        MLText m2 = new MLText();
        m2.addValue(Locale.FRENCH, mlOrderable_fr[position]);
        ArrayList<MLText> answer = new ArrayList<MLText>(2);
        answer.add(m1);
        answer.add(m2);
        return answer;
    }

    private <T> ArrayList<T> asArray(T ... ts) {
        ArrayList<T> list = new ArrayList<T>(ts.length);
        for (T t : ts) {
            list.add(t);
        }
        return list;
    }
}

