/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import java.util.Map;
import org.alfresco.email.server.AliasableAspect;
import org.alfresco.email.server.EmailServerModel;
import org.alfresco.email.server.handler.EmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.email.EmailService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailServiceImpl
implements EmailService {
    private static final String ERR_INBOUND_EMAIL_DISABLED = "email.server.err.inbound_mail_disabled";
    private static final String ERR_INVALID_SUBJECT = "email.server.err.invalid_subject";
    private static final String ERR_ACCESS_DENIED = "email.server.err.access_denied";
    private static final String ERR_UNKNOWN_SOURCE_ADDRESS = "email.server.err.unknown_source_address";
    private static final String ERR_USER_NOT_EMAIL_CONTRIBUTOR = "email.server.err.user_not_email_contributor";
    private static final String ERR_INVALID_NODE_ADDRESS = "email.server.err.invalid_node_address";
    private static final String ERR_HANDLER_NOT_FOUND = "email.server.err.handler_not_found";
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private AuthorityService authorityService;
    private boolean emailInboundEnabled;
    private String unknownUser;
    private Map<String, EmailMessageHandler> emailMessageHandlerMap;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public Map<String, EmailMessageHandler> getEmailMessageHandlerMap() {
        return this.emailMessageHandlerMap;
    }

    public void setEmailMessageHandlerMap(Map<String, EmailMessageHandler> emailMessageHandlerMap) {
        this.emailMessageHandlerMap = emailMessageHandlerMap;
    }

    public void setUnknownUser(String unknownUser) {
        this.unknownUser = unknownUser;
    }

    public void setEmailInboundEnabled(boolean mailInboundEnabled) {
        this.emailInboundEnabled = mailInboundEnabled;
    }

    @Override
    public void importMessage(EmailMessage message) {
        this.processMessage(null, message);
    }

    @Override
    public void importMessage(NodeRef nodeRef, EmailMessage message) {
        this.processMessage(nodeRef, message);
    }

    private void processMessage(final NodeRef nodeRef, final EmailMessage message) {
        if (!this.emailInboundEnabled) {
            throw new EmailMessageException(ERR_INBOUND_EMAIL_DISABLED, new Object[0]);
        }
        try {
            final RetryingTransactionHelper.RetryingTransactionCallback<String> getUsernameCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    String from = message.getFrom();
                    return EmailServiceImpl.this.getUsername(from);
                }
            };
            AuthenticationUtil.RunAsWork<String> getUsernameRunAsWork = new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    return (String)EmailServiceImpl.this.retryingTransactionHelper.doInTransaction(getUsernameCallback, false);
                }
            };
            String username = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getUsernameRunAsWork, (String)"System");
            final RetryingTransactionHelper.RetryingTransactionCallback<Object> processMessageCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    String recipient = message.getTo();
                    NodeRef targetNodeRef = null;
                    targetNodeRef = nodeRef == null ? EmailServiceImpl.this.getTargetNode(recipient) : nodeRef;
                    EmailMessageHandler messageHandler = EmailServiceImpl.this.getMessageHandler(targetNodeRef);
                    messageHandler.processMessage(targetNodeRef, message);
                    return null;
                }
            };
            AuthenticationUtil.RunAsWork<Object> processMessageRunAsWork = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    return EmailServiceImpl.this.retryingTransactionHelper.doInTransaction(processMessageCallback, false);
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)processMessageRunAsWork, (String)username);
        }
        catch (EmailMessageException e) {
            throw e;
        }
        catch (AccessDeniedException e) {
            throw new EmailMessageException(ERR_ACCESS_DENIED, message.getFrom(), message.getTo());
        }
        catch (IntegrityException e) {
            throw new EmailMessageException(ERR_INVALID_SUBJECT, new Object[0]);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Email message processing failed", e);
        }
    }

    private EmailMessageHandler getMessageHandler(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        String prefixedNodeTypeStr = nodeTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        EmailMessageHandler handler = this.emailMessageHandlerMap.get(prefixedNodeTypeStr);
        if (handler == null) {
            throw new EmailMessageException(ERR_HANDLER_NOT_FOUND, prefixedNodeTypeStr);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef getTargetNode(String recipient) {
        if (recipient == null || recipient.length() == 0) {
            throw new EmailMessageException(ERR_INVALID_NODE_ADDRESS, recipient);
        }
        String[] parts = recipient.split("@");
        if (parts.length != 2) {
            throw new EmailMessageException(ERR_INVALID_NODE_ADDRESS, recipient);
        }
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        String query = String.format(AliasableAspect.SEARCH_TEMPLATE, parts[0]);
        ResultSet resultSet = this.searchService.query(storeRef, "lucene", query);
        try {
            for (int i = 0; i < resultSet.length(); ++i) {
                NodeRef resRef = resultSet.getNodeRef(i);
                String alias = (String)((Object)this.nodeService.getProperty(resRef, EmailServerModel.PROP_ALIAS));
                if (!parts[0].equalsIgnoreCase(alias)) continue;
                NodeRef nodeRef = resRef;
                return nodeRef;
            }
        }
        finally {
            resultSet.close();
        }
        query = "@sys\\:node-dbid:" + parts[0];
        try {
            resultSet = this.searchService.query(storeRef, "lucene", query);
            if (resultSet.length() > 0) {
                NodeRef nodeRef = resultSet.getNodeRef(0);
                return nodeRef;
            }
        }
        finally {
            resultSet.close();
        }
        throw new EmailMessageException(ERR_INVALID_NODE_ADDRESS, recipient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUsername(String from) {
        String userName;
        block7: {
            userName = null;
            StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
            String query = "TYPE:cm\\:person +@cm\\:email:\"" + from + "\"";
            ResultSet resultSet = this.searchService.query(storeRef, "lucene", query);
            try {
                if (resultSet.length() == 0) {
                    if (this.unknownUser == null || this.unknownUser.length() == 0) {
                        throw new EmailMessageException(ERR_UNKNOWN_SOURCE_ADDRESS, from);
                    }
                    userName = this.unknownUser;
                    break block7;
                }
                NodeRef userNode = resultSet.getNodeRef(0);
                if (this.nodeService.exists(userNode)) {
                    userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_USERNAME));
                    break block7;
                }
                throw new EmailMessageException(ERR_UNKNOWN_SOURCE_ADDRESS, from);
            }
            finally {
                resultSet.close();
            }
        }
        if (userName == null || !this.isEmailContributeUser(userName)) {
            throw new EmailMessageException(ERR_USER_NOT_EMAIL_CONTRIBUTOR, userName);
        }
        return userName;
    }

    private boolean isEmailContributeUser(String userName) {
        return this.authorityService.getContainingAuthorities(AuthorityType.GROUP, userName, false).contains(this.authorityService.getName(AuthorityType.GROUP, "EMAIL_CONTRIBUTORS"));
    }
}

