/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.handler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.email.server.handler.AbstractEmailMessageHandler;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;

public abstract class AbstractForumEmailMessageHandler
extends AbstractEmailMessageHandler {
    protected NodeRef addPostNode(NodeRef nodeRef, EmailMessage message) {
        NodeService nodeService = this.getNodeService();
        Date now = new Date();
        String nodeName = "posted-" + new SimpleDateFormat("dd-MM-yyyy-hh-mm-ss").format(now) + ".html";
        PropertyMap properties = new PropertyMap(3);
        properties.put(ContentModel.PROP_NAME, nodeName);
        NodeRef postNodeRef = nodeService.getChildByName(nodeRef, ContentModel.ASSOC_CONTAINS, nodeName);
        if (postNodeRef == null) {
            ChildAssociationRef childAssoc = nodeService.createNode(nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), ForumModel.TYPE_POST, (Map)properties);
            postNodeRef = childAssoc.getChildRef();
        }
        properties.clear();
        properties.put(ContentModel.PROP_TITLE, nodeName);
        nodeService.addAspect(postNodeRef, ContentModel.ASPECT_TITLED, (Map)properties);
        properties.clear();
        properties.put(ApplicationModel.PROP_EDITINLINE, true);
        nodeService.addAspect(postNodeRef, ApplicationModel.ASPECT_INLINEEDITABLE, (Map)properties);
        if (message.getBody() != null) {
            this.writeContent(postNodeRef, message.getBody().getContent(), message.getBody().getContentType(), message.getBody().getEncoding());
        } else {
            this.writeContent(postNodeRef, "<The message was empty>");
        }
        this.addEmailedAspect(postNodeRef, message);
        return postNodeRef;
    }

    protected NodeRef getTopicNode(NodeRef nodeRef, String subject) {
        List assocRefList = this.getNodeService().getChildAssocs(nodeRef);
        for (ChildAssociationRef assocRef : assocRefList) {
            if (!assocRef.getQName().getLocalName().equals(subject)) continue;
            return assocRef.getChildRef();
        }
        return null;
    }

    protected NodeRef addTopicNode(NodeRef parentNode, String name) {
        NodeService nodeService = this.getNodeService();
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, name);
        NodeRef topicNode = nodeService.getChildByName(parentNode, ContentModel.ASSOC_CONTAINS, name);
        if (topicNode == null) {
            ChildAssociationRef association = nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ForumModel.TYPE_TOPIC, properties);
            topicNode = association.getChildRef();
        }
        properties.clear();
        properties.put(ApplicationModel.PROP_ICON, "topic");
        this.getNodeService().addAspect(topicNode, ApplicationModel.ASPECT_UIFACETS, properties);
        return topicNode;
    }
}

