/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.alfresco.filesys.CIFSServerBean;
import org.alfresco.filesys.FTPServerBean;
import org.alfresco.filesys.FileServerConfigMBean;
import org.alfresco.filesys.NFSServerBean;
import org.alfresco.filesys.util.CifsMounter;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.util.Platform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileServerConfig
implements FileServerConfigMBean {
    private static final Log logger = LogFactory.getLog(FileServerConfig.class);
    private ServerConfiguration m_serverConfig;
    private FTPServerBean m_ftpServer;
    private CIFSServerBean m_smbServer;
    private NFSServerBean m_nfsServer;

    public ServerConfiguration getFileServerConfiguration() {
        return this.m_serverConfig;
    }

    public void setFileServerConfiguration(ServerConfiguration serverConfig) {
        this.m_serverConfig = serverConfig;
    }

    public void setCifsServer(CIFSServerBean smbServer) {
        this.m_smbServer = smbServer;
    }

    public boolean isCIFSServerEnabled() {
        return this.m_smbServer.isStarted() && this.m_serverConfig.hasConfigSection("CIFS");
    }

    public void setCIFSServerEnabled(boolean enabled) throws Exception {
        if (!enabled && this.isCIFSServerEnabled()) {
            this.m_smbServer.stopServer();
        }
        if (enabled && !this.isCIFSServerEnabled()) {
            this.m_smbServer.startServer();
        }
    }

    public void setFtpServer(FTPServerBean ftpServer) {
        this.m_ftpServer = ftpServer;
    }

    public boolean isFTPServerEnabled() {
        return this.m_ftpServer.isStarted() && this.m_serverConfig.hasConfigSection("FTP");
    }

    public void setFTPServerEnabled(boolean enabled) throws Exception {
        if (!enabled && this.isFTPServerEnabled()) {
            this.m_ftpServer.stopServer();
        }
        if (enabled && !this.isFTPServerEnabled()) {
            this.m_ftpServer.startServer();
        }
    }

    public void setNfsServer(NFSServerBean nfsServer) {
        this.m_nfsServer = nfsServer;
    }

    public boolean isNFSServerEnabled() {
        return this.m_nfsServer.isStarted() && this.m_serverConfig.hasConfigSection("NFS");
    }

    public void setNFSServerEnabled(boolean enabled) throws Exception {
        if (!enabled && this.isNFSServerEnabled()) {
            this.m_nfsServer.stopServer();
        }
        if (enabled && !this.isNFSServerEnabled()) {
            this.m_nfsServer.startServer();
        }
    }

    public String getCIFSServerName() {
        return this.m_serverConfig.getServerName();
    }

    public String getCIFSServerAddress() {
        return null;
    }

    public CifsMounter createMounter() {
        Platform.Type platform;
        if (!this.isCIFSServerEnabled()) {
            return null;
        }
        CIFSConfigSection cifsConfig = (CIFSConfigSection)this.m_serverConfig.getConfigSection("CIFS");
        CifsMounter cifsMounter = new CifsMounter();
        cifsMounter.setServerName(this.getCIFSServerName());
        if (cifsConfig.hasSMBBindAddress()) {
            cifsMounter.setServerAddress(cifsConfig.getSMBBindAddress().getHostAddress());
        }
        if ((platform = Platform.isPlatformType()) == Platform.Type.LINUX && cifsConfig.hasTcpipSMB()) {
            cifsMounter.setProtocolType(2);
            if (cifsConfig.getTcpipSMBPort() != 445) {
                cifsMounter.setProtocolPort(cifsConfig.getTcpipSMBPort());
            }
        } else if (cifsConfig.hasWin32NetBIOS()) {
            cifsMounter.setProtocolType(3);
        } else if (cifsConfig.hasNetBIOSSMB()) {
            cifsMounter.setProtocolType(1);
            if (cifsConfig.hasNetBIOSBindAddress()) {
                cifsMounter.setServerAddress(cifsConfig.getNetBIOSBindAddress().getHostAddress());
            }
        }
        if (cifsMounter.getServerAddress() == null) {
            try {
                cifsMounter.setServerAddress(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException ex) {
                logger.error((Object)"Failed to get local IP address", (Throwable)ex);
            }
        }
        return cifsMounter;
    }
}

