/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.AbstractServerConfigurationBean;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionException;
import org.alfresco.filesys.alfresco.DesktopActionTable;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.avm.AVMContext;
import org.alfresco.filesys.avm.AVMDiskDriver;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.ftp.FTPPath;
import org.alfresco.jlan.ftp.InvalidPathException;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.server.auth.acl.ACLParseException;
import org.alfresco.jlan.server.auth.acl.AccessControlList;
import org.alfresco.jlan.server.auth.acl.AccessControlParser;
import org.alfresco.jlan.server.auth.acl.InvalidACLTypeException;
import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.server.auth.passthru.RangeDomainMapping;
import org.alfresco.jlan.server.auth.passthru.SubnetDomainMapping;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.MemorySize;
import org.alfresco.jlan.util.Platform;
import org.alfresco.jlan.util.StringList;
import org.alfresco.jlan.util.X64;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.element.GenericConfigElement;

public class ServerConfigurationBean
extends AbstractServerConfigurationBean {
    private static final String ConfigArea = "file-servers";
    private static final String ConfigCIFS = "CIFS Server";
    private static final String ConfigFTP = "FTP Server";
    private static final String ConfigNFS = "NFS Server";
    private static final String ConfigFilesystems = "Filesystems";
    private static final String ConfigSecurity = "Filesystem Security";
    private static final String ConfigCoreServer = "Server Core";
    public static final String SERVER_CONFIGURATION = "fileServerConfiguration";
    private ConfigService m_configService;
    private ConfigLookupContext configCtx;

    public ServerConfigurationBean() {
        super("");
    }

    public ServerConfigurationBean(String srvName) {
        super(srvName);
    }

    public void setConfigService(ConfigService configService) {
        this.m_configService = configService;
    }

    public void init() {
        if (this.m_configService == null) {
            throw new AlfrescoRuntimeException("Property 'configService' not set");
        }
        this.configCtx = new ConfigLookupContext(ConfigArea);
        super.init();
    }

    protected void processCIFSServerConfig() {
        this.processCIFSServerConfig(this.m_configService.getConfig((Object)ConfigCIFS, this.configCtx));
    }

    /*
     * Unable to fully structure code
     */
    protected void processCIFSServerConfig(Config config) {
        block159: {
            if (config == null) {
                this.removeConfigSection("CIFS");
                return;
            }
            elem = config.getConfigElement("serverEnable");
            if (elem != null && (srvEnable = elem.getAttribute("enabled")) != null && srvEnable.equalsIgnoreCase("false")) {
                this.removeConfigSection("CIFS");
                return;
            }
            cifsConfig = new CIFSConfigSection((ServerConfiguration)this);
            try {
                block158: {
                    elem = config.getConfigElement("disableNativeCode");
                    if (elem != null) {
                        cifsConfig.setNativeCodeDisabled(true);
                        this.m_disableNativeCode = true;
                        ServerConfigurationBean.logger.warn((Object)"CIFS server native calls disabled, JNI code will not be used");
                    }
                    if ((elem = config.getConfigElement("broadcast")) != null) {
                        if (!IPAddress.isNumericAddress((String)elem.getValue())) {
                            throw new AlfrescoRuntimeException("Invalid broadcast mask, must be n.n.n.n format");
                        }
                        cifsConfig.setBroadcastMask(elem.getValue());
                    }
                    if ((elem = config.getConfigElement("host")) == null) {
                        throw new AlfrescoRuntimeException("CIFS server host settings not specified");
                    }
                    hostName = elem.getAttribute("name");
                    if (hostName == null || hostName.length() == 0) {
                        throw new AlfrescoRuntimeException("Host name not specified or invalid");
                    }
                    pos = hostName.indexOf("${localname}");
                    if (pos != -1) {
                        srvName = this.getLocalServerName(true);
                        hostStr = new StringBuilder();
                        hostStr.append(hostName.substring(0, pos));
                        hostStr.append(srvName);
                        if ((pos += "${localname}".length()) < hostName.length()) {
                            hostStr.append(hostName.substring(pos));
                        }
                        if ((hostName = hostStr.toString()).equals(srvName) && this.getPlatformType() == Platform.Type.WINDOWS) {
                            throw new AlfrescoRuntimeException("CIFS server name must be unique");
                        }
                    }
                    if (hostName.length() > 15) {
                        hostName = hostName.substring(0, 15);
                        ServerConfigurationBean.logger.warn((Object)("CIFS server name is longer than 15 characters, truncated to " + hostName));
                    }
                    cifsConfig.setServerName(hostName.toUpperCase());
                    this.setServerName(hostName.toUpperCase());
                    domain = elem.getAttribute("domain");
                    if (domain != null && domain.length() > 0) {
                        cifsConfig.setDomainName(domain.toUpperCase());
                    } else {
                        localDomain = this.getLocalDomainName();
                        if (localDomain == null && (this.getPlatformType() != Platform.Type.WINDOWS || this.isNativeCodeDisabled())) {
                            localDomain = "WORKGROUP";
                            ServerConfigurationBean.logger.error((Object)("Failed to get local domain/workgroup name, using default of " + localDomain));
                            ServerConfigurationBean.logger.error((Object)"(This may be due to firewall settings or incorrect <broadcast> setting)");
                        }
                        cifsConfig.setDomainName(localDomain);
                    }
                    elem = config.getConfigElement("comment");
                    if (elem != null) {
                        cifsConfig.setComment(elem.getValue());
                    }
                    if ((elem = config.getConfigElement("bindto")) != null) {
                        if (elem.hasAttribute("adapter")) {
                            bindAddr = this.parseAdapterName(elem.getAttribute("adapter"));
                            cifsConfig.setSMBBindAddress(bindAddr);
                        } else if (!elem.getValue().equals("0.0.0.0")) {
                            bindText = elem.getValue();
                            try {
                                bindAddr = InetAddress.getByName(bindText);
                                cifsConfig.setSMBBindAddress(bindAddr);
                            }
                            catch (UnknownHostException ex) {
                                throw new AlfrescoRuntimeException("Invalid CIFS server bind address");
                            }
                        }
                    }
                    if ((authElem = config.getConfigElement("authenticator")) == null) ** GOTO lbl102
                    authType = authElem.getAttribute("type");
                    if (authType == null) {
                        authType = "alfresco";
                    }
                    ntlmMode = NTLMMode.NONE;
                    if (this.m_authenticationComponent instanceof NLTMAuthenticator) {
                        ntlmMode = ((NLTMAuthenticator)this.m_authenticationComponent).getNTLMMode();
                    }
                    authClass = "org.alfresco.filesys.auth.cifs.AlfrescoCifsAuthenticator";
                    if (authType.equalsIgnoreCase("passthru")) {
                        if (ntlmMode == NTLMMode.MD4_PROVIDER) {
                            throw new AlfrescoRuntimeException("Wrong authentication setup for passthru authenticator (cannot be used with Alfresco users)");
                        }
                        authClass = "org.alfresco.filesys.auth.cifs.PassthruCifsAuthenticator";
                    } else if (authType.equalsIgnoreCase("alfresco")) {
                        if (ntlmMode == NTLMMode.NONE) {
                            throw new AlfrescoRuntimeException("Wrong authentication setup for alfresco authenticator");
                        }
                    } else if (authType.equalsIgnoreCase("enterprise")) {
                        authClass = "org.alfresco.filesys.auth.cifs.EnterpriseCifsAuthenticator";
                    } else if (authType.equalsIgnoreCase("custom")) {
                        authClassElem = authElem.getChild("class");
                        authClass = authClassElem.getValue();
                    } else {
                        throw new AlfrescoRuntimeException("Invalid authenticator type, " + authType);
lbl102:
                        // 1 sources

                        throw new AlfrescoRuntimeException("CIFS authenticator not specified");
                    }
                    allowGuest = authElem.getChild("allowGuest") != null;
                    cifsConfig.setAuthenticator(authClass, authElem, 1, allowGuest);
                    elem = config.getConfigElement("hostAnnounce");
                    if (elem != null) {
                        enabled = elem.getAttribute("enabled");
                        if (enabled != null && enabled.equalsIgnoreCase("false")) {
                            cifsConfig.setHostAnnouncer(false);
                            ServerConfigurationBean.logger.info((Object)"Host announcements not enabled");
                        } else {
                            interval = elem.getAttribute("interval");
                            if (interval != null && interval.length() > 0) {
                                try {
                                    cifsConfig.setHostAnnounceInterval(Integer.parseInt(interval));
                                }
                                catch (NumberFormatException ex) {
                                    throw new AlfrescoRuntimeException("Invalid host announcement interval");
                                }
                            }
                            if (cifsConfig.getDomainName() == null) {
                                throw new AlfrescoRuntimeException("Domain name must be specified if host announcement is enabled");
                            }
                            cifsConfig.setHostAnnouncer(true);
                        }
                    }
                    if ((elem = config.getConfigElement("netBIOSSMB")) != null) {
                        platformsStr = elem.getAttribute("platforms");
                        platformOK = false;
                        if (platformsStr != null) {
                            enabledPlatforms = this.parsePlatformString(platformsStr);
                            if (enabledPlatforms.contains(this.getPlatformType())) {
                                platformOK = true;
                            }
                        } else {
                            platformOK = true;
                        }
                        cifsConfig.setNetBIOSSMB(platformOK);
                        if (cifsConfig.hasNetBIOSSMB()) {
                            if (cifsConfig.getBroadcastMask() == null) {
                                throw new AlfrescoRuntimeException("Network broadcast mask not specified");
                            }
                            bindto = elem.getAttribute("bindto");
                            if (bindto != null && bindto.length() > 0 && !bindto.equals("0.0.0.0")) {
                                try {
                                    bindAddr = InetAddress.getByName(bindto);
                                    cifsConfig.setNetBIOSBindAddress(bindAddr);
                                }
                                catch (UnknownHostException ex) {
                                    throw new AlfrescoRuntimeException("Invalid NetBIOS bind address");
                                }
                            }
                            if (cifsConfig.hasSMBBindAddress()) {
                                cifsConfig.setNetBIOSBindAddress(cifsConfig.getSMBBindAddress());
                            } else {
                                addrs = null;
                                try {
                                    addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                                }
                                catch (UnknownHostException ex) {
                                    ServerConfigurationBean.logger.error((Object)"Failed to get local address list", (Throwable)ex);
                                }
                                addrCnt = 0;
                                if (addrs != null) {
                                    for (i = 0; i < addrs.length; ++i) {
                                        if (addrs[i].getHostAddress().equals("127.0.0.1") || addrs[i].getHostAddress().equals("0.0.0.0")) continue;
                                        ++addrCnt;
                                    }
                                }
                                if (addrCnt == 0) {
                                    niEnum = null;
                                    try {
                                        niEnum = NetworkInterface.getNetworkInterfaces();
                                    }
                                    catch (SocketException ex) {
                                        // empty catch block
                                    }
                                    if (niEnum != null) {
                                        while (niEnum.hasMoreElements()) {
                                            ni = niEnum.nextElement();
                                            niAddrs = ni.getInetAddresses();
                                            if (niAddrs == null) continue;
                                            while (niAddrs.hasMoreElements()) {
                                                curAddr = niAddrs.nextElement();
                                                if (curAddr.getHostAddress().equals("127.0.0.1") || curAddr.getHostAddress().equals("0.0.0.0")) continue;
                                                ++addrCnt;
                                            }
                                        }
                                        if (addrCnt > 0 && ServerConfigurationBean.logger.isDebugEnabled()) {
                                            ServerConfigurationBean.logger.debug((Object)"Found valid IP address from interface list");
                                        }
                                    }
                                    if (addrCnt == 0) {
                                        if (ServerConfigurationBean.logger.isDebugEnabled()) {
                                            ServerConfigurationBean.logger.debug((Object)"Local address list dump :-");
                                            if (addrs != null) {
                                                for (i = 0; i < addrs.length; ++i) {
                                                    ServerConfigurationBean.logger.debug((Object)("  Address: " + addrs[i]));
                                                }
                                            } else {
                                                ServerConfigurationBean.logger.debug((Object)"  No addresses");
                                            }
                                        }
                                        throw new AlfrescoRuntimeException("Failed to get IP address(es) for the local server, check hosts file and/or DNS setup");
                                    }
                                }
                            }
                            portNum = elem.getAttribute("sessionPort");
                            if (portNum != null && portNum.length() > 0) {
                                try {
                                    cifsConfig.setSessionPort(Integer.parseInt(portNum));
                                    if (cifsConfig.getSessionPort() <= 0 || cifsConfig.getSessionPort() >= 65535) {
                                        throw new AlfrescoRuntimeException("NetBIOS session port out of valid range");
                                    }
                                }
                                catch (NumberFormatException ex) {
                                    throw new AlfrescoRuntimeException("Invalid NetBIOS session port");
                                }
                            }
                            if ((portNum = elem.getAttribute("namePort")) != null && portNum.length() > 0) {
                                try {
                                    cifsConfig.setNameServerPort(Integer.parseInt(portNum));
                                    if (cifsConfig.getNameServerPort() <= 0 || cifsConfig.getNameServerPort() >= 65535) {
                                        throw new AlfrescoRuntimeException("NetBIOS name port out of valid range");
                                    }
                                }
                                catch (NumberFormatException ex) {
                                    throw new AlfrescoRuntimeException("Invalid NetBIOS name port");
                                }
                            }
                            if ((portNum = elem.getAttribute("datagramPort")) != null && portNum.length() > 0) {
                                try {
                                    cifsConfig.setDatagramPort(Integer.parseInt(portNum));
                                    if (cifsConfig.getDatagramPort() <= 0 || cifsConfig.getDatagramPort() >= 65535) {
                                        throw new AlfrescoRuntimeException("NetBIOS datagram port out of valid range");
                                    }
                                }
                                catch (NumberFormatException ex) {
                                    throw new AlfrescoRuntimeException("Invalid NetBIOS datagram port");
                                }
                            }
                            if ((attr = elem.getAttribute("bindto")) != null && attr.length() > 0 && !attr.equals("0.0.0.0")) {
                                try {
                                    bindAddr = InetAddress.getByName(attr);
                                    cifsConfig.setNetBIOSBindAddress(bindAddr);
                                }
                                catch (UnknownHostException ex) {
                                    throw new InvalidConfigurationException(ex.toString());
                                }
                            } else if (elem.hasAttribute("adapter")) {
                                bindAddr = this.parseAdapterName(elem.getAttribute("adapter"));
                                cifsConfig.setNetBIOSBindAddress(bindAddr);
                            } else if (cifsConfig.hasSMBBindAddress()) {
                                cifsConfig.setNetBIOSBindAddress(cifsConfig.getSMBBindAddress());
                            }
                        }
                    } else {
                        cifsConfig.setNetBIOSSMB(false);
                    }
                    elem = config.getConfigElement("tcpipSMB");
                    if (elem != null) {
                        platformsStr = elem.getAttribute("platforms");
                        platformOK = false;
                        if (platformsStr != null) {
                            enabledPlatforms = this.parsePlatformString(platformsStr);
                            if (enabledPlatforms.contains(this.getPlatformType())) {
                                platformOK = true;
                            }
                        } else {
                            platformOK = true;
                        }
                        cifsConfig.setTcpipSMB(platformOK);
                        portNum = elem.getAttribute("port");
                        if (portNum != null && portNum.length() > 0) {
                            try {
                                cifsConfig.setTcpipSMBPort(Integer.parseInt(portNum));
                                if (cifsConfig.getTcpipSMBPort() <= 0 || cifsConfig.getTcpipSMBPort() >= 65535) {
                                    throw new AlfrescoRuntimeException("TCP/IP SMB port out of valid range");
                                }
                            }
                            catch (NumberFormatException ex) {
                                throw new AlfrescoRuntimeException("Invalid TCP/IP SMB port");
                            }
                        }
                        if ((ipv6 = elem.getAttribute("ipv6")) != null && ipv6.equalsIgnoreCase("enabled")) {
                            try {
                                cifsConfig.setSMBBindAddress(InetAddress.getByName("::"));
                                if (!ServerConfigurationBean.logger.isInfoEnabled()) ** GOTO lbl277
                                ServerConfigurationBean.logger.info((Object)"Enabled CIFS IPv6 bind address for native SMB");
                            }
                            catch (UnknownHostException ex) {
                                throw new AlfrescoRuntimeException("Failed to enable IPv6 bind address, " + ex.getMessage());
                            }
                        }
                    } else {
                        cifsConfig.setTcpipSMB(false);
                    }
lbl277:
                    // 4 sources

                    elem = config.getConfigElement("Win32NetBIOS");
                    if (elem != null) {
                        win32Name = elem.getAttribute("name");
                        if (win32Name != null && win32Name.length() > 0) {
                            if (win32Name.length() > 16) {
                                throw new AlfrescoRuntimeException("Invalid Win32 NetBIOS name, " + win32Name);
                            }
                            cifsConfig.setWin32NetBIOSName(win32Name);
                        }
                        if ((lanaStr = elem.getAttribute("lana")) != null && lanaStr.length() > 0) {
                            lana = -1;
                            if (IPAddress.isNumericAddress((String)lanaStr)) {
                                lana = Win32NetBIOS.getLANAForIPAddress((String)lanaStr);
                                if (lana == -1) {
                                    throw new AlfrescoRuntimeException("Failed to convert IP address " + lanaStr + " to a LANA");
                                }
                            } else if (lanaStr.length() > 1 && Character.isLetter(lanaStr.charAt(0))) {
                                lana = Win32NetBIOS.getLANAForAdapterName((String)lanaStr);
                                if (lana == -1) {
                                    throw new AlfrescoRuntimeException("Failed to convert network adapter " + lanaStr + " to a LANA");
                                }
                            } else {
                                try {
                                    lana = Integer.parseInt(lanaStr);
                                }
                                catch (NumberFormatException ex) {
                                    throw new AlfrescoRuntimeException("Invalid win32 NetBIOS LANA specified");
                                }
                            }
                            if (lana < 0 || lana > 255) {
                                throw new AlfrescoRuntimeException("Invalid Win32 NetBIOS LANA number, " + lana);
                            }
                            cifsConfig.setWin32LANA(lana);
                        }
                        if ((nativeAPI = elem.getAttribute("api")) != null && nativeAPI.length() > 0) {
                            useWinsock = true;
                            if (nativeAPI.equalsIgnoreCase("netbios")) {
                                useWinsock = false;
                            } else if (!nativeAPI.equalsIgnoreCase("winsock")) {
                                throw new AlfrescoRuntimeException("Invalid NetBIOS API type, spefify 'winsock' or 'netbios'");
                            }
                            cifsConfig.setWin32WinsockNetBIOS(useWinsock);
                        }
                        if (cifsConfig.useWinsockNetBIOS() && X64.isWindows64()) {
                            if (ServerConfigurationBean.logger.isDebugEnabled()) {
                                ServerConfigurationBean.logger.debug((Object)"Using older Netbios() API code");
                            }
                            cifsConfig.setWin32WinsockNetBIOS(false);
                        }
                        if (!(!(osName = System.getProperty("os.name")).startsWith("Windows") || osName.endsWith("95") || osName.endsWith("98") || osName.endsWith("ME") || this.isNativeCodeDisabled())) {
                            if (Win32NetBIOS.LanaEnumerate() != null) {
                                cifsConfig.setWin32NetBIOS(true);
                            } else {
                                ServerConfigurationBean.logger.warn((Object)"No NetBIOS LANAs available");
                            }
                        } else {
                            cifsConfig.setWin32NetBIOS(false);
                        }
                    } else {
                        cifsConfig.setWin32NetBIOS(false);
                    }
                    elem = config.getConfigElement("Win32Announce");
                    if (elem != null) {
                        enabled = elem.getAttribute("enabled");
                        if (enabled != null && enabled.equalsIgnoreCase("false")) {
                            cifsConfig.setWin32HostAnnouncer(false);
                            ServerConfigurationBean.logger.info((Object)"Win32 host announcements not enabled");
                        } else {
                            interval = elem.getAttribute("interval");
                            if (interval != null && interval.length() > 0) {
                                try {
                                    cifsConfig.setWin32HostAnnounceInterval(Integer.parseInt(interval));
                                }
                                catch (NumberFormatException ex) {
                                    throw new AlfrescoRuntimeException("Invalid host announcement interval");
                                }
                            }
                            if (cifsConfig.getDomainName() == null) {
                                throw new AlfrescoRuntimeException("Domain name must be specified if host announcement is enabled");
                            }
                            cifsConfig.setWin32HostAnnouncer(true);
                        }
                    }
                    if (!(cifsConfig.hasNetBIOSSMB() || cifsConfig.hasTcpipSMB() || cifsConfig.hasWin32NetBIOS())) {
                        throw new AlfrescoRuntimeException("NetBIOS SMB, TCP/IP SMB or Win32 NetBIOS must be enabled");
                    }
                    elem = config.getConfigElement("WINS");
                    if (elem != null) {
                        priWinsElem = elem.getChild("primary");
                        if (priWinsElem == null || priWinsElem.getValue().length() == 0) {
                            throw new AlfrescoRuntimeException("No primary WINS server configured");
                        }
                        primaryWINS = null;
                        try {
                            primaryWINS = InetAddress.getByName(priWinsElem.getValue());
                        }
                        catch (UnknownHostException ex) {
                            throw new AlfrescoRuntimeException("Invalid primary WINS server address, " + priWinsElem.getValue());
                        }
                        secWinsElem = elem.getChild("secondary");
                        secondaryWINS = null;
                        if (secWinsElem != null) {
                            try {
                                secondaryWINS = InetAddress.getByName(secWinsElem.getValue());
                            }
                            catch (UnknownHostException ex) {
                                throw new AlfrescoRuntimeException("Invalid secondary WINS server address, " + secWinsElem.getValue());
                            }
                        }
                        cifsConfig.setPrimaryWINSServer(primaryWINS);
                        if (secondaryWINS != null) {
                            cifsConfig.setSecondaryWINSServer(secondaryWINS);
                        }
                        NetBIOSSession.setDefaultWINSServer((InetAddress)primaryWINS);
                    } else if (cifsConfig.hasNetBIOSSMB() && this.getPlatformType() == Platform.Type.WINDOWS && !this.isNativeCodeDisabled() && (winsServers = Win32NetBIOS.getWINSServerList()) != null) {
                        tokens = new StringTokenizer(winsServers, ",");
                        addr = tokens.nextToken();
                        try {
                            winsAddr = InetAddress.getByName(addr);
                            winsSocket = new Socket();
                            sockAddr = new InetSocketAddress(winsAddr, 137);
                            winsSocket.connect(sockAddr, 3000);
                            winsSocket.close();
                            cifsConfig.setPrimaryWINSServer(winsAddr);
                            if (ServerConfigurationBean.logger.isDebugEnabled()) {
                                ServerConfigurationBean.logger.debug((Object)("Configuring to use WINS server " + addr));
                            }
                        }
                        catch (UnknownHostException ex) {
                            throw new AlfrescoRuntimeException("Invalid auto WINS server address, " + addr);
                        }
                        catch (IOException ex) {
                            if (!ServerConfigurationBean.logger.isDebugEnabled()) break block158;
                            ServerConfigurationBean.logger.debug((Object)("Failed to connect to auto WINS server " + addr));
                        }
                    }
                }
                elem = config.getConfigElement("sessionDebug");
                if (elem != null) {
                    flags = elem.getAttribute("flags");
                    sessDbg = 0;
                    if (flags != null) {
                        flags = flags.toUpperCase();
                        token = new StringTokenizer(flags, ",");
                        while (token.hasMoreTokens()) {
                            dbg = token.nextToken().trim();
                            for (idx = 0; idx < ServerConfigurationBean.m_sessDbgStr.length && !ServerConfigurationBean.m_sessDbgStr[idx].equalsIgnoreCase(dbg); ++idx) {
                            }
                            if (idx > ServerConfigurationBean.m_sessDbgStr.length) {
                                throw new AlfrescoRuntimeException("Invalid session debug flag, " + dbg);
                            }
                            sessDbg += 1 << idx;
                        }
                    }
                    cifsConfig.setSessionDebugFlags(sessDbg);
                }
                if (config.getConfigElement("disableNIO") != null) {
                    cifsConfig.setDisableNIOCode(true);
                    if (ServerConfigurationBean.logger.isDebugEnabled()) {
                        ServerConfigurationBean.logger.debug((Object)"NIO based code disabled for CIFS server");
                    }
                }
                if ((elem = config.getConfigElement("sessionTimeout")) == null) break block159;
                sessTmo = elem.getValue();
                if (sessTmo != null && sessTmo.length() > 0) {
                    try {
                        tmo = Integer.parseInt(sessTmo);
                        if (tmo < 0 || tmo > 3600) {
                            throw new AlfrescoRuntimeException("Session timeout out of range (0 - 3600)");
                        }
                        cifsConfig.setSocketTimeout(tmo * 1000);
                        break block159;
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid session timeout value, " + sessTmo);
                    }
                }
                throw new AlfrescoRuntimeException("Session timeout value not specified");
            }
            catch (InvalidConfigurationException ex) {
                throw new AlfrescoRuntimeException(ex.getMessage());
            }
        }
    }

    protected void processFTPServerConfig() {
        this.processFTPServerConfig(this.m_configService.getConfig((Object)ConfigFTP, this.configCtx));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processFTPServerConfig(Config config) {
        String srvEnable;
        if (config == null) {
            this.removeConfigSection("FTP");
            return;
        }
        ConfigElement elem = config.getConfigElement("serverEnable");
        if (elem != null && (srvEnable = elem.getAttribute("enabled")) != null && srvEnable.equalsIgnoreCase("false")) {
            this.removeConfigSection("FTP");
            return;
        }
        FTPConfigSection ftpConfig = new FTPConfigSection((ServerConfiguration)this);
        try {
            ConfigElement authElem;
            block46: {
                elem = config.getConfigElement("bindto");
                if (elem != null && !elem.getValue().equals("0.0.0.0")) {
                    String bindText = elem.getValue();
                    try {
                        InetAddress bindAddr = InetAddress.getByName(bindText);
                        ftpConfig.setFTPBindAddress(bindAddr);
                    }
                    catch (UnknownHostException ex) {
                        throw new AlfrescoRuntimeException("Invalid FTP bindto address, " + elem.getValue());
                    }
                }
                if ((elem = config.getConfigElement("port")) != null) {
                    try {
                        ftpConfig.setFTPPort(Integer.parseInt(elem.getValue()));
                        if (ftpConfig.getFTPPort() <= 0 || ftpConfig.getFTPPort() >= 65535) {
                            throw new AlfrescoRuntimeException("FTP server port out of valid range");
                        }
                        break block46;
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid FTP server port");
                    }
                }
                ftpConfig.setFTPPort(21);
            }
            elem = config.getConfigElement("allowAnonymous");
            if (elem != null) {
                ftpConfig.setAllowAnonymousFTP(true);
                String anonAcc = elem.getAttribute("user");
                if (anonAcc != null && anonAcc.length() > 0) {
                    ftpConfig.setAnonymousFTPAccount(anonAcc);
                    if (ftpConfig.getAnonymousFTPAccount() == null || ftpConfig.getAnonymousFTPAccount().length() == 0) {
                        throw new AlfrescoRuntimeException("Anonymous FTP account invalid");
                    }
                } else {
                    ftpConfig.setAnonymousFTPAccount("anonymous");
                }
            } else {
                ftpConfig.setAllowAnonymousFTP(false);
            }
            elem = config.getConfigElement("rootDirectory");
            if (elem != null) {
                String rootPath = elem.getValue();
                try {
                    new FTPPath(rootPath);
                    ftpConfig.setFTPRootPath(rootPath);
                }
                catch (InvalidPathException ex) {
                    throw new AlfrescoRuntimeException("Invalid FTP root directory, " + rootPath);
                }
            }
            if ((elem = config.getConfigElement("debug")) != null) {
                String flags = elem.getAttribute("flags");
                int ftpDbg = 0;
                if (flags != null) {
                    flags = flags.toUpperCase();
                    StringTokenizer token = new StringTokenizer(flags, ",");
                    while (token.hasMoreTokens()) {
                        int idx;
                        String dbg = token.nextToken().trim();
                        for (idx = 0; idx < m_ftpDebugStr.length && !m_ftpDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                        }
                        if (idx >= m_ftpDebugStr.length) {
                            throw new AlfrescoRuntimeException("Invalid FTP debug flag, " + dbg);
                        }
                        ftpDbg += 1 << idx;
                    }
                }
                ftpConfig.setFTPDebug(ftpDbg);
            }
            if ((elem = config.getConfigElement("IPv6")) != null && elem.hasAttribute("state") && elem.getAttribute("state").equalsIgnoreCase("enabled")) {
                ftpConfig.setIPv6Enabled(true);
            }
            if ((elem = config.getConfigElement("charSet")) != null) {
                try {
                    Charset.forName(elem.getValue());
                    ftpConfig.setFTPCharacterSet(elem.getValue());
                }
                catch (IllegalCharsetNameException ex) {
                    throw new AlfrescoRuntimeException("Illegal character set name, " + elem.getValue());
                }
                catch (UnsupportedCharsetException ex) {
                    throw new AlfrescoRuntimeException("Unsupported character set name, " + elem.getValue());
                }
            }
            if ((authElem = config.getConfigElement("authenticator")) == null) throw new AlfrescoRuntimeException("FTP authenticator not specified");
            String authType = authElem.getAttribute("type");
            if (authType == null) {
                authType = "alfresco";
            }
            NTLMMode ntlmMode = NTLMMode.NONE;
            if (this.m_authenticationComponent instanceof NLTMAuthenticator) {
                ntlmMode = ((NLTMAuthenticator)this.m_authenticationComponent).getNTLMMode();
            }
            String authClass = "org.alfresco.filesys.auth.ftp.AlfrescoFtpAuthenticator";
            if (authType.equalsIgnoreCase("passthru")) {
                if (ntlmMode == NTLMMode.MD4_PROVIDER) {
                    throw new AlfrescoRuntimeException("Wrong authentication setup for passthru authenticator (cannot be used with Alfresco users)");
                }
                authClass = "org.alfresco.filesys.auth.ftp.PassthruFtpAuthenticator";
            } else if (!authType.equalsIgnoreCase("alfresco")) {
                if (!authType.equalsIgnoreCase("custom")) throw new AlfrescoRuntimeException("Invalid authenticator type, " + authType);
                ConfigElement authClassElem = authElem.getChild("class");
                authClass = authClassElem.getValue();
            }
            ftpConfig.setAuthenticator(authClass, authElem);
            elem = config.getConfigElement("dataPorts");
            if (elem == null) return;
            StringTokenizer tok = new StringTokenizer(elem.getValue(), ":");
            if (tok.countTokens() != 2) {
                throw new InvalidConfigurationException("Invalid FTP data port range, specify as 'n:n'");
            }
            String rangeFromStr = tok.nextToken();
            String rangeToStr = tok.nextToken();
            int rangeFrom = -1;
            int rangeTo = -1;
            if (rangeFromStr != null && rangeFromStr.length() > 0) {
                try {
                    rangeFrom = Integer.parseInt(rangeFromStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid FTP range from value, " + rangeFromStr);
                }
            }
            if (rangeToStr != null && rangeToStr.length() > 0) {
                try {
                    rangeTo = Integer.parseInt(rangeToStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid FTP range to value, " + rangeToStr);
                }
            }
            if (rangeFrom == 0 || rangeTo == 0) return;
            if (rangeFrom == -1 || rangeTo == -1) {
                throw new InvalidConfigurationException("FTP data port range from/to must be specified");
            }
            if (rangeFrom < 1024 || rangeFrom > 65535) {
                throw new InvalidConfigurationException("Invalid FTP data port range from value, " + rangeFrom);
            }
            if (rangeTo < 1024 || rangeTo > 65535) {
                throw new InvalidConfigurationException("Invalid FTP data port range to value, " + rangeTo);
            }
            if (rangeFrom >= rangeTo) {
                throw new InvalidConfigurationException("Invalid FTP data port range, " + rangeFrom + "-" + rangeTo);
            }
            ftpConfig.setFTPDataPortLow(rangeFrom);
            ftpConfig.setFTPDataPortHigh(rangeTo);
            logger.info((Object)("FTP server data ports restricted to range " + rangeFrom + ":" + rangeTo));
            return;
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    protected void processNFSServerConfig() {
        this.processNFSServerConfig(this.m_configService.getConfig((Object)ConfigNFS, this.configCtx));
    }

    protected void processNFSServerConfig(Config config) {
        block41: {
            String srvEnable;
            if (config == null) {
                this.removeConfigSection("NFS");
                return;
            }
            ConfigElement elem = config.getConfigElement("serverEnable");
            if (elem != null && (srvEnable = elem.getAttribute("enabled")) != null && srvEnable.equalsIgnoreCase("false")) {
                this.removeConfigSection("NFS");
                return;
            }
            NFSConfigSection nfsConfig = new NFSConfigSection((ServerConfiguration)this);
            try {
                if (config.getConfigElement("enablePortMapper") != null) {
                    nfsConfig.setNFSPortMapper(true);
                }
                if ((elem = config.getConfigElement("ThreadPool")) != null) {
                    try {
                        int poolSize = Integer.parseInt(elem.getValue());
                        if (poolSize < 4) {
                            throw new AlfrescoRuntimeException("NFS thread pool size is below minimum of 4");
                        }
                        nfsConfig.setNFSThreadPoolSize(poolSize);
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid NFS thread pool size setting, " + elem.getValue());
                    }
                }
                if ((elem = config.getConfigElement("PacketPool")) != null) {
                    try {
                        int pktPoolSize = Integer.parseInt(elem.getValue());
                        if (pktPoolSize < 10) {
                            throw new AlfrescoRuntimeException("NFS packet pool size is below minimum of 10");
                        }
                        if (pktPoolSize < nfsConfig.getNFSThreadPoolSize() + 1) {
                            throw new AlfrescoRuntimeException("NFS packet pool must be at least thread pool size plus one");
                        }
                        nfsConfig.setNFSPacketPoolSize(pktPoolSize);
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid NFS packet pool size setting, " + elem.getValue());
                    }
                }
                if ((elem = config.getConfigElement("PortMapperPort")) != null) {
                    try {
                        nfsConfig.setPortMapperPort(Integer.parseInt(elem.getValue()));
                        if (nfsConfig.getPortMapperPort() <= 0 || nfsConfig.getPortMapperPort() >= 65535) {
                            throw new AlfrescoRuntimeException("Port mapper server port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid port mapper server port");
                    }
                }
                if ((elem = config.getConfigElement("MountServerPort")) != null) {
                    try {
                        nfsConfig.setMountServerPort(Integer.parseInt(elem.getValue()));
                        if (nfsConfig.getMountServerPort() <= 0 || nfsConfig.getMountServerPort() >= 65535) {
                            throw new AlfrescoRuntimeException("Mount server port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid mount server port");
                    }
                }
                if ((elem = config.getConfigElement("NFSServerPort")) != null) {
                    try {
                        nfsConfig.setNFSServerPort(Integer.parseInt(elem.getValue()));
                        if (nfsConfig.getNFSServerPort() <= 0 || nfsConfig.getNFSServerPort() >= 65535) {
                            throw new AlfrescoRuntimeException("NFS server port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid NFS server port");
                    }
                }
                if ((elem = config.getConfigElement("RPCRegisterPort")) != null) {
                    try {
                        nfsConfig.setRPCRegistrationPort(Integer.parseInt(elem.getValue()));
                        if (nfsConfig.getRPCRegistrationPort() <= 0 || nfsConfig.getRPCRegistrationPort() >= 65535) {
                            throw new AlfrescoRuntimeException("RPC registration port out of valid range");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new AlfrescoRuntimeException("Invalid RPC registration port");
                    }
                }
                if ((elem = config.getConfigElement("debug")) != null) {
                    String flags = elem.getAttribute("flags");
                    int nfsDbg = 0;
                    if (flags != null) {
                        flags = flags.toUpperCase();
                        StringTokenizer token = new StringTokenizer(flags, ",");
                        while (token.hasMoreTokens()) {
                            int idx;
                            String dbg = token.nextToken().trim();
                            for (idx = 0; idx < m_nfsDebugStr.length && !m_nfsDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                            }
                            if (idx >= m_nfsDebugStr.length) {
                                throw new AlfrescoRuntimeException("Invalid NFS debug flag, " + dbg);
                            }
                            nfsDbg += 1 << idx;
                        }
                    }
                    nfsConfig.setNFSDebug(nfsDbg);
                }
                if ((elem = config.getConfigElement("mountServerDebug")) != null) {
                    nfsConfig.setMountServerDebug(true);
                }
                if ((elem = config.getConfigElement("portMapperDebug")) != null) {
                    nfsConfig.setPortMapperDebug(true);
                }
                if ((elem = config.getConfigElement("rpcAuthenticator")) != null) {
                    try {
                        String authClass = "org.alfresco.filesys.auth.nfs.AlfrescoRpcAuthenticator";
                        ConfigElement authClassElem = elem.getChild("class");
                        if (authClassElem != null) {
                            authClass = authClassElem.getValue();
                        }
                        nfsConfig.setRpcAuthenticator(authClass, elem);
                        break block41;
                    }
                    catch (InvalidConfigurationException ex) {
                        throw new AlfrescoRuntimeException(ex.getMessage());
                    }
                }
                throw new AlfrescoRuntimeException("RPC authenticator configuration missing, require user mappings");
            }
            catch (InvalidConfigurationException ex) {
                throw new AlfrescoRuntimeException(ex.getMessage());
            }
        }
    }

    protected void processFilesystemsConfig() {
        this.processFilesystemsConfig(this.m_configService.getConfig((Object)ConfigFilesystems, this.configCtx));
    }

    protected void processFilesystemsConfig(Config config) {
        ConfigElement homeElem;
        AVMDiskDriver avmDriver;
        StringList storeNames;
        ConfigElement filesystems = config.getConfigElement("filesystems");
        ArrayList<ConfigElement> filesysElems = null;
        if (filesystems != null) {
            filesysElems = filesystems.getChildren();
        } else {
            ConfigElement filesysElem = config.getConfigElement("filesystem");
            if (filesysElem != null) {
                filesysElems = new ArrayList<ConfigElement>(1);
                filesysElems.add(filesysElem);
            }
            logger.warn((Object)"Old style file-servers.xml configuration being used");
        }
        FilesystemsConfigSection fsysConfig = new FilesystemsConfigSection((ServerConfiguration)this);
        SecurityConfigSection secConfig = (SecurityConfigSection)this.getConfigSection("Security");
        if (filesysElems != null) {
            for (int i = 0; i < filesysElems.size(); ++i) {
                ConfigElement elem = (ConfigElement)filesysElems.get(i);
                String filesysType = elem.getName();
                String filesysName = elem.getAttribute("name");
                try {
                    AlfrescoContext filesysContext;
                    ExtendedDiskInterface filesysDriver;
                    DiskSharedDevice filesys = null;
                    if (filesysType.equalsIgnoreCase("avmfilesystem")) {
                        filesysDriver = this.getAvmDiskInterface();
                        filesysContext = (AVMContext)filesysDriver.createContext(filesysName, elem);
                        filesys = new DiskSharedDevice(filesysName, (DeviceInterface)filesysDriver, (DiskDeviceContext)filesysContext);
                        filesys.setConfiguration((ServerConfiguration)this);
                        if (filesysContext.hasStateCache()) {
                            fsysConfig.addFileStateCache(filesysName, filesysContext.getStateCache());
                        }
                        filesysContext.startFilesystem(filesys);
                    } else {
                        DesktopActionTable desktopActions;
                        filesysDriver = this.getRepoDiskInterface();
                        filesysContext = (ContentContext)filesysDriver.createContext(filesysName, elem);
                        AccessControlList acls = null;
                        ConfigElement aclElem = elem.getChild("accessControl");
                        if (aclElem != null) {
                            acls = this.processAccessControlList(secConfig, aclElem);
                        } else if (secConfig.hasGlobalAccessControls()) {
                            acls = secConfig.getGlobalAccessControls();
                        }
                        boolean changeNotify = elem.getChild("disableChangeNotification") == null;
                        ConfigElement filesysDbgElem = elem.getChild("debug");
                        if (filesysDbgElem != null) {
                            String flags = filesysDbgElem.getAttribute("flags");
                            filesysContext.setDebug(flags);
                        }
                        filesys = new DiskSharedDevice(filesysName, (DeviceInterface)filesysDriver, (DiskDeviceContext)filesysContext);
                        filesys.setConfiguration((ServerConfiguration)this);
                        ConfigElement deskActionsElem = elem.getChild("desktopActions");
                        if (deskActionsElem != null && (desktopActions = this.processDesktopActions(deskActionsElem, filesys)) != null) {
                            filesysContext.setDesktopActions(desktopActions, filesysDriver);
                        }
                        filesys.setAccessControlList(acls);
                        filesysContext.enableChangeHandler(changeNotify);
                        if (filesysContext.hasStateCache()) {
                            fsysConfig.addFileStateCache(filesysName, filesysContext.getStateCache());
                        }
                        ((ContentContext)filesysContext).startFilesystem(filesys);
                    }
                    fsysConfig.addShare((SharedDevice)filesys);
                    continue;
                }
                catch (DeviceContextException ex) {
                    throw new AlfrescoRuntimeException("Error creating filesystem " + filesysName, (Throwable)ex);
                }
            }
        } else {
            logger.warn((Object)"No filesystems defined");
        }
        ConfigElement avmAllStoresElem = config.getConfigElement("avmAllStores");
        if (avmAllStoresElem != null && this.getAvmDiskInterface() != null && (storeNames = (avmDriver = (AVMDiskDriver)this.getAvmDiskInterface()).getAVMStoreNames()) != null && storeNames.numberOfStrings() > 0) {
            for (int i = 0; i < storeNames.numberOfStrings(); ++i) {
                String storeName = storeNames.getStringAt(i);
                if (fsysConfig.getShares().findShare(storeName, 0, true) != null) continue;
                AVMContext avmContext = new AVMContext(storeName, storeName + ":/", -1);
                avmContext.enableStateCache(true);
                DiskSharedDevice filesys = new DiskSharedDevice(storeName, (DeviceInterface)avmDriver, (DiskDeviceContext)avmContext);
                filesys.setConfiguration((ServerConfiguration)this);
                fsysConfig.addShare((SharedDevice)filesys);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added AVM share " + storeName));
            }
        }
        if ((homeElem = config.getConfigElement("homeFolder")) != null) {
            try {
                secConfig.setShareMapper("org.alfresco.filesys.alfresco.HomeShareMapper", homeElem);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Using home folder share mapper");
                }
            }
            catch (InvalidConfigurationException ex) {
                throw new AlfrescoRuntimeException("Failed to initialize home folder share mapper", (Throwable)ex);
            }
        }
    }

    protected void processSecurityConfig() {
        this.processSecurityConfig(this.m_configService.getConfig((Object)ConfigSecurity, this.configCtx));
    }

    protected void processSecurityConfig(Config config) {
        SecurityConfigSection secConfig = new SecurityConfigSection((ServerConfiguration)this);
        try {
            GenericConfigElement params = new GenericConfigElement("");
            if (config.getConfigElement("aclDebug") != null) {
                params.addChild((ConfigElement)new GenericConfigElement("debug"));
            }
            secConfig.setAccessControlManager("org.alfresco.jlan.server.auth.acl.DefaultAccessControlManager", (ConfigElement)params);
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("Failed to set ACL manager", (Throwable)ex);
        }
        try {
            List mappings;
            ConfigElement jceElem;
            AccessControlList acls;
            ConfigElement globalACLs = config.getConfigElement("globalAccessControl");
            if (globalACLs != null && (acls = this.processAccessControlList(secConfig, globalACLs)) != null) {
                secConfig.setGlobalAccessControls(acls);
            }
            if ((jceElem = config.getConfigElement("JCEProvider")) != null) {
                secConfig.setJCEProvider(jceElem.getValue());
            } else {
                secConfig.setJCEProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
            }
            ConfigElement mapperElem = config.getConfigElement("shareMapper");
            if (mapperElem != null) {
                String mapperType = mapperElem.getAttribute("type");
                String mapperClass = null;
                if (mapperType.equalsIgnoreCase("multi-tenant")) {
                    mapperClass = "org.alfresco.filesys.alfresco.MultiTenantShareMapper";
                } else if (mapperType.equalsIgnoreCase("home-folder")) {
                    mapperClass = "org.alfresco.filesys.alfresco.HomeShareMapper";
                } else {
                    ConfigElement classElem = mapperElem.getChild("class");
                    if (classElem == null) {
                        throw new InvalidConfigurationException("Share mapper class not specified");
                    }
                    mapperClass = classElem.getValue();
                }
                secConfig.setShareMapper(mapperClass, mapperElem);
            } else if (this.m_tenantService != null && this.m_tenantService.isEnabled()) {
                secConfig.setShareMapper("org.alfresco.filesys.alfresco.MultiTenantShareMapper", (ConfigElement)new GenericConfigElement("shareMapper"));
            }
            ConfigElement domainMappings = config.getConfigElement("DomainMappings");
            if (domainMappings != null && (mappings = domainMappings.getChildren()) != null) {
                SubnetDomainMapping mapping = null;
                for (ConfigElement domainMap : mappings) {
                    if (!domainMap.getName().equals("Domain")) continue;
                    String name = domainMap.getAttribute("name");
                    if (domainMap.hasAttribute("subnet")) {
                        String subnetStr = domainMap.getAttribute("subnet");
                        String maskStr = domainMap.getAttribute("mask");
                        int subnet = IPAddress.parseNumericAddress((String)subnetStr);
                        int mask = IPAddress.parseNumericAddress((String)maskStr);
                        if (subnet == 0 || mask == 0) {
                            throw new AlfrescoRuntimeException("Invalid subnet/mask for domain mapping " + name);
                        }
                        mapping = new SubnetDomainMapping(name, subnet, mask);
                    } else if (domainMap.hasAttribute("rangeFrom")) {
                        String rangeFromStr = domainMap.getAttribute("rangeFrom");
                        String rangeToStr = domainMap.getAttribute("rangeTo");
                        int rangeFrom = IPAddress.parseNumericAddress((String)rangeFromStr);
                        int rangeTo = IPAddress.parseNumericAddress((String)rangeToStr);
                        if (rangeFrom == 0 || rangeTo == 0) {
                            throw new AlfrescoRuntimeException("Invalid address range domain mapping " + name);
                        }
                        mapping = new RangeDomainMapping(name, rangeFrom, rangeTo);
                    } else {
                        throw new AlfrescoRuntimeException("Invalid domain mapping specified");
                    }
                    secConfig.addDomainMapping((DomainMapping)mapping);
                }
            }
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    protected void processCoreServerConfig() throws InvalidConfigurationException {
        this.processCoreServerConfig(this.m_configService.getConfig((Object)ConfigCoreServer, this.configCtx));
    }

    protected void processCoreServerConfig(Config config) throws InvalidConfigurationException {
        CoreServerConfigSection coreConfig = new CoreServerConfigSection((ServerConfiguration)this);
        if (config == null) {
            coreConfig.setMemoryPool(DefaultMemoryPoolBufSizes, DefaultMemoryPoolInitAlloc, DefaultMemoryPoolMaxAlloc);
            coreConfig.setThreadPool(25, 50);
            return;
        }
        ConfigElement elem = config.getConfigElement("threadPool");
        if (elem != null) {
            String initSizeStr = elem.getAttribute("init");
            if (initSizeStr == null || initSizeStr.length() == 0) {
                throw new InvalidConfigurationException("Thread pool initial size not specified");
            }
            int initSize = 0;
            try {
                initSize = Integer.parseInt(initSizeStr);
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid thread pool size value, " + initSizeStr);
            }
            if (initSize < 4) {
                throw new InvalidConfigurationException("Thread pool size below minimum allowed size");
            }
            if (initSize > 250) {
                throw new InvalidConfigurationException("Thread pool size above maximum allowed size");
            }
            String maxSizeStr = elem.getAttribute("max");
            int maxSize = initSize;
            if (maxSizeStr.length() > 0) {
                try {
                    maxSize = Integer.parseInt(maxSizeStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException(" Invalid thread pool maximum size value, " + maxSizeStr);
                }
                if (maxSize < 4) {
                    throw new InvalidConfigurationException("Thread pool maximum size below minimum allowed size");
                }
                if (maxSize > 250) {
                    throw new InvalidConfigurationException("Thread pool maximum size above maximum allowed size");
                }
                if (maxSize < initSize) {
                    throw new InvalidConfigurationException("Initial size is larger than maxmimum size");
                }
            } else if (maxSizeStr != null) {
                throw new InvalidConfigurationException("Thread pool maximum size not specified");
            }
            coreConfig.setThreadPool(initSize, maxSize);
        } else {
            coreConfig.setThreadPool(25, 50);
        }
        if (config.getConfigElement("threadPoolDebug") != null) {
            coreConfig.getThreadPool().setDebug(true);
        }
        if ((elem = config.getConfigElement("memoryPool")) != null) {
            ConfigElement pktElem = elem.getChild("packetSizes");
            if (pktElem != null) {
                int elemCnt = pktElem.getChildCount();
                int[] pktSizes = new int[elemCnt];
                int[] initSizes = new int[elemCnt];
                int[] maxSizes = new int[elemCnt];
                int elemIdx = 0;
                List pktSizeList = pktElem.getChildren();
                for (int i = 0; i < pktSizeList.size(); ++i) {
                    ConfigElement curChild = (ConfigElement)pktSizeList.get(i);
                    if (!curChild.getName().equals("packet")) continue;
                    int pktSize = -1;
                    int initAlloc = -1;
                    int maxAlloc = -1;
                    String pktSizeStr = curChild.getAttribute("size");
                    if (pktSizeStr == null || pktSizeStr.length() == 0) {
                        throw new InvalidConfigurationException("Memory pool packet size not specified");
                    }
                    try {
                        pktSize = MemorySize.getByteValueInt((String)pktSizeStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Memory pool packet size, invalid size value, " + pktSizeStr);
                    }
                    if (elemIdx > 0 && pktSizes[elemIdx - 1] >= pktSize) {
                        throw new InvalidConfigurationException("Invalid packet size specified, less than/equal to previous packet size");
                    }
                    String initSizeStr = curChild.getAttribute("init");
                    if (initSizeStr == null || initSizeStr.length() == 0) {
                        throw new InvalidConfigurationException("Memory pool initial allocation not specified");
                    }
                    try {
                        initAlloc = Integer.parseInt(initSizeStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid initial allocation, " + initSizeStr);
                    }
                    if (initAlloc < 5) {
                        throw new InvalidConfigurationException("Initial memory pool allocation below minimum of 5");
                    }
                    if (initAlloc > 500) {
                        throw new InvalidConfigurationException("Initial memory pool allocation above maximum of 500");
                    }
                    String maxSizeStr = curChild.getAttribute("max");
                    if (maxSizeStr == null || maxSizeStr.length() == 0) {
                        throw new InvalidConfigurationException("Memory pool maximum allocation not specified");
                    }
                    try {
                        maxAlloc = Integer.parseInt(maxSizeStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidConfigurationException("Invalid maximum allocation, " + maxSizeStr);
                    }
                    if (maxAlloc < 5) {
                        throw new InvalidConfigurationException("Maximum memory pool allocation below minimum of 5");
                    }
                    if (initAlloc > 500) {
                        throw new InvalidConfigurationException("Maximum memory pool allocation above maximum of 500");
                    }
                    pktSizes[elemIdx] = pktSize;
                    initSizes[elemIdx] = initAlloc;
                    maxSizes[elemIdx] = maxAlloc;
                    ++elemIdx;
                }
                if (elemIdx < pktSizes.length) {
                    int[] newPktSizes = new int[elemIdx];
                    int[] newInitSizes = new int[elemIdx];
                    int[] newMaxSizes = new int[elemIdx];
                    System.arraycopy(pktSizes, 0, newPktSizes, 0, elemIdx);
                    System.arraycopy(initSizes, 0, newInitSizes, 0, elemIdx);
                    System.arraycopy(maxSizes, 0, newMaxSizes, 0, elemIdx);
                    pktSizes = newPktSizes;
                    initSizes = newInitSizes;
                    maxSizes = newMaxSizes;
                }
                coreConfig.setMemoryPool(pktSizes, initSizes, maxSizes);
            }
        } else {
            coreConfig.setMemoryPool(DefaultMemoryPoolBufSizes, DefaultMemoryPoolInitAlloc, DefaultMemoryPoolMaxAlloc);
        }
    }

    protected AccessControlList processAccessControlList(SecurityConfigSection secConfig, ConfigElement aclsElem) {
        List aclElemList;
        if (secConfig.getAccessControlManager() == null) {
            throw new AlfrescoRuntimeException("No access control manager configured");
        }
        AccessControlList acls = new AccessControlList();
        String attrib = aclsElem.getAttribute("default");
        if (attrib != null && attrib.length() > 0) {
            try {
                int access = AccessControlParser.parseAccessTypeString((String)attrib);
                acls.setDefaultAccessLevel(access);
            }
            catch (InvalidACLTypeException ex) {
                throw new AlfrescoRuntimeException("Default access level error", (Throwable)ex);
            }
            catch (ACLParseException ex) {
                throw new AlfrescoRuntimeException("Default access level error", (Throwable)ex);
            }
        }
        if ((aclElemList = aclsElem.getChildren()) != null && aclElemList.size() > 0) {
            for (int i = 0; i < aclsElem.getChildCount(); ++i) {
                ConfigElement curAclElem = (ConfigElement)aclElemList.get(i);
                try {
                    acls.addControl(secConfig.getAccessControlManager().createAccessControl(curAclElem.getName(), curAclElem));
                    continue;
                }
                catch (InvalidACLTypeException ex) {
                    throw new AlfrescoRuntimeException("Invalid access control type - " + curAclElem.getName());
                }
                catch (ACLParseException ex) {
                    throw new AlfrescoRuntimeException("Access control parse error (" + curAclElem.getName() + ")", (Throwable)ex);
                }
            }
        }
        if (acls.getDefaultAccessLevel() == 0 && acls.numberOfControls() == 0) {
            throw new AlfrescoRuntimeException("Empty access control list and default access 'None' not allowed");
        }
        return acls;
    }

    protected DesktopActionTable processDesktopActions(ConfigElement deskActionElem, DiskSharedDevice fileSys) {
        DesktopActionTable desktopActions = null;
        List actionElems = deskActionElem.getChildren();
        if (actionElems != null) {
            ConfigElement globalConfig = deskActionElem.getChild("global");
            desktopActions = new DesktopActionTable();
            for (ConfigElement actionElem : actionElems) {
                if (actionElem.getName().equals("action")) {
                    ConfigElement className = actionElem.getChild("class");
                    if (className == null) continue;
                    Object actionObj = null;
                    try {
                        actionObj = Class.forName(className.getValue()).newInstance();
                        if (actionObj instanceof DesktopAction) {
                            DesktopAction deskAction = actionObj;
                            deskAction.initializeAction(globalConfig, actionElem, fileSys);
                            desktopActions.addAction(deskAction);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Added desktop action " + deskAction.getName()));
                            continue;
                        }
                        throw new AlfrescoRuntimeException("Desktop action does not extend DesktopAction class, " + className.getValue());
                    }
                    catch (ClassNotFoundException ex) {
                        throw new AlfrescoRuntimeException("Desktop action class not found, " + className.getValue());
                    }
                    catch (IllegalAccessException ex) {
                        throw new AlfrescoRuntimeException("Failed to create desktop action instance, " + className.getValue(), (Throwable)ex);
                    }
                    catch (InstantiationException ex) {
                        throw new AlfrescoRuntimeException("Failed to create desktop action instance, " + className.getValue(), (Throwable)ex);
                    }
                    catch (DesktopActionException ex) {
                        throw new AlfrescoRuntimeException("Failed to initialize desktop action", (Throwable)ex);
                    }
                }
                if (actionElem.getName().equals("global")) continue;
                throw new AlfrescoRuntimeException("Invalid configuration element in desktopActions section, " + actionElem.getName());
            }
        }
        return desktopActions;
    }

    protected void processWINSServerConfig(Config config) {
        ConfigElement elem = config.getConfigElement("WINS");
        if (elem != null) {
            ConfigElement priWinsElem = elem.getChild("primary");
            if (priWinsElem == null || priWinsElem.getValue().length() == 0) {
                throw new AlfrescoRuntimeException("No primary WINS server configured");
            }
            InetAddress primaryWINS = null;
            try {
                primaryWINS = InetAddress.getByName(priWinsElem.getValue());
            }
            catch (UnknownHostException ex) {
                throw new AlfrescoRuntimeException("Invalid primary WINS server address, " + priWinsElem.getValue());
            }
            NetBIOSSession.setDefaultWINSServer((InetAddress)primaryWINS);
        }
    }

    protected void processWINSServerConfig() {
        this.processWINSServerConfig(this.m_configService.getConfig((Object)ConfigCIFS, this.configCtx));
    }
}

