/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import javax.transaction.UserTransaction;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.filesys.repo.NodeMonitor;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeMonitorFactory {
    private static final Log logger = LogFactory.getLog(NodeMonitorFactory.class);
    private PolicyComponent m_policyComponent;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private PermissionService m_permissionService;
    private TransactionService m_transService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeMonitor createNodeMonitor(ContentDiskDriver filesysDriver, ContentContext filesysCtx) {
        UserTransaction tx = this.m_transService.getUserTransaction(true);
        NodeMonitor nodeMonitor = null;
        try {
            tx.begin();
            nodeMonitor = new NodeMonitor(filesysDriver, filesysCtx, this.m_nodeService, this.m_policyComponent, this.m_fileFolderService, this.m_permissionService, this.m_transService);
            tx.commit();
            tx = null;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        return nodeMonitor;
    }

    public void setNodeService(NodeService nodeService) {
        this.m_nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.m_permissionService = permissionService;
    }

    public void setFileFolderService(FileFolderService fileService) {
        this.m_fileFolderService = fileService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.m_policyComponent = policyComponent;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.m_transService = transactionService;
    }
}

