/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.alfresco.jcr.dictionary.JCRNamespace;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.item.property.JCRMixinTypesProperty;
import org.alfresco.jcr.item.property.JCRPrimaryTypeProperty;
import org.alfresco.jcr.item.property.JCRUUIDProperty;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.surf.util.Base64;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JCRDocumentXMLExporter
implements Exporter {
    private SessionImpl session;
    private ContentHandler contentHandler;
    private List<QName> currentProperties = new ArrayList<QName>();
    private List<Object> currentValues = new ArrayList<Object>();

    public JCRDocumentXMLExporter(SessionImpl session, ContentHandler contentHandler) {
        this.session = session;
        this.contentHandler = contentHandler;
    }

    public void start(ExporterContext exportNodeRef) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process export start event", e);
        }
    }

    public void startNamespace(String prefix, String uri) {
        try {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process start namespace event - prefix " + prefix + " uri " + uri, e);
        }
    }

    public void endNamespace(String prefix) {
        try {
            this.contentHandler.endPrefixMapping(prefix);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end namespace event - prefix " + prefix, e);
        }
    }

    public void startNode(NodeRef nodeRef) {
    }

    public void endNode(NodeRef nodeRef) {
        try {
            QName nodeName = this.getNodeName(nodeRef);
            this.contentHandler.endElement(nodeName.getNamespaceURI(), nodeName.getLocalName(), this.toPrefixString(nodeName));
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end node event - node ref " + nodeRef.toString(), e);
        }
    }

    public void startAspects(NodeRef nodeRef) {
    }

    public void endAspects(NodeRef nodeRef) {
    }

    public void startAspect(NodeRef nodeRef, QName aspect) {
    }

    public void endAspect(NodeRef nodeRef, QName aspect) {
    }

    public void startACL(NodeRef nodeRef) {
    }

    public void permission(NodeRef nodeRef, AccessPermission permission) {
    }

    public void endACL(NodeRef nodeRef) {
    }

    public void startProperties(NodeRef nodeRef) {
        this.currentProperties.clear();
        this.currentValues.clear();
    }

    public void endProperties(NodeRef nodeRef) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            NodeImpl nodeImpl = new NodeImpl(this.session, nodeRef);
            JCRPrimaryTypeProperty primaryType = new JCRPrimaryTypeProperty(nodeImpl);
            attrs.addAttribute(JCRPrimaryTypeProperty.PROPERTY_NAME.getNamespaceURI(), JCRPrimaryTypeProperty.PROPERTY_NAME.getLocalName(), this.toPrefixString(JCRPrimaryTypeProperty.PROPERTY_NAME), null, this.getValue(primaryType.getValue().getString()));
            JCRMixinTypesProperty mixinTypes = new JCRMixinTypesProperty(nodeImpl);
            ArrayList<String> mixins = new ArrayList<String>();
            for (Value value : mixinTypes.getValues()) {
                mixins.add(value.getString());
            }
            attrs.addAttribute(JCRMixinTypesProperty.PROPERTY_NAME.getNamespaceURI(), JCRMixinTypesProperty.PROPERTY_NAME.getLocalName(), this.toPrefixString(JCRMixinTypesProperty.PROPERTY_NAME), null, this.getCollectionValue(mixins));
            attrs.addAttribute(JCRUUIDProperty.PROPERTY_NAME.getNamespaceURI(), JCRUUIDProperty.PROPERTY_NAME.getLocalName(), this.toPrefixString(JCRUUIDProperty.PROPERTY_NAME), null, this.getValue(nodeRef.getId()));
            for (int i = 0; i < this.currentProperties.size(); ++i) {
                Object value = this.currentValues.get(i);
                String strValue = value instanceof Collection ? this.getCollectionValue((Collection)value) : this.getValue(value);
                QName propName = this.currentProperties.get(i);
                propName = this.encodeQName(propName);
                attrs.addAttribute(propName.getNamespaceURI(), propName.getLocalName(), this.toPrefixString(propName), null, strValue);
            }
            QName nodeName = this.getNodeName(nodeRef);
            this.contentHandler.startElement(nodeName.getNamespaceURI(), nodeName.getLocalName(), this.toPrefixString(nodeName), attrs);
        }
        catch (ValueFormatException e) {
            throw new ExporterException("Failed to process properties event - nodeRef " + nodeRef);
        }
        catch (RepositoryException e) {
            throw new ExporterException("Failed to process properties event - nodeRef " + nodeRef);
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process properties event - nodeRef " + nodeRef);
        }
    }

    public void startProperty(NodeRef nodeRef, QName property) {
    }

    public void endProperty(NodeRef nodeRef, QName property) {
    }

    public void startValueCollection(NodeRef nodeRef, QName property) {
    }

    public void endValueCollection(NodeRef nodeRef, QName property) {
    }

    public void value(NodeRef nodeRef, QName property, Object value, int index) {
        this.currentProperties.add(property);
        this.currentValues.add(value);
    }

    public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        try {
            StringBuffer strValue = new StringBuffer(9216);
            if (content != null) {
                int read;
                Base64.InputStream base64content = new Base64.InputStream(content, 9);
                byte[] buffer = new byte[9216];
                while ((read = base64content.read(buffer, 0, buffer.length)) > 0) {
                    String characters = new String(buffer, 0, read);
                    strValue.append(characters);
                }
            }
            this.currentProperties.add(property);
            this.currentValues.add(strValue.toString());
        }
        catch (IOException e) {
            throw new ExporterException("Failed to process content event - nodeRef " + nodeRef + "; property " + this.toPrefixString(property));
        }
    }

    public void startAssoc(NodeRef nodeRef, QName assoc) {
    }

    public void endAssoc(NodeRef nodeRef, QName assoc) {
    }

    public void startAssocs(NodeRef nodeRef) {
    }

    public void endAssocs(NodeRef nodeRef) {
    }

    public void startReference(NodeRef nodeRef, QName childName) {
    }

    public void endReference(NodeRef nodeRef) {
    }

    public void endValueMLText(NodeRef nodeRef) {
    }

    public void startValueMLText(NodeRef nodeRef, Locale locale) {
    }

    public void warning(String warning) {
    }

    public void end() {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new ExporterException("Failed to process end export event", e);
        }
    }

    private String toPrefixString(QName qname) {
        return qname.toPrefixString(this.session.getNamespaceResolver());
    }

    private QName getNodeName(NodeRef nodeRef) {
        QName childQName = null;
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        NodeRef rootNode = nodeService.getRootNode(nodeRef.getStoreRef());
        if (rootNode.equals((Object)nodeRef)) {
            childQName = QName.createQName((String)JCRNamespace.JCR_URI, (String)"root");
        } else {
            Path path = nodeService.getPath(nodeRef);
            String childName = path.last().getElementString();
            childQName = QName.createQName((String)childName);
            childQName = this.encodeQName(childQName);
        }
        return childQName;
    }

    private String getValue(Object value) throws RepositoryException {
        String strValue = this.session.getTypeConverter().convert(String.class, value);
        return this.encodeBlanks(strValue);
    }

    private String getCollectionValue(Collection values) {
        Collection strValues = this.session.getTypeConverter().getConverter().convert(String.class, values);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String strValue : strValues) {
            buffer.append(this.encodeBlanks(strValue));
            if (++i >= strValues.size()) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private QName encodeQName(QName name) {
        return QName.createQName((String)name.getNamespaceURI(), (String)ISO9075.encode((String)name.getLocalName()));
    }

    private String encodeBlanks(String value) {
        return value.replaceAll(" ", "_x0020_");
    }
}

