/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.alfresco.jcr.item.JCRTypeConverter;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.service.cmr.repository.ContentReader;

public class ValueImpl
implements Value {
    private ValueState state = ValueState.None;
    private SessionImpl session;
    private int datatype;
    private Object value;
    private InputStream stream = null;
    private Value proxy;

    public ValueImpl(SessionImpl session, int datatype, Object value) {
        this.session = session;
        this.datatype = datatype;
        this.value = value;
    }

    public Value getProxy() {
        if (this.proxy == null) {
            this.proxy = (Value)JCRProxyFactory.create(this, Value.class, this.session);
        }
        return this.proxy;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.isValidState(ValueState.Value);
        String typedValue = this.session.getTypeConverter().stringValue(this.getInternalValue());
        this.value = typedValue;
        this.enterState(ValueState.Value);
        return typedValue;
    }

    public InputStream getStream() throws IllegalStateException, RepositoryException {
        this.isValidState(ValueState.Stream);
        if (this.stream == null) {
            this.stream = this.session.getTypeConverter().streamValue(this.value);
        }
        this.enterState(ValueState.Stream);
        return this.stream;
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.isValidState(ValueState.Value);
        long typedValue = this.session.getTypeConverter().longValue(this.getInternalValue());
        this.value = typedValue;
        this.enterState(ValueState.Value);
        return typedValue;
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.isValidState(ValueState.Value);
        double typedValue = this.session.getTypeConverter().doubleValue(this.getInternalValue());
        this.value = typedValue;
        this.enterState(ValueState.Value);
        return typedValue;
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.isValidState(ValueState.Value);
        Calendar typedValue = this.session.getTypeConverter().dateValue(this.getInternalValue());
        this.value = typedValue.getTime();
        this.enterState(ValueState.Value);
        return typedValue;
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.isValidState(ValueState.Value);
        boolean typedValue = this.session.getTypeConverter().booleanValue(this.getInternalValue());
        this.value = typedValue;
        this.enterState(ValueState.Value);
        return typedValue;
    }

    public int getType() {
        return this.datatype;
    }

    public static Object getValue(Value value) throws RepositoryException {
        Object objValue = null;
        int valueType = value.getType();
        switch (valueType) {
            case 1: 
            case 7: 
            case 8: {
                objValue = value.getString();
                break;
            }
            case 3: {
                objValue = value.getLong();
                break;
            }
            case 4: {
                objValue = value.getDouble();
                break;
            }
            case 6: {
                objValue = value.getBoolean();
                break;
            }
            case 5: {
                objValue = value.getDate();
                break;
            }
            case 2: {
                objValue = value.getStream();
                break;
            }
            default: {
                objValue = ((ValueImpl)value).value;
            }
        }
        return objValue;
    }

    public static Object getValue(JCRTypeConverter typeConverter, int requiredType, Value value) throws RepositoryException {
        Object objValue = null;
        switch (requiredType) {
            case 1: {
                objValue = value.getString();
                break;
            }
            case 3: {
                objValue = value.getLong();
                break;
            }
            case 4: {
                objValue = value.getDouble();
                break;
            }
            case 6: {
                objValue = value.getBoolean();
                break;
            }
            case 5: {
                objValue = value.getDate();
                break;
            }
            case 2: {
                objValue = value.getStream();
                break;
            }
            case 7: {
                objValue = typeConverter.nameValue(ValueImpl.getValue(value));
                break;
            }
            case 8: {
                objValue = typeConverter.pathValue(ValueImpl.getValue(value));
                break;
            }
            default: {
                throw new ValueFormatException("Unsupported Value Type " + requiredType);
            }
        }
        return objValue;
    }

    private Object getInternalValue() {
        if (this.value instanceof ContentReader && this.state == ValueState.Value) {
            this.value = ((ContentReader)this.value).getReader();
        }
        return this.value;
    }

    private void isValidState(ValueState state) {
        if (this.state != ValueState.None && this.state != state) {
            throw new IllegalStateException("This value has already been retrieved as a " + (Object)((Object)state) + " and cannot be retrieved as a " + (Object)((Object)ValueState.Stream) + ".");
        }
    }

    private void enterState(ValueState state) {
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ValueImpl)) {
            return false;
        }
        ValueImpl other = (ValueImpl)obj;
        if (this.datatype != other.datatype) {
            return false;
        }
        if (this.value instanceof ContentReader) {
            String thisUrl = ((ContentReader)this.value).getContentUrl();
            String otherUrl = ((ContentReader)other).getContentUrl();
            return thisUrl.equals(otherUrl);
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode() * 32 + this.datatype;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValueState {
        Stream,
        Value,
        None;

    }
}

