/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator.compare;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.action.evaluator.ComparePropertyValueEvaluator;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.PropertyValueComparator;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPropertyValueComparator
implements PropertyValueComparator {
    private static final String MSGID_INVALID_OPERATION = "text_property_value_comparator.invalid_operation";
    private static final String STAR = "*";
    private static List<Character> ESCAPE_CHAR_LIST = null;

    @Override
    public boolean compare(Serializable propertyValue, Serializable compareValue, ComparePropertyValueOperation operation) {
        String compareText = (String)((Object)compareValue);
        boolean result = false;
        if (operation == null) {
            if (compareText.startsWith(STAR)) {
                operation = ComparePropertyValueOperation.ENDS;
                compareText = compareText.substring(1);
            } else if (compareText.endsWith(STAR)) {
                operation = ComparePropertyValueOperation.BEGINS;
                compareText = compareText.substring(0, compareText.length() - 1);
            } else {
                operation = ComparePropertyValueOperation.CONTAINS;
            }
        }
        String regEx = this.buildRegEx(compareText, operation);
        if (propertyValue != null) {
            result = ((String)((Object)propertyValue)).toLowerCase().matches(regEx);
        }
        return result;
    }

    private String buildRegEx(String matchText, ComparePropertyValueOperation operation) {
        String result = this.escapeText(matchText.toLowerCase());
        switch (operation) {
            case CONTAINS: {
                result = "^.*" + result + ".*$";
                break;
            }
            case BEGINS: {
                result = "^" + result + ".*$";
                break;
            }
            case ENDS: {
                result = "^.*" + result + "$";
                break;
            }
            case EQUALS: {
                break;
            }
            default: {
                throw new ActionServiceException(MSGID_INVALID_OPERATION, new Object[]{operation.toString()});
            }
        }
        return result;
    }

    private String escapeText(String matchText) {
        StringBuilder builder = new StringBuilder(matchText.length());
        for (char charValue : matchText.toCharArray()) {
            if (charValue == '*') {
                builder.append(".");
            } else if (this.getEscapeCharList().contains(Character.valueOf(charValue))) {
                builder.append("\\");
            }
            builder.append(charValue);
        }
        return builder.toString();
    }

    private List<Character> getEscapeCharList() {
        if (ESCAPE_CHAR_LIST == null) {
            ESCAPE_CHAR_LIST = new ArrayList<Character>(4);
            ESCAPE_CHAR_LIST.add(Character.valueOf('.'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('^'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('$'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('('));
            ESCAPE_CHAR_LIST.add(Character.valueOf('['));
            ESCAPE_CHAR_LIST.add(Character.valueOf('{'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('\\'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('|'));
            ESCAPE_CHAR_LIST.add(Character.valueOf(')'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('?'));
            ESCAPE_CHAR_LIST.add(Character.valueOf('+'));
        }
        return ESCAPE_CHAR_LIST;
    }

    @Override
    public void registerComparator(ComparePropertyValueEvaluator evaluator) {
        evaluator.registerComparator(DataTypeDefinition.TEXT, this);
        evaluator.registerComparator(DataTypeDefinition.MLTEXT, this);
    }
}

