/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ApplicationModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWorkflowActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "simple-workflow";
    public static final String PARAM_APPROVE_STEP = "approve-step";
    public static final String PARAM_APPROVE_FOLDER = "approve-folder";
    public static final String PARAM_APPROVE_MOVE = "approve-move";
    public static final String PARAM_REJECT_STEP = "reject-step";
    public static final String PARAM_REJECT_FOLDER = "reject-folder";
    public static final String PARAM_REJECT_MOVE = "reject-move";
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_APPROVE_STEP, DataTypeDefinition.TEXT, true, this.getParamDisplayLabel(PARAM_APPROVE_STEP)));
        paramList.add(new ParameterDefinitionImpl(PARAM_APPROVE_FOLDER, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_APPROVE_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_APPROVE_MOVE, DataTypeDefinition.BOOLEAN, true, this.getParamDisplayLabel(PARAM_APPROVE_MOVE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_REJECT_STEP, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_REJECT_STEP)));
        paramList.add(new ParameterDefinitionImpl(PARAM_REJECT_FOLDER, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_REJECT_FOLDER)));
        paramList.add(new ParameterDefinitionImpl(PARAM_REJECT_MOVE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_REJECT_MOVE)));
    }

    @Override
    protected void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef) && !this.nodeService.hasAspect(actionedUponNodeRef, ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            String approveStep = (String)((Object)ruleAction.getParameterValue(PARAM_APPROVE_STEP));
            NodeRef approveFolder = (NodeRef)ruleAction.getParameterValue(PARAM_APPROVE_FOLDER);
            Boolean approveMove = (Boolean)ruleAction.getParameterValue(PARAM_APPROVE_MOVE);
            String rejectStep = (String)((Object)ruleAction.getParameterValue(PARAM_REJECT_STEP));
            NodeRef rejectFolder = (NodeRef)ruleAction.getParameterValue(PARAM_REJECT_FOLDER);
            Boolean rejectMove = (Boolean)ruleAction.getParameterValue(PARAM_REJECT_MOVE);
            HashMap<QName, Object> propertyValues = new HashMap<QName, Object>();
            propertyValues.put(ApplicationModel.PROP_APPROVE_STEP, approveStep);
            propertyValues.put(ApplicationModel.PROP_APPROVE_FOLDER, approveFolder);
            if (approveMove != null) {
                propertyValues.put(ApplicationModel.PROP_APPROVE_MOVE, approveMove);
            }
            propertyValues.put(ApplicationModel.PROP_REJECT_STEP, rejectStep);
            propertyValues.put(ApplicationModel.PROP_REJECT_FOLDER, rejectFolder);
            if (rejectMove != null) {
                propertyValues.put(ApplicationModel.PROP_REJECT_MOVE, rejectMove);
            }
            this.nodeService.addAspect(actionedUponNodeRef, ApplicationModel.ASPECT_SIMPLE_WORKFLOW, propertyValues);
        }
    }
}

